/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.BindingMap;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBinaryType;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.util.ASTNodeFinder;
import org.eclipse.jdt.internal.core.util.HandleFactory;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;

public class HierarchyResolver
implements ITypeRequestor {
    private ReferenceBinding focusType;
    private boolean superTypesOnly;
    private boolean hasMissingSuperClass;
    LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    HierarchyBuilder builder;
    private ReferenceBinding[] typeBindings;
    private final BindingMap<IGenericType> bindingMap = new BindingMap();
    private int typeIndex;
    private IGenericType[] typeModels;
    private Parser basicParser;
    private static final CompilationUnitDeclaration FakeUnit;

    static {
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, new CompilerOptions(), (IProblemFactory)new DefaultProblemFactory());
        CompilationResult result = new CompilationResult(CharOperation.NO_CHAR, 0, 0, 0);
        FakeUnit = new CompilationUnitDeclaration(problemReporter, result, 0);
    }

    public HierarchyResolver(INameEnvironment nameEnvironment, Map settings, HierarchyBuilder builder, IProblemFactory problemFactory) {
        this.options = new CompilerOptions(settings);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        LookupEnvironment environment = new LookupEnvironment((ITypeRequestor)this, this.options, problemReporter, nameEnvironment);
        environment.mayTolerateMissingType = true;
        this.setEnvironment(environment, builder);
    }

    public HierarchyResolver(LookupEnvironment lookupEnvironment, HierarchyBuilder builder) {
        this.setEnvironment(lookupEnvironment, builder);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        SubMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.sanitizeBinaryType((IGenericType)binaryType);
        BinaryTypeBinding typeBinding = this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
        try {
            this.remember((IGenericType)binaryType, (ReferenceBinding)typeBinding);
        }
        catch (AbortCompilation abortCompilation) {}
    }

    private void sanitizeBinaryType(IGenericType binaryType) {
        HierarchyBinaryType hierarchyBinaryType;
        if (binaryType instanceof HierarchyBinaryType && (hierarchyBinaryType = (HierarchyBinaryType)binaryType).getSuperclassName() == null) {
            hierarchyBinaryType.recordSuperclass(CharOperation.concatWith((char[][])TypeConstants.JAVA_LANG_OBJECT, (char)'/'));
        }
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        if (CharOperation.equals((char[])TypeConstants.MODULE_INFO_NAME, (char[])sourceUnit.getMainTypeName())) {
            CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
            this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(parsedUnit, true, false);
        } else {
            this.lookupEnvironment.problemReporter.abortDueToInternalError(Messages.accept_cannot + sourceUnit.getFileName());
        }
    }

    private Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, (IProblemFactory)new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        SubMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{sourceType}, 12, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            try {
                LookupEnvironment environment = packageBinding.environment;
                if (environment == null) {
                    environment = this.lookupEnvironment;
                }
                environment.buildTypeBindings(unit, accessRestriction);
                org.eclipse.jdt.core.ICompilationUnit cu = ((SourceTypeElementInfo)sourceType).getHandle().getCompilationUnit();
                environment.completeTypeBindings(unit, true, false);
                this.rememberAllTypes(unit, cu, false);
            }
            catch (AbortCompilation abortCompilation) {}
        }
    }

    private IType findSuperClass(IGenericType type, ReferenceBinding typeBinding) {
        ReferenceBinding superBinding = typeBinding.superclass();
        if (superBinding != null) {
            IGenericType typeModel;
            superBinding = (ReferenceBinding)superBinding.erasure();
            if (typeBinding.isHierarchyInconsistent()) {
                if (superBinding.problemId() == 1) {
                    this.hasMissingSuperClass = true;
                    this.builder.hierarchy.missingTypes.add(new String(superBinding.sourceName));
                    return null;
                }
                if (superBinding.id == 1) {
                    int separator;
                    char[] superclassName;
                    if (type instanceof IBinaryType) {
                        superclassName = ((IBinaryType)type).getSuperclassName();
                        separator = 47;
                    } else if (type instanceof ISourceType) {
                        superclassName = ((ISourceType)type).getSuperclassName();
                        separator = 46;
                    } else if (type instanceof HierarchyType) {
                        superclassName = ((HierarchyType)type).superclassName;
                        separator = 46;
                    } else {
                        return null;
                    }
                    if (superclassName != null) {
                        char[] simpleName;
                        int lastSeparator = CharOperation.lastIndexOf((char)separator, (char[])superclassName);
                        char[] cArray = simpleName = lastSeparator == -1 ? superclassName : CharOperation.subarray((char[])superclassName, (int)(lastSeparator + 1), (int)superclassName.length);
                        if (!CharOperation.equals((char[])simpleName, (char[])TypeConstants.OBJECT)) {
                            this.hasMissingSuperClass = true;
                            this.builder.hierarchy.missingTypes.add(new String(simpleName));
                            return null;
                        }
                    }
                }
            }
            if ((typeModel = this.bindingMap.get((TypeBinding)superBinding)) != null) {
                return this.builder.getHandle(typeModel, superBinding);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private IType[] findSuperInterfaces(IGenericType type, ReferenceBinding typeBinding) {
        if (type instanceof IBinaryType) {
            superInterfaceNames = ((IBinaryType)type).getInterfaceNames();
            separator = '/';
        } else if (type instanceof ISourceType) {
            sourceType = (ISourceType)type;
            superInterfaceNames = sourceType.isAnonymous() ? (typeBinding.superInterfaces() != null && typeBinding.superInterfaces().length > 0 ? (Object)new char[][]{sourceType.getSuperclassName()} : sourceType.getInterfaceNames()) : (TypeDeclaration.kind((int)sourceType.getModifiers()) == 4 ? (Object)new char[][]{TypeConstants.CharArray_JAVA_LANG_ANNOTATION_ANNOTATION} : sourceType.getInterfaceNames());
            separator = '.';
        } else if (type instanceof HierarchyType) {
            hierarchyType = (HierarchyType)type;
            superInterfaceNames = hierarchyType.isAnonymous() ? (typeBinding.superInterfaces() != null && typeBinding.superInterfaces().length > 0 ? (Object)new char[][]{hierarchyType.superclassName} : hierarchyType.superInterfaceNames) : hierarchyType.superInterfaceNames;
            separator = '.';
        } else {
            return null;
        }
        interfaceBindings = typeBinding.superInterfaces();
        if (typeBinding.isRole() && !typeBinding.isInterface() && superInterfaceNames != null && (interfacePartBinding = typeBinding.roleModel.getInterfacePartBinding()) != null) {
            roleInterfaceBindings = interfacePartBinding.superInterfaces();
            bindings = new ArrayList<ReferenceBinding>();
            idx = 0;
            while (idx < ((char[][])superInterfaceNames).length) {
                superInterfaceName = superInterfaceNames[idx];
                counter = 0;
                while (counter < roleInterfaceBindings.length) {
                    binding = roleInterfaceBindings[counter];
                    if (!binding.isSynthInterface() && CharOperation.equals((char[])superInterfaceName, (char[])binding.sourceName)) {
                        bindings.add(binding);
                    }
                    ++counter;
                }
                ++idx;
            }
            interfaceBindings = bindings.toArray(new ReferenceBinding[bindings.size()]);
        }
        bindingIndex = 0;
        bindingLength = interfaceBindings == null ? 0 : interfaceBindings.length;
        length = superInterfaceNames == null ? 0 : ((char[][])superInterfaceNames).length;
        superinterfaces = new IType[length];
        index = 0;
        i = 0;
        while (i < length) {
            superInterfaceName = superInterfaceNames[i];
            end = superInterfaceName.length;
            genericStart = CharOperation.indexOf((char)'<', (char[])superInterfaceName);
            if (genericStart != -1) {
                end = genericStart;
            }
            if ((lastDollar = CharOperation.lastIndexOf((char)'$', (char[])superInterfaceName, (int)(start = (lastSeparator = CharOperation.lastIndexOf((char)separator, (char[])superInterfaceName, (int)0, (int)end)) + 1))) != -1) {
                start = lastDollar + 1;
            }
            simpleName = CharOperation.subarray((char[])superInterfaceName, (int)start, (int)end);
            if (bindingIndex >= bindingLength) ** GOTO lbl-1000
            interfaceBinding = (ReferenceBinding)interfaceBindings[bindingIndex].erasure();
            if (!CharOperation.equals((char[])simpleName, (char[])interfaceBinding.sourceName)) ** GOTO lbl-1000
            ++bindingIndex;
            genericType = this.bindingMap.get((TypeBinding)interfaceBinding);
            if (genericType != null && (handle = this.builder.getHandle(genericType, interfaceBinding)) != null) {
                superinterfaces[index++] = handle;
            } else lbl-1000:
            // 3 sources

            {
                this.builder.hierarchy.missingTypes.add(new String(simpleName));
            }
            ++i;
        }
        if (index != length) {
            v0 = superinterfaces;
            superinterfaces = new IType[index];
            System.arraycopy(v0, 0, superinterfaces, 0, index);
        }
        return superinterfaces;
    }

    /*
     * Unable to fully structure code
     */
    private void fixSupertypeBindings() {
        current = this.typeIndex;
        while (current >= 0) {
            block16: {
                block17: {
                    typeBinding = this.typeBindings[current];
                    if ((typeBinding.tagBits & 131072L) == 0L) break block16;
                    if (!(typeBinding instanceof SourceTypeBinding)) break block17;
                    if (!(typeBinding instanceof LocalTypeBinding)) ** GOTO lbl-1000
                    localTypeBinding = (LocalTypeBinding)typeBinding;
                    allocationExpression = localTypeBinding.scope.referenceContext.allocation;
                    if (allocationExpression != null && (type = allocationExpression.type) != null && type.resolvedType != null) {
                        localTypeBinding.setSuperClass((ReferenceBinding)type.resolvedType);
                    } else if ((scope = ((SourceTypeBinding)typeBinding).scope) != null) {
                        typeDeclaration = scope.referenceContext;
                        superclassRef = typeDeclaration == null ? null : typeDeclaration.superclass;
                        v0 = superclass = superclassRef == null ? null : superclassRef.resolvedType;
                        if (superclass != null) {
                            superclass = superclass.closestMatch();
                        }
                        if (superclass instanceof ReferenceBinding && !this.subTypeOfType((ReferenceBinding)superclass, typeBinding)) {
                            ((SourceTypeBinding)typeBinding).setSuperClass((ReferenceBinding)superclass);
                        }
                        superInterfaces = typeDeclaration == null ? null : typeDeclaration.superInterfaces;
                        interfaceBindings = typeBinding.superInterfaces();
                        if (superInterfaces != null && (length = superInterfaces.length) > (interfaceBindings == null ? 0 : interfaceBindings.length)) {
                            interfaceBindings = new ReferenceBinding[length];
                            index = 0;
                            i = 0;
                            while (i < length) {
                                superInterface = superInterfaces[i].resolvedType;
                                if (superInterface != null) {
                                    superInterface = superInterface.closestMatch();
                                }
                                if (superInterface instanceof ReferenceBinding && !this.subTypeOfType((ReferenceBinding)superInterface, typeBinding)) {
                                    interfaceBindings[index++] = (ReferenceBinding)superInterface;
                                }
                                ++i;
                            }
                            if (index < length) {
                                v1 = interfaceBindings;
                                interfaceBindings = new ReferenceBinding[index];
                                System.arraycopy(v1, 0, interfaceBindings, 0, index);
                            }
                            ((SourceTypeBinding)typeBinding).setSuperInterfaces(interfaceBindings);
                        }
                    }
                    break block16;
                }
                if (typeBinding instanceof BinaryTypeBinding) {
                    try {
                        typeBinding.superclass();
                    }
                    catch (AbortCompilation v2) {
                        ((BinaryTypeBinding)typeBinding).tagBits &= -33554433L;
                        this.builder.hierarchy.missingTypes.add(new String(typeBinding.superclass().sourceName()));
                        this.hasMissingSuperClass = true;
                    }
                    try {
                        typeBinding.superInterfaces();
                    }
                    catch (AbortCompilation v3) {
                        ((BinaryTypeBinding)typeBinding).tagBits &= -67108865L;
                    }
                }
            }
            --current;
        }
    }

    private void remember(IGenericType suppliedType, ReferenceBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        if (++this.typeIndex == this.typeModels.length) {
            this.typeModels = new IGenericType[this.typeIndex * 2];
            System.arraycopy(this.typeModels, 0, this.typeModels, 0, this.typeIndex);
            this.typeBindings = new ReferenceBinding[this.typeIndex * 2];
            System.arraycopy(this.typeBindings, 0, this.typeBindings, 0, this.typeIndex);
        }
        this.typeModels[this.typeIndex] = suppliedType;
        this.typeBindings[this.typeIndex] = typeBinding;
        this.bindingMap.put((TypeBinding)typeBinding, suppliedType);
    }

    private void remember(IType type, ReferenceBinding typeBinding) {
        if (((CompilationUnit)type.getCompilationUnit()).isOpen() && !this.isPurelyCopiedRole(typeBinding)) {
            try {
                IGenericType genericType = (IGenericType)((JavaElement)((Object)type)).getElementInfo();
                this.remember(genericType, typeBinding);
            }
            catch (JavaModelException javaModelException) {
                return;
            }
        }
        if (typeBinding == null) {
            return;
        }
        boolean isAnonymous = false;
        try {
            isAnonymous = type.isAnonymous();
        }
        catch (JavaModelException javaModelException) {}
        if (typeBinding instanceof SourceTypeBinding) {
            TypeDeclaration typeDeclaration = ((SourceTypeBinding)typeBinding).scope.referenceType();
            char[] superclassName = null;
            TypeReference superclass = (typeDeclaration.bits & 0x200) != 0 ? typeDeclaration.allocation.type : typeDeclaration.superclass;
            if (superclass != null) {
                char[][] typeName = superclass.getTypeName();
                superclassName = typeName == null ? null : typeName[typeName.length - 1];
            }
            char[][] superInterfaceNames = null;
            TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
            if (superInterfaces != null) {
                int length = superInterfaces.length;
                superInterfaceNames = new char[length][];
                int i = 0;
                while (i < length) {
                    TypeReference superInterface = superInterfaces[i];
                    char[][] typeName = superInterface.getTypeName();
                    superInterfaceNames[i] = typeName[typeName.length - 1];
                    ++i;
                }
            }
            HierarchyType hierarchyType = new HierarchyType(type, typeDeclaration.name, typeDeclaration.binding.modifiers, superclassName, superInterfaceNames, isAnonymous);
            this.remember(hierarchyType, (ReferenceBinding)typeDeclaration.binding);
        } else {
            HierarchyType hierarchyType = new HierarchyType(type, typeBinding.sourceName(), typeBinding.modifiers, typeBinding.superclass().sourceName(), new char[][]{typeBinding.superInterfaces()[0].sourceName()}, isAnonymous);
            this.remember(hierarchyType, typeBinding);
        }
    }

    private boolean isPurelyCopiedRole(ReferenceBinding typeBinding) {
        if (typeBinding == null || typeBinding.roleModel == null) {
            return false;
        }
        return typeBinding.roleModel.isPurelyCopied();
    }

    private void rememberAllTypes(CompilationUnitDeclaration parsedUnit, org.eclipse.jdt.core.ICompilationUnit cu, boolean includeLocalTypes) {
        TypeDeclaration[] types = parsedUnit.types;
        if (types != null) {
            TypeDeclaration[] typeDeclarationArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                Object stringName = new String(type.name);
                if (type.isRoleFile() && ((String)stringName).startsWith("__OT__")) {
                    stringName = ((String)stringName).substring(IOTConstants.OT_DELIM_LEN);
                }
                this.rememberWithMemberTypes(type, cu.getType((String)stringName));
                ++n2;
            }
        }
        if (!includeLocalTypes || parsedUnit.localTypes.isEmpty() && parsedUnit.functionalExpressions == null) {
            return;
        }
        HandleFactory factory = new HandleFactory();
        HashSet existingElements = new HashSet(parsedUnit.localTypes.size() + parsedUnit.functionalExpressionsCount);
        HashMap knownScopes = new HashMap(parsedUnit.localTypes.size() + parsedUnit.functionalExpressionsCount);
        for (LocalTypeBinding localType : parsedUnit.localTypes.values()) {
            ClassScope classScope = localType.scope;
            TypeDeclaration typeDecl = classScope.referenceType();
            IType typeHandle = (IType)factory.createElement(classScope, cu, existingElements, knownScopes);
            this.rememberWithMemberTypes(typeDecl, typeHandle);
        }
        if (parsedUnit.functionalExpressions != null) {
            int i = 0;
            while (i < parsedUnit.functionalExpressionsCount) {
                if (parsedUnit.functionalExpressions[i] instanceof LambdaExpression) {
                    LambdaExpression expression = (LambdaExpression)parsedUnit.functionalExpressions[i];
                    if (expression.resolvedType != null && expression.resolvedType.isValidBinding()) {
                        IType typeHandle = (IType)factory.createLambdaTypeElement(expression, cu, existingElements, knownScopes);
                        this.remember(typeHandle, expression.getTypeBinding());
                    }
                }
                ++i;
            }
        }
    }

    private void rememberWithMemberTypes(TypeDeclaration typeDecl, IType typeHandle) {
        if ((typeDecl.isTeam() || typeDecl.isDirectRole()) && !OTModelManager.hasOTElementFor(typeHandle)) {
            String baseClassName = null;
            String baseClassAnchor = null;
            if (typeDecl.baseclass != null) {
                char[][] baseTypeName = typeDecl.baseclass.getTypeName();
                baseClassName = CharOperation.concatWith((char[][])baseTypeName, (char)'.').toString();
                baseClassAnchor = CharOperation.concatWith((char[][])ParameterizedSingleTypeReference.getTypeAnchor((TypeReference)typeDecl.baseclass), (char)'.').toString();
            }
            OTModelManager.getSharedInstance().addType(typeHandle, typeDecl.modifiers, baseClassName, baseClassAnchor, typeDecl.isRoleFile());
        }
        this.remember(typeHandle, (ReferenceBinding)typeDecl.binding);
        TypeDeclaration[] memberTypes = typeDecl.memberTypes;
        if (memberTypes != null) {
            TypeDeclaration[] typeDeclarationArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration memberType = typeDeclarationArray[n2];
                String stringName = new String(memberType.name);
                if (stringName.startsWith("__OT__")) {
                    stringName = stringName.substring(IOTConstants.OT_DELIM_LEN);
                }
                this.rememberWithMemberTypes(memberType, typeHandle.getType(stringName));
                ++n2;
            }
        }
    }

    private void reportHierarchy(IType focus, TypeDeclaration focusLocalType, ReferenceBinding binaryTypeBinding) {
        if (focus != null) {
            if (binaryTypeBinding != null) {
                this.focusType = binaryTypeBinding;
            } else if (focusLocalType != null) {
                this.focusType = focusLocalType.binding;
            } else {
                char[] fullyQualifiedName = focus.getFullyQualifiedName().toCharArray();
                try {
                    fullyQualifiedName = TypeHelper.getQualifiedRoleSplitName(focus).toCharArray();
                }
                catch (JavaModelException ex) {
                    Util.log((IStatus)new Status(2, "org.eclipse.jdt.core", "Error getting role-split name of type", (Throwable)((Object)ex)));
                }
                this.setFocusType(CharOperation.splitOn((char)'.', (char[])fullyQualifiedName));
            }
        }
        this.fixSupertypeBindings();
        int objectIndex = -1;
        SubMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        int current = this.typeIndex;
        while (current >= 0) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ReferenceBinding typeBinding = this.typeBindings[current];
            if (typeBinding.id == 1) {
                objectIndex = current;
            } else {
                IGenericType suppliedType = this.typeModels[current];
                if (this.subOrSuperOfFocus(typeBinding)) {
                    if ((suppliedType.getModifiers() & 0x200) == 0 && typeBinding.isInterface() && typeBinding.roleModel != null) {
                        typeBinding = typeBinding.roleModel.getClassPartBinding();
                    }
                    if (!typeBinding.isSynthInterface()) {
                        ReferenceBinding[] tsuperBindings;
                        IType[] tsuperClasses = new IType[]{};
                        boolean[] arePhantoms = new boolean[]{};
                        if (typeBinding.isSourceRole() && (tsuperBindings = typeBinding.roleModel.getTSuperRoleBindings()).length > 0) {
                            tsuperClasses = new IType[tsuperBindings.length];
                            arePhantoms = new boolean[tsuperBindings.length];
                            int i = 0;
                            int t = tsuperBindings.length - 1;
                            while (t >= 0) {
                                tsuperClasses[i] = this.getHandle((ReferenceBinding)tsuperBindings[t].erasure());
                                arePhantoms[i] = tsuperBindings[t].roleModel.isPurelyCopied();
                                ++i;
                                --t;
                            }
                        }
                        boolean isPhantom = typeBinding.roleModel != null && typeBinding.roleModel.isPurelyCopied();
                        IType superclass = typeBinding.isInterface() ? null : this.findSuperClass(suppliedType, typeBinding);
                        IType[] superinterfaces = this.findSuperInterfaces(suppliedType, typeBinding);
                        this.builder.hookableConnect(this.focusType, typeBinding, suppliedType, this.builder.getHandle(suppliedType, typeBinding), isPhantom, superclass, tsuperClasses, arePhantoms, superinterfaces);
                    }
                }
            }
            --current;
        }
        if (!(objectIndex <= -1 || this.hasMissingSuperClass && this.focusType != null)) {
            IGenericType objectType = this.typeModels[objectIndex];
            this.builder.connect(objectType, this.builder.getHandle(objectType, this.typeBindings[objectIndex]), null, null);
        }
    }

    private IType getHandle(ReferenceBinding typeBinding) {
        int t = this.typeIndex;
        while (t >= 0) {
            if (TypeBinding.equalsEquals((TypeBinding)this.typeBindings[t], (TypeBinding)typeBinding)) {
                return this.builder.getHandle(this.typeModels[t], typeBinding);
            }
            --t;
        }
        JavaCore.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Inconsistency between typeIndex and typeBindings"));
        return null;
    }

    private void reset() {
        this.lookupEnvironment.reset();
        this.focusType = null;
        this.superTypesOnly = false;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
        this.bindingMap.clear();
    }

    public void resolve(IGenericType suppliedType) {
        block25: {
            try {
                try {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (Config config = Dependencies.setup((Object)this, null, (LookupEnvironment)this.lookupEnvironment, (boolean)true, (boolean)false);){
                        if (suppliedType.isBinaryType()) {
                            int startIndex;
                            this.sanitizeBinaryType(suppliedType);
                            BinaryTypeBinding binaryTypeBinding = this.lookupEnvironment.cacheBinaryType((IBinaryType)suppliedType, false, null);
                            this.remember(suppliedType, (ReferenceBinding)binaryTypeBinding);
                            int i = startIndex = this.typeIndex;
                            while (i <= this.typeIndex) {
                                block24: {
                                    IGenericType igType = this.typeModels[i];
                                    if (igType != null && igType.isBinaryType()) {
                                        CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                                        try {
                                            try {
                                                if (previousUnitBeingCompleted == null) {
                                                    this.lookupEnvironment.unitBeingCompleted = FakeUnit;
                                                }
                                                ReferenceBinding typeBinding = this.typeBindings[i];
                                                typeBinding.superclass();
                                                typeBinding.superInterfaces();
                                            }
                                            catch (AbortCompilation abortCompilation) {
                                                this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                                                break block24;
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                                            throw throwable2;
                                        }
                                        this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                                    }
                                }
                                ++i;
                            }
                            this.superTypesOnly = true;
                            this.reportHierarchy(this.builder.getType(), null, (ReferenceBinding)binaryTypeBinding);
                            break block25;
                        }
                        org.eclipse.jdt.core.ICompilationUnit cu = ((SourceTypeElementInfo)suppliedType).getHandle().getCompilationUnit();
                        if (cu != null) {
                            HashSet<String> localTypes = new HashSet<String>();
                            localTypes.add(cu.getPath().toString());
                            this.superTypesOnly = true;
                            this.resolve(new Openable[]{(Openable)((Object)cu)}, localTypes, null);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (AbortCompilation abortCompilation) {
                    this.reset();
                }
            }
            finally {
                this.reset();
            }
        }
    }

    /*
     * Loose catch block
     */
    public void resolve(Openable[] openables, HashSet localTypes, IProgressMonitor monitor) {
        block66: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            try {
                TypeDeclaration focusLocalType;
                IType focus;
                BinaryTypeBinding focusBinaryBinding;
                Config config;
                Throwable throwable;
                block64: {
                    block65: {
                        char[] fullyQualifiedName;
                        CompilationUnitDeclaration parsedUnit;
                        throwable = null;
                        Object var6_8 = null;
                        config = Dependencies.setup((Object)this, null, (LookupEnvironment)this.lookupEnvironment, (boolean)true, (boolean)true);
                        int openablesLength = openables.length;
                        CompilationUnitDeclaration[] parsedUnits = new CompilationUnitDeclaration[openablesLength];
                        boolean[] hasLocalType = new boolean[openablesLength];
                        org.eclipse.jdt.core.ICompilationUnit[] cus = new org.eclipse.jdt.core.ICompilationUnit[openablesLength];
                        int unitsIndex = 0;
                        CompilationUnitDeclaration focusUnit = null;
                        focusBinaryBinding = null;
                        focus = this.builder.getType();
                        Openable focusOpenable = null;
                        if (focus != null) {
                            focusOpenable = focus.isBinary() ? (Openable)((Object)focus.getClassFile()) : (Openable)((Object)focus.getCompilationUnit());
                        }
                        subMonitor.split(1);
                        Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
                        config.setParser(parser);
                        int i = 0;
                        while (i < openablesLength) {
                            block61: {
                                Openable openable = openables[i];
                                if (openable instanceof org.eclipse.jdt.core.ICompilationUnit) {
                                    org.eclipse.jdt.core.ICompilationUnit cu = (org.eclipse.jdt.core.ICompilationUnit)((Object)openable);
                                    boolean containsLocalType = false;
                                    if (localTypes == null) {
                                        containsLocalType = true;
                                    } else {
                                        IPath path = cu.getPath();
                                        containsLocalType = cu.isWorkingCopy() ? true : localTypes.contains(path.toString());
                                    }
                                    parsedUnit = null;
                                    if (cu.isOpen()) {
                                        CompilationResult result = new CompilationResult((ICompilationUnit)cu, i, openablesLength, this.options.maxProblemsPerUnit);
                                        ISourceType[] typeInfos = null;
                                        try {
                                            IType[] topLevelTypes = cu.getTypes();
                                            int topLevelLength = topLevelTypes.length;
                                            if (topLevelLength == 0) break block61;
                                            typeInfos = new SourceTypeElementInfo[topLevelLength];
                                            int j = 0;
                                            while (j < topLevelLength) {
                                                IType topLevelType = topLevelTypes[j];
                                                typeInfos[j] = (SourceTypeElementInfo)((JavaElement)((Object)topLevelType)).getElementInfo();
                                                ++j;
                                            }
                                        }
                                        catch (JavaModelException javaModelException) {}
                                        int flags = !containsLocalType ? 12 : 47;
                                        parsedUnit = SourceTypeConverter.buildCompilationUnit(typeInfos, flags, this.lookupEnvironment.problemReporter, result);
                                        if (containsLocalType && parsedUnit != null) {
                                            parsedUnit.bits |= 0x10;
                                        }
                                    } else {
                                        IFile file = (IFile)cu.getResource();
                                        ICompilationUnit sourceUnit = this.builder.createCompilationUnitFromPath(openable, file, this.findAssociatedModuleName(openable));
                                        CompilationResult unitResult = new CompilationResult(sourceUnit, i, openablesLength, this.options.maxProblemsPerUnit);
                                        parsedUnit = parser.dietParse(sourceUnit, unitResult);
                                    }
                                    if (parsedUnit != null) {
                                        hasLocalType[unitsIndex] = containsLocalType;
                                        cus[unitsIndex] = cu;
                                        parsedUnits[unitsIndex++] = parsedUnit;
                                        try {
                                            this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                                            if (openable.equals(focusOpenable)) {
                                                focusUnit = parsedUnit;
                                            }
                                        }
                                        catch (AbortCompilation abortCompilation) {}
                                    }
                                } else {
                                    ClassFile classFile = (ClassFile)openable;
                                    IBinaryType binaryType = (IBinaryType)JavaModelManager.getJavaModelManager().getInfo(classFile.getType());
                                    if (binaryType == null) {
                                        if (classFile.getPackageFragmentRoot().isArchive()) {
                                            binaryType = this.builder.createInfoFromClassFileInJar(classFile);
                                        } else {
                                            IResource file = classFile.resource();
                                            binaryType = this.builder.createInfoFromClassFile(classFile, file);
                                        }
                                    }
                                    if (binaryType != null) {
                                        try {
                                            this.sanitizeBinaryType((IGenericType)binaryType);
                                            BinaryTypeBinding binaryTypeBinding = this.lookupEnvironment.cacheBinaryType(binaryType, false, null);
                                            this.remember((IGenericType)binaryType, (ReferenceBinding)binaryTypeBinding);
                                            if (openable.equals(focusOpenable)) {
                                                focusBinaryBinding = binaryTypeBinding;
                                            }
                                        }
                                        catch (AbortCompilation abortCompilation) {}
                                    }
                                }
                            }
                            ++i;
                        }
                        focusLocalType = null;
                        if (focus != null && focusBinaryBinding == null && focusUnit != null && ((Member)((Object)focus)).getOuterMostLocalContext() != null) {
                            focusLocalType = new ASTNodeFinder(focusUnit).findType(focus);
                        }
                        int i2 = 0;
                        while (i2 <= this.typeIndex) {
                            block63: {
                                IGenericType suppliedType = this.typeModels[i2];
                                if (suppliedType != null && suppliedType.isBinaryType()) {
                                    CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                                    try {
                                        try {
                                            if (previousUnitBeingCompleted == null) {
                                                this.lookupEnvironment.unitBeingCompleted = FakeUnit;
                                            }
                                            ReferenceBinding typeBinding = this.typeBindings[i2];
                                            typeBinding.superclass();
                                            typeBinding.superInterfaces();
                                        }
                                        catch (AbortCompilation abortCompilation) {
                                            this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                                            break block63;
                                        }
                                    }
                                    catch (Throwable file) {
                                        this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                                        throw file;
                                    }
                                    this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                                }
                            }
                            ++i2;
                        }
                        SubMonitor unitLoopMonitor = subMonitor.split(1).setWorkRemaining(unitsIndex);
                        int i3 = 0;
                        while (i3 < unitsIndex) {
                            unitLoopMonitor.split(1);
                            CompilationUnitDeclaration parsedUnit2 = parsedUnits[i3];
                            if (parsedUnit2 != null) {
                                try {
                                    if (hasLocalType[i3]) {
                                        Dependencies.ensureState((CompilationUnitDeclaration)parsedUnit2, (int)12);
                                    }
                                }
                                catch (AbortCompilation abortCompilation) {
                                    hasLocalType[i3] = false;
                                }
                            }
                            ++i3;
                        }
                        try {
                            SubMonitor completeLoopMonitor = subMonitor.split(1).setWorkRemaining(unitsIndex);
                            this.lookupEnvironment.completeTypeBindings(parsedUnits, hasLocalType, unitsIndex);
                            int i4 = 0;
                            while (i4 < unitsIndex) {
                                completeLoopMonitor.split(1);
                                parsedUnit = parsedUnits[i4];
                                if (parsedUnit != null) {
                                    boolean containsLocalType = hasLocalType[i4];
                                    if (containsLocalType) {
                                        Dependencies.ensureState((CompilationUnitDeclaration)parsedUnit, (int)24);
                                    }
                                    this.rememberAllTypes(parsedUnit, cus[i4], containsLocalType);
                                }
                                ++i4;
                            }
                        }
                        catch (AbortCompilation abortCompilation) {}
                        if (focusBinaryBinding != null || focus == null || !focus.isBinary() || (focusBinaryBinding = this.lookupEnvironment.getCachedType(CharOperation.splitOn((char)'.', (char[])(fullyQualifiedName = focus.getFullyQualifiedName().toCharArray())))) != null && (focusBinaryBinding.tagBits & 0x2000000L) == 0L) break block64;
                        if (config == null) break block65;
                        config.close();
                    }
                    return;
                }
                try {
                    try {
                        this.reportHierarchy(focus, focusLocalType, (ReferenceBinding)focusBinaryBinding);
                        break block66;
                        {
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                        finally {
                            if (config != null) {
                                config.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (AbortCompilation e) {
                    if (TypeHierarchy.DEBUG) {
                        JavaModelManager.trace("", (Exception)((Object)e));
                    }
                }
            }
            finally {
                this.reset();
            }
        }
    }

    private char[] findAssociatedModuleName(Openable openable) {
        IJavaElement module = null;
        PackageFragmentRoot root = openable.getPackageFragmentRoot();
        try {
            module = root.getKind() == 1 ? root.getJavaProject().getModuleDescription() : root.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {}
        if (module != null) {
            return module.getElementName().toCharArray();
        }
        return null;
    }

    private void setEnvironment(LookupEnvironment lookupEnvironment, HierarchyBuilder builder) {
        this.lookupEnvironment = lookupEnvironment;
        this.builder = builder;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
        this.bindingMap.clear();
    }

    public ReferenceBinding setFocusType(char[][] compoundName) {
        if (compoundName == null || this.lookupEnvironment == null) {
            return null;
        }
        this.focusType = this.lookupEnvironment.getCachedType(compoundName);
        if (this.focusType == null) {
            int length;
            char[] typeName;
            int firstDollar;
            this.focusType = this.lookupEnvironment.askForType(compoundName, this.lookupEnvironment.UnNamedModule);
            if (this.focusType == null && (firstDollar = CharOperation.indexOf((char)'$', (char[])(typeName = compoundName[(length = compoundName.length) - 1]))) != -1) {
                compoundName[length - 1] = CharOperation.subarray((char[])typeName, (int)0, (int)firstDollar);
                this.focusType = this.lookupEnvironment.askForType(compoundName, this.lookupEnvironment.UnNamedModule);
                if (this.focusType != null) {
                    char[][] memberTypeNames;
                    char[][] cArray = memberTypeNames = CharOperation.splitOn((char)'$', (char[])typeName, (int)(firstDollar + 1), (int)typeName.length);
                    int n = memberTypeNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] memberTypeName = cArray[n2];
                        this.focusType = this.focusType.getMemberType(memberTypeName);
                        if (this.focusType == null) {
                            return null;
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.focusType;
    }

    public boolean subOrSuperOfFocus(ReferenceBinding typeBinding) {
        block5: {
            if (this.focusType == null) {
                return true;
            }
            try {
                if (!this.subTypeOfType(this.focusType, typeBinding)) break block5;
                return true;
            }
            catch (AbortCompilation abortCompilation) {}
        }
        if (!this.superTypesOnly && this.subTypeOfType(typeBinding, this.focusType)) {
            return true;
        }
        return false;
    }

    private boolean subTypeOfType(ReferenceBinding subType, ReferenceBinding typeBinding) {
        return this.subTypeOfType(subType, typeBinding, new IdentityHashMap<ReferenceBinding, Object>());
    }

    private boolean subTypeOfType(ReferenceBinding subType, ReferenceBinding typeBinding, Map<ReferenceBinding, Object> visited) {
        int n;
        int n2;
        ReferenceBinding[] referenceBindingArray;
        if (typeBinding == null || subType == null) {
            return false;
        }
        if (visited.put(subType, subType) != null) {
            return false;
        }
        if (TypeBinding.equalsEquals((TypeBinding)subType, (TypeBinding)typeBinding)) {
            return true;
        }
        ReferenceBinding superclass = subType.superclass();
        if (superclass != null) {
            superclass = (ReferenceBinding)superclass.erasure();
        }
        if (this.subTypeOfType(superclass, typeBinding, visited)) {
            return true;
        }
        ReferenceBinding[] superInterfaces = subType.superInterfaces();
        if (subType.isSourceRole()) {
            referenceBindingArray = subType.roleModel.getTSuperRoleBindings();
            n2 = referenceBindingArray.length;
            n = 0;
            while (n < n2) {
                ReferenceBinding tsuperBinding = referenceBindingArray[n];
                if (this.subTypeOfType(tsuperBinding, typeBinding, visited)) {
                    return true;
                }
                ++n;
            }
        }
        if (superInterfaces != null) {
            referenceBindingArray = superInterfaces;
            n2 = superInterfaces.length;
            n = 0;
            while (n < n2) {
                ReferenceBinding si = referenceBindingArray[n];
                ReferenceBinding superInterface = (ReferenceBinding)si.erasure();
                if (superInterface.isHierarchyInconsistent()) {
                    return false;
                }
                if (this.subTypeOfType(superInterface, typeBinding, visited)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    public Parser getPlainParser() {
        return null;
    }
}

