/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTConverter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTRecoveryPropagator;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.eclipse.jdt.core.dom.CompilationUnitResolverDiscovery;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryModule;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.dom.ICompilationUnitResolver;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;
import org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.jdt.internal.core.util.DOMFinder;
import org.eclipse.jdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.jdt.internal.core.util.Util;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    public static final int K_PARAMETER_MAPPING = 16;
    private final int apiLevel;
    private int astKind;
    private Map<String, String> compilerOptions;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ITypeRoot typeRoot = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaProject project = null;
    private String unitName = null;
    private String[] classpaths;
    private String[] sourcepaths;
    private String[] sourcepathsEncodings;
    private int bits;
    private final ICompilationUnitResolver unitResolver;

    public static ASTParser newParser(int level) {
        return new ASTParser(level);
    }

    ASTParser(int level) {
        DOMASTUtil.checkASTLevel(level);
        this.apiLevel = level;
        this.unitResolver = CompilationUnitResolverDiscovery.getInstance();
        this.initializeDefaults();
    }

    private List<FileSystem.Classpath> getClasspath() throws IllegalStateException {
        Main main = new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null);
        ArrayList<FileSystem.Classpath> allClasspaths = new ArrayList<FileSystem.Classpath>();
        try {
            ArrayList pendingErrors;
            if ((this.bits & 0x20) != 0) {
                org.eclipse.jdt.internal.compiler.util.Util.collectRunningVMBootclasspath(allClasspaths);
            }
            if (this.sourcepaths != null) {
                int i = 0;
                int max = this.sourcepaths.length;
                while (i < max) {
                    String sourcePath = this.sourcepaths[i];
                    if (sourcePath != null) {
                        String encoding = this.sourcepathsEncodings == null ? null : this.sourcepathsEncodings[i];
                        main.processPathEntries(4, allClasspaths, sourcePath, encoding, true, false);
                    }
                    ++i;
                }
            }
            if (this.classpaths != null) {
                String[] stringArray = this.classpaths;
                int n = this.classpaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String classpath = stringArray[n2];
                    main.processPathEntries(4, allClasspaths, classpath, null, false, false);
                    ++n2;
                }
            }
            if ((pendingErrors = main.pendingErrors) != null && pendingErrors.size() != 0) {
                throw new IllegalStateException("invalid environment settings");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("invalid environment settings", e);
        }
        if ((this.bits & 1) != 0) {
            this.checkForSystemLibrary(allClasspaths);
        }
        return allClasspaths;
    }

    private void checkForSystemLibrary(List<FileSystem.Classpath> allClasspaths) {
        if (!this.hasJavaNature()) {
            return;
        }
        boolean hasSystemLibrary = true;
        boolean hasModule = false;
        JavaModelException exception = null;
        String compliance = this.compilerOptions.get("org.eclipse.jdt.core.compiler.compliance");
        if (CompilerOptions.versionToJdkLevel((String)compliance) >= 0x350000L) {
            hasSystemLibrary = allClasspaths.stream().anyMatch(cp -> cp.getModule(TypeConstants.JAVA_DOT_BASE) != null);
            if (!hasSystemLibrary && this.project != null) {
                try {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = this.project.getAllPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        IModuleDescription moduleDescription = root.getModuleDescription();
                        if (moduleDescription != null) {
                            hasModule = true;
                            if (moduleDescription.getElementName().equals(String.valueOf(TypeConstants.JAVA_DOT_BASE))) {
                                hasSystemLibrary = true;
                                break;
                            }
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    exception = e;
                }
                if (!hasModule) {
                    try {
                        hasSystemLibrary = this.project.findType(String.valueOf(TypeConstants.CharArray_JAVA_LANG_OBJECT)) != null;
                    }
                    catch (JavaModelException e) {
                        exception = e;
                    }
                }
            }
            if (!hasSystemLibrary) {
                throw new IllegalStateException("Missing system library", (Throwable)((Object)exception));
            }
        }
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.typeRoot = null;
        this.bits = 0;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.classpaths = null;
        this.sourcepaths = null;
        this.sourcepathsEncodings = null;
        Hashtable<String, String> options = JavaCore.getOptions();
        options.remove("org.eclipse.jdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setBindingsRecovery(boolean enabled) {
        this.bits = enabled ? (this.bits |= 0x10) : (this.bits &= 0xFFFFFFEF);
    }

    public void setEnvironment(String[] classpathEntries, String[] sourcepathEntries, String[] encodings, boolean includeRunningVMBootclasspath) {
        this.classpaths = classpathEntries;
        this.sourcepaths = sourcepathEntries;
        this.sourcepathsEncodings = encodings;
        if (encodings != null && (sourcepathEntries == null || sourcepathEntries.length != encodings.length)) {
            throw new IllegalArgumentException();
        }
        if (includeRunningVMBootclasspath) {
            this.bits |= 0x20;
        }
    }

    public void setCompilerOptions(Map<String, String> options) {
        options = options == null ? JavaCore.getOptions() : new HashMap<String, String>(options);
        this.compilerOptions = options;
    }

    public void setResolveBindings(boolean enabled) {
        this.bits = enabled ? (this.bits |= 1) : (this.bits &= 0xFFFFFFFE);
    }

    public void setFocalPosition(int position) {
        this.bits |= 2;
        this.focalPointPosition = position;
    }

    public void setKind(int kind) {
        if (kind != 8 && kind != 4 && kind != 1 && kind != 16 && kind != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = kind;
    }

    public void setSource(char[] source) {
        this.rawSource = source;
        this.typeRoot = null;
    }

    public void setSource(ICompilationUnit source) {
        this.setSource((ITypeRoot)source);
        if (source != null) {
            this.setCompilerOptions(source.getOptions(true));
        }
    }

    public void setSource(IClassFile source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(ITypeRoot source) {
        this.typeRoot = source;
        this.rawSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            Map<String, String> options = this.project.getOptions(true);
            options.remove("org.eclipse.jdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public void setSource(ITypeRoot source, int astLevel) {
        this.typeRoot = source;
        this.rawSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            Map<String, String> options = this.project.getOptions(true);
            options.remove("org.eclipse.jdt.core.compiler.taskTags");
            this.compilerOptions = options;
            String compliance = DOMASTUtil.getCompliance(astLevel);
            this.compilerOptions.put("org.eclipse.jdt.core.compiler.compliance", compliance);
            this.compilerOptions.put("org.eclipse.jdt.core.compiler.source", compliance);
            this.compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
        }
    }

    public void setSourceRange(int offset, int length) {
        if (offset < 0 || length < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public void setStatementsRecovery(boolean enabled) {
        this.bits = enabled ? (this.bits |= 4) : (this.bits &= 0xFFFFFFFB);
    }

    public void setIgnoreMethodBodies(boolean enabled) {
        this.bits = enabled ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
    }

    public void setWorkingCopyOwner(WorkingCopyOwner owner) {
        this.workingCopyOwner = owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setProject(IJavaProject project) {
        this.project = project;
        if (project != null) {
            Map<String, String> options = project.getOptions(true);
            options.remove("org.eclipse.jdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public ASTNode createAST(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        ASTNode result = null;
        try {
            if (this.rawSource == null && this.typeRoot == null) {
                throw new IllegalStateException("source not specified");
            }
            result = this.internalCreateAST((IProgressMonitor)subMonitor.split(1));
        }
        finally {
            this.initializeDefaults();
        }
        return result;
    }

    public void createASTs(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        try {
            int flags = 0;
            if ((this.bits & 4) != 0) {
                flags |= 2;
            }
            if ((this.bits & 8) != 0) {
                flags |= 8;
            }
            if ((this.bits & 1) != 0) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                if ((this.bits & 0x10) != 0) {
                    flags |= 4;
                }
                this.unitResolver.resolve(ASTParser.safeCopyOf(compilationUnits), ASTParser.safeCopyOf(bindingKeys), requestor, this.apiLevel, ASTParser.safeUnmodifiableMap(this.compilerOptions), this.project, this.workingCopyOwner, flags, monitor);
            } else {
                this.unitResolver.parse(ASTParser.safeCopyOf(compilationUnits), requestor, this.apiLevel, ASTParser.safeUnmodifiableMap(this.compilerOptions), flags, monitor);
            }
        }
        finally {
            this.initializeDefaults();
        }
    }

    private static <T> T[] safeCopyOf(T[] original) {
        return original == null ? null : Arrays.copyOf(original, original.length);
    }

    private static <K, V> Map<K, V> safeUnmodifiableMap(Map<? extends K, ? extends V> m) {
        return m == null ? null : Collections.unmodifiableMap(m);
    }

    public void createASTs(String[] sourceFilePaths, String[] encodings, String[] bindingKeys, FileASTRequestor requestor, IProgressMonitor monitor) {
        try {
            int flags = 0;
            if ((this.bits & 4) != 0) {
                flags |= 2;
            }
            if ((this.bits & 8) != 0) {
                flags |= 8;
            }
            if ((this.bits & 1) != 0) {
                if (this.classpaths == null && this.sourcepaths == null && (this.bits & 0x20) == 0) {
                    throw new IllegalStateException("no environment is specified");
                }
                if ((this.bits & 0x10) != 0) {
                    flags |= 4;
                }
                this.unitResolver.resolve(ASTParser.safeCopyOf(sourceFilePaths), ASTParser.safeCopyOf(encodings), ASTParser.safeCopyOf(bindingKeys), requestor, this.apiLevel, ASTParser.safeUnmodifiableMap(this.compilerOptions), this.getClasspath(), flags, monitor);
            } else {
                this.unitResolver.parse(ASTParser.safeCopyOf(sourceFilePaths), ASTParser.safeCopyOf(encodings), requestor, this.apiLevel, ASTParser.safeUnmodifiableMap(this.compilerOptions), flags, monitor);
            }
        }
        finally {
            this.initializeDefaults();
        }
    }

    public IBinding[] createBindings(IJavaElement[] elements, IProgressMonitor monitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project or classpath not specified");
            }
            int flags = 0;
            if ((this.bits & 4) != 0) {
                flags |= 2;
            }
            if ((this.bits & 0x10) != 0) {
                flags |= 4;
            }
            if ((this.bits & 8) != 0) {
                flags |= 8;
            }
            IBinding[] iBindingArray = ASTParser.resolve(elements, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, this.unitResolver, monitor);
            return iBindingArray;
        }
        finally {
            this.initializeDefaults();
        }
    }

    static IBinding[] resolve(IJavaElement[] elements, int apiLevel, Map<String, String> compilerOptions, IJavaProject javaProject, WorkingCopyOwner owner, int flags, ICompilationUnitResolver unitResolver, IProgressMonitor monitor) {
        int length = elements.length;
        HashMap<IJavaElement, CompilationUnitResolver.IntArrayList> sourceElementPositions = new HashMap<IJavaElement, CompilationUnitResolver.IntArrayList>();
        int cuNumber = 0;
        HashtableOfObjectToInt binaryElementPositions = new HashtableOfObjectToInt();
        int i = 0;
        while (i < length) {
            IJavaElement element = elements[i];
            if (!(element instanceof SourceRefElement)) {
                throw new IllegalStateException(String.valueOf(element) + " is not part of a compilation unit or class file");
            }
            IJavaElement cu = element.getAncestor(5);
            if (cu != null) {
                CompilationUnitResolver.IntArrayList intList = (CompilationUnitResolver.IntArrayList)sourceElementPositions.get(cu);
                if (intList == null) {
                    intList = new CompilationUnitResolver.IntArrayList();
                    sourceElementPositions.put(cu, intList);
                    ++cuNumber;
                }
                intList.add(i);
            } else {
                try {
                    String key;
                    if (element instanceof BinaryMember) {
                        key = ((BinaryMember)element).getKey(true);
                    } else if (element instanceof LocalVariable) {
                        key = ((LocalVariable)element).getKey(true);
                    } else if (element instanceof TypeParameter) {
                        key = ((TypeParameter)element).getKey(true);
                    } else if (element instanceof BinaryModule) {
                        key = ((BinaryModule)element).getKey(true);
                    } else {
                        throw new IllegalArgumentException(String.valueOf(element) + " has an unexpected type");
                    }
                    binaryElementPositions.put((Object)key, i);
                }
                catch (JavaModelException e) {
                    throw new IllegalArgumentException(String.valueOf(element) + " does not exist", (Throwable)((Object)e));
                }
            }
            ++i;
        }
        ICompilationUnit[] cus = new ICompilationUnit[cuNumber];
        sourceElementPositions.keySet().toArray(cus);
        int bindingKeyNumber = binaryElementPositions.size();
        Object[] bindingKeys = new String[bindingKeyNumber];
        binaryElementPositions.keysToArray(bindingKeys);
        class Requestor
        extends ASTRequestor {
            IBinding[] bindings;
            private final /* synthetic */ HashMap val$sourceElementPositions;
            private final /* synthetic */ IJavaElement[] val$elements;
            private final /* synthetic */ HashtableOfObjectToInt val$binaryElementPositions;

            Requestor(int n, HashMap hashMap, IJavaElement[] iJavaElementArray, HashtableOfObjectToInt hashtableOfObjectToInt) {
                this.val$sourceElementPositions = hashMap;
                this.val$elements = iJavaElementArray;
                this.val$binaryElementPositions = hashtableOfObjectToInt;
                this.bindings = new IBinding[n];
            }

            @Override
            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                CompilationUnitResolver.IntArrayList intList = (CompilationUnitResolver.IntArrayList)this.val$sourceElementPositions.get(source);
                int i = 0;
                while (i < intList.length) {
                    int index = intList.list[i];
                    SourceRefElement element = (SourceRefElement)this.val$elements[index];
                    DOMFinder finder = new DOMFinder(ast, element, true);
                    try {
                        finder.search();
                    }
                    catch (JavaModelException e) {
                        throw new IllegalArgumentException(String.valueOf(element) + " does not exist", (Throwable)((Object)e));
                    }
                    this.bindings[index] = finder.foundBinding;
                    ++i;
                }
            }

            @Override
            public void acceptBinding(String bindingKey, IBinding binding) {
                int index = this.val$binaryElementPositions.get((Object)bindingKey);
                this.bindings[index] = binding;
            }
        }
        Requestor requestor = new Requestor(length, sourceElementPositions, elements, binaryElementPositions);
        unitResolver.resolve(cus, (String[])bindingKeys, requestor, apiLevel, compilerOptions, javaProject, owner, flags, monitor);
        return requestor.bindings;
    }

    private ASTNode internalCreateAST(IProgressMonitor monitor) {
        return JavaModelManager.cacheZipFiles(() -> this.internalCreateASTCached(monitor));
    }

    private ASTNode internalCreateASTCached(IProgressMonitor monitor) {
        boolean needToResolveBindings = (this.bits & 1) != 0;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: 
            case 16: {
                if (this.rawSource == null && this.typeRoot != null) {
                    if (this.typeRoot instanceof ICompilationUnit) {
                        org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)this.typeRoot;
                        this.rawSource = sourceUnit.getContents();
                    } else if (this.typeRoot instanceof IClassFile) {
                        try {
                            String sourceString = this.typeRoot.getSource();
                            if (sourceString != null) {
                                this.rawSource = sourceString.toCharArray();
                            }
                        }
                        catch (JavaModelException e) {
                            CharSequence stackTrace = org.eclipse.jdt.internal.compiler.util.Util.getStackTrace((Throwable)((Object)e));
                            throw new IllegalStateException(stackTrace.toString());
                        }
                    }
                }
                if (this.rawSource == null) break;
                if (this.sourceOffset + this.sourceLength > this.rawSource.length) {
                    throw new IllegalStateException();
                }
                return this.internalCreateASTForKind();
            }
            case 8: {
                boolean useSearcher = false;
                org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = null;
                WorkingCopyOwner wcOwner = this.workingCopyOwner;
                if (this.typeRoot instanceof ClassFileWorkingCopy) {
                    this.typeRoot = ((ClassFileWorkingCopy)this.typeRoot).classFile;
                }
                if (this.typeRoot instanceof ICompilationUnit) {
                    sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)this.typeRoot;
                    sourceUnit = new BasicCompilationUnit(sourceUnit.getContents(), sourceUnit.getPackageName(), new String(sourceUnit.getFileName()), this.project);
                    wcOwner = ((ICompilationUnit)this.typeRoot).getOwner();
                } else if (this.typeRoot instanceof IClassFile) {
                    try {
                        String sourceString = this.typeRoot.getSource();
                        if (sourceString == null) {
                            throw new IllegalStateException();
                        }
                        PackageFragment packageFragment = (PackageFragment)this.typeRoot.getParent();
                        BinaryType type = (BinaryType)this.typeRoot.findPrimaryType();
                        String fileNameString = null;
                        if (type != null) {
                            IBinaryType binaryType = type.getElementInfo();
                            char[] fileName = binaryType.getFileName();
                            int firstDollar = CharOperation.indexOf((char)'$', (char[])fileName);
                            if (firstDollar != -1) {
                                char[] suffix = SuffixConstants.SUFFIX_class;
                                int suffixLength = suffix.length;
                                char[] newFileName = new char[firstDollar + suffixLength];
                                System.arraycopy(fileName, 0, newFileName, 0, firstDollar);
                                System.arraycopy(suffix, 0, newFileName, firstDollar, suffixLength);
                                fileName = newFileName;
                            }
                            fileNameString = new String(fileName);
                        } else {
                            fileNameString = this.typeRoot.getElementName();
                        }
                        sourceUnit = new BasicCompilationUnit(sourceString.toCharArray(), Util.toCharArrays(packageFragment.names), fileNameString, this.typeRoot);
                    }
                    catch (JavaModelException e) {
                        CharSequence stackTrace = org.eclipse.jdt.internal.compiler.util.Util.getStackTrace((Throwable)((Object)e));
                        throw new IllegalStateException(stackTrace.toString());
                    }
                } else if (this.rawSource != null) {
                    needToResolveBindings = (this.bits & 1) != 0 && this.unitName != null && (this.project != null || this.classpaths != null || this.sourcepaths != null || (this.bits & 0x20) != 0) && this.compilerOptions != null;
                    sourceUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                } else {
                    throw new IllegalStateException();
                }
                if ((this.bits & 2) != 0) {
                    useSearcher = true;
                }
                int flags = 0;
                if ((this.bits & 4) != 0) {
                    flags |= 2;
                }
                if (!useSearcher && (this.bits & 8) != 0) {
                    flags |= 8;
                }
                if (needToResolveBindings && (this.bits & 0x10) != 0) {
                    flags |= 4;
                }
                CompilationUnit result = this.unitResolver.toCompilationUnit(sourceUnit, needToResolveBindings, this.project, this.getClasspath(), useSearcher ? this.focalPointPosition : -1, this.apiLevel, ASTParser.safeUnmodifiableMap(this.compilerOptions), this.workingCopyOwner, wcOwner, flags, monitor);
                result.setTypeRoot(this.typeRoot);
                return result;
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        ASTConverter converter = new ASTConverter(this.compilerOptions, false, null);
        converter.compilationUnitSource = this.rawSource;
        converter.compilationUnitSourceLength = this.rawSource.length;
        converter.scanner.setSource(this.rawSource);
        AST ast = AST.newAST(this.apiLevel, "enabled".equals(this.compilerOptions.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures")));
        ast.setDefaultNodeFlag(2);
        ast.setBindingResolver(new BindingResolver());
        if ((this.bits & 4) != 0) {
            ast.setFlag(2);
        }
        ast.scanner.previewEnabled = "enabled".equals(this.compilerOptions.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures"));
        converter.setAST(ast);
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil((this.bits & 8) != 0);
        CompilationUnit compilationUnit = ast.newCompilationUnit();
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        switch (this.astKind) {
            case 2: {
                org.eclipse.jdt.internal.compiler.ast.Statement[] statements;
                ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, (this.bits & 4) != 0);
                RecoveryScannerData data = constructorDeclaration.compilationResult.recoveryScannerData;
                if (data != null) {
                    Scanner scanner = converter.scanner;
                    converter.docParser.scanner = converter.scanner = new RecoveryScanner(scanner, data.removeUnused());
                    converter.scanner.setSource(scanner.source);
                    compilationUnit.setStatementsRecoveryData(data);
                }
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                Block block = ast.newBlock();
                block.setSourceRange(this.sourceOffset, this.sourceOffset + this.sourceLength);
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null && constructorCall.accessMode != 1) {
                    block.statements().add(converter.convert(constructorCall));
                }
                if ((statements = constructorDeclaration.statements) != null) {
                    int statementsLength = statements.length;
                    int i = 0;
                    while (i < statementsLength) {
                        if (statements[i] instanceof LocalDeclaration) {
                            converter.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                        } else {
                            Statement statement = converter.convert(statements[i]);
                            if (statement != null) {
                                block.statements().add(statement);
                            }
                        }
                        ++i;
                    }
                }
                this.rootNodeToCompilationUnit(ast, compilationUnit, block, recordedParsingInformation, data);
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return block;
            }
            case 1: 
            case 16: {
                org.eclipse.jdt.internal.compiler.ast.Expression expression = this.astKind == 1 ? codeSnippetParsingUtil.parseExpression(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true) : codeSnippetParsingUtil.parseParameterMapping(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (expression != null) {
                    Expression expression2 = converter.convert(expression);
                    this.rootNodeToCompilationUnit(expression2.getAST(), compilationUnit, expression2, codeSnippetParsingUtil.recordedParsingInformation, null);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return expression2;
                }
                CategorizedProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems((IProblem[])problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 4: {
                org.eclipse.jdt.internal.compiler.ast.ASTNode[] nodes = codeSnippetParsingUtil.parseClassBodyDeclarations(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, (this.bits & 4) != 0);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (nodes != null) {
                    TypeDeclaration typeDeclaration = converter.convert(nodes);
                    typeDeclaration.setSourceRange(this.sourceOffset, this.sourceOffset + this.sourceLength);
                    this.rootNodeToCompilationUnit(typeDeclaration.getAST(), compilationUnit, typeDeclaration, codeSnippetParsingUtil.recordedParsingInformation, null);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return typeDeclaration;
                }
                CategorizedProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems((IProblem[])problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
        }
        throw new IllegalStateException();
    }

    private void propagateErrors(ASTNode astNode, CategorizedProblem[] problems, RecoveryScannerData data) {
        astNode.accept(new ASTSyntaxErrorPropagator(problems));
        if (data != null) {
            astNode.accept(new ASTRecoveryPropagator(problems, data));
        }
    }

    private void rootNodeToCompilationUnit(AST ast, CompilationUnit compilationUnit, ASTNode node, RecordedParsingInformation recordedParsingInformation, RecoveryScannerData data) {
        int problemsCount = recordedParsingInformation.problemsCount;
        switch (node.getNodeType()) {
            case 8: {
                Block block = (Block)node;
                if (problemsCount != 0) {
                    CategorizedProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(block, problems, data);
                    compilationUnit.setProblems((IProblem[])problems);
                }
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (problemsCount != 0) {
                    CategorizedProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(typeDeclaration, problems, data);
                    compilationUnit.setProblems((IProblem[])problems);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                if (!(node instanceof Expression)) break;
                Expression expression = (Expression)node;
                if (problemsCount != 0) {
                    CategorizedProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(expression, problems, data);
                    compilationUnit.setProblems((IProblem[])problems);
                }
                ExpressionStatement expressionStatement = ast.newExpressionStatement(expression);
                Block block = ast.newBlock();
                block.statements().add(expressionStatement);
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }

    private boolean hasJavaNature() {
        return this.project == null || JavaProject.hasJavaNature(this.project.getProject());
    }
}

