/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ExtraCompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectMapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class AstConverter
implements ClassFileConstants,
ExtraCompilerModifiers,
IOTConstants {
    static final char[] VALUE_ARG = "value".toCharArray();
    public static final char[] ROLE_ARG_NAME = "_OT$rolearg".toCharArray();

    public static TypeDeclaration genRoleInterface(TypeDeclaration teamDeclaration, TypeDeclaration roleClassDeclaration) {
        TypeReference superClass;
        TypeDeclaration typeDeclaration = new TypeDeclaration(roleClassDeclaration.compilationResult);
        typeDeclaration.modifiers = (roleClassDeclaration.modifiers | 0x1200 | 0x10000) & 0x7FFFFFEF;
        typeDeclaration.isGenerated = true;
        typeDeclaration.name = roleClassDeclaration.name;
        typeDeclaration.sourceStart = roleClassDeclaration.sourceStart;
        typeDeclaration.sourceEnd = roleClassDeclaration.sourceEnd;
        if (roleClassDeclaration.isRoleFile()) {
            AstEdit.addTypeDeclaration(roleClassDeclaration.compilationUnit, typeDeclaration);
        }
        typeDeclaration.typeParameters = AstClone.copyTypeParameters(roleClassDeclaration.typeParameters);
        if (roleClassDeclaration.superInterfaces != null) {
            typeDeclaration.superInterfaces = roleClassDeclaration.superInterfaces;
            roleClassDeclaration.superInterfaces = null;
        }
        if ((superClass = roleClassDeclaration.superclass) != null && superClass instanceof SingleTypeReference && CharOperation.equals(((SingleTypeReference)superClass).token, IOTConstants.CONFINED)) {
            AstGenerator gen = new AstGenerator(roleClassDeclaration.sourceStart, roleClassDeclaration.sourceEnd);
            typeDeclaration.superclass = gen.singleTypeReference(IOTConstants.OTCONFINED);
        }
        return typeDeclaration;
    }

    static int computeIfcpartModifiers(int modifiers) {
        return (modifiers | 0x1000400) & 0xFFEFF6CF;
    }

    public static AbstractMethodDeclaration createMethod(MethodBinding methodBinding, ReferenceBinding site, CompilationResult compilationResult, Expression.DecapsulationState decapsulation, AstGenerator gen, Scope scope) {
        AbstractMethodDeclaration abstractMethodDeclaration;
        if (methodBinding == null) {
            return null;
        }
        if ((methodBinding.tagBits & 0x80L) != 0L) {
            scope.problemReporter().missingTypeInMethod((ASTNode)((Object)scope.referenceContext()), methodBinding);
            return null;
        }
        if (CharOperation.equals(methodBinding.selector, TypeConstants.INIT)) {
            ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
            constructorDeclaration.selector = site != null ? site.sourceName : methodBinding.declaringClass.sourceName;
            abstractMethodDeclaration = constructorDeclaration;
        } else {
            MethodDeclaration methodDeclaration = new MethodDeclaration(compilationResult);
            methodDeclaration.returnType = CharOperation.prefixEquals(IOTConstants.CAST_PREFIX, methodBinding.selector) || CharOperation.prefixEquals(IOTConstants._OT_LIFT_TO, methodBinding.selector) ? new SingleTypeReference(methodBinding.returnType.internalName(), 0L) : gen.typeReference(methodBinding.returnType);
            methodDeclaration.returnType.setBaseclassDecapsulation(decapsulation);
            methodDeclaration.selector = methodBinding.selector;
            TypeVariableBinding[] typeVariables = methodBinding.typeVariables();
            if (typeVariables != Binding.NO_TYPE_VARIABLES) {
                TypeParameter[] parameters = new TypeParameter[typeVariables.length];
                int i = 0;
                while (i < typeVariables.length) {
                    parameters[i] = gen.typeParameter(typeVariables[i]);
                    ++i;
                }
                methodDeclaration.typeParameters = parameters;
            }
            abstractMethodDeclaration = methodDeclaration;
        }
        gen.setMethodPositions(abstractMethodDeclaration);
        abstractMethodDeclaration.modifiers = methodBinding.modifiers & 0xFFFFEFBF;
        if (methodBinding.isAbstract()) {
            abstractMethodDeclaration.modifiers |= 0x1000000;
        }
        abstractMethodDeclaration.arguments = AstConverter.createArguments(methodBinding.parameters, site, decapsulation, gen);
        abstractMethodDeclaration.isCopied = true;
        abstractMethodDeclaration.sourceMethodBinding = methodBinding;
        abstractMethodDeclaration.thrownExceptions = AstClone.copyExceptions(methodBinding, gen);
        return abstractMethodDeclaration;
    }

    public static FieldDeclaration createField(FieldBinding fieldBinding, TypeDeclaration roleDeclaration, AstGenerator gen) {
        if (fieldBinding == null) {
            return null;
        }
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        fieldDeclaration.type = gen.typeReference(fieldBinding.type);
        fieldDeclaration.modifiers = fieldBinding.modifiers & 0xFBFFFFFF;
        fieldDeclaration.name = fieldBinding.name;
        fieldDeclaration.copyInheritanceSrc = fieldBinding.copyInheritanceSrc != null ? fieldBinding.copyInheritanceSrc : fieldBinding;
        AnnotationBinding[] annotBindings = fieldBinding.getAnnotations();
        if (annotBindings != Binding.NO_ANNOTATIONS) {
            ProblemReporter pr = fieldBinding.isStatic() ? roleDeclaration.staticInitializerScope.problemReporter() : roleDeclaration.initializerScope.problemReporter();
            Annotation[] annotDecls = new Annotation[annotBindings.length];
            boolean hasAnnotationError = false;
            int i = 0;
            while (i < annotBindings.length) {
                AnnotationBinding binding = annotBindings[i];
                ElementValuePair[] elementValuePairs = binding.getElementValuePairs();
                char[][] annotTypeName = binding.getAnnotationType().compoundName;
                if (elementValuePairs == Binding.NO_ELEMENT_VALUE_PAIRS) {
                    annotDecls[i] = gen.markerAnnotation(annotTypeName);
                } else {
                    int numPairs = elementValuePairs.length;
                    char[][] names = new char[numPairs][];
                    Expression[] values = new Expression[numPairs];
                    int j = 0;
                    while (j < names.length) {
                        names[j] = elementValuePairs[j].getName();
                        Object elementValue = elementValuePairs[j].getValue();
                        values[j] = AstConverter.annotationValues(elementValue, gen, pr);
                        ++j;
                    }
                    if (values.length == 0 || values[0] == null) {
                        pr.unexpectedAnnotationStructure(annotTypeName, fieldBinding.name, gen.sourceStart, gen.sourceEnd);
                        hasAnnotationError = true;
                    } else {
                        annotDecls[i] = numPairs == 1 && CharOperation.equals(names[0], TypeConstants.VALUE) ? gen.singleMemberAnnotation(annotTypeName, values[0]) : gen.normalAnnotation(annotTypeName, names, values);
                    }
                }
                ++i;
            }
            if (!hasAnnotationError) {
                fieldDeclaration.annotations = annotDecls;
            }
        }
        return fieldDeclaration;
    }

    private static Expression annotationValues(Object elementValue, AstGenerator gen, ProblemReporter pr) {
        if (elementValue instanceof Object[]) {
            Object[] valuesArray = (Object[])elementValue;
            ArrayInitializer arrayInit = new ArrayInitializer();
            arrayInit.expressions = new Expression[valuesArray.length];
            int k = 0;
            while (k < valuesArray.length) {
                arrayInit.expressions[k] = AstConverter.annotationValue(valuesArray[k], gen, pr);
                if (arrayInit.expressions[k] == null) {
                    return null;
                }
                ++k;
            }
            return arrayInit;
        }
        return AstConverter.annotationValue(elementValue, gen, pr);
    }

    private static Expression annotationValue(Object elementValue, AstGenerator gen, ProblemReporter pr) {
        FieldBinding field;
        if (elementValue instanceof StringConstant) {
            return gen.stringLiteral(((StringConstant)elementValue).stringValue().toCharArray());
        }
        if (elementValue instanceof IntConstant) {
            return gen.intLiteral(((IntConstant)elementValue).intValue());
        }
        if (elementValue instanceof FieldBinding && (field = (FieldBinding)elementValue).isStatic()) {
            char[][] tokens = CharOperation.splitOn('.', field.declaringClass.readableName());
            tokens = CharOperation.arrayConcat(tokens, field.name);
            return gen.qualifiedNameReference(tokens);
        }
        return null;
    }

    public static TypeDeclaration createNestedType(char[] name, int modifiers, boolean isNestedType, boolean isPurelyCopied, TypeDeclaration teamDecl, ReferenceBinding tsuperRole) {
        ReferenceBinding superclass;
        TypeDeclaration enclosingTypeDecl = teamDecl;
        if (tsuperRole != null && isNestedType) {
            ReferenceBinding srcEnclosing = tsuperRole.enclosingType();
            TypeDeclaration[] members = enclosingTypeDecl.memberTypes;
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    if (CharOperation.equals(members[i].name, srcEnclosing.internalName())) {
                        enclosingTypeDecl = members[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        TypeDeclaration nestedType = new TypeDeclaration(enclosingTypeDecl.compilationResult);
        nestedType.name = name;
        nestedType.modifiers = modifiers;
        nestedType.isGenerated = true;
        nestedType.isPurelyCopied = isPurelyCopied;
        int sStart = enclosingTypeDecl.sourceStart;
        int sEnd = enclosingTypeDecl.sourceEnd;
        if (enclosingTypeDecl.superclass != null) {
            sStart = enclosingTypeDecl.superclass.sourceStart;
            sEnd = enclosingTypeDecl.superclass.sourceEnd;
        }
        nestedType.declarationSourceStart = sStart;
        nestedType.declarationSourceEnd = sEnd;
        nestedType.sourceStart = sStart;
        nestedType.sourceEnd = sEnd;
        nestedType.bodyStart = sStart;
        nestedType.bodyEnd = sEnd;
        AstGenerator gen = new AstGenerator(sStart, sEnd);
        if (tsuperRole != null && tsuperRole.isInterface() && (superclass = tsuperRole.superclass()) != null && CharOperation.equals(superclass.internalName(), IOTConstants.OTCONFINED)) {
            nestedType.superclass = gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED);
            nestedType.superclass.resolvedType = superclass;
        }
        if (tsuperRole != null && tsuperRole.isLocalType()) {
            nestedType.bits |= 0x100;
            if (tsuperRole.isAnonymousType()) {
                ReferenceBinding[] superIfcs = tsuperRole.superInterfaces();
                ReferenceBinding superType = superIfcs != Binding.NO_SUPERINTERFACES ? superIfcs[0] : tsuperRole.superclass();
                nestedType.allocation = new QualifiedAllocationExpression();
                nestedType.allocation.type = gen.typeReference(superType);
                nestedType.allocation.anonymousType = nestedType;
            }
            AstEdit.addLocalTypeDeclaration(enclosingTypeDecl, nestedType);
        } else {
            AstEdit.addMemberTypeDeclaration(enclosingTypeDecl, nestedType);
        }
        if (tsuperRole != null && tsuperRole.roleModel != null && tsuperRole.roleModel.isRoleFile()) {
            ProblemReporter reporter = enclosingTypeDecl.scope.problemReporter();
            CompilationResult compilationResult = new CompilationResult("nofile".toCharArray(), 0, 0, 0);
            CompilationUnitDeclaration cud = new CompilationUnitDeclaration(reporter, compilationResult, 0);
            nestedType.compilationResult = compilationResult;
            nestedType.compilationUnit = cud;
            cud.types = new TypeDeclaration[]{nestedType};
            char[][] enclosingName = enclosingTypeDecl.binding.compoundName;
            char[][] tokens = CharOperation.arrayConcat(enclosingName, nestedType.name);
            long[] positions = new long[tokens.length];
            Arrays.fill(positions, 0L);
            cud.currentPackage = new ImportReference(enclosingName, positions, false, Integer.MIN_VALUE);
        }
        enclosingTypeDecl.scope.addGeneratedType(nestedType);
        int state = enclosingTypeDecl.getModel().getState();
        if (enclosingTypeDecl.isTeam()) {
            state = enclosingTypeDecl.getTeamModel().getState();
        }
        nestedType.scope.connectTypeHierarchyForGenerated(state >= 6);
        state = Math.min(state, 6);
        if (nestedType.getRoleModel() != null) {
            nestedType.getRoleModel().setState(state);
        }
        if (nestedType.isTeam() && nestedType.getTeamModel() != null) {
            nestedType.getTeamModel().setState(state);
        }
        return nestedType;
    }

    private static Argument[] createArguments(TypeBinding[] parameters, ReferenceBinding site, Expression.DecapsulationState decapsulation, AstGenerator gen) {
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        int length = parameters.length;
        Argument[] arguments = new Argument[length];
        int i = 0;
        while (i < length) {
            TypeBinding tb = parameters[i];
            if (site != null && tb instanceof ReferenceBinding) {
                tb = ConstantPoolObjectMapper.searchRoleClass((ReferenceBinding)tb, site);
            }
            TypeReference tr = gen.typeReference(tb);
            tr.setBaseclassDecapsulation(decapsulation);
            char[] bez = ("arg" + i).toCharArray();
            arguments[i] = new Argument(bez, 0L, tr, 0);
            ++i;
        }
        return arguments;
    }

    public static MethodDeclaration findAndAdjustCopiedMethod(TypeDeclaration teamDecl, char[] methodName, Argument[] arguments) {
        int argumentsCount = arguments == null ? 0 : arguments.length;
        AbstractMethodDeclaration foundMethod = TypeAnalyzer.findMethodDecl(teamDecl, methodName, argumentsCount);
        if (foundMethod != null) {
            if (!foundMethod.isCopied) {
                if (!foundMethod.isGenerated) {
                    foundMethod.scope.problemReporter().overridingPredefined(foundMethod);
                    return null;
                }
                throw new InternalCompilerError("Generated methods conflicting with each other: " + new String(foundMethod.selector));
            }
            foundMethod.isCopied = false;
            foundMethod.isGenerated = true;
            foundMethod.modifiers &= 0xFEFFFBFF;
            if (arguments != null) {
                int i = 0;
                while (i < argumentsCount) {
                    foundMethod.arguments[i].updateName(arguments[i].name);
                    ++i;
                }
            }
            if (foundMethod.binding != null) {
                foundMethod.binding.modifiers &= 0xFFFFFBFF;
                if (foundMethod.binding.copyInheritanceSrc != null) {
                    foundMethod.binding.addOverriddenTSuper(foundMethod.binding.copyInheritanceSrc);
                    foundMethod.binding.setCopyInheritanceSrc(null);
                }
            }
            return (MethodDeclaration)foundMethod;
        }
        return null;
    }

    public static MethodDeclaration genRoleIfcMethod(TypeDeclaration typeDecl, MethodDeclaration classpartMethod) {
        MethodDeclaration newmethod = AstClone.copyMethod(typeDecl, classpartMethod, null);
        newmethod.modifiers = AstConverter.computeIfcpartModifiers(classpartMethod.modifiers);
        classpartMethod.interfacePartMethod = newmethod;
        return newmethod;
    }

    public static MethodDeclaration genIfcMethodFromBinding(TypeDeclaration teamDecl, MethodBinding classpartMethod, AstGenerator gen) {
        MethodDeclaration newmethod = new MethodDeclaration(teamDecl.compilationResult);
        newmethod.selector = classpartMethod.selector;
        newmethod.modifiers = AstConverter.computeIfcpartModifiers(classpartMethod.modifiers);
        if (CharOperation.prefixEquals(IOTConstants.CAST_PREFIX, classpartMethod.selector) && !((ReferenceBinding)classpartMethod.returnType).isPublic()) {
            newmethod.modifiers = 0x1000404;
        }
        newmethod.isGenerated = true;
        gen.setMethodPositions(newmethod);
        newmethod.arguments = AstConverter.createArgumentsFromParameters(classpartMethod.parameters, gen);
        newmethod.returnType = gen.typeReference(classpartMethod.returnType);
        if (classpartMethod.typeVariables() != Binding.NO_TYPE_VARIABLES) {
            TypeVariableBinding[] typeVarBindings = classpartMethod.typeVariables;
            newmethod.typeParameters = new TypeParameter[typeVarBindings.length];
            int i = 0;
            while (i < typeVarBindings.length) {
                newmethod.typeParameters[i] = gen.typeParameter(typeVarBindings[i]);
                ++i;
            }
        }
        newmethod.thrownExceptions = AstClone.copyExceptions(classpartMethod, gen);
        return newmethod;
    }

    public static Argument[] createArgumentsFromParameters(TypeBinding[] parameters, AstGenerator gen) {
        if (parameters.length == 0) {
            return null;
        }
        Argument[] newArguments = new Argument[parameters.length];
        int a = 0;
        while (a < parameters.length) {
            TypeBinding param = parameters[a];
            newArguments[a] = new Argument(("arg" + a).toCharArray(), gen.pos, gen.typeReference(param), 0);
            ++a;
        }
        return newArguments;
    }
}

