/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CPTypeAnchorAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTSpecialAccessAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ReferencedTeamsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.RoleFilesAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class TypeModel
extends ModelElement {
    private CPTypeAnchorAttribute _typeAnchors;
    public RoleFilesAttribute _roleFilesAttribute = null;
    protected TypeDeclaration _ast;
    protected ReferenceBinding _binding;
    private HashSet<ReferenceBinding> _referencedTeams = null;
    public final StateMemento _state;
    private LinkedList<TypeDeclaration> _localPlainTypes = new LinkedList();
    public int _maxLineNumber = 0;
    protected LineNumberProvider _lineNumberProvider;
    public int _compilerVersion;
    CompilerOptions.WeavingScheme weavingScheme;
    protected String _classFilePath = null;
    protected OTSpecialAccessAttribute _specialAccess = null;

    public TypeModel(TypeDeclaration ast) {
        this._ast = ast;
        int[] lineSeparatorPositions = ast.compilationResult.lineSeparatorPositions;
        if (lineSeparatorPositions != null) {
            this._maxLineNumber = Util.getLineNumber(ast.declarationSourceEnd, lineSeparatorPositions, 0, lineSeparatorPositions.length - 1);
        } else if (!ast.isConverted && !ast.isGenerated && Dependencies.needMethodBodies(ast)) {
            throw new InternalCompilerError("Unexpectedly missing line number information");
        }
        this._state = new StateMemento();
    }

    public TypeModel(ReferenceBinding bind) {
        this._binding = bind;
        this._state = new StateMemento();
    }

    public TypeModel(TypeModel prototype, ReferenceBinding protoBinding) {
        this._binding = protoBinding;
        this._state = prototype._state;
        this._compilerVersion = prototype._compilerVersion;
        this.weavingScheme = prototype.weavingScheme;
        this._ast = prototype._ast;
    }

    public void setCompilerVersion(int version, CompilerOptions.WeavingScheme weavingScheme) {
        this._compilerVersion = version;
        this.weavingScheme = weavingScheme;
    }

    public void setBinding(ReferenceBinding binding) {
        this._binding = binding;
        binding.model = this;
    }

    public TypeDeclaration getAst() {
        return this._ast;
    }

    public ReferenceBinding getBinding() {
        if (this._binding == null && this._ast != null && this._ast.binding != null) {
            this.setBinding(this._ast.binding);
        }
        return this._binding;
    }

    public TypeModel[] getMembers() {
        LinkedList<TypeModel> list;
        block21: {
            AbstractMethodDeclaration[] methods;
            block20: {
                list = new LinkedList<TypeModel>();
                if (this._ast != null) break block20;
                if (this._binding.kind() == 4100 || this._binding.kind() == 516 || this._binding.kind() == 8196 || this._binding.kind() == 32772) {
                    return new TypeModel[0];
                }
                if (this._binding.isUnresolvedType()) {
                    return new TypeModel[0];
                }
                assert (this._binding.isBinaryBinding());
                ReferenceBinding[] memberBindings = ((BinaryTypeBinding)this._binding).unresolvedMemberTypes();
                int i = 0;
                while (i < memberBindings.length) {
                    ReferenceBinding binding = memberBindings[i];
                    if (!(binding instanceof UnresolvedReferenceBinding)) {
                        if (binding.isTeam()) {
                            list.add(binding.getTeamModel());
                        } else {
                            list.add(binding.model);
                        }
                    }
                    ++i;
                }
                break block21;
            }
            TypeDeclaration[] members = this._ast.memberTypes;
            if (members != null) {
                int idx = 0;
                while (idx < members.length) {
                    TypeDeclaration decl = members[idx];
                    if (decl.isTeam()) {
                        list.add(decl.getTeamModel());
                    } else if (decl.isRole()) {
                        list.add(decl.getRoleModel());
                    } else {
                        list.add(decl.getModel());
                    }
                    ++idx;
                }
            }
            if ((methods = this._ast.methods) == null) break block21;
            int i = 0;
            while (i < methods.length) {
                if (methods[i] != null && methods[i].scope != null) {
                    ClassScope[] scopes = methods[i].scope.getAllLocalTypes();
                    int j = 0;
                    while (j < scopes.length) {
                        TypeDeclaration type = scopes[j].referenceContext;
                        if (type.isTeam()) {
                            list.add(type.getTeamModel());
                        } else if (type.isRole()) {
                            list.add(type.getRoleModel());
                        } else {
                            list.add(type.getModel());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return list.toArray(new TypeModel[list.size()]);
    }

    public ReferenceBinding findType(LookupEnvironment environment, char[][] compoundName) {
        char[][] myName = CharOperation.splitOn('/', this._binding.constantPoolName());
        if (this._binding.isLocalType() && CharOperation.equals(compoundName, myName)) {
            return this._binding;
        }
        if (this._binding.enclosingType() != null && this._binding.enclosingType().isRole()) {
            return this._binding.enclosingType().roleModel.findType(environment, compoundName);
        }
        return environment.getType(compoundName);
    }

    public char[] getInternalName() {
        if (this._ast != null) {
            return this._ast.name;
        }
        return this._binding.internalName();
    }

    public void cleanup() {
        this._ast = null;
        this._lineNumberProvider = null;
    }

    public void addLocalType(TypeDeclaration localType) {
        this._localPlainTypes.add(localType);
    }

    public int getState() {
        return this._state.getState();
    }

    public int setState(int state) {
        int oldState = this._state.setState(state);
        for (TypeDeclaration localType : this._localPlainTypes) {
            if (localType.getModel().getState() < 24) continue;
            localType.getModel().setState(state);
        }
        this._state.runPendingJobs(state);
        return oldState;
    }

    public void setMemberState(int state) {
        TypeModel[] members = this.getMembers();
        if (members != null) {
            int i = 0;
            while (i < members.length) {
                TypeModel member = members[i];
                member.setMemberState(state);
                member.setState(state);
                ++i;
            }
        }
    }

    public boolean isReadyToProcess(int state) {
        return this._state.isReadyToProcess(state);
    }

    public boolean isTeam() {
        return false;
    }

    public boolean isRole() {
        if (this._binding != null) {
            return this._binding.isRole();
        }
        return this._ast.isRole();
    }

    protected String getKindString() {
        return "Class ";
    }

    public String toString() {
        String name = this._ast != null ? new String(this._ast.name) : new String(this._binding.sourceName());
        return this.getKindString() + " " + name + " (state: " + String.valueOf(this._state) + ")";
    }

    public static void checkReferencedTeam(Binding binding, Scope scope) {
        if (!(binding instanceof ReferenceBinding)) {
            return;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        if (!type.isTeam()) {
            return;
        }
        ReferenceBinding currentType = scope.enclosingSourceType();
        while (currentType != null) {
            if (currentType == binding) {
                return;
            }
            currentType = currentType.enclosingType();
        }
        while (scope != null) {
            TypeDeclaration site = scope.referenceType();
            if (site == null) {
                return;
            }
            site.getModel().registerReferencedTeam(type);
            scope = scope.parent;
        }
    }

    private void registerReferencedTeam(ReferenceBinding teamType) {
        if (TypeAnalyzer.isOrgObjectteamsTeam(teamType)) {
            return;
        }
        if (this._referencedTeams == null) {
            this._referencedTeams = new HashSet();
            this.addAttribute(new ReferencedTeamsAttribute(this));
        }
        this._referencedTeams.add(teamType);
    }

    public ReferenceBinding[] getReferencedTeams() {
        return this._referencedTeams.toArray(new ReferenceBinding[this._referencedTeams.size()]);
    }

    public boolean isIgnoreFurtherInvestigation() {
        if (this._ast == null) {
            return false;
        }
        return TypeModel.isIgnoreFurtherInvestigation(this._ast);
    }

    public static boolean isIgnoreFurtherInvestigation(TypeDeclaration type) {
        AbstractMethodDeclaration method;
        MethodScope outerMostMethodScope;
        if (type.ignoreFurtherInvestigation) {
            return true;
        }
        if (type.compilationUnit != null && type.compilationUnit.ignoreFurtherInvestigation) {
            return true;
        }
        if (type.scope != null && type.scope.cuIgnoreFurtherInvestigation()) {
            return true;
        }
        if (type.enclosingType != null && type.enclosingType.ignoreFurtherInvestigation) {
            return true;
        }
        return (type.bits & 0x100) != 0 && type.scope != null && (outerMostMethodScope = type.scope.outerMostMethodScope()) != null && outerMostMethodScope.referenceContext instanceof AbstractMethodDeclaration && (method = (AbstractMethodDeclaration)outerMostMethodScope.referenceContext) != null && method.ignoreFurtherInvestigation;
    }

    public boolean isIncompatibleCompilerVersion() {
        int minVersion = (IOTConstants.OTVersion.getMajor() << 9) + (IOTConstants.OTVersion.getMinor() << 5);
        return this._compilerVersion < minVersion;
    }

    public CPTypeAnchorAttribute getTypeAnchors() {
        return this._typeAnchors;
    }

    public void setTypeAnchors(CPTypeAnchorAttribute attribute) {
        this._typeAnchors = attribute;
    }

    public void addTypeAnchor(ITeamAnchor anchor, int cpIndex) {
        if (this._typeAnchors == null) {
            this._typeAnchors = new CPTypeAnchorAttribute();
            this.addAttribute(this._typeAnchors);
        }
        this._typeAnchors.addTypeAnchor(anchor, cpIndex);
    }

    public void evaluateLateAttributes(int state) {
        try {
            ReferenceBinding[] memberTypes;
            try {
                if (this._binding != null && this._binding.isBinaryBinding() && this._attributes != null) {
                    int i = 0;
                    while (i < this._attributes.length) {
                        this._attributes[i].evaluateLateAttribute(this._binding, state);
                        ++i;
                    }
                }
            }
            catch (AbortCompilation ac) {
                ReferenceBinding enclosing;
                TypeDeclaration type = this._ast;
                if (type == null && (enclosing = this._binding.enclosingType()) != null && !enclosing.isBinaryBinding()) {
                    type = enclosing.model.getAst();
                }
                if (type != null) {
                    ac.updateContext(type, type.compilationResult);
                }
                throw ac;
            }
            if (this._binding != null && (memberTypes = this._binding.memberTypes()) != null) {
                int i = 0;
                while (i < memberTypes.length) {
                    ModelElement.evaluateLateAttributes(memberTypes[i], state);
                    ++i;
                }
            }
        }
        finally {
            if (state == 22) {
                this.setState(22);
            }
        }
    }

    public void setClassFilePath(String classFilePath) {
        this._classFilePath = classFilePath;
    }

    public ClassFileReader read() throws IOException, ClassFormatException {
        if (this._classFilePath != null) {
            FileNotFoundException fileNotFoundException = null;
            int i = 0;
            while (i < 5) {
                try {
                    return ClassFileReader.read(this._classFilePath);
                }
                catch (FileNotFoundException ex) {
                    fileNotFoundException = ex;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            if (fileNotFoundException != null) {
                throw fileNotFoundException;
            }
        }
        return null;
    }

    public void copyAttributeFrom(TypeModel superDeclaringType, char[] attributeName) {
        if (superDeclaringType._attributes == null) {
            return;
        }
        int i = 0;
        while (i < superDeclaringType._attributes.length) {
            if (superDeclaringType._attributes[i].nameEquals(attributeName)) {
                this.addOrMergeAttribute(superDeclaringType._attributes[i]);
                return;
            }
            ++i;
        }
    }

    public void setSpecialAccess(OTSpecialAccessAttribute attribute) {
        assert (this._specialAccess == null);
        this._specialAccess = attribute;
    }

    public OTSpecialAccessAttribute getSpecialAccessAttribute() {
        if (this._specialAccess == null) {
            this._specialAccess = new OTSpecialAccessAttribute(this._binding, this.getWeavingScheme());
            this.addAttribute(this._specialAccess);
        }
        return this._specialAccess;
    }

    public LineNumberProvider getLineNumberProvider() {
        if (this._lineNumberProvider == null) {
            this._lineNumberProvider = new LineNumberProvider(this._binding, this._maxLineNumber);
        }
        return this._lineNumberProvider;
    }

    public static LineNumberProvider getLineNumberProvider(TypeDeclaration type) {
        if (type.isRole()) {
            return type.getRoleModel().getLineNumberProvider();
        }
        if (type.isTeam()) {
            return type.getTeamModel().getLineNumberProvider();
        }
        return type.getModel().getLineNumberProvider();
    }

    public static boolean isConverted(ReferenceBinding declaringClass) {
        TeamModel teamModel;
        TypeDeclaration result;
        RoleModel roleModel;
        ClassScope scope;
        if (declaringClass instanceof SourceTypeBinding && (scope = ((SourceTypeBinding)declaringClass).scope) != null && ((Scope)scope).referenceType() != null) {
            return ((Scope)scope).referenceType().isConverted;
        }
        if (declaringClass.isRole() && (roleModel = declaringClass.roleModel) != null) {
            result = roleModel.getClassPartAst();
            if (result != null && result.isConverted) {
                return true;
            }
            result = roleModel.getInterfaceAst();
            if (result != null && result.isConverted) {
                return true;
            }
        }
        return declaringClass.isTeam() && (teamModel = declaringClass.getTeamModel()) != null && (result = teamModel.getAst()) != null && result.isConverted;
    }

    public CompilerOptions.WeavingScheme getWeavingScheme() {
        if (this.weavingScheme == null && this._ast != null && this._ast.scope != null) {
            this.weavingScheme = this._ast.scope.compilerOptions().weavingScheme;
            if (this.weavingScheme == CompilerOptions.WeavingScheme.OTDRE && this._attributes != null) {
                int i = 0;
                while (i < this._attributes.length) {
                    if (this._attributes[i].nameEquals(IOTConstants.OT_COMPILER_VERSION)) {
                        ((WordValueAttribute)this._attributes[i]).setWeavingScheme(this.weavingScheme);
                        break;
                    }
                    ++i;
                }
            }
        }
        return this.weavingScheme;
    }
}

