/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.AbstractTeam;
import org.eclipse.objectteams.otredyn.bytecode.Field;
import org.eclipse.objectteams.otredyn.bytecode.IBytecodeProvider;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.RedefineStrategyFactory;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddAfterClassLoadingHook;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddEmptyMethodAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddFieldAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddGlobalTeamActivationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddImplicitActivationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddInterfaceAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddThreadNotificationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateAddRemoveRoleMethod;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateCallAllBindingsCallInOrgMethod;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateDispatchCodeInCallAllBindingsAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateDispatchCodeInOrgMethodAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateFieldAccessAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateMethodAccessAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSpecificSuperCallInCallOrigAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSuperCallAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSuperCallInCallOrigAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSwitchAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSwitchForAccessAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSwitchForCallAllBindingsNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.LiftingParticipantAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.LoaderAwareClassWriter;
import org.eclipse.objectteams.otredyn.bytecode.asm.MoveCodeToCallOrigAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.MultiClassAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.ReplaceWickedSuperCallsAdapter;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.eclipse.objectteams.runtime.IReweavingTask;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

class AsmWritableBoundClass
extends AsmBoundClass {
    private static boolean dumping = false;
    private static boolean verifying = false;
    private ClassWriter writer;
    private MultiClassAdapter multiAdapter;
    private ClassReader reader;
    private boolean isTransformed;
    private boolean isTransformedForMemberAccess;
    private boolean isTransformedStatic;
    private List<AbstractTransformableClassNode> nodes;
    private boolean isFirstTransformation = true;
    private boolean isTransformationActive;
    private Boolean superIsWeavable;
    private int n = 0;

    static {
        if (System.getProperty("ot.dump") != null) {
            dumping = true;
        }
        if (System.getProperty("objectteams.otdre.verify") != null) {
            verifying = true;
        }
    }

    protected AsmWritableBoundClass(@NonNull String name, String id, IBytecodeProvider bytecodeProvider, ClassLoader loader) {
        super(name, id, bytecodeProvider, loader);
    }

    private void addField(Field field, int access) {
        assert (this.isTransformationActive) : "No transformation active";
        String desc = field.getSignature();
        this.multiAdapter.addVisitor(new AddFieldAdapter((ClassVisitor)this.writer, field.getName(), access, desc));
    }

    private void addEmptyMethod(Method method, int access, String signature, String[] exceptions, String superToCall, boolean addThrow) {
        assert (this.isTransformationActive) : "No transformation active";
        String desc = method.getSignature();
        Type[] args = Type.getArgumentTypes((String)desc);
        this.multiAdapter.addVisitor(new AddEmptyMethodAdapter((ClassVisitor)this.writer, method.getName(), access, desc, exceptions, signature, args.length + 1, superToCall, addThrow));
    }

    private void addInterface(String name) {
        assert (this.isTransformationActive) : "No transformation active";
        this.multiAdapter.setToplevelVisitor(new AddInterfaceAdapter((ClassVisitor)this.writer, name));
    }

    @Override
    protected void startTransformation() {
        this.reader = new ClassReader(this.allocateAndGetBytecode());
        this.writer = this.getClassWriter();
        this.multiAdapter = new MultiClassAdapter((ClassVisitor)this.writer);
        if (this.nodes == null) {
            this.nodes = new ArrayList<AbstractTransformableClassNode>();
        }
        this.isTransformationActive = true;
    }

    LoaderAwareClassWriter getClassWriter() {
        int flags = 2;
        return new LoaderAwareClassWriter(this.reader, flags, this.loader);
    }

    @Override
    public boolean isTransformationActive() {
        return this.isTransformationActive;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void endTransformation(Class<?> definedClass) throws IllegalClassFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void scheduleRetry(final Class<?> definedClass) {
        final Runnable previousTask = (Runnable)TeamManager.pendingTasks.get();
        TeamManager.pendingTasks.set(new Runnable(){

            @Override
            public void run() {
                if (previousTask != null) {
                    previousTask.run();
                }
                try {
                    AsmWritableBoundClass.this.redefine(definedClass);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }

            public String toString() {
                return "Retry " + AsmWritableBoundClass.this.toString();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void superTransformation(Class<?> definedClass) throws IllegalClassFormatException {
        AbstractTeam mySuper = this.getSuperclass();
        if (mySuper != null && mySuper.isLoaded()) {
            boolean superNeedsWeaving = false;
            Map map = mySuper.openBindingTasks;
            synchronized (map) {
                superNeedsWeaving = !mySuper.openBindingTasks.isEmpty();
            }
            if (superNeedsWeaving) {
                mySuper.handleTaskList(definedClass != null ? definedClass.getSuperclass() : null);
            }
        }
    }

    @Override
    protected void createDispatchCodeInOrgMethod(Method boundMethod, int joinPointId, int boundMethodId) {
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new CreateDispatchCodeInOrgMethodAdapter(boundMethod, joinPointId, boundMethodId));
    }

    @Override
    protected void createDispatchCodeInCallAllBindings(int joinpointId, int boundMethodId) {
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new CreateDispatchCodeInCallAllBindingsAdapter(joinpointId, boundMethodId));
    }

    @Override
    protected void moveCodeToCallOrig(Method boundMethod, int boundMethodId, boolean baseSuperRequired) {
        if (boundMethod.getName().equals("<init>")) {
            return;
        }
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new MoveCodeToCallOrigAdapter(this, boundMethod, boundMethodId, baseSuperRequired, this.weavingContext));
    }

    @Override
    protected void createSuperCallInCallOrig(int boundMethodId) {
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new CreateSuperCallInCallOrigAdapter(this.getInternalSuperClassName(), boundMethodId));
    }

    @Override
    protected void createCallAllBindingsCallInOrgMethod(Method boundMethod, int boundMethodId, boolean needToAddMethod) {
        assert (this.isTransformationActive) : "No transformation active";
        if (needToAddMethod) {
            String desc = boundMethod.getSignature();
            Type[] args = Type.getArgumentTypes((String)desc);
            this.multiAdapter.addVisitor(new AddEmptyMethodAdapter((ClassVisitor)this.writer, boundMethod.getName(), boundMethod.getAccessFlags(), desc, null, boundMethod.getSignature(), args.length + 1, null, false));
            this.nodes.add(new CreateSpecificSuperCallInCallOrigAdapter(this, this.getInternalSuperClassName(), boundMethod, boundMethodId));
        }
        this.nodes.add(new CreateCallAllBindingsCallInOrgMethod(boundMethod, boundMethodId));
    }

    @Override
    protected void replaceWickedSuperCalls(AbstractBoundClass superclass, Method targetMethod) {
        ReplaceWickedSuperCallsAdapter.register(this.nodes, superclass, targetMethod);
    }

    @Override
    protected void weaveMethodAccess(Method method, int accessId) {
        this.nodes.add(new CreateMethodAccessAdapter(method, accessId));
    }

    @Override
    protected void weaveFieldAccess(Field field, int accessId) {
        this.nodes.add(new CreateFieldAccessAdapter(field, accessId));
    }

    private void dump() {
        if (!dumping) {
            return;
        }
        String name = this.getName().replaceAll("/", ".");
        File dir = new File("otdyn");
        if (!dir.exists()) {
            dir.mkdir();
        }
        String filename = "otdyn/" + name + ".class";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(filename);){
                fos.write(this.allocateAndGetBytecode());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dump(byte[] bytecode, String postfix) {
        if (!dumping) {
            return;
        }
        String name = this.getName().replaceAll("/", ".");
        File dir = new File("otdyn");
        if (!dir.exists()) {
            dir.mkdir();
        }
        String filename = "otdyn/" + name + postfix + ".#" + this.n++;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream fos = new FileOutputStream(filename);){
                fos.write(bytecode);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void redefine(Class<?> definedClass) throws ClassNotFoundException {
        try {
            Class<?> clazz = definedClass != null ? definedClass : this.loader.loadClass(this.getName());
            byte[] bytecode = this.allocateAndGetBytecode();
            this.dump(bytecode, "redef");
            RedefineStrategyFactory.getRedefineStrategy().redefine(clazz, bytecode);
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Throwable t) {
            throw new RuntimeException("OTDRE: Error occured while dynamically redefining class " + this.getName() + "\n" + t.getMessage(), t);
        }
    }

    @Override
    protected void prepareAsPossibleBaseClass() {
        if (!this.isFirstTransformation) {
            return;
        }
        this.addInterface(ClassNames.I_BOUND_BASE_SLASH);
        int methodModifiers = 1;
        if (this.isInterface()) {
            methodModifiers |= 0x400;
        }
        if (!this.isInterface() && !this.isSuperWeavable(true)) {
            this.addField(ConstantMembers.roleSet, 1);
        }
        String internalWeavableDirectSuperClassName = this.getInternalWeavableSuperClassName(false);
        this.addEmptyMethod(ConstantMembers.callOrig, methodModifiers, null, null, internalWeavableDirectSuperClassName, true);
        this.addEmptyMethod(ConstantMembers.callAllBindingsClient, methodModifiers, null, null, internalWeavableDirectSuperClassName, true);
        if (!this.isInterface()) {
            this.addEmptyMethod(this.getCallOrigStatic(), 9, null, null, null, false);
            this.addEmptyMethod(ConstantMembers.accessStatic, 9, null, null, null, false);
        }
        this.addEmptyMethod(ConstantMembers.access, methodModifiers, null, null, this.getInternalWeavableSuperClassName(true), true);
        this.addEmptyMethod(ConstantMembers.addOrRemoveRole, methodModifiers, null, null, this.getInternalWeavableSuperClassName(true), true);
        if (!this.isInterface()) {
            this.multiAdapter.addVisitor(new AddAfterClassLoadingHook((ClassVisitor)this.writer, this));
        }
        if (AddThreadNotificationAdapter.shouldNotify(this)) {
            this.multiAdapter.addVisitor(new AddThreadNotificationAdapter((ClassVisitor)this.writer, this));
        }
    }

    Method getCallOrigStatic() {
        if (this.isRole()) {
            return ConstantMembers.callOrigStaticRoleVersion(this.getEnclosingClassName());
        }
        return ConstantMembers.callOrigStatic;
    }

    @Override
    protected void prepareTeamActivation() {
        if (!this.isFirstTransformation || this.isInterface()) {
            return;
        }
        if (this.isTeam() || this.isRole()) {
            this.multiAdapter.addVisitor(new AddImplicitActivationAdapter((ClassVisitor)this.writer, this));
        }
        AddGlobalTeamActivationAdapter.checkAddVisitor(this.multiAdapter, this.writer);
    }

    @Override
    protected void prepareLiftingParticipant() {
        if (this.isTeam() && LiftingParticipantAdapter.isLiftingParticipantConfigured(this.loader)) {
            this.multiAdapter.addVisitor(new LiftingParticipantAdapter((ClassVisitor)this.writer));
        }
    }

    @Override
    protected void prepareForFirstTransformation() {
        if (!this.isTransformed && !this.isInterface()) {
            this.nodes.add(new CreateSwitchAdapter(ConstantMembers.callOrig, this.getInternalWeavableSuperClassName(false)));
            this.nodes.add(new CreateSwitchForCallAllBindingsNode());
            this.nodes.add(new CreateAddRemoveRoleMethod());
            this.isTransformed = true;
            this.hierarchyIsCallinAffected = true;
            this.propagateCallinInfraToSubclasses();
        }
    }

    @Override
    protected void propagateCallinInfraToSubclasses() {
        for (AbstractBoundClass sub : this.subclasses.keySet()) {
            if (!(sub instanceof AsmWritableBoundClass)) continue;
            AsmWritableBoundClass writableSub = (AsmWritableBoundClass)sub;
            if (writableSub.hierarchyIsCallinAffected) continue;
            writableSub.hierarchyIsCallinAffected = true;
            if (sub.isAnonymous()) continue;
            writableSub.createSuperCalls();
            writableSub.propagateCallinInfraToSubclasses();
        }
    }

    @Override
    protected void prepareForFirstStaticTransformation() {
        if (!this.isTransformedStatic && !this.isInterface()) {
            this.nodes.add(new CreateSwitchAdapter(this.getCallOrigStatic(), this.isRole()));
            this.isTransformedStatic = true;
        }
    }

    @Override
    protected void createSuperCalls() {
        String internalSuperClassName = this.getInternalSuperClassName();
        final Runnable operation = () -> {
            this.nodes.add(new CreateSuperCallAdapter(internalSuperClassName, ConstantMembers.callAllBindingsClient));
            this.nodes.add(new CreateSuperCallAdapter(internalSuperClassName, ConstantMembers.callOrig));
            this.nodes.add(new CreateSuperCallAdapter(internalSuperClassName, ConstantMembers.access));
        };
        if (this.isTransformationActive || this.isFirstTransformation && !this.isTransformed) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<AbstractTransformableClassNode>();
            }
            operation.run();
        } else if (this.weavingContext != null) {
            IReweavingTask task = new IReweavingTask(){

                public void reweave(@Nullable Class<?> definedClass) throws IllegalClassFormatException {
                    AsmWritableBoundClass.this.startTransaction();
                    if (!AsmWritableBoundClass.this.isTransformationActive) {
                        AsmWritableBoundClass.this.startTransformation();
                    }
                    operation.run();
                    AsmWritableBoundClass.this.commitTransaction(definedClass);
                    AsmWritableBoundClass.this.endTransformation(definedClass);
                }
            };
            if (!this.weavingContext.scheduleReweaving(this.getName(), task)) {
                try {
                    task.reweave(this.definedClass);
                }
                catch (IllegalClassFormatException e) {
                    e.printStackTrace();
                }
            }
        } else {
            new IllegalStateException("weavingContext unexpectedly null").printStackTrace();
        }
    }

    @Override
    protected void prepareForFirstMemberAccess() {
        if (!this.isTransformedForMemberAccess && !this.isInterface()) {
            String internalWeavableSuperClassName = this.getInternalWeavableSuperClassName(true);
            this.nodes.add(new CreateSwitchForAccessAdapter(ConstantMembers.access, internalWeavableSuperClassName, this));
            this.nodes.add(new CreateSwitchForAccessAdapter(ConstantMembers.accessStatic, internalWeavableSuperClassName, this));
            this.isTransformedForMemberAccess = true;
        }
    }

    @Override
    public boolean isFirstTransformation() {
        return this.isFirstTransformation;
    }

    @Override
    public void restartTransformation() {
        this.isFirstTransformation = true;
    }

    @Override
    protected boolean isSuperWeavable(boolean considerSupers) {
        if (this.superIsWeavable == null) {
            this.superIsWeavable = this.weavingContext.isWeavable(this.getSuperClassName(), considerSupers, false);
        }
        return this.superIsWeavable;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toDebugString(buf, "");
        return buf.toString();
    }

    @Override
    public void toDebugString(StringBuilder buf, String indent) {
        buf.append(indent).append("AsmWritableBoundClass ").append(this.getName()).append('\n');
        buf.append(indent).append("[\n");
        buf.append(indent).append("    isTransformed=").append(this.isTransformed).append('\n');
        buf.append(indent).append("    isTransformedForMemberAccess=").append(this.isTransformedForMemberAccess).append('\n');
        buf.append(indent).append("    isTransformedStatic=").append(this.isTransformedStatic).append('\n');
        buf.append(indent).append("    isFirstTransformation=").append(this.isFirstTransformation).append('\n');
        buf.append(indent).append("    isTransformationActive=").append(this.isTransformationActive).append('\n');
        buf.append(indent).append("    boundBaseClasses=").append(this.boundBaseClasses).append('\n');
        buf.append(indent).append("    openBindingTasks=").append(this.openBindingTasks).append('\n');
        buf.append(indent).append("    parsed=").append(this.parsed).append('\n');
        buf.append(indent).append("    isUnweavable=").append(this.isUnweavable).append('\n');
        buf.append(indent).append("    subclasses=\n");
        for (AbstractBoundClass sub : this.subclasses.keySet()) {
            sub.toDebugString(buf, indent + "        ");
        }
        buf.append(indent).append("]\n");
    }
}

