/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.util;

import org.eclipse.objectteams.otre.util.BoundClass;
import org.eclipse.objectteams.otre.util.BoundMethod;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.RoleBaseBinding;

public class MethodBinding {
    private String bindingFileName;
    private int bindingLineNumber;
    private int bindingLineOffset;
    private String bindingLabel;
    private BoundMethod baseMethod;
    private BoundMethod roleMethod;
    private boolean isStaticBaseMethod;
    private boolean isStaticRoleMethod;
    private boolean covariantBaseReturn;
    private int translationFlags;
    private String wrapperName;
    private String wrapperSignature;
    private String modifier;
    private String liftMethodName;
    private String liftMethodSignature;
    private String roleClassName;
    private RoleBaseBinding classBinding;

    public MethodBinding() {
    }

    public MethodBinding(String bindingFileName, int bindingLineNumber, int bindingLineOffest, String bindingLabel, String roleMethodName, String roleMethodSignature, boolean isStaticRoleMethod, String wrapperName, String wrapperSignature, String modifier, String baseMethodName, String baseMethodSignature, boolean isStaticBaseMethod, boolean baseIsCallin, boolean covariantBaseReturn, int translationFlags, String liftMethodName, String liftMethodSignature, RoleBaseBinding classBinding) {
        this.bindingFileName = bindingFileName;
        this.bindingLineNumber = bindingLineNumber;
        this.bindingLineOffset = bindingLineOffest;
        this.bindingLabel = bindingLabel;
        this.roleMethod = new BoundMethod(roleMethodName, roleMethodSignature, false, this);
        this.baseMethod = new BoundMethod(baseMethodName, baseMethodSignature, baseIsCallin, this);
        this.isStaticRoleMethod = isStaticRoleMethod;
        this.isStaticBaseMethod = isStaticBaseMethod;
        this.covariantBaseReturn = covariantBaseReturn;
        this.translationFlags = translationFlags;
        this.wrapperName = wrapperName;
        this.wrapperSignature = wrapperSignature;
        this.modifier = modifier;
        this.liftMethodName = liftMethodName;
        this.liftMethodSignature = liftMethodSignature;
        this.classBinding = classBinding;
        this.roleClassName = classBinding.getRoleClassName();
    }

    public String getRoleClassName() {
        return this.roleClassName;
    }

    public String getBindingFileName() {
        return this.bindingFileName;
    }

    public int getBindingLineNumber() {
        return this.bindingLineNumber;
    }

    public int getBindingLineOffset() {
        return this.bindingLineOffset;
    }

    public String getBindingLabel() {
        return this.bindingLabel;
    }

    public String getQualifiedBindingLabel() {
        String result = this.roleClassName;
        result = result.substring(result.indexOf(36) + 1);
        result = result.replace('$', '.');
        result = result.replace("__OT__", "");
        return result + "." + this.bindingLabel;
    }

    public String getRoleMethodName() {
        return this.roleMethod.getName();
    }

    public String getRoleMethodSignature() {
        return this.roleMethod.getSignature();
    }

    public String getWrapperName() {
        return this.wrapperName;
    }

    public String getWrapperSignature() {
        return this.wrapperSignature;
    }

    public String getBaseClassName() {
        return this.classBinding.getBaseClassName();
    }

    public String getBaseMethodName() {
        return this.baseMethod.getName();
    }

    public String getBaseMethodSignature() {
        return this.baseMethod.getSignature();
    }

    public boolean baseMethodIsCallin() {
        return this.baseMethod.getIsCallin();
    }

    public String getModifier() {
        return this.modifier;
    }

    public boolean isReplace() {
        return this.modifier.equals("replace");
    }

    public boolean isAfter() {
        return this.modifier.equals("after");
    }

    public boolean isBefore() {
        return this.modifier.equals("before");
    }

    public String getLiftMethodName() {
        return this.liftMethodName;
    }

    public String getLiftMethodSignature() {
        return this.liftMethodSignature;
    }

    public RoleBaseBinding getClassBinding() {
        return this.classBinding;
    }

    public String getRootBoundBase() {
        BoundClass bc = this.classBinding.getRoleClass();
        while (bc.getSuper() != null && CallinBindingManager.isBoundRoleClass(bc.getSuper().getName())) {
            bc = bc.getSuper();
        }
        RoleBaseBinding rbb = CallinBindingManager.getRoleBaseBinding(bc.getName());
        return rbb.getBaseClassName();
    }

    public String getTeamClassName() {
        int dollarIndex = this.roleClassName.lastIndexOf(36);
        return this.roleClassName.substring(0, dollarIndex);
    }

    public boolean overridesMethodBinding(MethodBinding anotherMB) {
        if (anotherMB == null) {
            return false;
        }
        if (!this.bindingLabel.equals(anotherMB.getBindingLabel())) {
            return false;
        }
        return this.classBinding.getRoleClass().isSubClassOf(anotherMB.getClassBinding().getRoleClassName());
    }

    public boolean inheritsBindingLabel(String bindingLabel, String teamName) {
        String prefix = teamName + "$__OT__";
        int dotIndex = bindingLabel.lastIndexOf(46);
        String classOfLabel = prefix + bindingLabel.substring(0, dotIndex);
        if (!bindingLabel.substring(dotIndex + 1).equals(this.bindingLabel)) {
            return false;
        }
        return this.classBinding.getRoleClass().isSubClassOf(classOfLabel);
    }

    public boolean equals(MethodBinding mb) {
        return this.roleMethod.getName().equals(mb.getRoleMethodName()) && this.roleMethod.getSignature().equals(mb.getRoleMethodSignature()) && this.classBinding.getBaseClassName().equals(mb.getBaseClassName()) && this.baseMethod.getName().equals(mb.getBaseMethodName()) && this.baseMethod.getSignature().equals(mb.getBaseMethodSignature()) && this.modifier.equals(mb.getModifier());
    }

    public String toString() {
        StringBuilder result = new StringBuilder(32);
        result.append("\t");
        result.append(this.getQualifiedBindingLabel());
        result.append(": ");
        result.append(this.roleMethod.getName());
        result.append(this.roleMethod.getSignature());
        result.append(" <-> ");
        result.append(this.modifier);
        result.append(" ");
        result.append(this.baseMethod.getName());
        result.append(this.baseMethod.getSignature());
        if (this.covariantBaseReturn) {
            result.append('+');
        }
        return result.toString();
    }

    public boolean hasStaticRoleMethod() {
        return this.isStaticRoleMethod;
    }

    public boolean hasStaticBaseMethod() {
        return this.isStaticBaseMethod;
    }

    public int getTranslationFlags() {
        return this.translationFlags;
    }

    static String getBaseMethodKey(String baseMethodName, String baseMethodSignature) {
        int pos = baseMethodSignature.lastIndexOf(41);
        String baseMethodKey = baseMethodName + "." + baseMethodSignature.substring(0, pos + 1);
        return baseMethodKey;
    }

    public boolean matchesMethod(String mName, String mSig, boolean strict) {
        String baseMethodName = this.getBaseMethodName();
        String baseMethodSignature = this.getBaseMethodSignature();
        if (this.covariantBaseReturn && !strict) {
            return MethodBinding.getBaseMethodKey(mName, mSig).equals(MethodBinding.getBaseMethodKey(baseMethodName, baseMethodSignature));
        }
        return mName.equals(baseMethodName) && mSig.equals(baseMethodSignature);
    }
}

