/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.FieldDescriptor;
import org.eclipse.objectteams.otre.util.SuperMethodDescriptor;

public class Decapsulation
extends ObjectTeamsTransformation
implements Constants {
    private HashSet<String> generatedFieldCalloutAccessors = new HashSet();
    private HashSet<String> generatedSuperAccessors = new HashSet();

    public Decapsulation(Object loader) {
        super(loader);
    }

    public void doTransformInterface(ClassEnhancer ce, ClassGen cg) {
        String class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        this.checkReadClassAttributes(ce, cg, class_name, cpg);
        this.generateFieldAccessForCallout(ce, cg, class_name, cpg);
        this.generateSuperAccessors(ce, cg, class_name, cpg);
        HashSet<String> calloutBindings = CallinBindingManager.getCalloutBindings(class_name);
        if (calloutBindings == null) {
            if (logging) {
                Decapsulation.printLogMessage("\nClass " + class_name + " requires no callout adjustment.");
            }
            return;
        }
        if (logging) {
            Decapsulation.printLogMessage("\nCallout bindings might be changing class " + class_name + ":");
        }
        HashSet<String> oldStyleBinding = new HashSet<String>();
        Iterator<String> iterator = calloutBindings.iterator();
        while (iterator.hasNext()) {
            DecapsulationDescriptor desc = new DecapsulationDescriptor();
            String calloutBinding = iterator.next();
            if (!desc.decode(calloutBinding, cg)) {
                oldStyleBinding.add(calloutBinding);
                continue;
            }
            if (desc.existsAlready) continue;
            ce.addMethod(desc.generate(class_name, cpg), cg);
        }
        if (oldStyleBinding.isEmpty()) {
            return;
        }
        int pos = class_name.lastIndexOf(46);
        String package_name = "NO_PACKAGE";
        if (pos != -1) {
            package_name = class_name.substring(0, pos);
        }
        Method[] methods = cg.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            String method_name = m.getName();
            boolean requiresAdjustment = CallinBindingManager.requiresCalloutAdjustment(oldStyleBinding, method_name, m.getSignature());
            if (requiresAdjustment) {
                ce.decapsulateMethod(m, cg, package_name, cpg);
            }
            ++i;
        }
    }

    private void generateFieldAccessForCallout(ClassEnhancer ce, ClassGen cg, String class_name, ConstantPoolGen cpg) {
        List<FieldDescriptor> setter;
        InstructionFactory factory = null;
        HashSet<String> addedAccessMethods = this.generatedFieldCalloutAccessors;
        List<FieldDescriptor> getter = CallinBindingManager.getCalloutGetFields(class_name);
        if (getter != null) {
            factory = new InstructionFactory(cg);
            for (FieldDescriptor fd : getter) {
                String key = "get_" + class_name + "." + fd.getFieldName() + fd.getFieldSignature();
                if (logging) {
                    Decapsulation.printLogMessage("Generating getter method " + key);
                }
                if (addedAccessMethods == null) {
                    addedAccessMethods = new HashSet();
                }
                if (addedAccessMethods.contains(key)) continue;
                ce.addMethod(this.generateGetter(cpg, class_name, fd, factory), cg);
                addedAccessMethods.add(key);
            }
        }
        if ((setter = CallinBindingManager.getCalloutSetFields(class_name)) != null) {
            if (factory == null) {
                factory = new InstructionFactory(cg);
            }
            for (FieldDescriptor fd : setter) {
                String key = "set_" + class_name + "." + fd.getFieldName() + fd.getFieldSignature();
                if (logging) {
                    Decapsulation.printLogMessage("Generating setter method " + key);
                }
                if (addedAccessMethods == null) {
                    addedAccessMethods = new HashSet();
                }
                if (addedAccessMethods.contains(key)) continue;
                ce.addMethod(this.generateSetter(cpg, class_name, fd, factory), cg);
                addedAccessMethods.add(key);
            }
        }
    }

    private Method generateGetter(ConstantPoolGen cpg, String class_name, FieldDescriptor fd, InstructionFactory factory) {
        Type[] argumentTypes;
        String[] argumentNames;
        String fieldName = fd.getFieldName();
        Type fieldType = Type.getType((String)fd.getFieldSignature());
        ObjectType baseType = new ObjectType(class_name);
        InstructionList il = new InstructionList();
        if (fd.isStaticField()) {
            argumentNames = new String[]{};
            argumentTypes = new Type[]{};
        } else {
            argumentNames = new String[]{"base_obj"};
            argumentTypes = new Type[]{baseType};
        }
        MethodGen mg = new MethodGen(9, fieldType, argumentTypes, argumentNames, "_OT$get$" + fieldName, class_name, il, cpg);
        if (!fd.isStaticField()) {
            il.append((Instruction)InstructionFactory.createLoad((Type)baseType, (int)0));
        }
        short fieldKind = fd.isStaticField() ? (short)178 : 180;
        il.append((Instruction)factory.createFieldAccess(class_name, fieldName, fieldType, fieldKind));
        il.append((Instruction)InstructionFactory.createReturn((Type)fieldType));
        mg.removeNOPs();
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private Method generateSetter(ConstantPoolGen cpg, String class_name, FieldDescriptor fd, InstructionFactory factory) {
        int argumentPosition;
        String[] argumentNames;
        Type[] argumentTypes;
        String fieldName = fd.getFieldName();
        Type fieldType = Type.getType((String)fd.getFieldSignature());
        ObjectType baseType = new ObjectType(class_name);
        if (fd.isStaticField()) {
            argumentTypes = new Type[]{fieldType};
            argumentNames = new String[]{"new_value"};
        } else {
            argumentTypes = new Type[]{baseType, fieldType};
            argumentNames = new String[]{"base_obj", "new_value"};
        }
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(9, (Type)Type.VOID, argumentTypes, argumentNames, "_OT$set$" + fieldName, class_name, il, cpg);
        if (!fd.isStaticField()) {
            il.append((Instruction)InstructionFactory.createLoad((Type)baseType, (int)0));
            argumentPosition = 1;
        } else {
            argumentPosition = 0;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)fieldType, (int)argumentPosition));
        short fieldKind = fd.isStaticField() ? (short)179 : 181;
        il.append((Instruction)factory.createFieldAccess(class_name, fieldName, fieldType, fieldKind));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        mg.removeNOPs();
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private void generateSuperAccessors(ClassEnhancer ce, ClassGen cg, String class_name, ConstantPoolGen cpg) {
        InstructionFactory factory = null;
        HashSet<String> addedAccessMethods = this.generatedSuperAccessors;
        List<SuperMethodDescriptor> methods = CallinBindingManager.getSuperAccesses(class_name);
        if (methods != null) {
            factory = new InstructionFactory(cg);
            for (SuperMethodDescriptor superMethod : methods) {
                String key = superMethod.methodName + "." + superMethod.signature;
                if (logging) {
                    Decapsulation.printLogMessage("Generating super access method " + key);
                }
                if (addedAccessMethods == null) {
                    addedAccessMethods = new HashSet();
                }
                if (addedAccessMethods.contains(key)) continue;
                ce.addMethod(this.generateSuperAccessor(cpg, class_name, superMethod, factory), cg);
                addedAccessMethods.add(key);
            }
        }
    }

    private Method generateSuperAccessor(ConstantPoolGen cpg, String className, SuperMethodDescriptor superMethod, InstructionFactory factory) {
        int endPos = superMethod.signature.indexOf(41);
        String segment = superMethod.signature.substring(1, endPos);
        String[] typeNames = segment.length() > 0 ? segment.split(",") : new String[]{};
        Type[] argTypes = new Type[typeNames.length];
        int i = 0;
        while (i < argTypes.length) {
            argTypes[i] = Type.getType((String)typeNames[i]);
            ++i;
        }
        int index = superMethod.signature.lastIndexOf(41) + 1;
        Type returnType = Type.getType((String)superMethod.signature.substring(index));
        ObjectType baseType = new ObjectType(className);
        Type[] wrapperTypes = new Type[argTypes.length + 1];
        System.arraycopy(argTypes, 0, wrapperTypes, 1, argTypes.length);
        wrapperTypes[0] = baseType;
        String[] argNames = new String[wrapperTypes.length];
        int i2 = 0;
        while (i2 < argNames.length) {
            argNames[i2] = "arg" + i2;
            ++i2;
        }
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(9, returnType, wrapperTypes, argNames, "_OT$" + superMethod.methodName + "$super", className, il, cpg);
        il.append((Instruction)InstructionFactory.createLoad((Type)baseType, (int)0));
        int i3 = 0;
        while (i3 < argTypes.length) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i3], (int)(i3 + 1)));
            ++i3;
        }
        String methodName = CallinBindingManager.isBoundBaseMethod(superMethod.superClass, superMethod.methodName, superMethod.signature) ? Decapsulation.genOrigMethName(superMethod.methodName) : superMethod.methodName;
        il.append((Instruction)factory.createInvoke(superMethod.superClass, methodName, returnType, argTypes, (short)183));
        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    class DecapsulationDescriptor {
        short invokeKind;
        String targetClass;
        String methodName;
        String methodSign;
        Type returnType;
        Type[] args;
        String accessorName;
        boolean existsAlready;

        DecapsulationDescriptor() {
        }

        boolean decode(String encodedBinding, ClassGen cg) {
            Method existing;
            int sepPos = encodedBinding.indexOf(33);
            if (sepPos != -1) {
                this.invokeKind = (short)184;
            } else {
                sepPos = encodedBinding.indexOf(63);
                if (sepPos != -1) {
                    this.invokeKind = (short)182;
                } else {
                    return false;
                }
            }
            this.targetClass = encodedBinding.substring(0, sepPos);
            int sigPos = encodedBinding.indexOf(40, sepPos);
            this.methodName = encodedBinding.substring(sepPos + 1, sigPos);
            this.methodSign = encodedBinding.substring(sigPos);
            this.returnType = Type.getReturnType((String)this.methodSign);
            this.args = Type.getArgumentTypes((String)this.methodSign);
            this.accessorName = "_OT$decaps$" + this.methodName;
            boolean bl = this.existsAlready = cg.containsMethod(this.accessorName, this.methodSign) != null;
            if (this.invokeKind == 182 && (existing = cg.containsMethod(this.methodName, this.methodSign)) != null && existing.isPrivate()) {
                this.invokeKind = (short)183;
            }
            return true;
        }

        Method generate(String currentClass, ConstantPoolGen cpg) {
            InstructionList il = new InstructionList();
            int instanceOffset = 0;
            int flags = 1;
            if (this.invokeKind != 184) {
                instanceOffset = 1;
                il.append(InstructionFactory.createThis());
            } else {
                flags = (short)(flags | 8);
            }
            int pos = 0;
            int i = 0;
            while (i < this.args.length) {
                il.append((Instruction)InstructionFactory.createLoad((Type)this.args[i], (int)(pos + instanceOffset)));
                pos += this.args[i].getSize();
                ++i;
            }
            il.append((Instruction)new InstructionFactory(cpg).createInvoke(this.targetClass, this.methodName, this.returnType, this.args, this.invokeKind));
            il.append((Instruction)InstructionFactory.createReturn((Type)this.returnType));
            MethodGen newMethod = new MethodGen(flags, this.returnType, this.args, null, this.accessorName, currentClass, il, cpg);
            newMethod.setMaxLocals();
            newMethod.setMaxStack();
            return newMethod.getMethod();
        }
    }
}

