/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.OTConstants;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.RepositoryAccess;
import org.eclipse.objectteams.otre.util.BoundClass;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.DebugUtil;
import org.eclipse.objectteams.otre.util.ListValueHashMap;
import org.eclipse.objectteams.otre.util.MethodBinding;
import org.eclipse.objectteams.otre.util.TeamIdDispenser;
import org.objectteams.OTREInternalError;

public class BaseMethodTransformation
extends ObjectTeamsTransformation {
    private static final String AFTER_INIT = "_OT$after_init$";
    private static boolean SHOW_ORIG_CALL = true;
    private static boolean SHOW_RECURSIVE_CALL = true;
    private static boolean SHOW_ROLE_CALL = true;
    private static final String IS_ACTIVE = "isActive";
    private static final int NORESULT = -1;
    private boolean classNeedsTransformation = false;
    private HashSet<String> pendingInitialWrappers;
    private HashSet<String> pendingSuperDelegationWrappers;
    public boolean useReflection = false;

    static {
        String callinStepping = System.getProperty("ot.debug.callin.stepping");
        if (callinStepping != null) {
            SHOW_ROLE_CALL = false;
            SHOW_RECURSIVE_CALL = false;
            SHOW_ORIG_CALL = false;
            StringTokenizer tokens = new StringTokenizer(callinStepping, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ("orig".equals(token)) {
                    SHOW_ORIG_CALL = true;
                    continue;
                }
                if ("recurse".equals(token)) {
                    SHOW_RECURSIVE_CALL = true;
                    continue;
                }
                if (!"role".equals(token)) continue;
                SHOW_ROLE_CALL = true;
            }
        }
    }

    public BaseMethodTransformation(Object loader) {
        super(loader);
    }

    public void doTransformCode(ClassGen cg) {
        this.factory = new InstructionFactory(cg);
        ConstantPoolGen cpg = cg.getConstantPool();
        String class_name = cg.getClassName();
        Method[] methods = cg.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            if (!m.isVolatile()) {
                String method_name = m.getName();
                String method_signature = m.getSignature();
                if (this.classNeedsTransformation) {
                    if (this.pendingInitialWrappers.contains(method_name + "." + method_signature)) {
                        Method method = m;
                        m = this.generateInitialWrapper(m, class_name, cg.getMajor(), cpg);
                        cg.replaceMethod(method, m);
                    } else if (this.pendingSuperDelegationWrappers.contains(method_name + "." + method_signature)) {
                        Method method = m;
                        m = this.generateSuperCall(m, cg, cpg);
                        cg.replaceMethod(method, m);
                    }
                    Method replacement = this.checkReplaceWickedSuper(class_name, m, cpg);
                    if (replacement != null) {
                        cg.replaceMethod(m, replacement);
                    }
                }
            }
            ++i;
        }
    }

    private Method checkReplaceWickedSuper(String className, Method m, ConstantPoolGen cpg) {
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        MethodGen mg = BaseMethodTransformation.newMethodGen(m, className, cpg);
        String method_name = m.getName();
        InstructionHandle[] ihs = mg.getInstructionList().getInstructionHandles();
        boolean found = false;
        InstructionHandle[] instructionHandleArray = ihs;
        int n = ihs.length;
        int n2 = 0;
        while (n2 < n) {
            String superClassName;
            Instruction actInstruction;
            INVOKESPECIAL is;
            String is_name;
            InstructionHandle ih = instructionHandleArray[n2];
            if (ih.getInstruction() instanceof INVOKESPECIAL && !(is_name = (is = (INVOKESPECIAL)(actInstruction = ih.getInstruction())).getName(cpg)).equals(method_name) && !is_name.equals("<init>") && !(superClassName = is.getClassName(cpg)).equals(className) && CallinBindingManager.isBoundBaseMethod(superClassName, is_name, is.getSignature(cpg))) {
                found = true;
                if (logging) {
                    BaseMethodTransformation.printLogMessage("wicked super-call to " + is_name + " has to be redirected to the orig-version!");
                }
                ih.setInstruction((Instruction)this.factory.createInvoke(superClassName, "_OT$" + is_name + "$orig", is.getReturnType(cpg), is.getArgumentTypes(cpg), (short)183));
            }
            ++n2;
        }
        if (found) {
            return mg.getMethod();
        }
        return null;
    }

    public void doTransformInterface(ClassEnhancer ce, ClassGen cg) {
        String class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        this.factory = new InstructionFactory(cg);
        if (CallinBindingManager.isBoundBaseClass(class_name) && cg.containsField("_OT$roleSet") == null) {
            switch (CallinBindingManager.hasBoundBaseParent(class_name)) {
                case NONE: {
                    ce.addImplements("org.objectteams.IBoundBase", cg);
                }
                case INTERFACE: {
                    if (cg.isInterface()) break;
                    ce.addField(this.generateRoleSet(cpg, class_name), cg);
                    ce.addMethod(this.generateAddRole(cpg, class_name), cg);
                    ce.addMethod(this.generateRemoveRole(cpg, class_name), cg);
                    break;
                }
            }
        }
        if (this.pendingInitialWrappers == null) {
            this.pendingInitialWrappers = new HashSet();
        }
        if (this.pendingSuperDelegationWrappers == null) {
            this.pendingSuperDelegationWrappers = new HashSet();
        }
        this.checkReadClassAttributes(ce, cg, class_name, cpg);
        if (CallinBindingManager.checkBaseClassModifierChange(class_name) && !cg.isPublic()) {
            cg.setAccessFlags(BaseMethodTransformation.makePublicFlags(cg.getAccessFlags()));
        }
        Collection<MethodBinding> inheritedBindings = CallinBindingManager.getInheritedCallinBindings(class_name);
        if (cg.isInterface()) {
            String roleClassName;
            int lastDollar = class_name.lastIndexOf(36);
            if (lastDollar != -1 && CallinBindingManager.isBoundBaseClass(roleClassName = class_name.substring(0, lastDollar + 1) + "__OT__" + class_name.substring(lastDollar + 1))) {
                Method[] methods = cg.getMethods();
                int i = 0;
                while (i < methods.length) {
                    MethodGen chainGen;
                    String signature;
                    String method_name;
                    Collection<MethodBinding> bindingsForMethod;
                    Method m = methods[i];
                    if (!m.isVolatile() && (bindingsForMethod = CallinBindingManager.getBindingForBaseMethod(roleClassName, method_name = m.getName(), signature = m.getSignature())) != null && cg.containsMethod((chainGen = this.generateChainingWrapper(class_name, cpg, m.getAccessFlags() | 0x400, method_name, signature, null)).getName(), chainGen.getSignature()) == null) {
                        ce.addMethod(chainGen.getMethod(), cg);
                    }
                    ++i;
                }
            }
            return;
        }
        boolean haveDirectCallin = CallinBindingManager.isBoundBaseClass(class_name);
        if (inheritedBindings.size() == 0 && !haveDirectCallin) {
            if (logging) {
                BaseMethodTransformation.printLogMessage("\nCallins: nothing to do for class " + class_name);
            }
            return;
        }
        if (logging) {
            BaseMethodTransformation.printLogMessage("\nCallin bindings may be changing class " + class_name + ":");
        }
        if (cg.getMajor() < 49) {
            BoundClass topBase;
            if (cg.containsField("_OT$self_class$") == null) {
                ce.addField(new FieldGen(12, (Type)classType, "_OT$self_class$", cpg).getField(), cg);
            }
            if ((topBase = CallinBindingManager.getTopmostBoundBaseClass(class_name)) != null && !topBase.getName().equals(class_name)) {
                ce.addField(new FieldGen(12, (Type)classType, "_OT$class_literal$" + topBase.getName().replace('.', '$'), cpg).getField(), cg);
            }
        }
        Method[] methods = cg.getMethods();
        int i = 0;
        while (i < methods.length) {
            block37: {
                Method chain;
                MethodGen chainGen;
                String method_key;
                int firstLine;
                MethodGen mg;
                Collection<MethodBinding> bindingsForMethod;
                String method_signature;
                String method_name;
                Method m;
                block39: {
                    MethodBinding inheritedBinding;
                    block38: {
                        InstructionList il;
                        InstructionHandle end;
                        m = methods[i];
                        if (m.isVolatile()) break block37;
                        method_name = m.getName();
                        method_signature = m.getSignature();
                        bindingsForMethod = null;
                        if (haveDirectCallin) {
                            bindingsForMethod = CallinBindingManager.getBindingForBaseMethod(class_name, method_name, m.getSignature());
                        }
                        mg = null;
                        firstLine = 65534;
                        inheritedBinding = BaseMethodTransformation.matchingBinding(inheritedBindings, m, false);
                        method_key = method_name + "." + method_signature;
                        if (bindingsForMethod == null || !"<init>".equals(method_name)) break block38;
                        mg = BaseMethodTransformation.getConcretMethodGen(m, class_name, cpg);
                        chain = this.generateAfterConstructorWrapperBody(class_name, cg, cpg, mg, method_name, method_signature, chainGen = this.generateAfterConstructorWrapper(class_name, cpg, mg.getAccessFlags(), method_name, method_signature, mg.getArgumentNames()), firstLine);
                        if (cg.containsMethod(chain.getName(), chain.getSignature()) == null) {
                            ce.addMethod(chain, cg);
                        }
                        if ((end = (il = (mg = new MethodGen(m, class_name, cpg)).getInstructionList()).getEnd()).getInstruction() instanceof ReturnInstruction) {
                            InstructionHandle[] instructionHandles;
                            end.setInstruction((Instruction)new NOP());
                            InstructionHandle afterInitDispatch = il.append((Instruction)new NOP());
                            this.createInitialDispatchCode(il, class_name, AFTER_INIT, mg, false, (Type)Type.VOID, cg.getMajor(), cpg);
                            InstructionHandle[] instructionHandleArray = instructionHandles = il.getInstructionHandles();
                            int n = instructionHandles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                InstructionHandle ih = instructionHandleArray[n2];
                                if (ih == afterInitDispatch) break;
                                if (ih.getInstruction() instanceof ReturnInstruction) {
                                    ih.setInstruction((Instruction)new NOP());
                                    il.insert(ih, (BranchInstruction)new GOTO(afterInitDispatch));
                                }
                                ++n2;
                            }
                            mg.setMaxStack();
                            mg.setMaxLocals();
                            Method generatedMethod = mg.getMethod();
                            il.dispose();
                            ce.addOrReplaceMethod(generatedMethod, cg);
                        }
                        break block37;
                    }
                    if (bindingsForMethod == null && (inheritedBinding == null || m.isStatic() || m.isPrivate())) break block39;
                    mg = BaseMethodTransformation.newMethodGen(m, class_name, cpg);
                    String name_orig = BaseMethodTransformation.genOrigMethName(method_name);
                    if (cg.containsMethod(name_orig, m.getSignature()) != null) break block37;
                    if (debugging) {
                        firstLine = this.findFirstLineNumber(m);
                    }
                    mg.setName(name_orig);
                    if (BaseMethodTransformation.matchingBinding(inheritedBindings, m, true) != null) {
                        this.replaceSuperCalls(mg, method_name, cpg);
                    }
                    Method orig_method = mg.getMethod();
                    ce.addMethod(orig_method, cg);
                    if (logging) {
                        BaseMethodTransformation.printLogMessage("Method " + method_name + " was backuped as " + name_orig + ".");
                    }
                    if (inheritedBinding != null) {
                        if (method_signature.equals(inheritedBinding.getBaseMethodSignature())) {
                            this.pendingSuperDelegationWrappers.add(method_key);
                        } else {
                            this.pendingInitialWrappers.add(method_key);
                        }
                    }
                }
                if (bindingsForMethod != null) {
                    mg = BaseMethodTransformation.getConcretMethodGen(m, class_name, cpg);
                    chain = this.generateChainingWrapperBody(class_name, cg, cpg, mg, method_name, method_signature, chainGen = this.generateChainingWrapper(class_name, cpg, mg.getAccessFlags(), method_name, method_signature, mg.getArgumentNames()), firstLine);
                    if (cg.containsMethod(chain.getName(), chain.getSignature()) == null) {
                        ce.addMethod(chain, cg);
                    }
                    this.pendingInitialWrappers.add(method_key);
                    this.pendingSuperDelegationWrappers.remove(method_key);
                }
                if (mg == null && logging) {
                    BaseMethodTransformation.printLogMessage("No method binding (direct or inherited) found for " + method_name);
                }
            }
            ++i;
        }
        this.classNeedsTransformation = true;
    }

    private int findFirstLineNumber(Method m) {
        LineNumberTable lnt = m.getLineNumberTable();
        if (lnt != null && lnt.getTableLength() > 0) {
            LineNumber[] lineNumberTable = lnt.getLineNumberTable();
            int i = 0;
            while (i < lineNumberTable.length) {
                int lineNumber = lineNumberTable[i].getLineNumber();
                if (lineNumber != 65534) {
                    return lineNumber;
                }
                ++i;
            }
            return lineNumberTable[0].getLineNumber();
        }
        return 65534;
    }

    private void replaceSuperCalls(MethodGen orig_method, String method_name, ConstantPoolGen cpg) {
        InstructionList il = orig_method.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        int actInstrIndex = 0;
        while (actInstrIndex < ihs.length) {
            Instruction actInstruction;
            INVOKESPECIAL is;
            String is_name;
            if (ihs[actInstrIndex].getInstruction() instanceof INVOKESPECIAL && (is_name = (is = (INVOKESPECIAL)(actInstruction = ihs[actInstrIndex].getInstruction())).getName(cpg)).equals(method_name)) {
                String superClassName = is.getClassName(cpg);
                if (logging) {
                    BaseMethodTransformation.printLogMessage("super-call to " + is_name + " has to be redirected to the orig-version!");
                }
                InvokeInstruction superOrigCall = this.factory.createInvoke(superClassName, orig_method.getName(), orig_method.getReturnType(), orig_method.getArgumentTypes(), (short)183);
                ihs[actInstrIndex].setInstruction((Instruction)superOrigCall);
            }
            ++actInstrIndex;
        }
    }

    static MethodBinding matchingBinding(Collection<MethodBinding> baseMethodBindings, Method m, boolean strict) {
        for (MethodBinding binding : baseMethodBindings) {
            if (!binding.matchesMethod(m.getName(), m.getSignature(), strict)) continue;
            return binding;
        }
        return null;
    }

    static MethodGen getConcretMethodGen(Method m, String class_name, ConstantPoolGen cpg) {
        MethodGen mg;
        String signature = m.getSignature();
        Type[] argTypes = Type.getArgumentTypes((String)signature);
        if (m.isAbstract()) {
            Type returnType = Type.getReturnType((String)signature);
            InstructionList il = new InstructionList();
            il.append((Instruction)new NOP());
            mg = new MethodGen(m.getAccessFlags() & 0xFFFFFBFF, returnType, argTypes, null, m.getName(), class_name, il, cpg);
        } else {
            mg = BaseMethodTransformation.wipeMethod(m, class_name, cpg);
        }
        if (debugging) {
            mg.removeLocalVariables();
            int slot = 0;
            if (!m.isAbstract()) {
                mg.addLocalVariable("this", (Type)new ObjectType(class_name), slot++, null, null);
            }
            int i = 0;
            while (i < argTypes.length) {
                mg.addLocalVariable("arg" + i, argTypes[i], slot++, null, null);
                ++i;
            }
            mg.setMaxLocals();
        }
        return mg;
    }

    private Method generateInitialWrapper(Method m, String class_name, int major, ConstantPoolGen cpg) {
        MethodGen mg = BaseMethodTransformation.getConcretMethodGen(m, class_name, cpg);
        String method_name = m.getName();
        String name_chain = BaseMethodTransformation.genChainMethName(method_name);
        InstructionList il = mg.getInstructionList();
        this.createInitialDispatchCode(il, class_name, name_chain, mg, m.isStatic(), (Type)object, major, cpg);
        mg.setMaxStack();
        mg.setMaxLocals();
        Method generatedMethod = mg.getMethod();
        il.dispose();
        return generatedMethod;
    }

    private void createInitialDispatchCode(InstructionList il, String class_name, String name_chain, MethodGen mg, boolean isStatic, Type chainReturnType, int major, ConstantPoolGen cpg) {
        Type[] argTypes = mg.getArgumentTypes();
        Type returnType = mg.getReturnType();
        LocalVariableGen lg = mg.addLocalVariable("_OT$teams", (Type)teamArray, null, null);
        int teams = lg.getIndex();
        BoundClass superBase = CallinBindingManager.getTopmostBoundBaseClass(class_name);
        String classNameForLiteral = superBase != null ? superBase.getName() : class_name;
        ObjectTeamsTransformation.Pair<Integer, InstructionHandle> monitorResult = this.addClassMonitorEnter(mg, il, class_name, classNameForLiteral, major, cpg);
        int monitor = (Integer)monitorResult.first;
        if (debugging) {
            mg.addLineNumber((InstructionHandle)monitorResult.second, 65534);
        }
        InstructionHandle startSynchronized = il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$activeTeams", (Type)teamArray, (short)178));
        il.append(InstructionConstants.ARRAYLENGTH);
        il.append(this.factory.createNewArray((Type)teamType, (short)1));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)teams));
        lg = mg.addLocalVariable("_OT$teamIDs", (Type)intArray, null, null);
        int teamIDs = lg.getIndex();
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$activeTeamIDs", (Type)intArray, (short)178));
        il.append(InstructionConstants.ARRAYLENGTH);
        il.append(this.factory.createNewArray((Type)Type.INT, (short)1));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)teamIDs));
        lg = mg.addLocalVariable("i", (Type)Type.INT, null, null);
        int for_index = lg.getIndex();
        il.append((CompoundInstruction)new PUSH(cpg, 0));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.INT, (int)for_index));
        InstructionHandle for_start = il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$activeTeams", (Type)teamArray, (short)178));
        il.append(InstructionConstants.ARRAYLENGTH);
        BranchInstruction if_loop_finished = InstructionFactory.createBranchInstruction((short)162, null);
        il.append(if_loop_finished);
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$activeTeams", (Type)teamArray, (short)178));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((Instruction)InstructionConstants.AALOAD);
        il.append((Instruction)this.factory.createInvoke("org.objectteams.ITeam", IS_ACTIVE, (Type)Type.BOOLEAN, Type.NO_ARGS, (short)185));
        BranchInstruction if_team_isactive = InstructionFactory.createBranchInstruction((short)154, null);
        il.append(if_team_isactive);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)teams));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append(InstructionConstants.ACONST_NULL);
        il.append((Instruction)InstructionConstants.AASTORE);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)teamIDs));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((CompoundInstruction)new PUSH(cpg, -1));
        il.append((Instruction)InstructionConstants.IASTORE);
        BranchInstruction goto_continue = InstructionFactory.createBranchInstruction((short)167, null);
        il.append(goto_continue);
        InstructionHandle adopt_activation = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)teams));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$activeTeams", (Type)teamArray, (short)178));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((Instruction)InstructionConstants.AALOAD);
        il.append((Instruction)InstructionConstants.AASTORE);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)teamIDs));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$activeTeamIDs", (Type)intArray, (short)178));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)for_index));
        il.append((Instruction)InstructionConstants.IALOAD);
        il.append((Instruction)InstructionConstants.IASTORE);
        InstructionHandle do_continue = il.append((Instruction)new IINC(for_index, 1));
        il.append(InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)for_start));
        InstructionHandle loop_finished = il.append((Instruction)new NOP());
        if_loop_finished.setTarget(loop_finished);
        if_team_isactive.setTarget(adopt_activation);
        goto_continue.setTarget(do_continue);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)monitor));
        il.append((Instruction)new MONITOREXIT());
        InstructionHandle chainCall = !isStatic ? il.append(InstructionFactory.createThis()) : il.append((Instruction)new NOP());
        if (debugging) {
            mg.addLineNumber(chainCall, 65533);
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)teams));
        il.append((Instruction)InstructionFactory.createLoad((Type)intArray, (int)teamIDs));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)new ICONST(-1));
        il.append((Instruction)new ACONST_NULL());
        int index = isStatic ? 0 : 1;
        short invocationKind = isStatic ? (short)184 : 182;
        int i = 0;
        while (i < argTypes.length) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i], (int)index));
            index += argTypes[i].getSize();
            ++i;
        }
        il.append((Instruction)this.factory.createInvoke(class_name, name_chain, chainReturnType, BaseMethodTransformation.enhanceArgumentTypes(argTypes), invocationKind));
        this.adjustValue(il, null, chainReturnType, returnType);
        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        LocalVariableGen ex = mg.addLocalVariable("exceptionInSynchronized", (Type)Type.THROWABLE, il.getEnd(), null);
        InstructionHandle handler = il.append((Instruction)InstructionFactory.createStore((Type)Type.THROWABLE, (int)ex.getIndex()));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)monitor));
        il.append((Instruction)new MONITOREXIT());
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.THROWABLE, (int)ex.getIndex()));
        il.append((Instruction)new ATHROW());
        mg.addExceptionHandler(startSynchronized, chainCall, handler, Type.THROWABLE);
    }

    Method generateSuperCall(Method m, ClassGen cg, ConstantPoolGen cpg) {
        short invocationKind = m.isStatic() ? (short)184 : 183;
        MethodGen mg = BaseMethodTransformation.getConcretMethodGen(m, cg.getClassName(), cpg);
        String method_name = m.getName();
        Type returnType = mg.getReturnType();
        Type[] argTypes = mg.getArgumentTypes();
        InstructionList il = mg.getInstructionList();
        if (logging) {
            BaseMethodTransformation.printLogMessage("\nReplacing with call to super: " + method_name);
        }
        if (!m.isStatic()) {
            il.append(InstructionFactory.createThis());
        }
        int index = 1;
        int i = 0;
        while (i < argTypes.length) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i], (int)index));
            index += argTypes[i].getSize();
            ++i;
        }
        il.append((Instruction)this.factory.createInvoke(cg.getSuperclassName(), method_name, returnType, argTypes, invocationKind));
        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        mg.setMaxStack();
        mg.setMaxLocals();
        Method generatedMethod = mg.getMethod();
        il.dispose();
        return generatedMethod;
    }

    MethodGen generateChainingWrapper(String class_name, ConstantPoolGen cpg, int accessFlags, String method_name, String method_signature, String[] argumentNames) {
        Type[] argumentTypes = Type.getArgumentTypes((String)method_signature);
        if (argumentNames == null) {
            argumentNames = new String[argumentTypes.length];
            int i = 0;
            while (i < argumentNames.length) {
                argumentNames[i] = "arg" + i;
                ++i;
            }
        }
        return new MethodGen(BaseMethodTransformation.makePublicFlags(accessFlags), (Type)object, BaseMethodTransformation.enhanceArgumentTypes(argumentTypes), BaseMethodTransformation.enhanceArgumentNames(argumentNames), BaseMethodTransformation.genChainMethName(method_name), class_name, new InstructionList(), cpg);
    }

    Method generateChainingWrapperBody(String class_name, ClassGen cg, ConstantPoolGen cpg, MethodGen mg, String method_name, String method_signature, MethodGen chainMethod, int firstLine) {
        Type origReturnType = mg.getReturnType();
        Type[] argumentTypes = mg.getArgumentTypes();
        Type enhancedReturnType = chainMethod.getReturnType();
        InstructionList il = chainMethod.getInstructionList();
        LocalVariableGen lg = chainMethod.addLocalVariable("_OT$result", enhancedReturnType, null, null);
        int result = lg.getIndex();
        InstructionHandle ih = il.append(InstructionFactory.createNull((Type)enhancedReturnType));
        if (debugging) {
            chainMethod.addLineNumber(ih, 65534);
        }
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)enhancedReturnType, (int)result)));
        lg = chainMethod.addLocalVariable("_OT$team", (Type)teamType, null, null);
        int ot_team = lg.getIndex();
        int indexOffset = chainMethod.isStatic() ? -1 : 0;
        short invocationKind = this.getInvocationType(mg);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)(3 + indexOffset)));
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)(1 + indexOffset)));
        il.append((Instruction)new ARRAYLENGTH());
        IF_ICMPLT recursionNotYetTerminated = new IF_ICMPLT(null);
        il.append((BranchInstruction)recursionNotYetTerminated);
        ih = !chainMethod.isStatic() ? il.append(InstructionFactory.createThis()) : il.append((Instruction)new NOP());
        if (debugging) {
            chainMethod.addLineNumber(ih, SHOW_ORIG_CALL ? firstLine : 65533);
        }
        int index = 7;
        int i = 0;
        while (i < argumentTypes.length) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argumentTypes[i], (int)(index + indexOffset)));
            index += argumentTypes[i].getSize();
            ++i;
        }
        il.append((Instruction)this.factory.createInvoke(class_name, BaseMethodTransformation.genOrigMethName(method_name), origReturnType, argumentTypes, invocationKind));
        if (debugging) {
            chainMethod.addLineNumber(il.append((Instruction)new NOP()), 65534);
        }
        this.adjustValue(il, null, origReturnType, enhancedReturnType);
        il.append((Instruction)InstructionFactory.createReturn((Type)enhancedReturnType));
        ih = il.append((Instruction)new NOP());
        recursionNotYetTerminated.setTarget(ih);
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)(1 + indexOffset)));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)(3 + indexOffset)));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)teamType));
        il.append((Instruction)InstructionFactory.createStore((Type)teamType, (int)ot_team));
        this.createDispatchCode(chainMethod, il, class_name, method_name, method_signature, result, ot_team, cg, firstLine);
        ih = il.append((Instruction)InstructionFactory.createLoad((Type)enhancedReturnType, (int)result));
        il.append((Instruction)InstructionFactory.createReturn((Type)enhancedReturnType));
        if (debugging) {
            chainMethod.addLineNumber(ih, 65534);
        }
        chainMethod.removeNOPs();
        try {
            chainMethod.setMaxStack();
        }
        catch (ClassCastException cce) {
            System.err.println(chainMethod);
            cce.printStackTrace();
        }
        chainMethod.setMaxLocals();
        Method generated = chainMethod.getMethod();
        il.dispose();
        return generated;
    }

    MethodGen generateAfterConstructorWrapper(String class_name, ConstantPoolGen cpg, int accessFlags, String method_name, String method_signature, String[] argumentNames) {
        Type[] argumentTypes = Type.getArgumentTypes((String)method_signature);
        if (argumentNames == null) {
            argumentNames = new String[argumentTypes.length];
            int i = 0;
            while (i < argumentNames.length) {
                argumentNames[i] = "arg" + i;
                ++i;
            }
        }
        return new MethodGen(accessFlags, (Type)Type.VOID, BaseMethodTransformation.enhanceArgumentTypes(argumentTypes), BaseMethodTransformation.enhanceArgumentNames(argumentNames), AFTER_INIT, class_name, new InstructionList(), cpg);
    }

    Method generateAfterConstructorWrapperBody(String class_name, ClassGen cg, ConstantPoolGen cpg, MethodGen mg, String method_name, String method_signature, MethodGen chainMethod, int firstLine) {
        InstructionList il = chainMethod.getInstructionList();
        LocalVariableGen lg = chainMethod.addLocalVariable("_OT$team", (Type)teamType, null, null);
        int ot_team = lg.getIndex();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)3));
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)1));
        il.append((Instruction)new ARRAYLENGTH());
        IF_ICMPLT recursionNotYetTerminated = new IF_ICMPLT(null);
        il.append((BranchInstruction)recursionNotYetTerminated);
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        InstructionHandle ih = il.append((Instruction)new NOP());
        recursionNotYetTerminated.setTarget(ih);
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)1));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)3));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)teamType));
        il.append((Instruction)InstructionFactory.createStore((Type)teamType, (int)ot_team));
        this.createAfterCtorDispatchCode(chainMethod, il, class_name, method_name, method_signature, ot_team, cg, firstLine);
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        if (debugging) {
            chainMethod.addLineNumber(ih, 65534);
        }
        chainMethod.removeNOPs();
        try {
            chainMethod.setMaxStack();
        }
        catch (ClassCastException cce) {
            System.err.println(chainMethod);
            cce.printStackTrace();
        }
        chainMethod.setMaxLocals();
        Method generated = chainMethod.getMethod();
        il.dispose();
        return generated;
    }

    private short getInvocationType(MethodGen chainMethod) {
        if (chainMethod.isStatic()) {
            return 184;
        }
        if (chainMethod.isPrivate()) {
            return 183;
        }
        return 182;
    }

    private static int makePublicFlags(int flags) {
        if ((flags & 1) != 0) {
            return flags;
        }
        if ((flags & 2) != 0) {
            flags &= 0xFFFFFFFD;
        } else if ((flags & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        return flags |= 1;
    }

    void createDispatchCode(MethodGen chainMethod, InstructionList il, String class_name, String method_name, String method_signature, int result, int ot_team, ClassGen cg, int firstLine) {
        HashMap<String, ArrayList<MethodBinding>> sortedMethodBindings = new HashMap<String, ArrayList<MethodBinding>>();
        Collection<MethodBinding> callinsForMethod = CallinBindingManager.getBindingForBaseMethod(class_name, method_name, method_signature);
        List<MethodBinding> inheritedMethodBindings = CallinBindingManager.getInheritedBaseMethodBindings(class_name, method_name, method_signature);
        if (!chainMethod.isStatic()) {
            callinsForMethod.addAll(inheritedMethodBindings);
        }
        ListValueHashMap<MethodBinding> beforeBindings = new ListValueHashMap<MethodBinding>();
        ListValueHashMap<MethodBinding> replaceBindings = new ListValueHashMap<MethodBinding>();
        ListValueHashMap<MethodBinding> afterBindings = new ListValueHashMap<MethodBinding>();
        for (MethodBinding methodBinding : callinsForMethod) {
            String modifier = methodBinding.getModifier();
            ArrayList<MethodBinding> bindings = (ArrayList<MethodBinding>)sortedMethodBindings.get(modifier);
            if (bindings == null) {
                bindings = new ArrayList<MethodBinding>();
                sortedMethodBindings.put(modifier, bindings);
            }
            bindings.add(methodBinding);
            String teamName = methodBinding.getTeamClassName();
            if (modifier.equals("before")) {
                beforeBindings.put(teamName, methodBinding);
                continue;
            }
            if (modifier.equals("replace")) {
                replaceBindings.put(teamName, methodBinding);
                continue;
            }
            if (!modifier.equals("after")) continue;
            afterBindings.put(teamName, methodBinding);
        }
        boolean useBindingIdx = false;
        for (LinkedList perTeamMethods : replaceBindings.valueSet()) {
            if (perTeamMethods.size() <= 1) continue;
            useBindingIdx = true;
            break;
        }
        if (sortedMethodBindings.containsKey("before")) {
            if (logging) {
                BaseMethodTransformation.printLogMessage("before bindings will be applied...");
            }
            il.append(this.createSwitch(beforeBindings, chainMethod, ot_team, -1, firstLine, cg.getMajor(), useBindingIdx));
            if (logging) {
                BaseMethodTransformation.printLogMessage("before bindings: " + String.valueOf(sortedMethodBindings.get("before")));
            }
        }
        if (sortedMethodBindings.containsKey("replace")) {
            if (logging) {
                BaseMethodTransformation.printLogMessage("recursive call and replace bindings will be applied...");
            }
            il.append(this.createSwitch(replaceBindings, chainMethod, ot_team, result, firstLine, cg.getMajor(), useBindingIdx));
            if (logging) {
                BaseMethodTransformation.printLogMessage("replace bindings: " + String.valueOf(sortedMethodBindings.get("replace")));
            }
        } else {
            if (logging) {
                BaseMethodTransformation.printLogMessage("recursive chain-method call will be done...");
            }
            this.createRecursiveCall(il, chainMethod, result, 1, 0, method_name, method_signature, firstLine);
        }
        if (sortedMethodBindings.containsKey("after")) {
            if (logging) {
                BaseMethodTransformation.printLogMessage("after bindings will be applied...");
            }
            il.append(this.createSwitch(afterBindings, chainMethod, ot_team, result, firstLine, cg.getMajor(), useBindingIdx));
            if (logging) {
                BaseMethodTransformation.printLogMessage("after bindings: " + String.valueOf(sortedMethodBindings.get("after")));
            }
        }
    }

    void createAfterCtorDispatchCode(MethodGen chainMethod, InstructionList il, String class_name, String method_name, String method_signature, int ot_team, ClassGen cg, int firstLine) {
        Collection<MethodBinding> callinsForMethod = CallinBindingManager.getBindingForBaseMethod(class_name, method_name, method_signature);
        List<MethodBinding> inheritedMethodBindings = CallinBindingManager.getInheritedBaseMethodBindings(class_name, method_name, method_signature);
        if (!chainMethod.isStatic()) {
            callinsForMethod.addAll(inheritedMethodBindings);
        }
        ListValueHashMap<MethodBinding> afterBindings = new ListValueHashMap<MethodBinding>();
        for (MethodBinding methodBinding : callinsForMethod) {
            if (!methodBinding.getModifier().equals("after")) continue;
            afterBindings.put(methodBinding.getTeamClassName(), methodBinding);
        }
        if (afterBindings.size() > 0) {
            if (logging) {
                BaseMethodTransformation.printLogMessage("after bindings will be applied...");
            }
            il.append(this.createSwitch(afterBindings, chainMethod, ot_team, -1, firstLine, cg.getMajor(), false));
            if (logging) {
                BaseMethodTransformation.printLogMessage("after bindings: " + String.valueOf(afterBindings));
            }
        }
    }

    private InstructionList createSwitch(ListValueHashMap<MethodBinding> methodBindings, MethodGen mg, int ot_team, int ot_result, int firstLine, int major, boolean useBindingIdx) {
        InstructionList il = new InstructionList();
        boolean handlesReplacement = false;
        int indexOffset = mg.isStatic() ? -1 : 0;
        il.append((Instruction)InstructionFactory.createLoad((Type)intArray, (int)(2 + indexOffset)));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)(3 + indexOffset)));
        InstructionHandle switchStart = il.append((Instruction)InstructionFactory.createArrayLoad((Type)Type.INT));
        int numberOfCases = methodBindings.size();
        GOTO[] breaks = new GOTO[numberOfCases];
        int i = 0;
        while (i < numberOfCases) {
            breaks[i] = new GOTO(null);
            ++i;
        }
        int[] matches = new int[numberOfCases];
        InstructionHandle[] targets = new InstructionHandle[numberOfCases];
        int caseCounter = 0;
        List<MethodBinding> methodBindingsForTeam = null;
        MethodBinding mb = null;
        for (Map.Entry<String, LinkedList<MethodBinding>> entry : methodBindings.entrySet()) {
            String teamName = entry.getKey();
            methodBindingsForTeam = CallinBindingManager.sortMethodBindings((List<MethodBinding>)entry.getValue(), teamName);
            mb = methodBindingsForTeam.get(0);
            matches[caseCounter] = TeamIdDispenser.getTeamId(teamName);
            InstructionHandle nextBranch = il.append((Instruction)new NOP());
            if (mb.isReplace()) {
                handlesReplacement = true;
                this.createReplaceCase(mg, il, teamName, methodBindingsForTeam, ot_result, ot_team, major, firstLine);
            } else {
                IFNE ifBindingIdx = null;
                if (useBindingIdx) {
                    il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)(4 + indexOffset)));
                    ifBindingIdx = new IFNE(null);
                    il.append((BranchInstruction)ifBindingIdx);
                }
                this.createBeforeAfterCase(mg, il, teamName, methodBindingsForTeam, ot_result, ot_team, major, firstLine);
                if (useBindingIdx) {
                    ifBindingIdx.setTarget(il.append((Instruction)new NOP()));
                }
            }
            targets[caseCounter] = nextBranch;
            il.append((BranchInstruction)breaks[caseCounter]);
            ++caseCounter;
        }
        InstructionHandle defaultBranch = il.append((Instruction)new NOP());
        if (handlesReplacement) {
            this.createRecursiveCall(il, mg, ot_result, 1, 0, mb.getBaseMethodName(), mb.getBaseMethodSignature(), firstLine);
        }
        InstructionHandle afterSwitch = il.append((Instruction)new NOP());
        il.append(switchStart, BaseMethodTransformation.createLookupSwitch(matches, targets, breaks, defaultBranch, afterSwitch));
        InstructionHandle endTry = il.getEnd();
        GOTO skipHdlr = null;
        skipHdlr = new GOTO(null);
        il.append((BranchInstruction)skipHdlr);
        InstructionHandle hdlr = il.append((Instruction)new NOP());
        il.append(DebugUtil.createReportExc(this.factory));
        if (handlesReplacement) {
            this.createRecursiveCall(il, mg, ot_result, 1, 0, mb.getBaseMethodName(), mb.getBaseMethodSignature(), firstLine);
        }
        mg.addExceptionHandler(il.getStart(), endTry, hdlr, liftingVeto);
        mg.addExceptionHandler(il.getStart(), endTry, hdlr, liftingFailed);
        InstructionHandle nop = il.append((Instruction)new NOP());
        skipHdlr.setTarget(nop);
        return il;
    }

    void createRecursiveCall(InstructionList il, MethodGen mg, int ot_result, int idx_offset, int bindIdx_offset, String methodName, String methodSignature, int firstLine) {
        InstructionHandle ih;
        InstructionHandle instructionHandle = ih = !mg.isStatic() ? il.append(InstructionFactory.createThis()) : il.append((Instruction)new NOP());
        if (debugging) {
            mg.addLineNumber(ih, SHOW_RECURSIVE_CALL ? firstLine : 65533);
        }
        Type[] argTypes = mg.getArgumentTypes();
        Type returnType = mg.getReturnType();
        short invocationKind = this.getInvocationType(mg);
        int index = 1;
        int indexOffset = mg.isStatic() ? -1 : 0;
        int i = 0;
        while (i < argTypes.length) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i], (int)(index + indexOffset)));
            if (index == 3 && idx_offset != 0) {
                il.append((Instruction)new ICONST(idx_offset));
                il.append((Instruction)new IADD());
            } else if (index == 4) {
                if (bindIdx_offset == 0) {
                    il.append((Instruction)new POP());
                    il.append((Instruction)new ICONST(0));
                } else {
                    il.append((Instruction)new ICONST(bindIdx_offset));
                    il.append((Instruction)new IADD());
                }
            }
            index += argTypes[i].getSize();
            ++i;
        }
        il.append((Instruction)this.factory.createInvoke(mg.getClassName(), mg.getName(), returnType, argTypes, invocationKind));
        il.append((Instruction)InstructionFactory.createStore((Type)returnType, (int)ot_result));
        if (debugging) {
            mg.addLineNumber(il.append((Instruction)new NOP()), 65534);
        }
    }

    void createBeforeAfterCase(MethodGen mg, InstructionList il, String teamClassName, List<MethodBinding> sortedMBList, int ot_result, int ot_team, int major, int firstLine) {
        MethodBinding mb2 = sortedMBList.get(0);
        ConstantPoolGen cpg = mg.getConstantPool();
        if (mb2.isAfter()) {
            ArrayList<MethodBinding> reverse = new ArrayList<MethodBinding>(sortedMBList.size());
            int i = sortedMBList.size() - 1;
            while (i >= 0) {
                reverse.add(sortedMBList.get(i));
                --i;
            }
            sortedMBList = reverse;
        }
        for (MethodBinding mb2 : sortedMBList) {
            InstructionHandle callinCall;
            String baseMethodSignature = mb2.getBaseMethodSignature();
            Type[] baseArgTypes = Type.getArgumentTypes((String)baseMethodSignature);
            Type baseReturnType = Type.getReturnType((String)baseMethodSignature);
            Type[] wrapperArgTypes = Type.getArgumentTypes((String)mb2.getWrapperSignature());
            int argsLen = wrapperArgTypes.length - 1;
            il.append((Instruction)InstructionFactory.createLoad((Type)teamType, (int)ot_team));
            int packedArgPos = 0;
            InstructionHandle argArray = null;
            if (this.useReflection) {
                il.append((Instruction)this.factory.createInvoke("java.lang.Object", "getClass", (Type)classType, new Type[0], (short)182));
                il.append((Instruction)new LDC(cpg.addString(mb2.getWrapperName())));
                this.pushTypeArray(il, wrapperArgTypes, major, mg.getClassName(), cpg);
                il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getMethod", (Type)methodType, OTConstants.getMethodSignature, (short)182));
                il.append((Instruction)InstructionFactory.createLoad((Type)teamType, (int)ot_team));
                argArray = il.append((Instruction)new ANEWARRAY(cpg.addClass(object)));
            } else {
                il.append(this.factory.createCast((Type)teamType, (Type)new ObjectType(teamClassName)));
            }
            packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
            if (!mg.isStatic()) {
                il.append(InstructionFactory.createThis());
            } else {
                il.append(InstructionFactory.createNull((Type)Type.OBJECT));
            }
            this.checkPackValue1(il, this.useReflection, (Type)Type.OBJECT);
            if (mb2.isAfter() && !baseReturnType.equals((Object)Type.VOID)) {
                packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
                il.append((Instruction)InstructionFactory.createLoad((Type)object, (int)ot_result));
                this.adjustValue(il, null, (Type)object, baseReturnType);
                --argsLen;
                this.checkPackValue1(il, this.useReflection, baseReturnType);
            }
            int stackIndex = 6 + (mg.isStatic() ? 0 : 1);
            int firstArg = 0;
            if (mb2.baseMethodIsCallin()) {
                firstArg += 6;
                stackIndex += 6;
                argsLen += 6;
            }
            int i = firstArg;
            while (i < argsLen) {
                if (logging) {
                    BaseMethodTransformation.printLogMessage("loading " + baseArgTypes[i].toString());
                }
                packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
                il.append((Instruction)InstructionFactory.createLoad((Type)baseArgTypes[i], (int)stackIndex));
                this.checkPackValue1(il, this.useReflection, baseArgTypes[i]);
                stackIndex += baseArgTypes[i].getSize();
                ++i;
            }
            if (this.useReflection) {
                il.insert(argArray, this.createIntegerPush(cpg, packedArgPos));
                callinCall = il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Method", "invoke", (Type)object, new Type[]{object, objectArray}, (short)182));
                il.append((Instruction)new POP());
            } else {
                callinCall = il.append((Instruction)this.factory.createInvoke(teamClassName, mb2.getWrapperName(), (Type)Type.VOID, wrapperArgTypes, (short)182));
            }
            if (!debugging) continue;
            mg.addLineNumber(callinCall, SHOW_ROLE_CALL ? firstLine : 65533);
            mg.addLineNumber(il.append((Instruction)new NOP()), 65534);
        }
    }

    private int checkPackValue0(InstructionList il, boolean doPack, int argCount, ConstantPoolGen cpg) {
        if (doPack) {
            il.append((Instruction)new DUP());
            il.append(this.createIntegerPush(cpg, argCount));
            return argCount + 1;
        }
        return argCount;
    }

    private void checkPackValue1(InstructionList il, boolean doPack, Type argType) {
        if (doPack) {
            if (argType instanceof BasicType) {
                il.append(this.createBoxing((BasicType)argType));
            }
            il.append((Instruction)new AASTORE());
        }
    }

    private void pushTypeArray(InstructionList il, Type[] argTypes, int major, String class_name_this, ConstantPoolGen cpg) {
        il.append(this.createIntegerPush(cpg, argTypes.length));
        il.append((Instruction)new ANEWARRAY(cpg.addClass(classType)));
        int i = 0;
        while (i < argTypes.length) {
            Type type = argTypes[i];
            il.append((Instruction)new DUP());
            il.append(this.createIntegerPush(cpg, i));
            if (type instanceof BasicType) {
                il.append((Instruction)this.factory.createFieldAccess(BaseMethodTransformation.toObjectTypeName((BasicType)type), "TYPE", (Type)classType, (short)178));
            } else if (type instanceof ObjectType) {
                this.appendClassLiteral(il, class_name_this, ((ObjectType)type).getClassName(), major, cpg);
            } else if (type instanceof ArrayType) {
                Object prefix = "";
                while (type instanceof ArrayType) {
                    prefix = (String)prefix + "[";
                    type = ((ArrayType)type).getElementType();
                }
                Object elemTypeName = null;
                if (type instanceof ObjectType) {
                    elemTypeName = "L" + ((ObjectType)type).getClassName() + ";";
                } else if (type instanceof BasicType) {
                    elemTypeName = ((BasicType)type).getSignature();
                }
                this.appendClassLiteral(il, class_name_this, (String)prefix + (String)elemTypeName, major, cpg);
            } else {
                throw new OTREInternalError("unsupported type in signature " + String.valueOf(type));
            }
            il.append((Instruction)new AASTORE());
            ++i;
        }
    }

    void createReplaceCase(MethodGen mg, InstructionList il, String teamClassName, List<MethodBinding> sortedMBList, int ot_result, int ot_team, int major, int firstLine) {
        int indexOffset = mg.isStatic() ? -1 : 0;
        boolean multipleBindings = sortedMBList.size() > 1;
        LocalVariableGen unused_args_lg = mg.addLocalVariable("_OT$unusedArgs", (Type)objectArray, null, null);
        int unused_args = unused_args_lg.getIndex();
        unused_args_lg.setStart(il.append((Instruction)new NOP()));
        if (multipleBindings) {
            InstructionList addition = new InstructionList();
            InstructionHandle switchStart = addition.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)(4 + indexOffset)));
            int numberOfCases = sortedMBList.size();
            GOTO[] breaks = new GOTO[numberOfCases];
            int i = 0;
            while (i < numberOfCases) {
                breaks[i] = new GOTO(null);
                ++i;
            }
            int[] matches = new int[numberOfCases];
            InstructionHandle[] targets = new InstructionHandle[numberOfCases];
            int caseCounter = 0;
            Iterator<MethodBinding> mbIterator = sortedMBList.iterator();
            MethodBinding mb = null;
            while (mbIterator.hasNext()) {
                mb = mbIterator.next();
                matches[caseCounter] = caseCounter;
                InstructionHandle nextBranch = addition.append((Instruction)new NOP());
                addition.append(this.createSingleReplaceCallin(mg, teamClassName, mb, ot_result, ot_team, unused_args, multipleBindings, mg.isStatic(), major, firstLine));
                targets[caseCounter] = nextBranch;
                addition.append((BranchInstruction)breaks[caseCounter]);
                ++caseCounter;
            }
            InstructionHandle defaultBranch = addition.append((Instruction)new NOP());
            this.createRecursiveCall(addition, mg, ot_result, 1, 0, mb.getBaseMethodName(), mb.getBaseMethodSignature(), firstLine);
            InstructionHandle afterSwitch = addition.append((Instruction)new NOP());
            int i2 = 0;
            while (i2 < numberOfCases) {
                breaks[i2].setTarget(afterSwitch);
                ++i2;
            }
            addition.append(switchStart, (BranchInstruction)new TABLESWITCH(matches, targets, defaultBranch));
            InstructionHandle endTry = addition.getEnd();
            GOTO skipHdlr = null;
            skipHdlr = new GOTO(null);
            addition.append((BranchInstruction)skipHdlr);
            InstructionHandle hdlr = addition.append((Instruction)new NOP());
            addition.append(DebugUtil.createReportExc(this.factory));
            this.createRecursiveCall(addition, mg, ot_result, 0, 1, mb.getBaseMethodName(), mb.getBaseMethodSignature(), firstLine);
            mg.addExceptionHandler(addition.getStart(), endTry, hdlr, liftingVeto);
            mg.addExceptionHandler(addition.getStart(), endTry, hdlr, liftingFailed);
            InstructionHandle nop = addition.append((Instruction)new NOP());
            skipHdlr.setTarget(nop);
            il.append(addition);
        } else {
            MethodBinding mb = sortedMBList.get(0);
            il.append(this.createSingleReplaceCallin(mg, teamClassName, mb, ot_result, ot_team, unused_args, multipleBindings, mg.isStatic(), major, firstLine));
        }
        unused_args_lg.setEnd(il.getEnd());
    }

    private InstructionList createSingleReplaceCallin(MethodGen mg, String connectorClassName, MethodBinding mb, int ot_result, int ot_team, int unused_args, boolean multipleBindings, boolean staticBaseMethod, int major, int firstLine) {
        InstructionHandle callinCall;
        boolean baseIsStaticCallin;
        Type[] chainArgTypes = mg.getArgumentTypes();
        Type[] baseArgTypes = Type.getArgumentTypes((String)mb.getBaseMethodSignature());
        Type[] roleArgTypes = Type.getArgumentTypes((String)mb.getRoleMethodSignature());
        roleArgTypes = BaseMethodTransformation.enhanceArgumentTypes(roleArgTypes);
        String wrapperName = mb.getWrapperName();
        Type wrapperReturnType = Type.getReturnType((String)mb.getWrapperSignature());
        Type[] wrapperArgTypes = Type.getArgumentTypes((String)mb.getWrapperSignature());
        Type chainReturnType = mg.getReturnType();
        ConstantPoolGen cpg = mg.getConstantPool();
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)teamType, (int)ot_team));
        int packedArgPos = 0;
        InstructionHandle argArray = null;
        if (this.useReflection) {
            il.append((Instruction)this.factory.createInvoke("java.lang.Object", "getClass", (Type)classType, new Type[0], (short)182));
            il.append((Instruction)new LDC(cpg.addString(mb.getWrapperName())));
            this.pushTypeArray(il, wrapperArgTypes, major, mg.getClassName(), cpg);
            il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getMethod", (Type)methodType, OTConstants.getMethodSignature, (short)182));
            il.append((Instruction)InstructionFactory.createLoad((Type)teamType, (int)ot_team));
            argArray = il.append((Instruction)new ANEWARRAY(cpg.addClass(object)));
        } else {
            il.append(this.factory.createCast((Type)teamType, (Type)new ObjectType(connectorClassName)));
        }
        packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
        if (!staticBaseMethod) {
            il.append(InstructionFactory.createThis());
        } else {
            il.append(InstructionFactory.createNull((Type)Type.OBJECT));
        }
        this.checkPackValue1(il, this.useReflection, (Type)Type.OBJECT);
        int staticOffset = staticBaseMethod ? -1 : 0;
        int i = 0;
        while (i < 4) {
            packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
            il.append((Instruction)InstructionFactory.createLoad((Type)chainArgTypes[i], (int)(i + 1 + staticOffset)));
            if (!multipleBindings && i + 1 + staticOffset == 3 + staticOffset) {
                il.append((Instruction)new ICONST(1));
                il.append((Instruction)new IADD());
            } else if (multipleBindings && i + 1 + staticOffset == 4 + staticOffset) {
                il.append((Instruction)new ICONST(1));
                il.append((Instruction)new IADD());
            }
            this.checkPackValue1(il, this.useReflection, chainArgTypes[i]);
            ++i;
        }
        int base_meth_tag = CallinBindingManager.getBaseCallTag(mb.getBaseClassName(), mb.getBaseMethodName(), mb.getBaseMethodSignature());
        packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
        il.append(this.createIntegerPush(cpg, base_meth_tag));
        this.checkPackValue1(il, this.useReflection, (Type)Type.INT);
        InstructionList regularArgs = new InstructionList();
        packedArgPos = this.checkPackValue0(il, this.useReflection, packedArgPos, cpg);
        il.append(this.createIntegerPush(cpg, baseArgTypes.length));
        il.append(this.factory.createNewArray((Type)object, (short)1));
        il.append((Instruction)InstructionFactory.createStore((Type)objectArray, (int)unused_args));
        int unusedArgsIdx = 0;
        int stackIdx = 7 + staticOffset;
        int regularArgsStart = 6;
        boolean bl = baseIsStaticCallin = mb.baseMethodIsCallin() && staticBaseMethod;
        if (baseIsStaticCallin) {
            this.storeUnusedArg(il, unused_args, 0, (Instruction)new ICONST(0), (Type)Type.INT, cpg);
            this.storeUnusedArg(il, unused_args, 1, (Instruction)new ALOAD(regularArgsStart + 1), (Type)OTConstants.teamType, cpg);
            regularArgsStart += 2;
            stackIdx += 2;
            unusedArgsIdx += 2;
        }
        int i2 = regularArgsStart;
        while (i2 < chainArgTypes.length) {
            Type argType = chainArgTypes[i2];
            LocalVariableInstruction loadingInstruction = InstructionFactory.createLoad((Type)argType, (int)stackIdx);
            if (BaseMethodTransformation.isRegularArg(i2, mb.baseMethodIsCallin(), staticBaseMethod)) {
                packedArgPos = this.checkPackValue0(regularArgs, this.useReflection, packedArgPos, cpg);
                regularArgs.append((Instruction)loadingInstruction);
                this.checkPackValue0(regularArgs, this.useReflection, packedArgPos, cpg);
            } else {
                this.storeUnusedArg(il, unused_args, unusedArgsIdx++, (Instruction)loadingInstruction, argType, cpg);
            }
            stackIdx += argType.getSize();
            ++i2;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)objectArray, (int)unused_args));
        this.checkPackValue1(il, this.useReflection, (Type)objectArray);
        il.append(regularArgs);
        if (this.useReflection) {
            il.insert(argArray, this.createIntegerPush(cpg, packedArgPos));
            callinCall = il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Method", "invoke", (Type)object, new Type[]{object, objectArray}, (short)182));
            wrapperReturnType = Type.OBJECT;
        } else {
            callinCall = il.append((Instruction)this.factory.createInvoke(connectorClassName, wrapperName, wrapperReturnType, wrapperArgTypes, (short)182));
        }
        if (debugging) {
            mg.addLineNumber(callinCall, SHOW_ROLE_CALL ? firstLine : 65533);
            mg.addLineNumber(il.append((Instruction)new NOP()), 65534);
        }
        this.adjustValue(il, null, wrapperReturnType, chainReturnType);
        il.append((Instruction)InstructionFactory.createStore((Type)chainReturnType, (int)ot_result));
        return il;
    }

    private void storeUnusedArg(InstructionList il, int unused_args, int arrayIndex, Instruction pushInstruction, Type argType, ConstantPoolGen cpg) {
        il.append((Instruction)InstructionFactory.createLoad((Type)objectArray, (int)unused_args));
        il.append(this.createIntegerPush(cpg, arrayIndex));
        il.append(pushInstruction);
        if (argType instanceof BasicType) {
            il.append(this.createBoxing((BasicType)argType));
        }
        il.append((Instruction)InstructionFactory.createArrayStore((Type)objectArray));
    }

    static boolean isRegularArg(int idx, boolean baseIsCallin, boolean baseIsStatic) {
        int firstVisible;
        if (baseIsCallin && baseIsStatic) {
            idx -= 2;
        }
        return idx >= (firstVisible = 6 + (baseIsCallin ? 6 : 0));
    }

    static Type checkWiden(Type actual, Type formal) {
        ObjectType formalObj;
        ObjectType actualObj;
        if (!actual.equals((Object)formal) && actual instanceof ObjectType && formal instanceof ObjectType && RepositoryAccess.safeSubclassOf(actualObj = (ObjectType)actual, formalObj = (ObjectType)formal)) {
            return formalObj;
        }
        return actual;
    }

    private InstructionList getInitializedRoleSet(String class_name, boolean valueRequired) {
        InstructionList il = new InstructionList();
        il.append((Instruction)new ALOAD(0));
        il.append((Instruction)this.factory.createGetField(class_name, "_OT$roleSet", (Type)OTConstants.roleSetType));
        if (valueRequired) {
            il.append((Instruction)new DUP());
        }
        IFNONNULL branch = new IFNONNULL(null);
        il.append((BranchInstruction)branch);
        if (valueRequired) {
            il.append((Instruction)new POP());
        }
        il.append((Instruction)new ALOAD(0));
        il.append((Instruction)this.factory.createNew(OTConstants.roleSetType));
        il.append((Instruction)new DUP());
        il.append((Instruction)this.factory.createInvoke(OTConstants.roleSetType.getClassName(), "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        if (valueRequired) {
            il.append((Instruction)new DUP_X1());
        }
        il.append((Instruction)this.factory.createPutField(class_name, "_OT$roleSet", (Type)OTConstants.roleSetType));
        branch.setTarget(il.append((Instruction)new NOP()));
        return il;
    }

    private Field generateRoleSet(ConstantPoolGen cpg, String class_name) {
        FieldGen fg = new FieldGen(132, (Type)OTConstants.roleSetType, "_OT$roleSet", cpg);
        return fg.getField();
    }

    private Method generateAddRole(ConstantPoolGen cpg, String class_name) {
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.OBJECT}, new String[]{"role"}, "_OT$addRole", class_name, il, cpg);
        il.append(this.getInitializedRoleSet(class_name, true));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.factory.createInvoke(OTConstants.roleSetType.getClassName(), "add", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)182));
        il.append((Instruction)new POP());
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        mg.removeNOPs();
        mg.setMaxStack();
        mg.setMaxLocals(2);
        return mg.getMethod();
    }

    private Method generateRemoveRole(ConstantPoolGen cpg, String class_name) {
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.OBJECT}, new String[]{"role"}, "_OT$removeRole", class_name, il, cpg);
        il.append((Instruction)new ALOAD(0));
        il.append((Instruction)this.factory.createGetField(class_name, "_OT$roleSet", (Type)OTConstants.roleSetType));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.factory.createInvoke(OTConstants.roleSetType.getClassName(), "remove", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)182));
        il.append((Instruction)new POP());
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        mg.removeNOPs();
        mg.setMaxStack(2);
        mg.setMaxLocals(2);
        return mg.getMethod();
    }
}

