/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashMap;
import java.util.Map;

public enum TerminalToken {
    TokenNameInvalid(-1),
    TokenNameNotAToken(0),
    TokenNameWHITESPACE(1000),
    TokenNameCOMMENT_LINE(1001),
    TokenNameCOMMENT_BLOCK(1002),
    TokenNameCOMMENT_JAVADOC(1003),
    TokenNameSingleQuoteStringLiteral(1004),
    TokenNameCOMMENT_MARKDOWN(1005),
    TokenNameIdentifier(16),
    TokenNameabstract(57),
    TokenNameassert(88),
    TokenNameboolean(115),
    TokenNamebreak(89),
    TokenNamebyte(116),
    TokenNamecase(117),
    TokenNamecatch(118),
    TokenNamechar(119),
    TokenNameclass(76),
    TokenNamecontinue(90),
    TokenNameconst(153),
    TokenNamedefault(83),
    TokenNamedo(91),
    TokenNamedouble(120),
    TokenNameelse(132),
    TokenNameenum(80),
    TokenNameextends(100),
    TokenNamefalse(42),
    TokenNamefinal(58),
    TokenNamefinally(129),
    TokenNamefloat(121),
    TokenNamefor(92),
    TokenNamegoto(154),
    TokenNameif(93),
    TokenNameimplements(149),
    TokenNameimport(122),
    TokenNameinstanceof(18),
    TokenNameint(123),
    TokenNameinterface(79),
    TokenNamelong(124),
    TokenNamenative(59),
    TokenNamenew(38),
    TokenNamenon_sealed(60),
    TokenNamenull(43),
    TokenNamepackage(101),
    TokenNameprivate(61),
    TokenNameprotected(62),
    TokenNamepublic(63),
    TokenNamereturn(94),
    TokenNameshort(125),
    TokenNamestatic(44),
    TokenNamestrictfp(64),
    TokenNamesuper(36),
    TokenNameswitch(65),
    TokenNamesynchronized(54),
    TokenNamethis(37),
    TokenNamethrow(86),
    TokenNamethrows(130),
    TokenNametransient(66),
    TokenNametrue(45),
    TokenNametry(95),
    TokenNamevoid(126),
    TokenNamevolatile(67),
    TokenNamewhile(87),
    TokenNamemodule(131),
    TokenNameopen(139),
    TokenNamerequires(133),
    TokenNametransitive(140),
    TokenNameexports(134),
    TokenNameopens(135),
    TokenNameto(150),
    TokenNameuses(136),
    TokenNameprovides(137),
    TokenNamewith(102),
    TokenNameas(141),
    TokenNamebase(33),
    TokenNamecallin(68),
    TokenNameplayedBy(151),
    TokenNameprecedence(103),
    TokenNameteam(55),
    TokenNametsuper(40),
    TokenNamewithin(96),
    TokenNamereplace(142),
    TokenNameafter(138),
    TokenNamebefore(143),
    TokenNameget(144),
    TokenNameset(145),
    TokenNameIntegerLiteral(46),
    TokenNameLongLiteral(47),
    TokenNameFloatingPointLiteral(48),
    TokenNameDoubleLiteral(49),
    TokenNameCharacterLiteral(50),
    TokenNameStringLiteral(51),
    TokenNameTextBlock(52),
    TokenNamePLUS_PLUS(2),
    TokenNameMINUS_MINUS(3),
    TokenNameEQUAL_EQUAL(21),
    TokenNameLESS_EQUAL(14),
    TokenNameGREATER_EQUAL(15),
    TokenNameNOT_EQUAL(22),
    TokenNameLEFT_SHIFT(19),
    TokenNameRIGHT_SHIFT(13),
    TokenNameUNSIGNED_RIGHT_SHIFT(17),
    TokenNamePLUS_EQUAL(104),
    TokenNameMINUS_EQUAL(105),
    TokenNameMULTIPLY_EQUAL(106),
    TokenNameDIVIDE_EQUAL(107),
    TokenNameAND_EQUAL(108),
    TokenNameOR_EQUAL(109),
    TokenNameXOR_EQUAL(110),
    TokenNameREMAINDER_EQUAL(111),
    TokenNameLEFT_SHIFT_EQUAL(112),
    TokenNameRIGHT_SHIFT_EQUAL(113),
    TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL(114),
    TokenNameOR_OR(31),
    TokenNameAND_AND(30),
    TokenNamePLUS(4),
    TokenNameMINUS(5),
    TokenNameNOT(71),
    TokenNameREMAINDER(10),
    TokenNameXOR(27),
    TokenNameAND(23),
    TokenNameMULTIPLY(9),
    TokenNameOR(28),
    TokenNameTWIDDLE(72),
    TokenNameDIVIDE(11),
    TokenNameGREATER(12),
    TokenNameLESS(8),
    TokenNameLPAREN(20),
    TokenNameRPAREN(24),
    TokenNameLBRACE(69),
    TokenNameRBRACE(34),
    TokenNameLBRACKET(6),
    TokenNameRBRACKET(75),
    TokenNameSEMICOLON(25),
    TokenNameQUESTION(29),
    TokenNameCOLON(70),
    TokenNameCOMMA(32),
    TokenNameDOT(1),
    TokenNameEQUAL(84),
    TokenNameAT(41),
    TokenNameELLIPSIS(146),
    TokenNameARROW(127),
    TokenNameCOLON_COLON(7),
    TokenNameBeginLambda(53),
    TokenNameBeginIntersectionCast(73),
    TokenNameBeginTypeArguments(85),
    TokenNameElidedSemicolonAndRightBrace(77),
    TokenNameAT308(26),
    TokenNameAT308DOTDOTDOT(152),
    TokenNameCaseArrow(78),
    TokenNameRestrictedIdentifierYield(97),
    TokenNameRestrictedIdentifierrecord(81),
    TokenNameRestrictedIdentifiersealed(56),
    TokenNameRestrictedIdentifierpermits(147),
    TokenNameBeginCasePattern(148),
    TokenNameRestrictedIdentifierWhen(98),
    TokenNameUNDERSCORE(35),
    TokenNameATOT(128),
    TokenNameBINDIN(82),
    TokenNameCALLOUT_OVERRIDE(99),
    TokenNameBINDOUT(74),
    TokenNameEOF(39),
    TokenNameERROR(155);

    private static final Map<Integer, TerminalToken> tokenMap;
    private final int tokenNumber;

    static {
        tokenMap = new HashMap<Integer, TerminalToken>(256);
        TerminalToken[] terminalTokenArray = TerminalToken.values();
        int n = terminalTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalToken t = terminalTokenArray[n2];
            tokenMap.put(t.tokenNumber(), t);
            ++n2;
        }
    }

    private TerminalToken(int number) {
        this.tokenNumber = number;
    }

    public int tokenNumber() {
        return this.tokenNumber;
    }

    public static boolean isRestrictedKeyword(TerminalToken tokenType) {
        boolean bl;
        switch (tokenType) {
            case TokenNameRestrictedIdentifierYield: 
            case TokenNameRestrictedIdentifierrecord: 
            case TokenNameRestrictedIdentifiersealed: 
            case TokenNameRestrictedIdentifierpermits: 
            case TokenNameRestrictedIdentifierWhen: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static TerminalToken getRestrictedKeyword(char[] text) {
        int len;
        if (text != null && ((len = text.length) == 4 && text[0] == 'w' || len == 5 && text[0] == 'y' || len == 6 && (text[0] == 'r' || text[0] == 's') || len == 7 && text[0] == 'p')) {
            return TerminalToken.getRestrictedKeyword(new String(text));
        }
        return TokenNameNotAToken;
    }

    public static TerminalToken getRestrictedKeyword(String text) {
        TerminalToken terminalToken;
        switch (text) {
            case "yield": {
                terminalToken = TokenNameRestrictedIdentifierYield;
                break;
            }
            case "record": {
                terminalToken = TokenNameRestrictedIdentifierrecord;
                break;
            }
            case "when": {
                terminalToken = TokenNameRestrictedIdentifierWhen;
                break;
            }
            case "sealed": {
                terminalToken = TokenNameRestrictedIdentifiersealed;
                break;
            }
            case "permits": {
                terminalToken = TokenNameRestrictedIdentifierpermits;
                break;
            }
            default: {
                terminalToken = TokenNameNotAToken;
            }
        }
        return terminalToken;
    }

    public static TerminalToken of(int act) {
        TerminalToken token = tokenMap.get(act);
        if (token == null) {
            throw new IllegalArgumentException("Unknown token number = " + act);
        }
        return token;
    }

    static TerminalToken maybeOf(int act) {
        return tokenMap.get(act);
    }
}

