/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class NameReference
extends Reference
implements InvocationSite {
    public Binding binding;
    public TypeBinding actualReceiverType;
    public Expression.DecapsulationState baseclassDecapsulation = Expression.DecapsulationState.NONE;
    public boolean isGenerated;

    public void setBaseclassDecapsulation(Expression.DecapsulationState state) {
        this.baseclassDecapsulation = state;
    }

    @Override
    public Expression.DecapsulationState getBaseclassDecapsulation() {
        return this.baseclassDecapsulation;
    }

    @Override
    public void tagReportedBaseclassDecapsulation() {
        this.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
    }

    @Override
    protected boolean checkBaseclassDecapsulation(Scope scope) {
        if (this.binding instanceof ProblemReferenceBinding && this.binding.problemId() == 2 && this.getBaseclassDecapsulation().isAllowed()) {
            TypeBinding closestMatch = ((ProblemReferenceBinding)this.binding).closestMatch();
            if (closestMatch == null) {
                return false;
            }
            this.binding = closestMatch;
            if (this.binding.kind() == 4) {
                this.resolvedType = (TypeBinding)this.binding;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    public NameReference() {
        this.bits |= 7;
    }

    public void emitDeclaringClassOfConstant(CodeStream codeStream) {
        Binding binding;
        if (this.constant != Constant.NotAConstant && (binding = this.binding) instanceof FieldBinding) {
            FieldBinding f = (FieldBinding)binding;
            codeStream.constantPool.literalIndexForType(f.declaringClass);
        }
    }

    public static void emitDeclaringClassOfConstant(Expression expr, final CodeStream codeStream) {
        if (expr instanceof Literal) {
            return;
        }
        expr.traverse(new ASTVisitor(){

            @Override
            public boolean visit(SingleNameReference nameReference, BlockScope scope) {
                nameReference.emitDeclaringClassOfConstant(codeStream);
                return false;
            }

            @Override
            public boolean visit(QualifiedNameReference nameReference, BlockScope scope) {
                nameReference.emitDeclaringClassOfConstant(codeStream);
                return false;
            }
        }, (BlockScope)null);
    }

    @Override
    public FieldBinding fieldBinding() {
        return (FieldBinding)this.binding;
    }

    @Override
    public FieldBinding lastFieldBinding() {
        if ((this.bits & 7) == 1) {
            return this.fieldBinding();
        }
        return null;
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return null;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return this.binding == null || (this.binding.kind() & 4) != 0;
    }

    @Override
    public boolean isTypeReference() {
        return this.binding instanceof ReferenceBinding;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
        if (receiverType == null) {
            return;
        }
        this.actualReceiverType = receiverType;
    }

    @Override
    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    @Override
    public void setFieldIndex(int index) {
    }

    public abstract String unboundReferenceErrorName();

    public abstract char[][] getName();

    public void resolveFinished() {
    }

    @Override
    public boolean isType() {
        return (this.bits & 4) != 0;
    }
}

