/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.IMethodSpec;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.MethodMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCallinMapping;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public class CallinMapping
extends MethodMapping
implements ICallinMapping {
    private int callinKind;
    private MethodData[] baseMethodHandles;
    private String name;

    public CallinMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType parent, IMethod corrJavaMeth, char[] name, int callinKind, MethodData roleMethodHandle, MethodData[] baseMethodHandles, boolean hasSignature) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, parent, corrJavaMeth, name, callinKind, roleMethodHandle, baseMethodHandles, hasSignature, true);
    }

    public CallinMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType parent, IMethod corrJavaMeth, char[] name, int callinKind, MethodData roleMethodHandle, MethodData[] baseMethodHandles, boolean hasSignature, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 102, corrJavaMeth, parent, roleMethodHandle, hasSignature, addAsChild);
        this.name = new String(name);
        this.callinKind = callinKind;
        this.baseMethodHandles = baseMethodHandles;
    }

    @Override
    protected void getNameForHandle(StringBuilder buff) {
        this.escapeMementoName(buff, this.name);
        buff.append('\u00a7');
    }

    @Override
    protected char getMappingKindChar() {
        switch (this.callinKind) {
            case 2: {
                return 'a';
            }
            case 1: {
                return 'b';
            }
            case 3: {
                return 'r';
            }
        }
        throw new InternalCompilerError("Unexpected callin kind");
    }

    @Override
    protected void getBaseMethodsForHandle(StringBuilder buff) {
        MethodData[] methodDataArray = this.baseMethodHandles;
        int n = this.baseMethodHandles.length;
        int n2 = 0;
        while (n2 < n) {
            MethodData baseMethod = methodDataArray[n2];
            this.getMethodForHandle(baseMethod, buff);
            ++n2;
        }
    }

    @Override
    public JavaElement getParent() {
        JavaElement myParent = super.getParent();
        if (myParent instanceof IRoleType) {
            return myParent;
        }
        return (JavaElement)((Object)OTModelManager.getOTElement((IType)((Object)myParent)));
    }

    @Override
    protected IRoleType getDeclaringRole() {
        return (IRoleType)((Object)this.getParent());
    }

    @Override
    protected String getSourceName() {
        if (this.hasName()) {
            return this.name;
        }
        return super.getSourceName();
    }

    @Override
    public String getElementName() {
        ITypeParameter[] typeParameters;
        StringBuffer elementName = new StringBuffer(super.getElementName());
        elementName.append(" <- ");
        if (this.baseMethodHandles.length > 1) {
            elementName.append("{");
        }
        int idx = 0;
        while (idx < this.baseMethodHandles.length) {
            if (idx != 0) {
                elementName.append(",");
            }
            if (this.hasSignature()) {
                elementName.append(this.baseMethodHandles[idx].toString());
            } else {
                elementName.append(this.baseMethodHandles[idx].getSelector());
            }
            ++idx;
        }
        if (this.baseMethodHandles.length > 1) {
            elementName.append("}");
        }
        if ((typeParameters = this.getRoleMethodHandle().typeParameters).length > 0) {
            elementName.append(" <");
            int i = 0;
            while (i < typeParameters.length) {
                elementName.append(typeParameters[i].getElementName());
                if (i + 1 < typeParameters.length) {
                    elementName.append(", ");
                }
                ++i;
            }
            elementName.append(">");
        }
        return elementName.toString();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.startsWith("<");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMappingKind() {
        return 102;
    }

    @Override
    public int getCallinKind() {
        return this.callinKind;
    }

    @Override
    public boolean hasCovariantReturn() {
        if (this.baseMethodHandles != null) {
            MethodData[] methodDataArray = this.baseMethodHandles;
            int n = this.baseMethodHandles.length;
            int n2 = 0;
            while (n2 < n) {
                MethodData baseMethod = methodDataArray[n2];
                if (baseMethod.hasCovariantReturn()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public IMethod[] getBoundBaseMethods() throws JavaModelException {
        return this.findBaseMethods();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CallinMapping)) {
            return false;
        }
        CallinMapping other = (CallinMapping)obj;
        if (this.name.charAt(0) != '<' && other.name.charAt(0) != '<' && !this.name.equals(other.name)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.name.equals(other.name)) {
            return true;
        }
        return this.callinKind == other.callinKind;
    }

    @Override
    protected int calculateHashCode() {
        return Util.combineHashCodes(super.calculateHashCode(), Arrays.hashCode(this.baseMethodHandles));
    }

    @Override
    public String toString() {
        return "callin " + super.toString();
    }

    private IMethod[] findBaseMethods() throws JavaModelException {
        IOTType otType;
        IType baseClass = ((IRoleType)((Object)this.getParent())).getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        if (OTModelManager.hasOTElementFor(baseClass) && (otType = OTModelManager.getOTElement(baseClass)).isRole()) {
            IType[] implicitSupers = TypeHelper.getImplicitSuperTypes((IRoleType)otType);
            int len1 = typeParents.length;
            int len2 = implicitSupers.length;
            IType[] iTypeArray = typeParents;
            typeParents = new IType[len1 + len2];
            System.arraycopy(iTypeArray, 0, typeParents, 0, len1);
            System.arraycopy(implicitSupers, 0, typeParents, len1, len2);
        }
        LinkedList<IMethod> baseMethods = new LinkedList<IMethod>();
        int idx = 0;
        while (idx < this.baseMethodHandles.length) {
            IMethod baseMethod = this.findMethod(typeParents, this.baseMethodHandles[idx]);
            if (baseMethod != null) {
                baseMethods.add(baseMethod);
            }
            ++idx;
        }
        return baseMethods.toArray(new IMethod[baseMethods.size()]);
    }

    @Override
    public IMethodSpec[] getBaseMethodHandles() {
        return this.baseMethodHandles;
    }

    public static int convertModelToTerminalToken(int icallinmappingKind) {
        switch (icallinmappingKind) {
            case 1: {
                return 143;
            }
            case 2: {
                return 138;
            }
        }
        return 142;
    }

    public static int convertTerminalTokenToModel(int terminalTokensCallinKind) {
        switch (terminalTokensCallinKind) {
            case 143: {
                return 1;
            }
            case 138: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCallinMapping resolvedHandle = new ResolvedCallinMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), (IRoleType)((Object)this.getParent()), this.getIMethod(), this.name.toCharArray(), this.callinKind, this.getRoleMethodHandle(), this.baseMethodHandles, this.hasSignature(), new String(uniqueKey));
        return resolvedHandle;
    }
}

