/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class WithinStatement
extends Statement {
    public static final ChildPropertyDescriptor TEAM_EXPRESSION_PROPERTY = new ChildPropertyDescriptor(WithinStatement.class, "team expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(WithinStatement.class, "body", Statement.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Expression teamExpression = null;
    private Statement body = null;

    static {
        ArrayList propertyList = new ArrayList(3);
        WithinStatement.createPropertyList(WithinStatement.class, propertyList);
        WithinStatement.addProperty(TEAM_EXPRESSION_PROPERTY, propertyList);
        WithinStatement.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = WithinStatement.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    WithinStatement(AST ast) {
        super(ast);
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return WithinStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean isGet, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (isGet) {
                return this.getBody();
            }
            this.setBody((Statement)child);
            return null;
        }
        if (property == TEAM_EXPRESSION_PROPERTY) {
            if (isGet) {
                return this.getTeamExpression();
            }
            this.setTeamExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, isGet, child);
    }

    @Override
    int getNodeType0() {
        return 120;
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        WithinStatement result = new WithinStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setTeamExpression((Expression)this.getTeamExpression().clone(target));
        result.setBody((Statement)this.getBody().clone(target));
        return result;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.teamExpression);
            this.acceptChild(visitor, this.body);
        }
        visitor.endVisit(this);
    }

    @Override
    int memSize() {
        return super.memSize() + 12 + this.body.memSize();
    }

    @Override
    int treeSize() {
        return this.memSize() + this.body.treeSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getTeamExpression() {
        if (this.teamExpression == null) {
            WithinStatement withinStatement = this;
            synchronized (withinStatement) {
                if (this.teamExpression == null) {
                    this.preLazyInit();
                    this.teamExpression = new SimpleName(this.ast);
                    this.postLazyInit(this.teamExpression, TEAM_EXPRESSION_PROPERTY);
                }
            }
        }
        return this.teamExpression;
    }

    public void setTeamExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.teamExpression;
        this.preReplaceChild(oldChild, expression, TEAM_EXPRESSION_PROPERTY);
        this.teamExpression = expression;
        this.postReplaceChild(oldChild, expression, TEAM_EXPRESSION_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getBody() {
        if (this.body == null) {
            WithinStatement withinStatement = this;
            synchronized (withinStatement) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, statement, BODY_PROPERTY);
        this.body = statement;
        this.postReplaceChild(oldChild, statement, BODY_PROPERTY);
    }
}

