/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class ImportDeclaration
extends ASTNode {
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(ImportDeclaration.class, "name", Name.class, true, false);
    public static final SimplePropertyDescriptor ON_DEMAND_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "onDemand", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor STATIC_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "static", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor BASE_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "base", Boolean.TYPE, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private volatile Name importName;
    private boolean onDemand = false;
    private boolean isStatic = false;
    private boolean isBase = false;
    private int baseModifierPosition = -1;

    static {
        ArrayList properyList = new ArrayList(3);
        ImportDeclaration.createPropertyList(ImportDeclaration.class, properyList);
        ImportDeclaration.addProperty(NAME_PROPERTY, properyList);
        ImportDeclaration.addProperty(ON_DEMAND_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_2_0 = ImportDeclaration.reapPropertyList(properyList);
        properyList = new ArrayList(4);
        ImportDeclaration.createPropertyList(ImportDeclaration.class, properyList);
        ImportDeclaration.addProperty(STATIC_PROPERTY, properyList);
        ImportDeclaration.addProperty(BASE_PROPERTY, properyList);
        ImportDeclaration.addProperty(NAME_PROPERTY, properyList);
        ImportDeclaration.addProperty(ON_DEMAND_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_3_0 = ImportDeclaration.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    ImportDeclaration(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ImportDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == ON_DEMAND_PROPERTY) {
            if (get) {
                return this.isOnDemand();
            }
            this.setOnDemand(value);
            return false;
        }
        if (property == STATIC_PROPERTY) {
            if (get) {
                return this.isStatic();
            }
            this.setStatic(value);
            return false;
        }
        if (property == BASE_PROPERTY) {
            if (get) {
                return this.isBase();
            }
            this.setBase(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Name)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 26;
    }

    @Override
    ASTNode clone0(AST target) {
        ImportDeclaration result = new ImportDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOnDemand(this.isOnDemand());
        if (this.ast.apiLevel >= 3) {
            result.setStatic(this.isStatic());
        }
        if (this.ast.apiLevel >= 3) {
            result.setBase(this.isBase());
        }
        result.setName((Name)this.getName().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getName() {
        if (this.importName == null) {
            ImportDeclaration importDeclaration = this;
            synchronized (importDeclaration) {
                if (this.importName == null) {
                    this.preLazyInit();
                    this.importName = this.postLazyInit(this.ast.newQualifiedName(new SimpleName(this.ast), new SimpleName(this.ast)), NAME_PROPERTY);
                }
            }
        }
        return this.importName;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.importName;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.importName = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }

    public void setOnDemand(boolean onDemand) {
        this.preValueChange(ON_DEMAND_PROPERTY);
        this.onDemand = onDemand;
        this.postValueChange(ON_DEMAND_PROPERTY);
    }

    public boolean isStatic() {
        this.unsupportedIn2();
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.unsupportedIn2();
        this.preValueChange(STATIC_PROPERTY);
        this.isStatic = isStatic;
        this.postValueChange(STATIC_PROPERTY);
    }

    public boolean isBase() {
        this.unsupportedIn2();
        return this.isBase;
    }

    public void setBase(boolean isBase) {
        this.unsupportedIn2();
        this.preValueChange(BASE_PROPERTY);
        this.isBase = isBase;
        this.postValueChange(BASE_PROPERTY);
    }

    public IBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveImport(this);
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.importName == null ? 0 : this.getName().treeSize());
    }

    public void setBaseModifierPosition(int baseModifierPosition) {
        this.baseModifierPosition = baseModifierPosition;
    }

    public int getBaseModifierPosition() {
        return this.baseModifierPosition;
    }
}

