/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.compiler.env.IBinaryInfo;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ElementCache;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.VerboseElementCache;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.internal.core.OTType;

public class JavaModelCache {
    public static boolean VERBOSE = false;
    public static boolean DEBUG_CACHE_INSERTIONS = false;
    public static final int DEFAULT_ROOT_SIZE = 2000;
    public static final int DEFAULT_PKG_SIZE = 20000;
    public static final int DEFAULT_OPENABLE_SIZE = 200000;
    public static final String RATIO_PROPERTY = "org.eclipse.jdt.core.javamodelcache.ratio";
    public static final String JAR_TYPE_RATIO_PROPERTY = "org.eclipse.jdt.core.javamodelcache.jartyperatio";
    public static final IBinaryInfo NON_EXISTING_JAR_TYPE_INFO = new IBinaryInfo(){};
    protected double memoryRatio = -1.0;
    protected JavaElementInfo modelInfo;
    protected HashMap<IJavaProject, JavaElementInfo> projectCache;
    protected ElementCache<IPackageFragmentRoot> rootCache;
    protected ElementCache<IPackageFragment> pkgCache;
    protected ElementCache<ITypeRoot> openableCache;
    protected Map<IJavaElement, IElementInfo> childrenCache;
    protected LRUCache<IJavaElement, IElementInfo> jarTypeCache;

    public JavaModelCache() {
        double openableRatio = this.getOpenableRatio();
        int rootCacheSize = this.sizeLimit(2000.0 * openableRatio);
        int packageCacheeSize = this.sizeLimit(20000.0 * openableRatio);
        int openableCacheSize = this.sizeLimit(200000.0 * openableRatio);
        this.projectCache = new HashMap();
        if (VERBOSE) {
            this.rootCache = new VerboseElementCache<IPackageFragmentRoot>(rootCacheSize, "Root cache");
            this.pkgCache = new VerboseElementCache<IPackageFragment>(packageCacheeSize, "Package cache");
            this.openableCache = new VerboseElementCache<ITypeRoot>(openableCacheSize, "Openable cache");
        } else {
            this.rootCache = new ElementCache(rootCacheSize);
            this.pkgCache = new ElementCache(packageCacheeSize);
            this.openableCache = new ElementCache(openableCacheSize);
        }
        this.childrenCache = new HashMap<IJavaElement, IElementInfo>();
        this.resetJarTypeCache();
    }

    private int sizeLimit(double d) {
        return (int)Double.min(1.073741823E9, d);
    }

    private double getOpenableRatio() {
        return this.getRatioForProperty(RATIO_PROPERTY);
    }

    private double getJarTypeRatio() {
        return this.getRatioForProperty(JAR_TYPE_RATIO_PROPERTY);
    }

    private double getRatioForProperty(String propertyName) {
        String property = System.getProperty(propertyName);
        if (property != null) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException e) {
                Util.log(e, "Could not parse value for " + propertyName + ": " + property);
            }
        }
        return 1.0;
    }

    public IElementInfo getInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return (IElementInfo)this.rootCache.get((IPackageFragmentRoot)element);
            }
            case 4: {
                return (IElementInfo)this.pkgCache.get((IPackageFragment)element);
            }
            case 5: 
            case 6: {
                return (IElementInfo)this.openableCache.get((ITypeRoot)element);
            }
            case 100: 
            case 101: {
                element = ((OTType)element).getCorrespondingJavaElement();
            }
            case 7: {
                IElementInfo result = this.jarTypeCache.get(element);
                if (result != null) {
                    return result;
                }
                return this.childrenCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    public IJavaElement getExistingElement(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return element;
            }
            case 2: {
                return element;
            }
            case 3: {
                return this.rootCache.getKey((IPackageFragmentRoot)element);
            }
            case 4: {
                return this.pkgCache.getKey((IPackageFragment)element);
            }
            case 5: 
            case 6: {
                return this.openableCache.getKey((ITypeRoot)element);
            }
            case 7: {
                return element;
            }
        }
        return element;
    }

    protected IElementInfo peekAtInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return (IElementInfo)this.rootCache.peek((IPackageFragmentRoot)element);
            }
            case 4: {
                return (IElementInfo)this.pkgCache.peek((IPackageFragment)element);
            }
            case 5: 
            case 6: {
                return (IElementInfo)this.openableCache.peek((ITypeRoot)element);
            }
            case 100: 
            case 101: {
                element = ((OTType)element).getCorrespondingJavaElement();
            }
            case 7: {
                IElementInfo result = this.jarTypeCache.peek(element);
                if (result != null) {
                    return result;
                }
                return this.childrenCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IJavaElement element, IElementInfo info) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (JavaElementInfo)info;
                break;
            }
            case 2: {
                this.projectCache.put((IJavaProject)element, (JavaElementInfo)info);
                this.rootCache.ensureSpaceLimit((JavaElementInfo)info, element);
                break;
            }
            case 3: {
                this.rootCache.put((IPackageFragmentRoot)element, (JavaElementInfo)info);
                this.pkgCache.ensureSpaceLimit((JavaElementInfo)info, element);
                break;
            }
            case 4: {
                this.pkgCache.put((IPackageFragment)element, (JavaElementInfo)info);
                this.openableCache.ensureSpaceLimit((JavaElementInfo)info, element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put((ITypeRoot)element, (JavaElementInfo)info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
                return;
            }
        }
        if (DEBUG_CACHE_INSERTIONS) {
            JavaModelManager.trace(String.valueOf(Thread.currentThread()) + " cache putInfo " + JavaModelCache.getCacheType(element) + " " + element.getElementName() + ", " + info.getClass().getSimpleName());
        }
    }

    static String getCacheType(IJavaElement element) {
        String elementType;
        switch (element.getElementType()) {
            case 1: {
                elementType = "JAVA_MODEL";
                break;
            }
            case 2: {
                elementType = "JAVA_PROJECT";
                break;
            }
            case 3: {
                elementType = "PACKAGE_FRAGMENT_ROOT";
                break;
            }
            case 4: {
                elementType = "PACKAGE_FRAGMENT";
                break;
            }
            case 6: {
                elementType = "CLASS_FILE";
                break;
            }
            case 5: {
                elementType = "COMPILATION_UNIT";
                break;
            }
            default: {
                elementType = "CHILD";
            }
        }
        return elementType + ", " + element.getClass().getSimpleName();
    }

    protected void removeInfo(JavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove((IJavaProject)((Object)element));
                this.rootCache.resetSpaceLimit(element);
                break;
            }
            case 3: {
                this.rootCache.remove((IPackageFragmentRoot)((Object)element));
                this.pkgCache.resetSpaceLimit(element);
                break;
            }
            case 4: {
                this.pkgCache.remove((IPackageFragment)((Object)element));
                this.openableCache.resetSpaceLimit(element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove((ITypeRoot)((Object)element));
                break;
            }
            default: {
                this.childrenCache.remove(element);
                return;
            }
        }
        if (DEBUG_CACHE_INSERTIONS) {
            JavaModelManager.trace(String.valueOf(Thread.currentThread()) + " cache removeInfo " + JavaModelCache.getCacheType(element) + " " + element.getElementName());
        }
    }

    protected void resetJarTypeCache() {
        int jarTypeCacheSize = this.sizeLimit(200000.0 * this.getJarTypeRatio());
        this.jarTypeCache = new LRUCache(jarTypeCacheSize);
    }

    protected void removeFromJarTypeCache(BinaryType type) {
        this.jarTypeCache.flush(type);
    }

    public String toString() {
        return this.toStringFillingRation("");
    }

    public String toStringFillingRation(String prefix) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        buffer.append("Project cache: ");
        buffer.append(this.projectCache.size());
        buffer.append(" projects\n");
        buffer.append(prefix);
        buffer.append(this.rootCache.toStringFillingRation("Root cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.pkgCache.toStringFillingRation("Package cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.openableCache.toStringFillingRation("Openable cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.jarTypeCache.toStringFillingRation("Jar type cache"));
        buffer.append('\n');
        return buffer.toString();
    }
}

