/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodBindingOperator;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class CallinMappingDeclaration
extends AbstractMethodMappingDeclaration {
    public static final String CALLIN = "<-";
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(CallinMappingDeclaration.class, "name", SimpleName.class, false, false);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = CallinMappingDeclaration.internalModifiers2PropertyFactory(CallinMappingDeclaration.class);
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = CallinMappingDeclaration.internalJavadocPropertyFactory(CallinMappingDeclaration.class);
    public static final ChildPropertyDescriptor ROLE_MAPPING_ELEMENT_PROPERTY = new ChildPropertyDescriptor(CallinMappingDeclaration.class, "roleMappingElement", MethodMappingElement.class, true, false);
    public static final ChildPropertyDescriptor BINDING_OPERATOR_PROPERTY = new ChildPropertyDescriptor(CallinMappingDeclaration.class, "bindingOperator", MethodBindingOperator.class, true, false);
    public static final ChildListPropertyDescriptor BASE_MAPPING_ELEMENTS_PROPERTY = new ChildListPropertyDescriptor(CallinMappingDeclaration.class, "baseMappingElements", MethodMappingElement.class, false);
    public static final ChildPropertyDescriptor GUARD_PROPERTY = new ChildPropertyDescriptor(CallinMappingDeclaration.class, "guardPredicate", GuardPredicateDeclaration.class, false, false);
    public static final ChildListPropertyDescriptor PARAMETER_MAPPINGS_PROPERTY = CallinMappingDeclaration.internalParameterMappingPropertyFactory(CallinMappingDeclaration.class);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_2_0;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_3_0;
    private SimpleName _labelName = null;
    private MethodMappingElement _roleMappingElement = null;
    ASTNode.NodeList _baseMappingElements = new ASTNode.NodeList(BASE_MAPPING_ELEMENTS_PROPERTY);
    GuardPredicateDeclaration _optionalGuardPredicate = null;

    static {
        ArrayList propertyList = new ArrayList(7);
        CallinMappingDeclaration.createPropertyList(CallinMappingDeclaration.class, propertyList);
        CallinMappingDeclaration.addProperty(NAME_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(ROLE_MAPPING_ELEMENT_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(BINDING_OPERATOR_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(BASE_MAPPING_ELEMENTS_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(PARAMETER_MAPPINGS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = CallinMappingDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(9);
        CallinMappingDeclaration.createPropertyList(CallinMappingDeclaration.class, propertyList);
        CallinMappingDeclaration.addProperty(NAME_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(ROLE_MAPPING_ELEMENT_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(BINDING_OPERATOR_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(BASE_MAPPING_ELEMENTS_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(GUARD_PROPERTY, propertyList);
        CallinMappingDeclaration.addProperty(PARAMETER_MAPPINGS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = CallinMappingDeclaration.reapPropertyList(propertyList);
    }

    CallinMappingDeclaration(AST ast) {
        super(ast);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        if (apiLevel >= 3) {
            return PROPERTY_DESCRIPTORS_3_0;
        }
        return PROPERTY_DESCRIPTORS_2_0;
    }

    @Override
    final SimplePropertyDescriptor internalModifiersProperty() {
        throw new UnsupportedOperationException("JLS2 not supported");
    }

    @Override
    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    @Override
    public ChildPropertyDescriptor getRoleElementProperty() {
        return ROLE_MAPPING_ELEMENT_PROPERTY;
    }

    @Override
    protected ChildPropertyDescriptor internalGetBindingOperatorProperty() {
        return BINDING_OPERATOR_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalParameterMappingsProperty() {
        return PARAMETER_MAPPINGS_PROPERTY;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((Javadoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == ROLE_MAPPING_ELEMENT_PROPERTY) {
            if (get) {
                return this.getRoleMappingElement();
            }
            this.setRoleMappingElement((MethodSpec)child);
            return null;
        }
        if (property == GUARD_PROPERTY) {
            if (get) {
                return this.getGuardPredicate();
            }
            this.setGuardPredicate((GuardPredicateDeclaration)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == BASE_MAPPING_ELEMENTS_PROPERTY) {
            return this.getBaseMappingElements();
        }
        if (property == PARAMETER_MAPPINGS_PROPERTY) {
            return this.getParameterMappings();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return CallinMappingDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    int getNodeType0() {
        return 119;
    }

    @Override
    ASTNode clone0(AST target) {
        CallinMappingDeclaration result = new CallinMappingDeclaration(target);
        result.setName(this.getName());
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
        }
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        result.setRoleMappingElement((MethodSpec)ASTNode.copySubtree(target, this.getRoleMappingElement()));
        result.setBindingOperator((MethodBindingOperator)this.bindingOperator().clone(target));
        result.getBaseMappingElements().addAll(ASTNode.copySubtrees(target, this.getBaseMappingElements()));
        result.setGuardPredicate((GuardPredicateDeclaration)ASTNode.copySubtree(target, this.getGuardPredicate()));
        result.getParameterMappings().addAll(ASTNode.copySubtrees(target, this.getParameterMappings()));
        return result;
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            if (this.ast.apiLevel >= 3) {
                this.acceptChildren(visitor, this.modifiers);
            }
            this.acceptChild(visitor, this._labelName);
            this.acceptChild(visitor, this._roleMappingElement);
            this.acceptChild(visitor, this.bindingOperator);
            this.acceptChildren(visitor, this._baseMappingElements);
            this.acceptChild(visitor, this.getGuardPredicate());
            this.acceptChildren(visitor, this.parameterMappings);
        }
        visitor.endVisit(this);
    }

    @Override
    void appendDebugString(StringBuilder buffer) {
        if (this.getName() != null) {
            buffer.append(this.getName().getIdentifier());
            buffer.append(':');
        }
        super.appendDebugString(buffer);
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalDocComment == null ? 0 : this.getJavadoc().treeSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodMappingElement getRoleMappingElement() {
        if (this._roleMappingElement == null) {
            CallinMappingDeclaration callinMappingDeclaration = this;
            synchronized (callinMappingDeclaration) {
                if (this._roleMappingElement == null) {
                    this.preLazyInit();
                    this._roleMappingElement = new MethodSpec(this.ast);
                    this.postLazyInit(this._roleMappingElement, ROLE_MAPPING_ELEMENT_PROPERTY);
                }
            }
        }
        return this._roleMappingElement;
    }

    @Override
    public void setRoleMappingElement(MethodMappingElement roleMappingElement) {
        if (roleMappingElement == null) {
            throw new IllegalArgumentException();
        }
        MethodMappingElement oldChild = this._roleMappingElement;
        this.preReplaceChild(oldChild, roleMappingElement, ROLE_MAPPING_ELEMENT_PROPERTY);
        this._roleMappingElement = roleMappingElement;
        this.postReplaceChild(oldChild, roleMappingElement, ROLE_MAPPING_ELEMENT_PROPERTY);
    }

    public List getBaseMappingElements() {
        return this._baseMappingElements;
    }

    @Override
    public void removeSignatures() {
        super.removeSignatures();
        for (Object baseElement : this.getBaseMappingElements()) {
            this.removeSignatureFrom((MethodMappingElement)baseElement);
        }
    }

    public int getCallinModifier() {
        return this.bindingOperator.getBindingModifier();
    }

    public void setCallinModifier(int modifiers) {
        this.setCallinModifier(this.ast.newModifier(Modifier.ModifierKeyword.fromFlagValue(modifiers)));
    }

    public void setCallinModifier(Modifier modifier) {
        if (this.bindingOperator == null) {
            MethodBindingOperator op = new MethodBindingOperator(this.ast);
            op.setBindingKind(3);
            op.setBindingModifier(modifier);
            this.setBindingOperator(op);
        } else {
            this.bindingOperator.setBindingModifier(modifier);
        }
    }

    public Modifier callinModifier() {
        return this.bindingOperator.bindingModifier();
    }

    public boolean hasName() {
        return this._labelName != null && this._labelName.getIdentifier().charAt(0) != '<';
    }

    public void setName(SimpleName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this._labelName;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this._labelName = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public SimpleName getName() {
        return this._labelName;
    }

    public void setGuardPredicate(GuardPredicateDeclaration predicate) {
        GuardPredicateDeclaration oldChild = this._optionalGuardPredicate;
        this.preReplaceChild(oldChild, predicate, GUARD_PROPERTY);
        this._optionalGuardPredicate = predicate;
        this.postReplaceChild(oldChild, predicate, GUARD_PROPERTY);
    }

    public GuardPredicateDeclaration getGuardPredicate() {
        return this._optionalGuardPredicate;
    }

    public boolean isStatic() {
        for (Object baseElem : this.getBaseMappingElements()) {
            IMethodBinding baseMethod = ((MethodSpec)baseElem).resolveBinding();
            if (baseMethod == null || !Modifier.isStatic(baseMethod.getModifiers())) continue;
            return true;
        }
        return false;
    }
}

