/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class TextBlock
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(TextBlock.class, "escapedValue", String.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "\"\"";
    private String literalValue = "";

    static {
        ArrayList propertyList = new ArrayList(2);
        TextBlock.createPropertyList(TextBlock.class, propertyList);
        TextBlock.addProperty(ESCAPED_VALUE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TextBlock.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    TextBlock(AST ast) {
        super(ast);
        this.unsupportedBelow15();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TextBlock.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 102;
    }

    @Override
    ASTNode clone0(AST target) {
        TextBlock result = new TextBlock(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.ast.scanner;
        char[] source = token.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 52: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Text Block : >" + token + "<");
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException("Invalid Text Block : >" + token + "<");
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String token, String literal) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.literalValue = literal;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public String getLiteralValue() {
        if (!this.literalValue.isEmpty()) {
            return this.literalValue;
        }
        char[] escaped = this.getEscapedValue().toCharArray();
        int len = escaped.length;
        if (len < 7) {
            throw new IllegalArgumentException();
        }
        int start = -1;
        int i = 3;
        block3: while (i < len) {
            char c = escaped[i];
            if (!ScannerHelper.isWhitespace((char)c)) break;
            switch (c) {
                case '\n': 
                case '\r': {
                    start = i + 1;
                    break block3;
                }
                default: {
                    ++i;
                }
            }
        }
        if (start == -1) {
            throw new IllegalArgumentException();
        }
        return new String(CharOperation.subarray((char[])escaped, (int)start, (int)(len - 3)));
    }

    @Override
    int memSize() {
        int size = 44 + TextBlock.stringSize(this.escapedValue);
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }
}

