/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import java.util.HashSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;

public class ParameterMapping
extends Expression {
    public int direction;
    public Expression expression;
    public SingleNameReference ident;
    public HashSet<MethodSpec> isUsedForMethodSpec = new HashSet();

    public ParameterMapping(int direction, Expression expression, SingleNameReference ident) {
        this.direction = direction;
        this.expression = expression;
        this.ident = ident;
        if (direction == 3) {
            this.sourceStart = ident.sourceStart;
            this.sourceEnd = expression.sourceEnd;
        } else {
            this.sourceStart = expression.sourceStart;
            this.sourceEnd = ident.sourceEnd;
        }
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.direction == 3) {
            output.append(this.ident.token);
            output.append(" <- ");
            this.expression.print(0, output);
        } else {
            this.expression.print(indent, output);
            output.append(" -> ");
            output.append(this.ident.token);
        }
        return output;
    }

    public boolean isUsedFor(MethodSpec sourceMethodSpec) {
        return this.isUsedForMethodSpec.contains(sourceMethodSpec);
    }

    public void setUsedFor(MethodSpec sourceMethodSpec) {
        this.isUsedForMethodSpec.add(sourceMethodSpec);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    protected void argumentsResolved(MethodSpec spec) {
        if (spec instanceof FieldAccessSpec) {
            if (CharOperation.equals(((FieldAccessSpec)spec).selector, this.ident.token)) {
                this.ident.binding = ((FieldAccessSpec)spec).resolvedField;
            }
        } else if (spec.arguments != null) {
            Argument[] argumentArray = spec.arguments;
            int n = spec.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Argument arg = argumentArray[n2];
                if (CharOperation.equals(arg.name, this.ident.token)) {
                    this.ident.binding = arg.binding;
                }
                ++n2;
            }
        }
    }
}

