/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.parser.ConflictedParser;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.compiler.parser.diagnose.DiagnoseParser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CharDeduplication;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Scanner
implements TerminalTokens {
    public long sourceLevel;
    public long complianceLevel;
    public boolean useAssertAsAnIndentifier = false;
    public boolean containsAssertKeyword = false;
    public boolean previewEnabled;
    public boolean useEnumAsAnIndentifier = false;
    public boolean parsePureJavaOnly = false;
    public boolean parseOTJonly;
    protected boolean _isOTSource = this.parseOTJonly = false;
    protected boolean _forceBaseIsIdentifier = false;
    protected boolean _teamKeywordSeen = false;
    protected boolean _atStartOfImport = false;
    protected boolean _inImport = false;
    protected boolean _calloutSeen = false;
    protected boolean _callinSeen = false;
    public boolean _precedenceSeen = false;
    protected int _dotSeen = 0;
    public boolean _insideParameterMapping = false;
    protected BindoutLookahead _bindoutLookahead = null;
    public boolean recordLineSeparator = false;
    public char currentCharacter;
    public int startPosition;
    public int currentPosition;
    public int initialPosition;
    public int eofPosition;
    public boolean skipComments = false;
    public boolean tokenizeComments = false;
    public boolean tokenizeWhiteSpace = false;
    public char[] source;
    public char[] withoutUnicodeBuffer;
    public int withoutUnicodePtr;
    public boolean unicodeAsBackSlash = false;
    public boolean scanningFloatLiteral = false;
    public static final int COMMENT_ARRAYS_SIZE = 30;
    public int[] commentStops = new int[30];
    public int[] commentStarts = new int[30];
    public int[] commentTagStarts = new int[30];
    public int commentPtr = -1;
    public int lastCommentLinePosition = -1;
    public char[][] foundTaskTags = null;
    public char[][] foundTaskMessages;
    public char[][] foundTaskPriorities = null;
    public int[][] foundTaskPositions;
    public int foundTaskCount = 0;
    public char[][] taskTags = null;
    public char[][] taskPriorities = null;
    public boolean isTaskCaseSensitive = true;
    public boolean diet = false;
    public int[] lineEnds = new int[250];
    public int linePtr = -1;
    public boolean wasAcr = false;
    public boolean fakeInModule = false;
    public int caseStartPosition = -1;
    boolean inCondition = false;
    int yieldColons = -1;
    boolean breakPreviewAllowed = false;
    protected ScanContext scanContext = null;
    protected boolean insideModuleInfo = false;
    public static final String END_OF_SOURCE = "End_Of_Source";
    public static final String INVALID_HEXA = "Invalid_Hexa_Literal";
    public static final String INVALID_OCTAL = "Invalid_Octal_Literal";
    public static final String INVALID_CHARACTER_CONSTANT = "Invalid_Character_Constant";
    public static final String INVALID_ESCAPE = "Invalid_Escape";
    public static final String INVALID_INPUT = "Invalid_Input";
    public static final String INVALID_TEXTBLOCK = "Invalid_Textblock";
    public static final String INVALID_UNICODE_ESCAPE = "Invalid_Unicode_Escape";
    public static final String INVALID_FLOAT = "Invalid_Float_Literal";
    public static final String INVALID_LOW_SURROGATE = "Invalid_Low_Surrogate";
    public static final String INVALID_HIGH_SURROGATE = "Invalid_High_Surrogate";
    public static final String NULL_SOURCE_STRING = "Null_Source_String";
    public static final String UNTERMINATED_STRING = "Unterminated_String";
    public static final String UNTERMINATED_TEXT_BLOCK = "Unterminated_Text_Block";
    public static final String UNTERMINATED_COMMENT = "Unterminated_Comment";
    public static final String INVALID_CHAR_IN_STRING = "Invalid_Char_In_String";
    public static final String INVALID_DIGIT = "Invalid_Digit";
    private static final int[] EMPTY_LINE_ENDS = Util.EMPTY_INT_ARRAY;
    public static final String INVALID_BINARY = "Invalid_Binary_Literal";
    public static final String BINARY_LITERAL_NOT_BELOW_17 = "Binary_Literal_Not_Below_17";
    public static final String ILLEGAL_HEXA_LITERAL = "Illegal_Hexa_Literal";
    public static final String INVALID_UNDERSCORE = "Invalid_Underscore";
    public static final String UNDERSCORES_IN_LITERALS_NOT_BELOW_17 = "Underscores_In_Literals_Not_Below_17";
    public static final char[] TAG_PREFIX = "//$NON-NLS-".toCharArray();
    public static final int TAG_PREFIX_LENGTH = TAG_PREFIX.length;
    public static final char TAG_POSTFIX = '$';
    public static final int TAG_POSTFIX_LENGTH = 1;
    public static final char[] IDENTITY_COMPARISON_TAG = "//$IDENTITY-COMPARISON$".toCharArray();
    public boolean[] validIdentityComparisonLines;
    public boolean checkUninternedIdentityComparison;
    private NLSTag[] nlsTags = null;
    protected int nlsTagsPtr;
    public boolean checkNonExternalizedStringLiterals;
    protected int lastPosition;
    public boolean returnOnlyGreater = false;
    public boolean insideRecovery = false;
    int[] lookBack = new int[2];
    protected int nextToken = 0;
    private VanguardScanner vanguardScanner;
    private VanguardParser vanguardParser;
    ConflictedParser activeParser = null;
    private boolean consumingEllipsisAnnotations = false;
    protected boolean multiCaseLabelComma = false;
    public static final int RoundBracket = 0;
    public static final int SquareBracket = 1;
    public static final int CurlyBracket = 2;
    public static final int BracketKinds = 3;
    public static final int LOW_SURROGATE_MIN_VALUE = 56320;
    public static final int HIGH_SURROGATE_MIN_VALUE = 55296;
    public static final int HIGH_SURROGATE_MAX_VALUE = 56319;
    public static final int LOW_SURROGATE_MAX_VALUE = 57343;
    protected int rawStart = -1;
    Map<String, Integer> _Keywords = null;
    private final CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();

    public void enterOTSource() {
        this._isOTSource = true;
        this._teamKeywordSeen = false;
    }

    public void forceBaseIsIdentifier() {
        this._forceBaseIsIdentifier = true;
    }

    public void restoreBaseKeyword() {
        this._forceBaseIsIdentifier = false;
    }

    protected boolean baseIsKeyword() {
        if (this.parsePureJavaOnly || this._forceBaseIsIdentifier) {
            return false;
        }
        if (this._atStartOfImport && this.currentCharacter != '.') {
            return true;
        }
        if (this._inImport) {
            return false;
        }
        return this._isOTSource;
    }

    public char[] peekPendingIdentifier() {
        if (this._bindoutLookahead != null) {
            return this._bindoutLookahead.identifier;
        }
        return null;
    }

    public void resetOTFlags() {
        this._isOTSource = this.parseOTJonly;
        this._teamKeywordSeen = false;
        this._forceBaseIsIdentifier = false;
        this._callinSeen = false;
        this._calloutSeen = false;
        this._insideParameterMapping = false;
        this._bindoutLookahead = null;
        this._atStartOfImport = false;
        this._inImport = false;
    }

    public void setOTFlags(CompilerOptions options) {
        this.parseOTJonly = !options.allowScopedKeywords;
        this._isOTSource |= this.parseOTJonly;
        this.parsePureJavaOnly = options.isPureJava;
    }

    public void copyOTFlags(Scanner other) {
        this.parseOTJonly = other.parseOTJonly;
        this.parsePureJavaOnly = other.parsePureJavaOnly;
    }

    public boolean isTokenEnabled(int sym) {
        switch (sym) {
            case 54: 
            case 97: {
                return !this.parsePureJavaOnly;
            }
            case 33: {
                return this.baseIsKeyword();
            }
            case 39: 
            case 66: 
            case 73: 
            case 81: 
            case 88: 
            case 102: 
            case 142: 
            case 152: {
                return this._isOTSource;
            }
            case 101: {
                return this._isOTSource || this.insideModuleInfo;
            }
        }
        return true;
    }

    public Scanner() {
        this(false, false, false, 0x2F0000L, null, null, true);
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, long complianceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive, boolean isPreviewEnabled) {
        this.eofPosition = Integer.MAX_VALUE;
        this.tokenizeComments = tokenizeComments;
        this.tokenizeWhiteSpace = tokenizeWhiteSpace;
        this.sourceLevel = sourceLevel;
        this.resetLookBack();
        this.nextToken = 0;
        this.consumingEllipsisAnnotations = false;
        this.complianceLevel = complianceLevel;
        this.checkNonExternalizedStringLiterals = checkNonExternalizedStringLiterals;
        this.previewEnabled = isPreviewEnabled;
        this.caseStartPosition = -1;
        this.multiCaseLabelComma = false;
        if (taskTags != null) {
            int taskTagsLength;
            int length = taskTagsLength = ((char[][])taskTags).length;
            if (taskPriorities != null) {
                int taskPrioritiesLength = ((char[][])taskPriorities).length;
                if (taskPrioritiesLength != taskTagsLength) {
                    if (taskPrioritiesLength > taskTagsLength) {
                        char[][] cArray = taskPriorities;
                        char[][] cArrayArray = new char[taskTagsLength][];
                        taskPriorities = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, taskTagsLength);
                    } else {
                        char[][] cArray = taskTags;
                        char[][] cArrayArray = new char[taskPrioritiesLength][];
                        taskTags = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, taskPrioritiesLength);
                        length = taskPrioritiesLength;
                    }
                }
                int[] initialIndexes = new int[length];
                int i = 0;
                while (i < length) {
                    initialIndexes[i] = i;
                    ++i;
                }
                Util.reverseQuickSort(taskTags, 0, length - 1, initialIndexes);
                char[][] temp = new char[length][];
                int i2 = 0;
                while (i2 < length) {
                    temp[i2] = taskPriorities[initialIndexes[i2]];
                    ++i2;
                }
                this.taskPriorities = temp;
            } else {
                Util.reverseQuickSort(taskTags, 0, length - 1);
            }
            this.taskTags = taskTags;
            this.isTaskCaseSensitive = isTaskCaseSensitive;
        }
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive, boolean isPreviewEnabled) {
        this(tokenizeComments, tokenizeWhiteSpace, checkNonExternalizedStringLiterals, sourceLevel, sourceLevel, taskTags, taskPriorities, isTaskCaseSensitive, isPreviewEnabled);
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive) {
        this(tokenizeComments, tokenizeWhiteSpace, checkNonExternalizedStringLiterals, sourceLevel, sourceLevel, taskTags, taskPriorities, isTaskCaseSensitive, false);
    }

    public final boolean atEnd() {
        return this.eofPosition <= this.currentPosition;
    }

    /*
     * Unable to fully structure code
     */
    public void checkTaskTag(int commentStart, int commentEnd) throws InvalidInputException {
        src = this.source;
        if (this.foundTaskCount > 0 && this.foundTaskPositions[this.foundTaskCount - 1][0] >= commentStart) {
            return;
        }
        foundTaskIndex = this.foundTaskCount;
        previous = src[commentStart + 1];
        i = commentStart + 2;
        while (i < commentEnd && i < this.eofPosition) {
            tag = null;
            priority = null;
            if (previous != '@') {
                itag = 0;
                while (itag < this.taskTags.length) {
                    block25: {
                        tag = this.taskTags[itag];
                        tagLength = tag.length;
                        if (!(tagLength == 0 || ScannerHelper.isJavaIdentifierStart(this.complianceLevel, tag[0]) && ScannerHelper.isJavaIdentifierPart(this.complianceLevel, previous))) {
                            t = 0;
                            while (t < tagLength) {
                                x = i + t;
                                if (x < this.eofPosition && x < commentEnd && ((sc = src[i + t]) == (tc = tag[t]) || !this.isTaskCaseSensitive && ScannerHelper.toLowerCase(sc) == ScannerHelper.toLowerCase(tc))) {
                                    ++t;
                                    continue;
                                }
                                break block25;
                            }
                            if (i + tagLength >= commentEnd || !ScannerHelper.isJavaIdentifierPart(this.complianceLevel, src[i + tagLength - 1]) || !ScannerHelper.isJavaIdentifierPart(this.complianceLevel, src[i + tagLength])) {
                                if (this.foundTaskTags == null) {
                                    this.foundTaskTags = new char[5][];
                                    this.foundTaskMessages = new char[5][];
                                    this.foundTaskPriorities = new char[5][];
                                    this.foundTaskPositions = new int[5][];
                                } else if (this.foundTaskCount == this.foundTaskTags.length) {
                                    v0 = new char[this.foundTaskCount * 2][];
                                    this.foundTaskTags = v0;
                                    System.arraycopy(this.foundTaskTags, 0, v0, 0, this.foundTaskCount);
                                    v1 = new char[this.foundTaskCount * 2][];
                                    this.foundTaskMessages = v1;
                                    System.arraycopy(this.foundTaskMessages, 0, v1, 0, this.foundTaskCount);
                                    v2 = new char[this.foundTaskCount * 2][];
                                    this.foundTaskPriorities = v2;
                                    System.arraycopy(this.foundTaskPriorities, 0, v2, 0, this.foundTaskCount);
                                    v3 = new int[this.foundTaskCount * 2][];
                                    this.foundTaskPositions = v3;
                                    System.arraycopy(this.foundTaskPositions, 0, v3, 0, this.foundTaskCount);
                                }
                                priority = this.taskPriorities != null && itag < this.taskPriorities.length ? this.taskPriorities[itag] : null;
                                this.foundTaskTags[this.foundTaskCount] = tag;
                                this.foundTaskPriorities[this.foundTaskCount] = priority;
                                this.foundTaskPositions[this.foundTaskCount] = new int[]{i, i + tagLength - 1};
                                this.foundTaskMessages[this.foundTaskCount] = CharOperation.NO_CHAR;
                                ++this.foundTaskCount;
                                i += tagLength - 1;
                                break;
                            }
                        }
                    }
                    ++itag;
                }
            }
            previous = src[i];
            ++i;
        }
        containsEmptyTask = false;
        i = foundTaskIndex;
        while (i < this.foundTaskCount) {
            block26: {
                msgStart = this.foundTaskPositions[i][0] + this.foundTaskTags[i].length;
                v4 = max_value = i + 1 < this.foundTaskCount ? this.foundTaskPositions[i + 1][0] - 1 : commentEnd - 1;
                if (max_value < msgStart) {
                    max_value = msgStart;
                }
                end = -1;
                j = msgStart;
                while (j < max_value) {
                    c = src[j];
                    if (c == '\n' || c == '\r') {
                        end = j - 1;
                        break;
                    }
                    ++j;
                }
                if (end == -1) {
                    j = max_value;
                    while (j > msgStart) {
                        c = src[j];
                        if (c == '*') {
                            end = j - 1;
                            break;
                        }
                        --j;
                    }
                    if (end == -1) {
                        end = max_value;
                    }
                }
                if (msgStart != end) ** GOTO lbl88
                containsEmptyTask = true;
                break block26;
lbl-1000:
                // 1 sources

                {
                    --end;
lbl88:
                    // 2 sources

                    ** while (CharOperation.isWhitespace((char)src[end]) && msgStart <= end)
                }
lbl89:
                // 1 sources

                this.foundTaskPositions[i][1] = end;
                messageLength = end - msgStart + 1;
                message = new char[messageLength];
                System.arraycopy(src, msgStart, message, 0, messageLength);
                this.foundTaskMessages[i] = message;
            }
            ++i;
        }
        if (containsEmptyTask) {
            i = foundTaskIndex;
            max = this.foundTaskCount;
            while (i < max) {
                if (this.foundTaskMessages[i].length == 0) {
                    j = i + 1;
                    while (j < max) {
                        if (this.foundTaskMessages[j].length != 0) {
                            this.foundTaskMessages[i] = this.foundTaskMessages[j];
                            this.foundTaskPositions[i][1] = this.foundTaskPositions[j][1];
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public char[] getCurrentIdentifierSource() {
        char[] result;
        if (this._bindoutLookahead != null && (result = this._bindoutLookahead.getIdentifier()) != null) {
            return result;
        }
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, result, 0, this.withoutUnicodePtr);
            return result;
        }
        int length = this.currentPosition - this.startPosition;
        if (length == this.eofPosition) {
            return this.source;
        }
        return this.deduplication.sharedCopyOfRange(this.source, this.startPosition, this.currentPosition);
    }

    public int getCurrentTokenEndPosition() {
        return this.currentPosition - 1;
    }

    public char[] getCurrentTokenSource() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, result, 0, this.withoutUnicodePtr);
        } else {
            int length = this.currentPosition - this.startPosition;
            result = new char[length];
            System.arraycopy(this.source, this.startPosition, result, 0, length);
        }
        return result;
    }

    public final String getCurrentTokenString() {
        if (this.withoutUnicodePtr != 0) {
            return new String(this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
        }
        return new String(this.source, this.startPosition, this.currentPosition - this.startPosition);
    }

    public char[] getCurrentTokenSourceString() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr - 2];
            System.arraycopy(this.withoutUnicodeBuffer, 2, result, 0, this.withoutUnicodePtr - 2);
        } else {
            int length = this.currentPosition - this.startPosition - 2;
            result = new char[length];
            System.arraycopy(this.source, this.startPosition + 1, result, 0, length);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean scanForTextBlockBeginning() {
        try {
            int temp = this.currentPosition;
            if (this.source[temp++] != '\"') return false;
            if (this.source[temp++] != '\"') return false;
            char c = this.source[temp++];
            while (true) {
                if (!ScannerHelper.isWhitespace(c)) {
                    return false;
                }
                switch (c) {
                    case '\n': {
                        this.currentCharacter = c;
                        this.currentPosition = temp;
                        return true;
                    }
                }
                c = this.source[temp++];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    protected final boolean scanForTextBlockClose() throws InvalidInputException {
        try {
            if (this.source[this.currentPosition] == '\"' && this.source[this.currentPosition + 1] == '\"') {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    public char[] getCurrentTextBlock() {
        char[] all;
        if (this.withoutUnicodePtr != 0) {
            all = CharOperation.subarray(this.withoutUnicodeBuffer, this.rawStart + 1, this.withoutUnicodePtr + 1);
        } else {
            all = CharOperation.subarray(this.source, this.startPosition + this.rawStart, this.currentPosition - 3);
            if (all == null) {
                all = new char[]{};
            }
        }
        all = this.normalize(all);
        char[][] lines = CharOperation.splitOn('\n', all);
        int size = lines.length;
        ArrayList<char[]> list = new ArrayList<char[]>(lines.length);
        int i = 0;
        while (i < lines.length) {
            char[] line = lines[i];
            if (i + 1 == size && line.length == 0) {
                list.add(line);
                break;
            }
            char[][] sub = CharOperation.splitOn('\r', line);
            if (sub.length == 0) {
                list.add(line);
            } else {
                char[][] cArray = sub;
                int n = sub.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] cs = cArray[n2];
                    list.add(cs);
                    ++n2;
                }
            }
            ++i;
        }
        size = list.size();
        lines = (char[][])list.toArray((T[])new char[size][]);
        int prefix = -1;
        int i2 = 0;
        while (i2 < size) {
            char[] line = lines[i2];
            boolean blank = true;
            int whitespaces = 0;
            char[] cArray = line;
            int n = line.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (blank) {
                    if (ScannerHelper.isWhitespace(c)) {
                        ++whitespaces;
                    } else {
                        blank = false;
                    }
                }
                ++n3;
            }
            if (!(blank && i2 + 1 != size || prefix >= 0 && whitespaces >= prefix)) {
                prefix = whitespaces;
            }
            ++i2;
        }
        if (prefix == -1) {
            prefix = 0;
        }
        StringBuilder result = new StringBuilder();
        boolean newLine = false;
        int i3 = 0;
        while (i3 < lines.length) {
            int length;
            char[] l = lines[i3];
            int trail = length = l.length;
            while (trail > 0) {
                if (!ScannerHelper.isWhitespace(l[trail - 1])) break;
                --trail;
            }
            if (i3 >= size - 1) {
                if (newLine) {
                    result.append('\n');
                }
                if (trail >= prefix) {
                    newLine = this.getLineContent(result, l, prefix, trail - 1, false, true);
                }
            } else {
                if (i3 > 0 && newLine) {
                    result.append('\n');
                }
                if (trail <= prefix) {
                    newLine = true;
                } else {
                    boolean merge = length > 0 && l[length - 1] == '\\';
                    newLine = this.getLineContent(result, l, prefix, trail - 1, merge, false);
                }
            }
            ++i3;
        }
        this.rawStart = -1;
        return result.toString().toCharArray();
    }

    private char[] normalize(char[] content) {
        StringBuilder result = new StringBuilder();
        boolean isCR = false;
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\r': {
                    result.append(c);
                    isCR = true;
                    break;
                }
                case '\n': {
                    if (!isCR) {
                        result.append(c);
                    }
                    isCR = false;
                    break;
                }
                default: {
                    result.append(c);
                    isCR = false;
                }
            }
            ++n2;
        }
        return result.toString().toCharArray();
    }

    private boolean getLineContent(StringBuilder result, char[] line, int start, int end, boolean merge, boolean lastLine) {
        char[] chars;
        int lastPointer = 0;
        int i = start;
        block12: while (i < end) {
            char c = line[i];
            if (c != '\\') {
                ++i;
                continue;
            }
            if (i >= end) continue;
            if (lastPointer + 1 <= i) {
                result.append(CharOperation.subarray(line, lastPointer == 0 ? start : lastPointer, i));
            }
            char next = line[++i];
            switch (next) {
                case '\\': {
                    result.append('\\');
                    if (i != end) break;
                    merge = false;
                    break;
                }
                case 's': {
                    result.append(' ');
                    break;
                }
                case '\"': {
                    result.append('\"');
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                default: {
                    int pos = i + 1;
                    int number = ScannerHelper.getHexadecimalValue(next);
                    if (number >= 0 && number <= 7) {
                        boolean zeroToThreeNot = number > 3;
                        try {
                            next = line[pos];
                            if (ScannerHelper.isDigit(next)) {
                                ++pos;
                                int digit = ScannerHelper.getHexadecimalValue(next);
                                if (digit >= 0 && digit <= 7) {
                                    number = number * 8 + digit;
                                    next = line[pos];
                                    if (ScannerHelper.isDigit(next)) {
                                        ++pos;
                                        if (!zeroToThreeNot && (digit = ScannerHelper.getHexadecimalValue(next)) >= 0 && digit <= 7) {
                                            number = number * 8 + digit;
                                        }
                                    }
                                }
                            }
                        }
                        catch (InvalidInputException invalidInputException) {}
                        if (number < 255) {
                            next = (char)number;
                        }
                        result.append(next);
                        lastPointer = i = pos;
                        continue block12;
                    }
                    result.append(c);
                    lastPointer = i;
                    continue block12;
                }
            }
            lastPointer = ++i;
        }
        end = merge ? end : (end >= line.length ? end : end + 1);
        char[] cArray = chars = lastPointer == 0 ? CharOperation.subarray(line, start, end) : CharOperation.subarray(line, lastPointer, end);
        if (chars != null && chars.length > 0) {
            result.append(chars);
        }
        return !merge && !lastLine;
    }

    public final String getCurrentStringLiteral() {
        if (this.withoutUnicodePtr != 0) {
            return new String(this.withoutUnicodeBuffer, 2, this.withoutUnicodePtr - 2);
        }
        return new String(this.source, this.startPosition + 1, this.currentPosition - this.startPosition - 2);
    }

    public final char[] getRawTokenSource() {
        int length = this.currentPosition - this.startPosition;
        char[] tokenSource = new char[length];
        System.arraycopy(this.source, this.startPosition, tokenSource, 0, length);
        return tokenSource;
    }

    public final char[] getRawTokenSourceEnd() {
        int length = this.eofPosition - this.currentPosition - 1;
        char[] sourceEnd = new char[length];
        System.arraycopy(this.source, this.currentPosition, sourceEnd, 0, length);
        return sourceEnd;
    }

    public int getCurrentTokenStartPosition() {
        return this.startPosition;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (lineNumber > this.lineEnds.length + 1) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == this.lineEnds.length + 1) {
            return this.eofPosition;
        }
        return this.lineEnds[lineNumber - 1];
    }

    public final int[] getLineEnds() {
        if (this.linePtr == -1) {
            return EMPTY_LINE_ENDS;
        }
        int[] copy = new int[this.linePtr + 1];
        System.arraycopy(this.lineEnds, 0, copy, 0, this.linePtr + 1);
        return copy;
    }

    public final int getLineStart(int lineNumber) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (lineNumber > this.lineEnds.length + 1) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return this.initialPosition;
        }
        return this.lineEnds[lineNumber - 2] + 1;
    }

    public final int getNextChar() {
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else {
                this.unicodeAsBackSlash = false;
                if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            }
            return this.currentCharacter;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            return -1;
        }
    }

    public final int getNextCharWithBoundChecks() {
        if (this.currentPosition >= this.eofPosition) {
            return -1;
        }
        this.currentCharacter = this.source[this.currentPosition++];
        if (this.currentPosition >= this.eofPosition) {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return this.currentCharacter;
        }
        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
            try {
                this.getNextUnicodeChar();
            }
            catch (InvalidInputException invalidInputException) {
                return -1;
            }
        } else {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
        }
        return this.currentCharacter;
    }

    public final boolean getNextChar(char testedChar) {
        int temp;
        block8: {
            block7: {
                if (this.currentPosition >= this.eofPosition) {
                    this.unicodeAsBackSlash = false;
                    return false;
                }
                temp = this.currentPosition;
                this.currentCharacter = this.source[this.currentPosition++];
                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != 'u') break block7;
                this.getNextUnicodeChar();
                if (this.currentCharacter != testedChar) {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (this.currentCharacter == testedChar) break block8;
            this.currentPosition = temp;
            return false;
        }
        try {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.unicodeAsBackSlash = false;
            this.currentPosition = temp;
            return false;
        }
    }

    public final int getNextChar(char testedChar1, char testedChar2) {
        int result;
        int temp;
        block12: {
            if (this.currentPosition >= this.eofPosition) {
                return -1;
            }
            temp = this.currentPosition;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int result2;
                this.getNextUnicodeChar();
                if (this.currentCharacter == testedChar1) {
                    result2 = 0;
                } else if (this.currentCharacter == testedChar2) {
                    result2 = 1;
                } else {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    result2 = -1;
                }
                return result2;
            }
            if (this.currentCharacter == testedChar1) {
                result = 0;
                break block12;
            }
            if (this.currentCharacter == testedChar2) {
                result = 1;
                break block12;
            }
            this.currentPosition = temp;
            return -1;
        }
        try {
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return result;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = temp;
            return -1;
        }
    }

    private final void consumeDigits(int radix) throws InvalidInputException {
        this.consumeDigits(radix, false);
    }

    private final void consumeDigits(int radix, boolean expectingDigitFirst) throws InvalidInputException {
        switch (this.consumeDigits0(radix, 1, 2, expectingDigitFirst)) {
            case 1: {
                if (this.sourceLevel >= 0x330000L) break;
                throw Scanner.invalidUnderscoresInLiterals();
            }
            case 2: {
                if (this.sourceLevel < 0x330000L) {
                    throw Scanner.invalidUnderscoresInLiterals();
                }
                throw Scanner.invalidUnderscore();
            }
        }
    }

    private final int consumeDigits0(int radix, int usingUnderscore, int invalidPosition, boolean expectingDigitFirst) throws InvalidInputException {
        int kind = 0;
        if (this.getNextChar('_')) {
            if (expectingDigitFirst) {
                return invalidPosition;
            }
            kind = usingUnderscore;
            while (this.getNextChar('_')) {
            }
        }
        if (this.getNextCharAsDigit(radix)) {
            while (this.getNextCharAsDigit(radix)) {
            }
            int kind2 = this.consumeDigits0(radix, usingUnderscore, invalidPosition, false);
            if (kind2 == 0) {
                return kind;
            }
            return kind2;
        }
        if (kind == usingUnderscore) {
            return invalidPosition;
        }
        return kind;
    }

    public final boolean getNextCharAsDigit() throws InvalidInputException {
        int temp;
        block8: {
            block7: {
                if (this.currentPosition >= this.eofPosition) {
                    return false;
                }
                temp = this.currentPosition;
                this.currentCharacter = this.source[this.currentPosition++];
                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != 'u') break block7;
                this.getNextUnicodeChar();
                if (!ScannerHelper.isDigit(this.currentCharacter)) {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (ScannerHelper.isDigit(this.currentCharacter)) break block8;
            this.currentPosition = temp;
            return false;
        }
        try {
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = temp;
            return false;
        }
    }

    public final boolean getNextCharAsDigit(int radix) {
        int temp;
        block8: {
            block7: {
                if (this.currentPosition >= this.eofPosition) {
                    return false;
                }
                temp = this.currentPosition;
                this.currentCharacter = this.source[this.currentPosition++];
                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != 'u') break block7;
                this.getNextUnicodeChar();
                if (ScannerHelper.digit(this.currentCharacter, radix) == -1) {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (ScannerHelper.digit(this.currentCharacter, radix) != -1) break block8;
            this.currentPosition = temp;
            return false;
        }
        try {
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = temp;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getNextCharAsJavaIdentifierPartWithBoundCheck() {
        int pos = this.currentPosition;
        if (pos >= this.eofPosition) {
            return false;
        }
        int temp2 = this.withoutUnicodePtr;
        try {
            boolean unicode = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentPosition < this.eofPosition && this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                unicode = true;
            }
            char c = this.currentCharacter;
            boolean isJavaIdentifierPart = false;
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                char low = (char)this.getNextCharWithBoundChecks();
                if (low < '\udc00' || low > '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c, low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c);
            }
            if (unicode) {
                if (!isJavaIdentifierPart) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                return true;
            }
            if (!isJavaIdentifierPart) {
                this.currentPosition = pos;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (InvalidInputException invalidInputException) {
            this.currentPosition = pos;
            this.withoutUnicodePtr = temp2;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getNextCharAsJavaIdentifierPart() {
        int pos = this.currentPosition;
        if (pos >= this.eofPosition) {
            return false;
        }
        int temp2 = this.withoutUnicodePtr;
        try {
            boolean unicode = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                unicode = true;
            }
            char c = this.currentCharacter;
            boolean isJavaIdentifierPart = false;
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                char low = (char)this.getNextChar();
                if (low < '\udc00' || low > '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c, low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c);
            }
            if (unicode) {
                if (!isJavaIdentifierPart) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                return true;
            }
            if (!isJavaIdentifierPart) {
                this.currentPosition = pos;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException exception) {
            this.currentPosition = pos;
            this.withoutUnicodePtr = temp2;
            return false;
        }
    }

    public int scanIdentifier() throws InvalidInputException {
        boolean isJavaIdStart;
        char c;
        int offset;
        int unicodePtr;
        boolean isWhiteSpace;
        int whiteStart = 0;
        this.withoutUnicodePtr = 0;
        whiteStart = this.currentPosition;
        boolean hasWhiteSpaces = false;
        boolean checkIfUnicode = false;
        do {
            unicodePtr = this.withoutUnicodePtr;
            offset = this.currentPosition;
            this.startPosition = this.currentPosition;
            if (this.currentPosition >= this.eofPosition) {
                if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                    --this.currentPosition;
                    this.startPosition = whiteStart;
                    return 1000;
                }
                return 69;
            }
            this.currentCharacter = this.source[this.currentPosition++];
            checkIfUnicode = this.currentPosition < this.eofPosition && this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
            if (checkIfUnicode) {
                isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                offset = this.currentPosition - offset;
            } else {
                offset = this.currentPosition - offset;
                switch (this.currentCharacter) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        isWhiteSpace = true;
                        break;
                    }
                    default: {
                        isWhiteSpace = false;
                    }
                }
            }
            if (!isWhiteSpace) continue;
            hasWhiteSpaces = true;
        } while (isWhiteSpace);
        if (hasWhiteSpaces) {
            if (this.tokenizeWhiteSpace) {
                this.currentPosition -= offset;
                this.startPosition = whiteStart;
                if (checkIfUnicode) {
                    this.withoutUnicodePtr = unicodePtr;
                }
                return 1000;
            }
            if (checkIfUnicode) {
                this.withoutUnicodePtr = 0;
                this.unicodeStore();
            } else {
                this.withoutUnicodePtr = 0;
            }
        }
        if ((c = this.currentCharacter) < '\u0080') {
            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x40) != 0) {
                return this.scanIdentifierOrKeywordWithBoundCheck();
            }
            return 155;
        }
        if (c >= '\ud800' && c <= '\udbff') {
            if (this.complianceLevel < 0x310000L) {
                throw Scanner.invalidUnicodeEscape();
            }
            char low = (char)this.getNextCharWithBoundChecks();
            if (low < '\udc00' || low > '\udfff') {
                throw Scanner.invalidLowSurrogate();
            }
            isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
        } else {
            if (c >= '\udc00' && c <= '\udfff') {
                if (this.complianceLevel < 0x310000L) {
                    throw Scanner.invalidUnicodeEscape();
                }
                throw Scanner.invalidHighSurrogate();
            }
            isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
        }
        if (isJavaIdStart) {
            return this.scanIdentifierOrKeywordWithBoundCheck();
        }
        return 155;
    }

    public void ungetToken(int unambiguousToken) {
        if (this.nextToken != 0) {
            throw new ArrayIndexOutOfBoundsException("Single cell array overflow");
        }
        this.nextToken = unambiguousToken;
    }

    protected void updateCase(int token) {
        if (token == 115) {
            this.caseStartPosition = this.startPosition;
        }
    }

    public int getNextToken() throws InvalidInputException {
        int token;
        int result;
        if (this.nextToken != 0) {
            int token2 = this.nextToken;
            this.nextToken = 0;
            return token2;
        }
        if (this._bindoutLookahead != null && (result = this._bindoutLookahead.getNextToken()) != 0) {
            return result;
        }
        if (this.scanContext == null) {
            ScanContext scanContext = this.scanContext = this.isInModuleDeclaration() ? ScanContext.EXPECTING_KEYWORD : ScanContext.INACTIVE;
        }
        if ((token = this.getNextToken0()) == 101 || token == 25) {
            this._callinSeen = false;
            this._calloutSeen = false;
        }
        if (this._inImport) {
            switch (token) {
                case 122: {
                    break;
                }
                case 1: 
                case 13: 
                case 33: {
                    this._atStartOfImport = false;
                    break;
                }
                default: {
                    this._atStartOfImport = false;
                    this._inImport = false;
                }
            }
        }
        this.updateCase(token);
        if (this.areRestrictedModuleKeywordsActive()) {
            if (Scanner.isRestrictedKeyword(token)) {
                token = this.disambiguatedRestrictedKeyword(token);
            }
            this.updateScanContext(token);
        }
        if (this.activeParser == null) {
            if (token != 1000) {
                this.addTokenToLookBack(token);
                this.multiCaseLabelComma = false;
            }
            return token;
        }
        if (token == 19 || token == 8 || token == 38 || token == 114) {
            token = this.disambiguatedToken(token, this);
        } else if (token == 132) {
            this.consumingEllipsisAnnotations = false;
        } else if (this.mayBeAtCasePattern(token)) {
            token = this.disambiguateCasePattern(token, this);
        }
        this.addTokenToLookBack(token);
        this.multiCaseLabelComma = false;
        return token;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getNextToken0() throws InvalidInputException {
        if (this._dotSeen > 0) {
            --this._dotSeen;
        }
        this.wasAcr = false;
        if (this.diet) {
            this.jumpOverMethodBody();
            this.diet = false;
            if (this.currentPosition <= this.eofPosition) return 34;
            return 69;
        }
        whiteStart = 0;
        try {
            block43: while (true) lbl-1000:
            // 4 sources

            {
                this.withoutUnicodePtr = 0;
                whiteStart = ++this.currentPosition;
                hasWhiteSpaces = false;
                checkIfUnicode = false;
                do {
                    block120: {
                        block121: {
                            unicodePtr = this.withoutUnicodePtr;
                            offset = this.currentPosition;
                            this.startPosition = this.currentPosition;
                            repositionNeeded = false;
                            if (this.currentPosition >= this.source.length) break block121;
                            this.currentCharacter = this.source[this.currentPosition];
                            ++this.currentPosition;
                            if (this.currentCharacter == '\\') {
                                if (this.currentPosition < this.source.length) {
                                    checkIfUnicode = this.source[this.currentPosition] == 'u';
                                    break block120;
                                } else {
                                    repositionNeeded = true;
                                }
                                break block120;
                            } else {
                                checkIfUnicode = false;
                            }
                            break block120;
                        }
                        ++this.currentPosition;
                        repositionNeeded = true;
                    }
                    if (repositionNeeded) {
                        if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                            --this.currentPosition;
                            this.startPosition = whiteStart;
                            return 1000;
                        }
                        if (this.currentPosition > this.eofPosition) {
                            return 69;
                        }
                    }
                    if (this.currentPosition > this.eofPosition) {
                        if (this.tokenizeWhiteSpace == false) return 69;
                        if (whiteStart == this.currentPosition - 1) return 69;
                        --this.currentPosition;
                        this.startPosition = whiteStart;
                        return 1000;
                    }
                    if (checkIfUnicode) {
                        isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                        offset = this.currentPosition - offset;
                    } else {
                        offset = this.currentPosition - offset;
                        if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                            this.pushLineSeparator();
                        }
                        switch (this.currentCharacter) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                isWhiteSpace = true;
                                break;
                            }
                            default: {
                                isWhiteSpace = false;
                            }
                        }
                    }
                    if (!isWhiteSpace) continue;
                    hasWhiteSpaces = true;
                } while (isWhiteSpace);
                if (hasWhiteSpaces) {
                    if (this.tokenizeWhiteSpace) {
                        this.currentPosition -= offset;
                        this.startPosition = whiteStart;
                        if (checkIfUnicode == false) return 1000;
                        this.withoutUnicodePtr = unicodePtr;
                        return 1000;
                    }
                    if (checkIfUnicode) {
                        this.withoutUnicodePtr = 0;
                        this.unicodeStore();
                    } else {
                        this.withoutUnicodePtr = 0;
                    }
                }
                switch (this.currentCharacter) {
                    case '@': {
                        return 38;
                    }
                    case '(': {
                        return 19;
                    }
                    case ')': {
                        return 24;
                    }
                    case '{': {
                        return 41;
                    }
                    case '}': {
                        return 34;
                    }
                    case '[': {
                        return 6;
                    }
                    case ']': {
                        return 74;
                    }
                    case ';': {
                        return 25;
                    }
                    case ',': {
                        return 32;
                    }
                    case '.': {
                        if (this.getNextCharAsDigit()) {
                            return this.scanNumber(true);
                        }
                        temp = this.currentPosition;
                        if (!this.getNextChar('.')) {
                            this._dotSeen = 2;
                            this.currentPosition = temp;
                            return 1;
                        }
                        if (this.getNextChar('.')) {
                            return 132;
                        }
                        this.currentPosition = temp;
                        return 1;
                    }
                    case '+': {
                        test = this.getNextChar('+', '=');
                        if (test == 0) {
                            return 2;
                        }
                        if (test <= 0) return 4;
                        return 103;
                    }
                    case '-': {
                        test = this.getNextChar('-', '=');
                        if (test == 0) {
                            return 3;
                        }
                        if (test > 0) {
                            return 104;
                        }
                        if (this.getNextChar('>') == false) return 5;
                        if (this.needBindoutDisambiguation() == false) return 114;
                        if (this._insideParameterMapping) {
                            this._bindoutLookahead = new BindoutLookahead();
                            return this._bindoutLookahead.getNextToken();
                        }
                        this._calloutSeen = true;
                        return 73;
                    }
                    case '~': {
                        return 71;
                    }
                    case '!': {
                        if (this.getNextChar('=') == false) return 70;
                        return 22;
                    }
                    case '*': {
                        if (this.getNextChar('=') == false) return 9;
                        return 105;
                    }
                    case '%': {
                        if (this.getNextChar('=') == false) return 10;
                        return 110;
                    }
                    case '<': {
                        test = this.getNextChar('=', '<');
                        if (test == 0) {
                            return 15;
                        }
                        if (test > 0) {
                            if (this.getNextChar('=') == false) return 20;
                            return 111;
                        }
                        if (test >= 0) return 8;
                        if (this._isOTSource == false) return 8;
                        if (this.getNextChar('-') == false) return 8;
                        this._callinSeen = true;
                        return 81;
                    }
                    case '>': {
                        if (this.returnOnlyGreater) {
                            return 12;
                        }
                        test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return 16;
                        }
                        if (test <= 0) return 12;
                        test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return 112;
                        }
                        if (test <= 0) return 14;
                        if (this.getNextChar('=') == false) return 17;
                        return 113;
                    }
                    case '=': {
                        test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return 21;
                        }
                        if (test <= 0) return 83;
                        this._calloutSeen = true;
                        return 98;
                    }
                    case '&': {
                        test = this.getNextChar('&', '=');
                        if (test == 0) {
                            return 30;
                        }
                        if (test <= 0) return 23;
                        return 107;
                    }
                    case '|': {
                        test = this.getNextChar('|', '=');
                        if (test == 0) {
                            return 31;
                        }
                        if (test <= 0) return 28;
                        return 108;
                    }
                    case '^': {
                        if (this.getNextChar('=') == false) return 27;
                        return 109;
                    }
                    case '?': {
                        return 29;
                    }
                    case ':': {
                        if (this.getNextChar(':')) {
                            return 7;
                        }
                        ++this.yieldColons;
                        return 68;
                    }
                    case '\'': {
                        return this.processSingleQuotes(checkIfUnicode);
                    }
                    case '\"': {
                        return this.scanForStringLiteral();
                    }
                    case '/': {
                        if (this.skipComments) ** GOTO lbl322
                        test = this.getNextChar('/', '*');
                        if (test != 0) ** GOTO lbl250
                        this.lastCommentLinePosition = this.currentPosition--;
                        try {
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                            }
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                ++this.currentPosition;
                            }
                            isUnicode = false;
                            while (true) {
                                if (this.currentCharacter != '\r' && this.currentCharacter != '\n') ** GOTO lbl215
                                if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                    if (this.source[this.currentPosition] != '\n') break;
                                    ++this.currentPosition;
                                    this.currentCharacter = (char)10;
                                }
                                ** GOTO lbl229
lbl215:
                                // 1 sources

                                if (this.currentPosition >= this.eofPosition) {
                                    this.lastCommentLinePosition = this.currentPosition++;
                                    throw new IndexOutOfBoundsException();
                                }
                                this.lastCommentLinePosition = this.currentPosition;
                                isUnicode = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            }
lbl229:
                            // 4 sources

                            this.recordComment(1001);
                            if (this.taskTags != null) {
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                            }
                            if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (this.recordLineSeparator) {
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                            }
                            if (!this.tokenizeComments) ** GOTO lbl-1000
                            return 1001;
                        }
                        catch (IndexOutOfBoundsException v0) {
                            this.recordComment(1001);
                            if (this.taskTags != null) {
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                            }
                            if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                this.parseTags();
                            }
                            if (!this.tokenizeComments) ** GOTO lbl-1000
                            return 1001;
                        }
lbl250:
                        // 1 sources

                        if (test <= 0) ** GOTO lbl322
                        try {
                            isJavadoc = false;
                            star = false;
                            isUnicode = false;
                            this.unicodeAsBackSlash = false;
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                                if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            if (this.currentCharacter == '*') {
                                isJavadoc = true;
                                star = true;
                            }
                            if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                if (isUnicode) {
                                    this.pushUnicodeLineSeparator();
                                } else {
                                    this.pushLineSeparator();
                                }
                            }
                            isUnicode = false;
                            previous = this.currentPosition;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                            }
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                ++this.currentPosition;
                            }
                            if (this.currentCharacter == '/') {
                                isJavadoc = false;
                            }
                            firstTag = 0;
                            while (true) {
                                if (this.currentCharacter != '/' || !star) ** GOTO lbl286
lbl286:
                                // 1 sources

                                if (this.currentPosition >= this.eofPosition) {
                                    throw Scanner.unterminatedComment();
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                switch (this.currentCharacter) {
                                    case '*': {
                                        star = true;
                                        break;
                                    }
                                    case '@': {
                                        if (firstTag == 0 && this.isFirstTag()) {
                                            firstTag = previous;
                                        }
                                    }
                                    default: {
                                        star = false;
                                    }
                                }
                                previous = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            token = isJavadoc != false ? 1003 : 1002;
                            this.recordComment(token);
                            this.commentTagStarts[this.commentPtr] = firstTag;
                            if (this.taskTags == null) continue block43;
                            this.checkTaskTag(this.startPosition, this.currentPosition);
                            if (!this.tokenizeComments) continue block43;
                            return token;
                        }
                        catch (IndexOutOfBoundsException v1) {
                            --this.currentPosition;
                            throw Scanner.unterminatedComment();
                        }
lbl322:
                        // 2 sources

                        if (this.getNextChar('=') == false) return 11;
                        return 106;
                    }
                    case '\u001a': {
                        if (this.atEnd() == false) throw Scanner.invalidEof();
                        return 69;
                    }
                }
                break;
            }
            c = this.currentCharacter;
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 64) != 0) {
                    return this.scanIdentifierOrKeyword();
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) == 0) return 155;
                return this.scanNumber(false);
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    throw Scanner.invalidUnicodeEscape();
                }
                low = (char)this.getNextChar();
                if (low < '\udc00') throw Scanner.invalidLowSurrogate();
                if (low > '\udfff') {
                    throw Scanner.invalidLowSurrogate();
                }
                isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    if (this.complianceLevel >= 0x310000L) throw Scanner.invalidHighSurrogate();
                    throw Scanner.invalidUnicodeEscape();
                }
                isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
            }
            if (isJavaIdStart) {
                return this.scanIdentifierOrKeyword();
            }
            if (ScannerHelper.isDigit(this.currentCharacter) == false) return 155;
            return this.scanNumber(false);
        }
        catch (IndexOutOfBoundsException v2) {
            if (this.tokenizeWhiteSpace == false) return 69;
            if (whiteStart == this.currentPosition - 1) return 69;
            --this.currentPosition;
            this.startPosition = whiteStart;
            return 1000;
        }
    }

    protected boolean needBindoutDisambiguation() {
        if (!this._isOTSource) {
            return false;
        }
        if (this.activeParser instanceof VanguardParser) {
            Goal goal = ((VanguardParser)this.activeParser).currentGoal;
            return goal != Goal.LambdaParameterListGoal && goal != Goal.PatternGoal && goal != Goal.SwitchLabelCaseLhsGoal;
        }
        Parser parser = null;
        if (this.activeParser instanceof DiagnoseParser) {
            parser = ((DiagnoseParser)this.activeParser).parser;
        } else if (this.activeParser instanceof Parser) {
            parser = (Parser)this.activeParser;
        } else {
            return true;
        }
        if (parser.referenceContext instanceof AbstractMethodDeclaration) {
            return false;
        }
        for (int ptr = parser.astPtr; ptr > -1; --ptr) {
            ASTNode topAstNode = parser.astStack[ptr];
            if (topAstNode instanceof TypeDeclaration) {
                return true;
            }
            if (topAstNode instanceof MethodDeclaration) {
                return true;
            }
            if (topAstNode instanceof LambdaExpression) {
                return topAstNode.sourceEnd != 0;
            }
            if (topAstNode instanceof Argument) {
                continue;
            }
            return true;
        }
        return true;
    }

    protected int processSingleQuotes(boolean checkIfUnicode) throws InvalidInputException {
        int lookAhead;
        int test = this.getNextChar('\n', '\r');
        if (test == 0) {
            throw Scanner.invalidCharacter();
        }
        if (test > 0) {
            int lookAhead2 = 0;
            while (lookAhead2 < 3) {
                if (this.currentPosition + lookAhead2 == this.eofPosition || this.source[this.currentPosition + lookAhead2] == '\n') break;
                if (this.source[this.currentPosition + lookAhead2] == '\'') {
                    this.currentPosition += lookAhead2 + 1;
                    break;
                }
                ++lookAhead2;
            }
            throw Scanner.invalidCharacter();
        }
        if (this.getNextChar('\'')) {
            lookAhead = 0;
            while (lookAhead < 3) {
                if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                if (this.source[this.currentPosition + lookAhead] == '\'') {
                    this.currentPosition += lookAhead + 1;
                    break;
                }
                ++lookAhead;
            }
            throw Scanner.invalidCharacter();
        }
        if (this.getNextChar('\\')) {
            if (this.unicodeAsBackSlash) {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            } else {
                this.currentCharacter = this.source[this.currentPosition++];
            }
            this.scanEscapeCharacter();
        } else {
            this.unicodeAsBackSlash = false;
            checkIfUnicode = false;
            try {
                this.currentCharacter = this.source[this.currentPosition++];
                checkIfUnicode = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                --this.currentPosition;
                throw Scanner.invalidCharacter();
            }
            if (checkIfUnicode) {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
        }
        if (this.getNextChar('\'')) {
            return 50;
        }
        lookAhead = 0;
        while (lookAhead < 20) {
            if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
            if (this.source[this.currentPosition + lookAhead] == '\'') {
                this.currentPosition += lookAhead + 1;
                break;
            }
            ++lookAhead;
        }
        throw Scanner.invalidCharacter();
    }

    /*
     * Unable to fully structure code
     */
    protected int scanForStringLiteral() throws InvalidInputException {
        block29: {
            block30: {
                isTextBlock = false;
                this.unicodeAsBackSlash = false;
                isUnicode = false;
                isTextBlock = this.scanForTextBlockBeginning();
                if (isTextBlock) {
                    return this.scanForTextBlock();
                }
                try {
                    this.unicodeAsBackSlash = false;
                    isUnicode = false;
                    this.currentCharacter = this.source[this.currentPosition++];
                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                        isUnicode = true;
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    while (this.currentCharacter != '\"') {
                        if (this.currentPosition >= this.eofPosition) {
                            throw Scanner.unterminatedString();
                        }
                        if (this.currentCharacter == '\n' || this.currentCharacter == '\r') {
                            if (isUnicode) {
                                start = this.currentPosition;
                                lookAhead = 0;
                                while (lookAhead < 50) {
                                    if (this.currentPosition >= this.eofPosition) {
                                        this.currentPosition = start;
                                        break;
                                    }
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        isUnicode = true;
                                        this.getNextUnicodeChar();
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (!isUnicode && this.currentCharacter == '\n') {
                                        --this.currentPosition;
                                        break;
                                    }
                                    if (this.currentCharacter == '\"') {
                                        throw Scanner.invalidCharInString();
                                    }
                                    ++lookAhead;
                                }
                            } else {
                                --this.currentPosition;
                            }
                            throw Scanner.invalidCharInString();
                        }
                        if (this.currentCharacter == '\\') {
                            if (this.unicodeAsBackSlash) {
                                --this.withoutUnicodePtr;
                                this.unicodeAsBackSlash = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                    --this.withoutUnicodePtr;
                                } else {
                                    isUnicode = false;
                                }
                            } else {
                                if (this.withoutUnicodePtr == 0) {
                                    this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                }
                                --this.withoutUnicodePtr;
                                this.currentCharacter = this.source[this.currentPosition++];
                            }
                            this.scanEscapeCharacter();
                            if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                            isUnicode = true;
                            continue;
                        }
                        isUnicode = false;
                        if (this.withoutUnicodePtr == 0) continue;
                        this.unicodeStore();
                    }
                    break block29;
                }
                catch (IndexOutOfBoundsException v0) {
                    --this.currentPosition;
                    throw Scanner.unterminatedString();
                }
                catch (InvalidInputException e) {
                    if (!e.getMessage().equals("Invalid_Escape")) break block30;
                    lookAhead = 0;
                    ** while (lookAhead < 50)
                }
lbl-1000:
                // 1 sources

                {
                    if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                    if (this.source[this.currentPosition + lookAhead] == '\"') {
                        this.currentPosition += lookAhead + 1;
                        break;
                    }
                    ++lookAhead;
                    continue;
                }
            }
            throw e;
        }
        return 51;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int scanForTextBlock() throws InvalidInputException {
        int lastQuotePos = 0;
        try {
            this.rawStart = this.currentPosition - this.startPosition;
            block8: while (true) {
                block23: {
                    if (this.currentPosition > this.eofPosition) {
                        if (lastQuotePos <= 0) break;
                        this.currentPosition = lastQuotePos;
                    }
                    if (this.currentCharacter == '\"') {
                        lastQuotePos = this.currentPosition;
                        if (this.scanForTextBlockClose()) {
                            this.currentPosition += 2;
                            return 52;
                        }
                        if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    } else if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                        this.pushLineSeparator();
                    }
                    if (this.currentCharacter == '\\') {
                        switch (this.source[this.currentPosition]) {
                            case 'f': 
                            case 'n': 
                            case 'r': 
                            case 's': 
                            case 't': {
                                break block23;
                            }
                            case '\n': 
                            case '\r': {
                                this.currentCharacter = (char)92;
                                ++this.currentPosition;
                                break;
                            }
                            case '\"': {
                                ++this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                continue block8;
                            }
                            case '\\': {
                                ++this.currentPosition;
                                break;
                            }
                            default: {
                                if (this.unicodeAsBackSlash) {
                                    --this.withoutUnicodePtr;
                                    if (this.currentPosition >= this.eofPosition) break;
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        --this.withoutUnicodePtr;
                                    }
                                } else {
                                    if (this.withoutUnicodePtr == 0) {
                                        this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                    }
                                    --this.withoutUnicodePtr;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                }
                                int oldPos = this.currentPosition - 1;
                                this.scanEscapeCharacter();
                                if (!ScannerHelper.isWhitespace(this.currentCharacter)) break;
                                if (this.withoutUnicodePtr == 0) {
                                    this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                }
                                this.unicodeStore('\\');
                                this.currentPosition = oldPos;
                                this.currentCharacter = this.source[this.currentPosition];
                                break block23;
                            }
                        }
                        if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                }
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                    continue;
                }
                if (this.currentCharacter == '\"' || this.withoutUnicodePtr == 0) continue;
                this.unicodeStore();
            }
            this.currentPosition = lastQuotePos > 0 ? lastQuotePos : this.startPosition + this.rawStart;
            throw Scanner.unterminatedTextBlock();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.currentPosition = lastQuotePos > 0 ? lastQuotePos : this.startPosition + this.rawStart;
            throw Scanner.unterminatedTextBlock();
        }
    }

    public void getNextUnicodeChar() throws InvalidInputException {
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int c4 = 0;
        int unicodeSize = 6;
        ++this.currentPosition;
        if (this.currentPosition < this.eofPosition) {
            while (this.source[this.currentPosition] == 'u') {
                ++this.currentPosition;
                if (this.currentPosition >= this.eofPosition) {
                    --this.currentPosition;
                    throw Scanner.invalidUnicodeEscape();
                }
                ++unicodeSize;
            }
        } else {
            --this.currentPosition;
            throw Scanner.invalidUnicodeEscape();
        }
        if (this.currentPosition + 4 > this.eofPosition) {
            this.currentPosition += this.eofPosition - this.currentPosition;
            throw Scanner.invalidUnicodeEscape();
        }
        if ((c1 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
            throw Scanner.invalidUnicodeEscape();
        }
        this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
        if (this.withoutUnicodePtr == 0) {
            this.unicodeInitializeBuffer(this.currentPosition - unicodeSize - this.startPosition);
        }
        this.unicodeStore();
        this.unicodeAsBackSlash = this.currentCharacter == '\\';
    }

    public NLSTag[] getNLSTags() {
        int length = this.nlsTagsPtr;
        if (length != 0) {
            NLSTag[] result = new NLSTag[length];
            System.arraycopy(this.nlsTags, 0, result, 0, length);
            this.nlsTagsPtr = 0;
            return result;
        }
        return null;
    }

    public boolean[] getIdentityComparisonLines() {
        boolean[] retVal = this.validIdentityComparisonLines;
        this.validIdentityComparisonLines = null;
        return retVal;
    }

    public char[] getSource() {
        return this.source;
    }

    protected boolean isFirstTag() {
        return true;
    }

    public final void jumpOverMethodBody() {
        this.jumpOverMethodBody(1);
    }

    /*
     * Unable to fully structure code
     */
    public final void jumpOverMethodBody(int found) {
        this.wasAcr = false;
        block37: while (true) {
            block38: while (true) {
                this.withoutUnicodePtr = 0;
                do {
                    this.startPosition = ++this.currentPosition;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                        continue;
                    }
                    if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n')) {
                        this.pushLineSeparator();
                    }
                    isWhiteSpace = CharOperation.isWhitespace(this.currentCharacter);
                } while (isWhiteSpace);
                switch (this.currentCharacter) {
                    case '{': {
                        ++found;
                        continue block38;
                    }
                    case '}': {
                        if (--found != 0) continue block38;
                        return;
                    }
                    case '\'': {
                        test = this.getNextChar('\\');
                        if (test) {
                            try {
                                if (this.unicodeAsBackSlash) {
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                } else {
                                    this.currentCharacter = this.source[this.currentPosition++];
                                }
                                this.scanEscapeCharacter();
                            }
                            catch (InvalidInputException v0) {}
                        } else {
                            try {
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            catch (InvalidInputException v1) {}
                        }
                        this.getNextChar('\'');
                        continue block38;
                    }
                    case '\"': {
                        isTextBlock = false;
                        firstClosingBrace = 0;
                        try {
                            try {
                                isTextBlock = this.scanForTextBlockBeginning();
                                if (!isTextBlock) {
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                            }
                            catch (InvalidInputException v2) {}
                            while (true) {
                                if (this.currentPosition > this.eofPosition) continue block37;
                                if (!isTextBlock) ** GOTO lbl94
                                switch (this.currentCharacter) {
                                    case '\"': {
                                        if (this.scanForTextBlockClose()) {
                                            this.currentPosition += 2;
                                            this.currentCharacter = this.source[this.currentPosition];
                                            isTextBlock = false;
                                            continue block38;
                                        }
                                        ** GOTO lbl95
                                    }
                                    case '}': {
                                        if (firstClosingBrace == 0) {
                                            firstClosingBrace = this.currentPosition;
                                        }
                                        ** GOTO lbl95
                                    }
                                    case '\r': {
                                        if (this.source[this.currentPosition] == '\n') {
                                            ++this.currentPosition;
                                        }
                                    }
                                    case '\n': {
                                        this.pushLineSeparator();
                                    }
                                    default: {
                                        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\"') {
                                            ++this.currentPosition;
                                        }
                                        this.currentCharacter = this.source[this.currentPosition++];
                                        break;
                                    }
                                }
                                continue;
lbl94:
                                // 1 sources

                                if (this.currentCharacter == '\"') continue block38;
lbl95:
                                // 3 sources

                                if (this.currentCharacter == '\r') {
                                    if (this.source[this.currentPosition] != '\n') continue block38;
                                    continue block38;
                                }
                                if (this.currentCharacter == '\n') continue block38;
                                if (this.currentCharacter == '\\') {
                                    try {
                                        if (this.unicodeAsBackSlash) {
                                            this.unicodeAsBackSlash = false;
                                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                                this.getNextUnicodeChar();
                                            } else if (this.withoutUnicodePtr != 0) {
                                                this.unicodeStore();
                                            }
                                        } else {
                                            this.currentCharacter = this.source[this.currentPosition++];
                                        }
                                        this.scanEscapeCharacter();
                                    }
                                    catch (InvalidInputException v3) {}
                                }
                                try {
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        continue;
                                    }
                                    if (this.withoutUnicodePtr == 0) continue;
                                    this.unicodeStore();
                                }
                                catch (InvalidInputException v4) {}
                            }
                        }
                        catch (IndexOutOfBoundsException v5) {
                            if (!isTextBlock || firstClosingBrace <= 0) continue block38;
                            this.currentPosition = firstClosingBrace - 1;
                        }
                        continue block38;
                    }
                    case '/': {
                        test = this.getNextChar('/', '*');
                        if (test == 0) {
                            try {
                                this.lastCommentLinePosition = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                isUnicode = false;
                                while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                    if (this.currentPosition >= this.eofPosition) {
                                        this.lastCommentLinePosition = this.currentPosition++;
                                        throw new IndexOutOfBoundsException();
                                    }
                                    this.lastCommentLinePosition = this.currentPosition;
                                    isUnicode = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        isUnicode = true;
                                        this.getNextUnicodeChar();
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                    if (this.source[this.currentPosition] == '\n') {
                                        ++this.currentPosition;
                                        this.currentCharacter = (char)10;
                                    } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                        isUnicode = true;
                                        this.getNextUnicodeChar();
                                    }
                                }
                                this.recordComment(1001);
                                if (!this.recordLineSeparator || this.currentCharacter != '\r' && this.currentCharacter != '\n') continue block38;
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (!this.recordLineSeparator) continue block38;
                                if (isUnicode) {
                                    this.pushUnicodeLineSeparator();
                                    continue block38;
                                }
                                this.pushLineSeparator();
                            }
                            catch (IndexOutOfBoundsException v6) {
                                --this.currentPosition;
                                this.recordComment(1001);
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (this.tokenizeComments) continue block38;
                                ++this.currentPosition;
                            }
                            continue block38;
                        }
                        if (test <= 0) continue block38;
                        isJavadoc = false;
                        try {
                            star = false;
                            isUnicode = false;
                            this.unicodeAsBackSlash = false;
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                                if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            if (this.currentCharacter == '*') {
                                isJavadoc = true;
                                star = true;
                            }
                            if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                if (isUnicode) {
                                    this.pushUnicodeLineSeparator();
                                } else {
                                    this.pushLineSeparator();
                                }
                            }
                            isUnicode = false;
                            previous = this.currentPosition;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                            }
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                ++this.currentPosition;
                            }
                            if (this.currentCharacter == '/') {
                                isJavadoc = false;
                            }
                            firstTag = 0;
                            while (this.currentCharacter != '/' || !star) {
                                if (this.currentPosition >= this.eofPosition) {
                                    return;
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                switch (this.currentCharacter) {
                                    case '*': {
                                        star = true;
                                        break;
                                    }
                                    case '@': {
                                        if (firstTag == 0 && this.isFirstTag()) {
                                            firstTag = previous;
                                        }
                                    }
                                    default: {
                                        star = false;
                                    }
                                }
                                previous = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            this.recordComment(isJavadoc != false ? 1003 : 1002);
                            this.commentTagStarts[this.commentPtr] = firstTag;
                            continue block38;
                        }
                        catch (IndexOutOfBoundsException v7) {
                            return;
                        }
                    }
                }
                try {
                    c = this.currentCharacter;
                    if (c < '\u0080') {
                        if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 64) != 0) {
                            this.scanIdentifierOrKeyword();
                            continue;
                        }
                        if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) == 0) continue;
                        this.scanNumber(false);
                        continue;
                    }
                    if (c >= '\ud800' && c <= '\udbff') {
                        if (this.complianceLevel < 0x310000L) {
                            throw Scanner.invalidUnicodeEscape();
                        }
                        low = (char)this.getNextChar();
                        if (low < '\udc00' || low > '\udfff') continue;
                        isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
                    } else {
                        if (c >= '\udc00' && c <= '\udfff') continue;
                        isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
                    }
                    if (!isJavaIdStart) continue;
                    this.scanIdentifierOrKeyword();
                }
                catch (InvalidInputException v8) {}
            }
            break;
        }
        catch (IndexOutOfBoundsException | InvalidInputException v9) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    public final void jumpOverPredicate() {
        block96: {
            this.wasAcr = false;
            int found = 0;
            while (true) {
                block35: while (true) {
                    boolean isWhiteSpace;
                    this.withoutUnicodePtr = 0;
                    do {
                        this.startPosition = ++this.currentPosition;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                            continue;
                        }
                        if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n')) {
                            this.pushLineSeparator();
                        }
                        isWhiteSpace = CharOperation.isWhitespace(this.currentCharacter);
                    } while (isWhiteSpace);
                    switch (this.currentCharacter) {
                        case '(': {
                            ++found;
                            continue block35;
                        }
                        case ')': {
                            if (--found != 0) continue block35;
                            return;
                        }
                        case '{': {
                            ++found;
                            continue block35;
                        }
                        case '}': {
                            if (--found != 0) continue block35;
                            return;
                        }
                        case '\'': {
                            int test = this.getNextChar('\\');
                            if (test != 0) {
                                try {
                                    if (this.unicodeAsBackSlash) {
                                        this.unicodeAsBackSlash = false;
                                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                            this.getNextUnicodeChar();
                                        } else if (this.withoutUnicodePtr != 0) {
                                            this.unicodeStore();
                                        }
                                    } else {
                                        this.currentCharacter = this.source[this.currentPosition++];
                                    }
                                    this.scanEscapeCharacter();
                                }
                                catch (InvalidInputException invalidInputException) {}
                            } else {
                                try {
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                                catch (InvalidInputException invalidInputException) {}
                            }
                            this.getNextChar('\'');
                            continue block35;
                        }
                        case '\"': {
                            try {
                                try {
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                                catch (InvalidInputException invalidInputException) {}
                                while (true) {
                                    if (this.currentCharacter == '\"') continue block35;
                                    if (this.currentCharacter == '\r') {
                                        if (this.source[this.currentPosition] != '\n') continue block35;
                                        continue block35;
                                    }
                                    if (this.currentCharacter == '\n') continue block35;
                                    if (this.currentCharacter == '\\') {
                                        try {
                                            if (this.unicodeAsBackSlash) {
                                                this.unicodeAsBackSlash = false;
                                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                                    this.getNextUnicodeChar();
                                                } else if (this.withoutUnicodePtr != 0) {
                                                    this.unicodeStore();
                                                }
                                            } else {
                                                this.currentCharacter = this.source[this.currentPosition++];
                                            }
                                            this.scanEscapeCharacter();
                                        }
                                        catch (InvalidInputException invalidInputException) {}
                                    }
                                    try {
                                        this.unicodeAsBackSlash = false;
                                        this.currentCharacter = this.source[this.currentPosition++];
                                        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                            this.getNextUnicodeChar();
                                            continue;
                                        }
                                        if (this.withoutUnicodePtr == 0) continue;
                                        this.unicodeStore();
                                    }
                                    catch (InvalidInputException invalidInputException) {}
                                }
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                return;
                            }
                        }
                        case '/': {
                            int test = this.getNextChar('/', '*');
                            if (test == 0) {
                                try {
                                    this.lastCommentLinePosition = this.currentPosition;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    }
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                        ++this.currentPosition;
                                    }
                                    boolean isUnicode = false;
                                    while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                        this.lastCommentLinePosition = this.currentPosition;
                                        isUnicode = false;
                                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                            isUnicode = true;
                                            this.getNextUnicodeChar();
                                        }
                                        if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                        ++this.currentPosition;
                                    }
                                    if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                        if (this.source[this.currentPosition] == '\n') {
                                            ++this.currentPosition;
                                            this.currentCharacter = (char)10;
                                        } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                            isUnicode = true;
                                            this.getNextUnicodeChar();
                                        }
                                    }
                                    this.recordComment(1001);
                                    if (!this.recordLineSeparator || this.currentCharacter != '\r' && this.currentCharacter != '\n') continue block35;
                                    if (this.checkNonExternalizedStringLiterals && this.lastPosition < this.currentPosition) {
                                        this.parseTags();
                                    }
                                    if (!this.recordLineSeparator) continue block35;
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                        continue block35;
                                    }
                                    this.pushLineSeparator();
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    --this.currentPosition;
                                    this.recordComment(1001);
                                    if (this.checkNonExternalizedStringLiterals && this.lastPosition < this.currentPosition) {
                                        this.parseTags();
                                    }
                                    if (this.tokenizeComments) continue block35;
                                    ++this.currentPosition;
                                }
                                continue block35;
                            }
                            if (test <= 0) continue block35;
                            boolean isJavadoc = false;
                            try {
                                boolean star = false;
                                boolean isUnicode = false;
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                    if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                                if (this.currentCharacter == '*') {
                                    isJavadoc = true;
                                    star = true;
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                isUnicode = false;
                                int previous = this.currentPosition;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '/') {
                                    isJavadoc = false;
                                }
                                int firstTag = 0;
                                while (this.currentCharacter != '/' || !star) {
                                    if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                        if (isUnicode) {
                                            this.pushUnicodeLineSeparator();
                                        } else {
                                            this.pushLineSeparator();
                                        }
                                    }
                                    switch (this.currentCharacter) {
                                        case '*': {
                                            star = true;
                                            break;
                                        }
                                        case '@': {
                                            if (firstTag == 0 && this.isFirstTag()) {
                                                firstTag = previous;
                                            }
                                        }
                                        default: {
                                            star = false;
                                        }
                                    }
                                    previous = this.currentPosition;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                this.recordComment(isJavadoc ? 1003 : 1002);
                                this.commentTagStarts[this.commentPtr] = firstTag;
                                continue block35;
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                return;
                            }
                        }
                    }
                    try {
                        boolean isJavaIdStart;
                        char c = this.currentCharacter;
                        if (c < '\u0080') {
                            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x40) != 0) {
                                this.scanIdentifierOrKeyword();
                                continue;
                            }
                            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) == 0) continue;
                            this.scanNumber(false);
                            continue;
                        }
                        if (c >= '\ud800' && c <= '\udbff') {
                            if (this.complianceLevel < 0x310000L) {
                                throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
                            }
                            char low = (char)this.getNextChar();
                            if (low < '\udc00' || low > '\udfff') continue;
                            isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
                        } else {
                            if (c >= '\udc00' && c <= '\udfff') continue;
                            isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
                        }
                        if (!isJavaIdStart) continue;
                        this.scanIdentifierOrKeyword();
                    }
                    catch (InvalidInputException invalidInputException) {}
                }
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break block96;
            }
            catch (InvalidInputException invalidInputException) {}
        }
    }

    public final boolean jumpOverUnicodeWhiteSpace() throws InvalidInputException {
        this.wasAcr = false;
        this.getNextUnicodeChar();
        return CharOperation.isWhitespace(this.currentCharacter);
    }

    public boolean isInModuleDeclaration() {
        return this.fakeInModule || this.insideModuleInfo || this.activeParser != null && this.activeParser.isParsingModuleDeclaration();
    }

    protected boolean areRestrictedModuleKeywordsActive() {
        return this.scanContext != null && this.scanContext != ScanContext.INACTIVE;
    }

    void updateScanContext(int token) {
        switch (token) {
            case 24: 
            case 25: 
            case 34: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case 131: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case 134: {
                this.scanContext = ScanContext.AFTER_REQUIRES;
                break;
            }
            case 1: 
            case 26: 
            case 32: 
            case 38: 
            case 101: 
            case 122: 
            case 130: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 141: 
            case 151: {
                this.scanContext = ScanContext.EXPECTING_IDENTIFIER;
                break;
            }
            case 13: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case 41: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
        }
    }

    private void parseTags() {
        int pos;
        int position = 0;
        int currentStartPosition = this.startPosition;
        int currentLinePtr = this.linePtr;
        if (currentLinePtr >= 0) {
            position = this.lineEnds[currentLinePtr] + 1;
        }
        while (ScannerHelper.isWhitespace(this.source[position])) {
            ++position;
        }
        if (currentStartPosition == position) {
            return;
        }
        char[] s = null;
        int sourceEnd = this.currentPosition;
        int sourceStart = currentStartPosition;
        int sourceDelta = 0;
        if (this.withoutUnicodePtr != 0) {
            s = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, s, 0, this.withoutUnicodePtr);
            sourceEnd = this.withoutUnicodePtr;
            sourceStart = 1;
            sourceDelta = currentStartPosition;
        } else {
            s = this.source;
        }
        if (this.checkNonExternalizedStringLiterals && (pos = CharOperation.indexOf(TAG_PREFIX, s, true, sourceStart, sourceEnd)) != -1) {
            if (this.nlsTags == null) {
                this.nlsTags = new NLSTag[10];
                this.nlsTagsPtr = 0;
            }
            while (pos != -1) {
                int start = pos + TAG_PREFIX_LENGTH;
                int end = CharOperation.indexOf('$', s, start, sourceEnd);
                if (end != -1) {
                    NLSTag currentTag = null;
                    int currentLine = currentLinePtr + 1;
                    try {
                        currentTag = new NLSTag(pos + sourceDelta, end + sourceDelta, currentLine, this.extractInt(s, start, end));
                    }
                    catch (NumberFormatException numberFormatException) {
                        currentTag = new NLSTag(pos + sourceDelta, end + sourceDelta, currentLine, -1);
                    }
                    if (this.nlsTagsPtr == this.nlsTags.length) {
                        this.nlsTags = new NLSTag[this.nlsTagsPtr + 10];
                        System.arraycopy(this.nlsTags, 0, this.nlsTags, 0, this.nlsTagsPtr);
                    }
                    this.nlsTags[this.nlsTagsPtr++] = currentTag;
                } else {
                    end = start;
                }
                pos = CharOperation.indexOf(TAG_PREFIX, s, true, end, sourceEnd);
            }
        }
        if (this.checkUninternedIdentityComparison && (pos = CharOperation.indexOf(IDENTITY_COMPARISON_TAG, s, true, sourceStart, sourceEnd)) != -1) {
            if (this.validIdentityComparisonLines == null) {
                this.validIdentityComparisonLines = new boolean[0];
            }
            int currentLine = currentLinePtr + 1;
            int length = this.validIdentityComparisonLines.length;
            this.validIdentityComparisonLines = new boolean[currentLine + 1];
            System.arraycopy(this.validIdentityComparisonLines, 0, this.validIdentityComparisonLines, 0, length);
            this.validIdentityComparisonLines[currentLine] = true;
        }
    }

    private int extractInt(char[] array, int start, int end) {
        int value = 0;
        int i = start;
        while (i < end) {
            char currentChar = array[i];
            int digit = 0;
            switch (currentChar) {
                case '0': {
                    digit = 0;
                    break;
                }
                case '1': {
                    digit = 1;
                    break;
                }
                case '2': {
                    digit = 2;
                    break;
                }
                case '3': {
                    digit = 3;
                    break;
                }
                case '4': {
                    digit = 4;
                    break;
                }
                case '5': {
                    digit = 5;
                    break;
                }
                case '6': {
                    digit = 6;
                    break;
                }
                case '7': {
                    digit = 7;
                    break;
                }
                case '8': {
                    digit = 8;
                    break;
                }
                case '9': {
                    digit = 9;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            value *= 10;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            value += digit;
            ++i;
        }
        return value;
    }

    public final void pushLineSeparator() {
        block12: {
            if (this.currentCharacter == '\r') {
                int separatorPos = this.currentPosition - 1;
                if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= separatorPos) {
                    return;
                }
                int length = this.lineEnds.length;
                if (++this.linePtr >= length) {
                    this.lineEnds = new int[2 * length + 250];
                    System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, length);
                }
                this.lineEnds[this.linePtr] = separatorPos;
                try {
                    if (this.source[this.currentPosition] == '\n') {
                        this.lineEnds[this.linePtr] = this.currentPosition++;
                        this.wasAcr = false;
                        break block12;
                    }
                    this.wasAcr = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.wasAcr = true;
                }
            } else if (this.currentCharacter == '\n') {
                if (this.wasAcr && this.lineEnds[this.linePtr] == this.currentPosition - 2) {
                    this.lineEnds[this.linePtr] = this.currentPosition - 1;
                } else {
                    int separatorPos = this.currentPosition - 1;
                    if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= separatorPos) {
                        return;
                    }
                    int length = this.lineEnds.length;
                    if (++this.linePtr >= length) {
                        this.lineEnds = new int[2 * length + 250];
                        System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, length);
                    }
                    this.lineEnds[this.linePtr] = separatorPos;
                }
                this.wasAcr = false;
            }
        }
    }

    public final void pushUnicodeLineSeparator() {
        if (this.currentCharacter == '\r') {
            this.wasAcr = this.source[this.currentPosition] != '\n';
        } else if (this.currentCharacter == '\n') {
            this.wasAcr = false;
        }
    }

    public void recordComment(int token) {
        int commentStart = this.startPosition;
        int stopPosition = this.currentPosition;
        switch (token) {
            case 1001: {
                commentStart = -this.startPosition;
                stopPosition = -this.lastCommentLinePosition;
                break;
            }
            case 1002: {
                stopPosition = -this.currentPosition;
            }
        }
        int length = this.commentStops.length;
        if (++this.commentPtr >= length) {
            int newLength = length + 300;
            this.commentStops = new int[newLength];
            System.arraycopy(this.commentStops, 0, this.commentStops, 0, length);
            this.commentStarts = new int[newLength];
            System.arraycopy(this.commentStarts, 0, this.commentStarts, 0, length);
            this.commentTagStarts = new int[newLength];
            System.arraycopy(this.commentTagStarts, 0, this.commentTagStarts, 0, length);
        }
        this.commentStops[this.commentPtr] = stopPosition;
        this.commentStarts[this.commentPtr] = commentStart;
    }

    public void resetTo(int begin, int end) {
        this.resetTo(begin, end, this.isInModuleDeclaration());
    }

    public void resetTo(int begin, int end, boolean isModuleInfo) {
        this.resetTo(begin, end, isModuleInfo, null);
    }

    public void resetTo(int begin, int end, boolean isModuleInfo, ScanContext context) {
        this.diet = false;
        this.startPosition = this.currentPosition = begin;
        this.initialPosition = this.currentPosition;
        this.eofPosition = this.source != null && this.source.length < end ? this.source.length : (end < Integer.MAX_VALUE ? end + 1 : end);
        this.commentPtr = -1;
        this.foundTaskCount = 0;
        this.resetLookBack();
        this.nextToken = 0;
        this.consumingEllipsisAnnotations = false;
        this._insideParameterMapping = false;
        this._bindoutLookahead = null;
        this._atStartOfImport = false;
        this._inImport = false;
        this.insideModuleInfo = isModuleInfo;
        this.scanContext = context == null ? this.getScanContext(begin) : context;
        this.multiCaseLabelComma = false;
    }

    final void resetLookBack() {
        this.lookBack[1] = 0;
        this.lookBack[0] = 0;
    }

    final void addTokenToLookBack(int newToken) {
        switch (newToken) {
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: {
                return;
            }
        }
        this.lookBack[0] = this.lookBack[1];
        this.lookBack[1] = newToken;
    }

    private ScanContext getScanContext(int begin) {
        if (!this.isInModuleDeclaration()) {
            return ScanContext.INACTIVE;
        }
        if (begin == 0) {
            return ScanContext.EXPECTING_KEYWORD;
        }
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = this.complianceLevel;
        options.sourceLevel = this.sourceLevel;
        ScanContextDetector parser = new ScanContextDetector(options);
        return parser.getScanContext(this.source, begin - 1);
    }

    protected final void scanEscapeCharacter() throws InvalidInputException {
        switch (this.currentCharacter) {
            case 'b': {
                this.currentCharacter = (char)8;
                break;
            }
            case 't': {
                this.currentCharacter = (char)9;
                break;
            }
            case 'n': {
                this.currentCharacter = (char)10;
                break;
            }
            case 'f': {
                this.currentCharacter = (char)12;
                break;
            }
            case 'r': {
                this.currentCharacter = (char)13;
                break;
            }
            case '\"': {
                this.currentCharacter = (char)34;
                break;
            }
            case '\'': {
                this.currentCharacter = (char)39;
                break;
            }
            case 's': {
                if (this.sourceLevel < 0x3B0000L) {
                    throw Scanner.invalidEscape();
                }
                this.currentCharacter = (char)32;
                break;
            }
            case '\\': {
                this.currentCharacter = (char)92;
                break;
            }
            default: {
                int number = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                if (number >= 0 && number <= 7) {
                    boolean zeroToThreeNot = number > 3;
                    if (ScannerHelper.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                        int digit = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                        if (digit >= 0 && digit <= 7) {
                            number = number * 8 + digit;
                            if (ScannerHelper.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                                if (zeroToThreeNot) {
                                    --this.currentPosition;
                                } else {
                                    digit = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                                    if (digit >= 0 && digit <= 7) {
                                        number = number * 8 + digit;
                                    } else {
                                        --this.currentPosition;
                                    }
                                }
                            } else {
                                --this.currentPosition;
                            }
                        } else {
                            --this.currentPosition;
                        }
                    } else {
                        --this.currentPosition;
                    }
                    if (number > 255) {
                        throw Scanner.invalidEscape();
                    }
                    this.currentCharacter = (char)number;
                    break;
                }
                throw Scanner.invalidEscape();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCallinModifierToken(char[] data) {
        int length = data.length;
        int index = 0;
        char firstLetter = data[index];
        switch (firstLetter) {
            case 'a': {
                switch (length) {
                    case 5: {
                        if (data[++index] != 'f' || data[++index] != 't' || data[++index] != 'e' || data[++index] != 'r') return 155;
                        return 139;
                    }
                }
                return 155;
            }
            case 'b': {
                switch (length) {
                    case 6: {
                        if (data[++index] != 'e' || data[++index] != 'f' || data[++index] != 'o' || data[++index] != 'r' || data[++index] != 'e') return 155;
                        return 144;
                    }
                }
                return 155;
            }
            case 'r': {
                switch (length) {
                    case 7: {
                        if (data[++index] != 'e' || data[++index] != 'p' || data[++index] != 'l' || data[++index] != 'a' || data[++index] != 'c' || data[++index] != 'e') return 155;
                        return 143;
                    }
                }
            }
        }
        return 155;
    }

    public int scanIdentifierOrKeywordWithBoundCheck() {
        int index;
        char[] data;
        int length;
        int pos;
        this.useAssertAsAnIndentifier = false;
        this.useEnumAsAnIndentifier = false;
        char[] src = this.source;
        int srcLength = this.eofPosition;
        while ((pos = ++this.currentPosition) < srcLength) {
            char c = src[pos];
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.currentCharacter = c;
                        this.unicodeStore();
                    }
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x102) != 0) {
                    this.currentCharacter = c;
                    break;
                }
                while (this.getNextCharAsJavaIdentifierPartWithBoundCheck()) {
                }
                break;
            }
            while (this.getNextCharAsJavaIdentifierPartWithBoundCheck()) {
            }
            break block0;
        }
        if (this.withoutUnicodePtr == 0) {
            length = this.currentPosition - this.startPosition;
            if (length == 1) {
                return 13;
            }
            data = this.source;
            index = this.startPosition;
        } else {
            length = this.withoutUnicodePtr;
            if (length == 1) {
                return 13;
            }
            data = this.withoutUnicodeBuffer;
            index = 1;
        }
        return this.internalScanIdentifierOrKeyword(index, length, data);
    }

    public int scanIdentifierOrKeyword() {
        int index;
        char[] data;
        int length;
        int pos;
        this.useAssertAsAnIndentifier = false;
        this.useEnumAsAnIndentifier = false;
        char[] src = this.source;
        int srcLength = this.eofPosition;
        while ((pos = ++this.currentPosition) < srcLength) {
            char c = src[pos];
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.currentCharacter = c;
                        this.unicodeStore();
                    }
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x102) != 0) {
                    this.currentCharacter = c;
                    break;
                }
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
                break;
            }
            while (this.getNextCharAsJavaIdentifierPart()) {
            }
            break block0;
        }
        if (this.withoutUnicodePtr == 0) {
            length = this.currentPosition - this.startPosition;
            if (length == 1) {
                return 13;
            }
            data = this.source;
            index = this.startPosition;
        } else {
            length = this.withoutUnicodePtr;
            if (length == 1) {
                return 13;
            }
            data = this.withoutUnicodeBuffer;
            index = 1;
        }
        return this.internalScanIdentifierOrKeyword(index, length, data);
    }

    private int internalScanIdentifierOrKeyword(int index, int length, char[] data) {
        boolean calloutSeen = this._calloutSeen;
        boolean callinSeen = this._callinSeen;
        if (this._insideParameterMapping) {
            this._calloutSeen = false;
            this._callinSeen = false;
        }
        boolean precedenceSeen = this._precedenceSeen;
        this._precedenceSeen = false;
        switch (data[index]) {
            case 'a': {
                switch (length) {
                    case 2: {
                        if (this._isOTSource && data[++index] == 's') {
                            return 142;
                        }
                        return 13;
                    }
                    case 8: {
                        if (data[++index] == 'b' && data[++index] == 's' && data[++index] == 't' && data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'c' && data[++index] == 't') {
                            return 56;
                        }
                        return 13;
                    }
                    case 5: {
                        if ((callinSeen || precedenceSeen) && data[++index] == 'f' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'r') {
                            return 139;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 's' && data[++index] == 's' && data[++index] == 'e' && data[++index] == 'r' && data[++index] == 't') {
                            if (this.sourceLevel >= 0x300000L) {
                                this.containsAssertKeyword = true;
                                return 89;
                            }
                            this.useAssertAsAnIndentifier = true;
                            return 13;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'b': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'y' && data[++index] == 't' && data[++index] == 'e') {
                            return 117;
                        }
                        if (this.baseIsKeyword() && data[index] == 'a' && data[++index] == 's' && data[++index] == 'e') {
                            return 33;
                        }
                        return 13;
                    }
                    case 5: {
                        if (data[++index] == 'r' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'k') {
                            return 90;
                        }
                        return 13;
                    }
                    case 6: {
                        if (callinSeen && data[++index] == 'e' && data[++index] == 'f' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 'e') {
                            return 144;
                        }
                        return 13;
                    }
                    case 7: {
                        if (data[++index] == 'o' && data[++index] == 'o' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'n') {
                            return 116;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'c': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 's' && data[++index] == 'e') {
                                return 115;
                            }
                            return 13;
                        }
                        if (data[index] == 'h' && data[++index] == 'a' && data[++index] == 'r') {
                            return 119;
                        }
                        return 13;
                    }
                    case 5: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 't' && data[++index] == 'c' && data[++index] == 'h') {
                                return 118;
                            }
                            return 13;
                        }
                        if (data[index] == 'l') {
                            if (data[++index] == 'a' && data[++index] == 's' && data[++index] == 's') {
                                if (this._teamKeywordSeen) {
                                    this.enterOTSource();
                                }
                                return 75;
                            }
                            return 13;
                        }
                        if (data[index] == 'o' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 't') {
                            return 153;
                        }
                        return 13;
                    }
                    case 6: {
                        if (this._isOTSource && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'l' && data[++index] == 'i' && data[++index] == 'n') {
                            return 66;
                        }
                        return 13;
                    }
                    case 8: {
                        if (data[++index] == 'o' && data[++index] == 'n' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'n' && data[++index] == 'u' && data[++index] == 'e') {
                            return 91;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'd': {
                switch (length) {
                    case 2: {
                        if (data[++index] == 'o') {
                            return 92;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 'o' && data[++index] == 'u' && data[++index] == 'b' && data[++index] == 'l' && data[++index] == 'e') {
                            return 120;
                        }
                        return 13;
                    }
                    case 7: {
                        if (data[++index] == 'e' && data[++index] == 'f' && data[++index] == 'a' && data[++index] == 'u' && data[++index] == 'l' && data[++index] == 't') {
                            return 82;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'e': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'l') {
                            if (data[++index] == 's' && data[++index] == 'e') {
                                return 133;
                            }
                            return 13;
                        }
                        if (data[index] == 'n' && data[++index] == 'u' && data[++index] == 'm') {
                            if (this.sourceLevel >= 0x310000L) {
                                return 79;
                            }
                            this.useEnumAsAnIndentifier = true;
                            return 13;
                        }
                        return 13;
                    }
                    case 7: {
                        if (data[++index] == 'x') {
                            if (data[++index] == 't' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 'd' && data[++index] == 's') {
                                return 99;
                            }
                            if (this.areRestrictedModuleKeywordsActive() && data[index] == 'p' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't' && data[++index] == 's') {
                                return 135;
                            }
                            return 13;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'f': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'o' && data[++index] == 'r') {
                            return 93;
                        }
                        return 13;
                    }
                    case 5: {
                        if (data[++index] == 'i') {
                            if (data[++index] == 'n' && data[++index] == 'a' && data[++index] == 'l') {
                                return 57;
                            }
                            return 13;
                        }
                        if (data[index] == 'l') {
                            if (data[++index] == 'o' && data[++index] == 'a' && data[++index] == 't') {
                                return 121;
                            }
                            return 13;
                        }
                        if (data[index] == 'a' && data[++index] == 'l' && data[++index] == 's' && data[++index] == 'e') {
                            return 42;
                        }
                        return 13;
                    }
                    case 7: {
                        if (data[++index] == 'i' && data[++index] == 'n' && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'l' && data[++index] == 'y') {
                            return 129;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'g': {
                if (length == 3 && calloutSeen && data[++index] == 'e' && data[++index] == 't') {
                    return 145;
                }
                if (length == 4 && data[++index] == 'o' && data[++index] == 't' && data[++index] == 'o') {
                    return 154;
                }
                return 13;
            }
            case 'i': {
                switch (length) {
                    case 2: {
                        if (data[++index] == 'f') {
                            return 94;
                        }
                        return 13;
                    }
                    case 3: {
                        if (data[++index] == 'n' && data[++index] == 't') {
                            return 123;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 'm' && data[++index] == 'p' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't') {
                            this._atStartOfImport = true;
                            this._inImport = true;
                            return 122;
                        }
                        return 13;
                    }
                    case 9: {
                        if (data[++index] == 'n' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'r' && data[++index] == 'f' && data[++index] == 'a' && data[++index] == 'c' && data[++index] == 'e') {
                            if (this._teamKeywordSeen) {
                                this.enterOTSource();
                            }
                            return 78;
                        }
                        return 13;
                    }
                    case 10: {
                        if (data[++index] == 'm') {
                            if (data[++index] == 'p' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'm' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 't' && data[++index] == 's') {
                                return 150;
                            }
                            return 13;
                        }
                        if (data[index] == 'n' && data[++index] == 's' && data[++index] == 't' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'e' && data[++index] == 'o' && data[++index] == 'f') {
                            return 18;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'l': {
                if (length == 4 && data[++index] == 'o' && data[++index] == 'n' && data[++index] == 'g') {
                    return 124;
                }
                return 13;
            }
            case 'm': {
                switch (length) {
                    case 6: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'o' && data[++index] == 'd' && data[++index] == 'u' && data[++index] == 'l' && data[++index] == 'e') {
                            return 130;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'n': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'e' && data[++index] == 'w') {
                            return 37;
                        }
                        int token = this.checkFor_KeyWord(index - 1, length, data);
                        return token != 0 ? token : 13;
                    }
                    case 4: {
                        if (data[++index] == 'u' && data[++index] == 'l' && data[++index] == 'l') {
                            return 43;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'e') {
                            return 58;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'o': {
                switch (length) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'n') {
                            return 131;
                        }
                        return 13;
                    }
                    case 5: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 's') {
                            return 136;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'p': {
                switch (length) {
                    case 6: {
                        if (data[++index] == 'u' && data[++index] == 'b' && data[++index] == 'l' && data[++index] == 'i' && data[++index] == 'c') {
                            return 62;
                        }
                        return 13;
                    }
                    case 7: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 'c' && data[++index] == 'k' && data[++index] == 'a' && data[++index] == 'g' && data[++index] == 'e') {
                                return 100;
                            }
                            return 13;
                        }
                        if (data[index] == 'r' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'a' && data[++index] == 't' && data[++index] == 'e') {
                            return 60;
                        }
                        if (data[index] == 'e' && data[++index] == 'r' && data[++index] == 'm' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 's') {
                            return this.disambiguatedRestrictedIdentifierpermits(140);
                        }
                        return 13;
                    }
                    case 8: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'v' && data[++index] == 'i' && data[++index] == 'd' && data[++index] == 'e' && data[++index] == 's') {
                            return 138;
                        }
                        if (this._isOTSource && data[++index] == 'l' && data[++index] == 'a' && data[++index] == 'y' && data[++index] == 'e' && data[++index] == 'd' && data[++index] == 'B' && data[++index] == 'y') {
                            return 152;
                        }
                        return 13;
                    }
                    case 10: {
                        if (this._isOTSource && data[++index] == 'r' && data[++index] == 'e' && data[++index] == 'c' && data[++index] == 'e' && data[++index] == 'd' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'e') {
                            this._precedenceSeen = true;
                            return 102;
                        }
                        return 13;
                    }
                    case 9: {
                        if (data[++index] == 'r' && data[++index] == 'o' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'c' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'd') {
                            return 61;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'r': {
                switch (length) {
                    case 6: {
                        if (data[++index] == 'e') {
                            if (data[++index] == 't' && data[++index] == 'u' && data[++index] == 'r' && data[++index] == 'n') {
                                return 95;
                            }
                            if (data[index] == 'c' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 'd') {
                                return this.disambiguatedRestrictedIdentifierrecord(80);
                            }
                        }
                        return 13;
                    }
                    case 8: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'e' && data[++index] == 'q' && data[++index] == 'u' && data[++index] == 'i' && data[++index] == 'r' && data[++index] == 'e' && data[++index] == 's') {
                            return 134;
                        }
                        return 13;
                    }
                    case 7: {
                        if (!callinSeen || data[++index] != 'e' || data[++index] != 'p' || data[++index] != 'l' || data[++index] != 'a' || data[++index] != 'c' || data[++index] != 'e') break;
                        return 143;
                    }
                }
                return 13;
            }
            case 's': {
                switch (length) {
                    case 3: {
                        if (calloutSeen && data[++index] == 'e' && data[++index] == 't') {
                            return 146;
                        }
                        return 13;
                    }
                    case 5: {
                        if (data[++index] == 'h') {
                            if (data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't') {
                                return 125;
                            }
                            return 13;
                        }
                        if (data[index] == 'u' && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'r') {
                            return 35;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 't') {
                            if (data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'c') {
                                return 40;
                            }
                            return 13;
                        }
                        if (data[index] == 'w' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'c' && data[++index] == 'h') {
                            return 67;
                        }
                        if (data[index] == 'e' && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'd') {
                            return this.disambiguatedRestrictedIdentifiersealed(55);
                        }
                        return 13;
                    }
                    case 8: {
                        if (data[++index] == 't' && data[++index] == 'r' && data[++index] == 'i' && data[++index] == 'c' && data[++index] == 't' && data[++index] == 'f' && data[++index] == 'p') {
                            return 63;
                        }
                        return 13;
                    }
                    case 12: {
                        if (data[++index] == 'y' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'n' && data[++index] == 'i' && data[++index] == 'z' && data[++index] == 'e' && data[++index] == 'd') {
                            return 44;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 't': {
                switch (length) {
                    case 2: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'o') {
                            return 151;
                        }
                        return 13;
                    }
                    case 3: {
                        if (data[++index] == 'r' && data[++index] == 'y') {
                            return 96;
                        }
                        return 13;
                    }
                    case 4: {
                        if (data[++index] == 'h') {
                            if (data[++index] == 'i' && data[++index] == 's') {
                                return 36;
                            }
                            return 13;
                        }
                        if (data[index] == 'r' && data[++index] == 'u' && data[++index] == 'e') {
                            return 45;
                        }
                        if (data[index] == 'e' && data[++index] == 'a' && data[++index] == 'm' && (this._isOTSource || this._dotSeen == 0) && !this.parsePureJavaOnly) {
                            this._teamKeywordSeen = true;
                            return 54;
                        }
                        return 13;
                    }
                    case 5: {
                        if (data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'w') {
                            return 85;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 'h') {
                            if (data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'w' && data[++index] == 's') {
                                return 126;
                            }
                            return 13;
                        }
                        if (this._isOTSource && data[index] == 's' && data[++index] == 'u' && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'r') {
                            return 39;
                        }
                        return 13;
                    }
                    case 9: {
                        if (data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 'i' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 't') {
                            return 64;
                        }
                        return 13;
                    }
                    case 10: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'e') {
                            return 141;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'u': {
                switch (length) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 's' && data[++index] == 'e' && data[++index] == 's') {
                            return 137;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'v': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'o' && data[++index] == 'i' && data[++index] == 'd') {
                            return 127;
                        }
                        return 13;
                    }
                    case 8: {
                        if (data[++index] == 'o' && data[++index] == 'l' && data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'l' && data[++index] == 'e') {
                            return 65;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'w': {
                switch (length) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'h') {
                            return 101;
                        }
                        switch (data[++index]) {
                            case 'i': {
                                if (!this._isOTSource || data[++index] != 't' || data[++index] != 'h') break;
                                return 101;
                            }
                            case 'h': {
                                if (data[++index] != 'e' || data[++index] != 'n') break;
                                return this.disambiguatedRestrictedIdentifierWhen(88);
                            }
                        }
                        return 13;
                    }
                    case 5: {
                        if (data[++index] == 'h' && data[++index] == 'i' && data[++index] == 'l' && data[++index] == 'e') {
                            return 86;
                        }
                        return 13;
                    }
                    case 6: {
                        if (data[++index] == 'i' && data[++index] == 't' && data[++index] == 'h' && data[++index] == 'i' && data[++index] == 'n' && !this.parsePureJavaOnly) {
                            return 97;
                        }
                        return 13;
                    }
                }
                return 13;
            }
            case 'y': {
                switch (length) {
                    case 5: {
                        if (data[++index] != 'i' || data[++index] != 'e' || data[++index] != 'l' || data[++index] != 'd') break;
                        return this.disambiguatedRestrictedIdentifierYield(87);
                    }
                }
                return 13;
            }
        }
        return 13;
    }

    private int checkFor_KeyWord(int index, int length, char[] data) {
        if (this._Keywords == null) {
            this._Keywords = new HashMap<String, Integer>(0);
            if (JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
                this._Keywords.put("non-sealed", 59);
            }
        }
        for (String key : this._Keywords.keySet()) {
            if (!CharOperation.prefixEquals(key.toCharArray(), data, true, index)) continue;
            this.currentPosition = this.currentPosition - length + key.length();
            if (this.currentPosition < this.eofPosition) {
                this.currentCharacter = data[this.currentPosition];
            }
            return this._Keywords.get(key);
        }
        return 0;
    }

    public int scanNumber(boolean dotPrefix) throws InvalidInputException {
        boolean floating = dotPrefix;
        if (!dotPrefix && this.currentCharacter == '0') {
            if (this.getNextChar('x', 'X') >= 0) {
                int start = this.currentPosition;
                this.consumeDigits(16, true);
                int end = this.currentPosition;
                if (this.getNextChar('l', 'L') >= 0) {
                    if (end == start) {
                        throw Scanner.invalidHexa();
                    }
                    return 47;
                }
                if (this.getNextChar('.')) {
                    boolean hasNoDigitsBeforeDot = end == start;
                    start = this.currentPosition;
                    this.consumeDigits(16, true);
                    end = this.currentPosition;
                    if (hasNoDigitsBeforeDot && end == start) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        throw Scanner.invalidHexa();
                    }
                    if (this.getNextChar('p', 'P') >= 0) {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                        if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                            this.unicodeAsBackSlash = false;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                            } else if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        if (!ScannerHelper.isDigit(this.currentCharacter)) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            if (this.currentCharacter == '_') {
                                this.consumeDigits(10);
                                throw Scanner.invalidUnderscore();
                            }
                            throw Scanner.invalidHexa();
                        }
                        this.consumeDigits(10);
                        if (this.getNextChar('f', 'F') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            return 48;
                        }
                        if (this.getNextChar('d', 'D') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            return 49;
                        }
                        if (this.getNextChar('l', 'L') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            throw Scanner.invalidHexa();
                        }
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        return 49;
                    }
                    if (this.sourceLevel < 0x310000L) {
                        throw Scanner.illegalHexaLiteral();
                    }
                    throw Scanner.invalidHexa();
                }
                if (this.getNextChar('p', 'P') >= 0) {
                    if (end == start) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        throw Scanner.invalidHexa();
                    }
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                    if (!ScannerHelper.isDigit(this.currentCharacter)) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        if (this.currentCharacter == '_') {
                            this.consumeDigits(10);
                            throw Scanner.invalidUnderscore();
                        }
                        throw Scanner.invalidFloat();
                    }
                    this.consumeDigits(10);
                    if (this.getNextChar('f', 'F') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        return 48;
                    }
                    if (this.getNextChar('d', 'D') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        return 49;
                    }
                    if (this.getNextChar('l', 'L') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        throw Scanner.invalidHexa();
                    }
                    if (this.sourceLevel < 0x310000L) {
                        throw Scanner.illegalHexaLiteral();
                    }
                    return 49;
                }
                if (end == start) {
                    throw Scanner.invalidHexa();
                }
                return 46;
            }
            if (this.getNextChar('b', 'B') >= 0) {
                int start = this.currentPosition;
                this.consumeDigits(2, true);
                int end = this.currentPosition;
                if (end == start) {
                    if (this.sourceLevel < 0x330000L) {
                        throw Scanner.invalidBinaryLiteral();
                    }
                    throw Scanner.invalidBinary();
                }
                if (this.getNextChar('l', 'L') >= 0) {
                    if (this.sourceLevel < 0x330000L) {
                        throw Scanner.invalidBinaryLiteral();
                    }
                    return 47;
                }
                if (this.sourceLevel < 0x330000L) {
                    throw Scanner.invalidBinaryLiteral();
                }
                return 46;
            }
            if (this.getNextCharAsDigit()) {
                this.consumeDigits(10);
                if (this.getNextChar('l', 'L') >= 0) {
                    return 47;
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return 48;
                }
                if (this.getNextChar('d', 'D') >= 0) {
                    return 49;
                }
                boolean isInteger = true;
                if (this.getNextChar('.')) {
                    isInteger = false;
                    this.consumeDigits(10);
                }
                if (this.getNextChar('e', 'E') >= 0) {
                    isInteger = false;
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                    if (!ScannerHelper.isDigit(this.currentCharacter)) {
                        if (this.currentCharacter == '_') {
                            this.consumeDigits(10);
                            throw Scanner.invalidUnderscore();
                        }
                        throw Scanner.invalidFloat();
                    }
                    this.consumeDigits(10);
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return 48;
                }
                if (this.getNextChar('d', 'D') >= 0 || !isInteger) {
                    return 49;
                }
                return 46;
            }
        }
        this.consumeDigits(10);
        if (!dotPrefix && this.getNextChar('l', 'L') >= 0) {
            return 47;
        }
        if (!dotPrefix && this.getNextChar('.')) {
            this.consumeDigits(10, true);
            floating = true;
        }
        if (this.getNextChar('e', 'E') >= 0) {
            floating = true;
            this.unicodeAsBackSlash = false;
            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            }
            if (!ScannerHelper.isDigit(this.currentCharacter)) {
                if (this.currentCharacter == '_') {
                    this.consumeDigits(10);
                    throw Scanner.invalidUnderscore();
                }
                throw Scanner.invalidFloat();
            }
            this.consumeDigits(10);
        }
        if (this.getNextChar('d', 'D') >= 0) {
            return 49;
        }
        if (this.getNextChar('f', 'F') >= 0) {
            return 48;
        }
        return floating ? 49 : 46;
    }

    public final int getLineNumber(int position) {
        return Util.getLineNumber(position, this.lineEnds, 0, this.linePtr);
    }

    public final void setSource(char[] sourceString) {
        int sourceLength;
        if (sourceString == null) {
            this.source = CharOperation.NO_CHAR;
            sourceLength = 0;
        } else {
            this.source = sourceString;
            sourceLength = sourceString.length;
        }
        this.startPosition = -1;
        this.eofPosition = sourceLength;
        this.currentPosition = 0;
        this.initialPosition = 0;
        this.containsAssertKeyword = false;
        this.linePtr = -1;
        this.resetOTFlags();
        this.scanContext = null;
        this.yieldColons = -1;
        this.insideModuleInfo = false;
    }

    public final void setSource(char[] contents, CompilationResult compilationResult) {
        if (contents == null) {
            char[] cuContents = compilationResult.compilationUnit.getContents();
            this.setSource(cuContents);
        } else {
            this.setSource(contents);
        }
        int[] lineSeparatorPositions = compilationResult.lineSeparatorPositions;
        if (lineSeparatorPositions != null) {
            this.lineEnds = lineSeparatorPositions;
            this.linePtr = lineSeparatorPositions.length - 1;
        }
    }

    public final void setSource(CompilationResult compilationResult) {
        this.setSource(null, compilationResult);
    }

    public String toString() {
        if (this.startPosition == this.eofPosition) {
            return "EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition > this.eofPosition) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition <= 0) {
            return "NOT started!\n\n" + (this.source != null ? new String(this.source) : "");
        }
        StringBuilder buffer = new StringBuilder();
        if (this.startPosition < 1000) {
            buffer.append(this.source, 0, this.startPosition);
        } else {
            buffer.append("<source beginning>\n...\n");
            int line = Util.getLineNumber(this.startPosition - 1000, this.lineEnds, 0, this.linePtr);
            int lineStart = this.getLineStart(line);
            buffer.append(this.source, lineStart, this.startPosition - lineStart);
        }
        buffer.append("\n===============================\nStarts here -->");
        int middleLength = this.currentPosition - 1 - this.startPosition + 1;
        if (middleLength > -1) {
            buffer.append(this.source, this.startPosition, middleLength);
        }
        if (this.nextToken != 0) {
            buffer.append("<-- Ends here [in pipeline " + this.toStringAction(this.nextToken) + "]\n===============================\n");
        } else {
            buffer.append("<-- Ends here\n===============================\n");
        }
        buffer.append(this.source, this.currentPosition - 1 + 1, this.eofPosition - (this.currentPosition - 1) - 1);
        return buffer.toString();
    }

    public String toStringAction(int act) {
        switch (act) {
            case 13: {
                return "Identifier(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 88: {
                return "when";
            }
            case 87: {
                return "yield";
            }
            case 80: {
                return "record";
            }
            case 56: {
                return "abstract";
            }
            case 142: {
                return "as";
            }
            case 66: {
                return "callin";
            }
            case 152: {
                return "playedBy";
            }
            case 102: {
                return "precedence";
            }
            case 54: {
                return "team";
            }
            case 101: {
                return "with";
            }
            case 97: {
                return "within";
            }
            case 143: {
                return "replace";
            }
            case 144: {
                return "before";
            }
            case 139: {
                return "after";
            }
            case 145: {
                return "get";
            }
            case 146: {
                return "set";
            }
            case 116: {
                return "boolean";
            }
            case 90: {
                return "break";
            }
            case 117: {
                return "byte";
            }
            case 115: {
                return "case";
            }
            case 118: {
                return "catch";
            }
            case 119: {
                return "char";
            }
            case 75: {
                return "class";
            }
            case 91: {
                return "continue";
            }
            case 82: {
                return "default";
            }
            case 92: {
                return "do";
            }
            case 120: {
                return "double";
            }
            case 133: {
                return "else";
            }
            case 99: {
                return "extends";
            }
            case 42: {
                return "false";
            }
            case 57: {
                return "final";
            }
            case 129: {
                return "finally";
            }
            case 121: {
                return "float";
            }
            case 93: {
                return "for";
            }
            case 94: {
                return "if";
            }
            case 150: {
                return "implements";
            }
            case 122: {
                return "import";
            }
            case 18: {
                return "instanceof";
            }
            case 123: {
                return "int";
            }
            case 78: {
                return "interface";
            }
            case 124: {
                return "long";
            }
            case 58: {
                return "native";
            }
            case 37: {
                return "new";
            }
            case 59: {
                return "non-sealed";
            }
            case 43: {
                return "null";
            }
            case 100: {
                return "package";
            }
            case 140: {
                return "permits";
            }
            case 60: {
                return "private";
            }
            case 61: {
                return "protected";
            }
            case 62: {
                return "public";
            }
            case 95: {
                return "return";
            }
            case 55: {
                return "sealed";
            }
            case 125: {
                return "short";
            }
            case 40: {
                return "static";
            }
            case 35: {
                return "super";
            }
            case 67: {
                return "switch";
            }
            case 44: {
                return "synchronized";
            }
            case 36: {
                return "this";
            }
            case 85: {
                return "throw";
            }
            case 126: {
                return "throws";
            }
            case 64: {
                return "transient";
            }
            case 45: {
                return "true";
            }
            case 96: {
                return "try";
            }
            case 127: {
                return "void";
            }
            case 65: {
                return "volatile";
            }
            case 86: {
                return "while";
            }
            case 130: {
                return "module";
            }
            case 134: {
                return "requires";
            }
            case 135: {
                return "exports";
            }
            case 46: {
                return "Integer(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 47: {
                return "Long(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 48: {
                return "Float(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 49: {
                return "Double(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 50: {
                return "Char(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 51: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 52: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 2: {
                return "++";
            }
            case 3: {
                return "--";
            }
            case 21: {
                return "==";
            }
            case 81: {
                return "<-";
            }
            case 98: {
                return "=>";
            }
            case 15: {
                return "<=";
            }
            case 16: {
                return ">=";
            }
            case 22: {
                return "!=";
            }
            case 20: {
                return "<<";
            }
            case 14: {
                return ">>";
            }
            case 17: {
                return ">>>";
            }
            case 103: {
                return "+=";
            }
            case 104: {
                return "-=";
            }
            case 114: {
                return "->";
            }
            case 105: {
                return "*=";
            }
            case 106: {
                return "/=";
            }
            case 107: {
                return "&=";
            }
            case 108: {
                return "|=";
            }
            case 109: {
                return "^=";
            }
            case 110: {
                return "%=";
            }
            case 111: {
                return "<<=";
            }
            case 112: {
                return ">>=";
            }
            case 113: {
                return ">>>=";
            }
            case 31: {
                return "||";
            }
            case 30: {
                return "&&";
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
            case 70: {
                return "!";
            }
            case 10: {
                return "%";
            }
            case 27: {
                return "^";
            }
            case 23: {
                return "&";
            }
            case 9: {
                return "*";
            }
            case 28: {
                return "|";
            }
            case 71: {
                return "~";
            }
            case 11: {
                return "/";
            }
            case 12: {
                return ">";
            }
            case 8: {
                return "<";
            }
            case 19: {
                return "(";
            }
            case 24: {
                return ")";
            }
            case 41: {
                return "{";
            }
            case 34: {
                return "}";
            }
            case 6: {
                return "[";
            }
            case 74: {
                return "]";
            }
            case 25: {
                return ";";
            }
            case 29: {
                return "?";
            }
            case 68: {
                return ":";
            }
            case 7: {
                return "::";
            }
            case 32: {
                return ",";
            }
            case 1: {
                return ".";
            }
            case 83: {
                return "=";
            }
            case 69: {
                return "EOF";
            }
            case 1000: {
                return "white_space(" + new String(this.getCurrentTokenSource()) + ")";
            }
        }
        return "not-a-token";
    }

    public void unicodeInitializeBuffer(int length) {
        int bLength;
        this.withoutUnicodePtr = length;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[length + 11];
        }
        if (1 + length >= (bLength = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[length + 11];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, bLength);
        }
        System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, length);
    }

    public void unicodeStore() {
        int length;
        int pos = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (pos == (length = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[length * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, length);
        }
        this.withoutUnicodeBuffer[pos] = this.currentCharacter;
    }

    public void unicodeStore(char character) {
        int length;
        int pos = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (pos == (length = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[length * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, length);
        }
        this.withoutUnicodeBuffer[pos] = character;
    }

    public static boolean isIdentifier(int token) {
        return token == 13;
    }

    public static boolean isLiteral(int token) {
        switch (token) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    public static boolean isKeyword(int token) {
        switch (token) {
            case 18: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 75: 
            case 78: 
            case 82: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 133: 
            case 150: {
                return true;
            }
        }
        return false;
    }

    private VanguardParser getVanguardParser() {
        if (this.vanguardParser == null) {
            this.vanguardScanner = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
            this.vanguardParser = new VanguardParser(this.vanguardScanner);
            this.vanguardScanner.setActiveParser(this.vanguardParser);
        }
        this.vanguardScanner.setSource(this.source);
        this.vanguardScanner.resetTo(this.startPosition, this.eofPosition - 1, this.isInModuleDeclaration(), this.scanContext);
        this.vanguardScanner._isOTSource = this._isOTSource;
        this.vanguardScanner._dotSeen = this._dotSeen;
        this.vanguardScanner._calloutSeen = this._calloutSeen;
        this.vanguardScanner._callinSeen = this._callinSeen;
        this.vanguardScanner._insideParameterMapping = this._insideParameterMapping;
        this.vanguardScanner._forceBaseIsIdentifier = this._forceBaseIsIdentifier;
        return this.vanguardParser;
    }

    private VanguardParser getNewVanguardParser() {
        VanguardScanner vs = this.getNewVanguardScanner();
        VanguardParser vp = new VanguardParser(vs);
        vs.setActiveParser(vp);
        return vp;
    }

    private VanguardScanner getNewVanguardScanner() {
        VanguardScanner vs = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
        vs.setSource(this.source);
        vs.resetTo(this.startPosition, this.eofPosition - 1, this.isInModuleDeclaration(), this.scanContext);
        return vs;
    }

    protected final boolean mayBeAtCasePattern(int token) {
        return !this.isInModuleDeclaration() && JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(this.complianceLevel, this.previewEnabled) && (token == 115 || this.multiCaseLabelComma);
    }

    protected final boolean maybeAtLambdaOrCast() {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (this.lookBack[1]) {
            case 13: 
            case 35: 
            case 36: 
            case 44: 
            case 67: 
            case 86: 
            case 93: 
            case 94: 
            case 96: 
            case 115: 
            case 118: {
                return false;
            }
        }
        return this.activeParser.atConflictScenario(19);
    }

    protected final boolean maybeAtEnhForRecordPattern() {
        return this.lookBack[1] == 93 && !this.isInModuleDeclaration();
    }

    protected final boolean maybeAtReferenceExpression() {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (this.lookBack[1]) {
            case 13: {
                switch (this.lookBack[0]) {
                    case 8: 
                    case 12: 
                    case 14: 
                    case 18: 
                    case 23: 
                    case 25: 
                    case 34: 
                    case 35: 
                    case 37: 
                    case 38: 
                    case 40: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 99: 
                    case 126: 
                    case 140: 
                    case 150: {
                        return false;
                    }
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        return this.activeParser.atConflictScenario(8);
    }

    private final boolean maybeAtEllipsisAnnotationsStart() {
        if (this.consumingEllipsisAnnotations) {
            return false;
        }
        switch (this.lookBack[1]) {
            case 1: 
            case 8: 
            case 18: 
            case 23: 
            case 32: 
            case 35: 
            case 37: 
            case 41: 
            case 99: 
            case 126: 
            case 140: 
            case 150: {
                return false;
            }
        }
        return true;
    }

    protected final boolean atTypeAnnotation() {
        return !this.activeParser.atConflictScenario(38);
    }

    protected final boolean atTypeAnchor() {
        return this.activeParser.atConflictScenario(128);
    }

    public void setActiveParser(ConflictedParser parser) {
        this.activeParser = parser;
        this.resetLookBack();
        if (parser != null) {
            this.insideModuleInfo = parser.isParsingModuleDeclaration();
        }
        this.multiCaseLabelComma = false;
    }

    public static boolean isRestrictedKeyword(int token) {
        switch (token) {
            case 101: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 141: 
            case 151: {
                return true;
            }
        }
        return false;
    }

    private boolean mayBeAtAnYieldStatement() {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (this.lookBack[1]) {
            case 24: 
            case 25: 
            case 34: 
            case 41: 
            case 92: 
            case 133: {
                return true;
            }
            case 68: {
                return this.lookBack[0] == 82 || this.yieldColons == 1;
            }
        }
        return false;
    }

    private boolean mayBeAtASealedRestricedIdentifier(int restrictedIdentifier) {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (restrictedIdentifier) {
            case 55: {
                break;
            }
        }
        return true;
    }

    int disambiguatedRestrictedIdentifierrecord(int restrictedIdentifierToken) {
        if (restrictedIdentifierToken != 80) {
            return restrictedIdentifierToken;
        }
        if (!JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 13;
        }
        return this.disambiguaterecordWithLookAhead() ? restrictedIdentifierToken : 13;
    }

    private int getNextTokenAfterTypeParameterHeader() {
        block8: {
            int count = 1;
            try {
                int token;
                while ((token = this.vanguardScanner.getNextToken()) != 0) {
                    if (token != 69) {
                        if (token == 8) {
                            ++count;
                        }
                        if (token == 12) {
                            --count;
                        }
                        if (token == 14) {
                            count -= 2;
                        }
                        if (token == 17) {
                            count -= 3;
                        }
                        if (count > 0) continue;
                        return this.vanguardScanner.getNextToken();
                    }
                    break;
                }
            }
            catch (InvalidInputException e) {
                if (e.getMessage().equals(INVALID_CHAR_IN_STRING)) break block8;
                e.printStackTrace();
            }
        }
        return 69;
    }

    private boolean disambiguaterecordWithLookAhead() {
        block4: {
            int lookAhead2;
            block5: {
                if (this.isInModuleDeclaration()) {
                    return false;
                }
                this.getVanguardParser();
                this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
                int lookAhead1 = this.vanguardScanner.getNextToken();
                if (lookAhead1 != 13) break block4;
                lookAhead2 = this.vanguardScanner.getNextToken();
                int n = lookAhead2 = lookAhead2 == 8 ? this.getNextTokenAfterTypeParameterHeader() : lookAhead2;
                if (lookAhead2 != 41) break block5;
                return true;
            }
            try {
                return lookAhead2 == 19;
            }
            catch (InvalidInputException e) {
                if (e.getMessage().equals(INVALID_CHAR_IN_STRING)) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disambiguateYieldWithLookAhead() {
        this.getVanguardParser();
        this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
        try {
            int lookAhead1 = this.vanguardScanner.getNextToken();
            switch (lookAhead1) {
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 38: 
                case 41: 
                case 68: 
                case 71: 
                case 74: 
                case 83: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 132: {
                    return false;
                }
                case 2: 
                case 3: {
                    int lookAhead2 = this.vanguardScanner.getNextToken();
                    return lookAhead2 == 13;
                }
            }
            return true;
        }
        catch (InvalidInputException e) {
            if (!e.getMessage().equals(INVALID_CHAR_IN_STRING)) {
                e.printStackTrace();
            }
            return false;
        }
    }

    int disambiguatedRestrictedIdentifierpermits(int restrictedIdentifierToken) {
        if (restrictedIdentifierToken != 140) {
            return restrictedIdentifierToken;
        }
        if (!JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 13;
        }
        return this.disambiguatesRestrictedIdentifierWithLookAhead(this::mayBeAtASealedRestricedIdentifier, restrictedIdentifierToken, Goal.RestrictedIdentifierPermitsGoal);
    }

    int disambiguatedRestrictedIdentifiersealed(int restrictedIdentifierToken) {
        if (restrictedIdentifierToken != 55) {
            return restrictedIdentifierToken;
        }
        if (!JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 13;
        }
        return this.disambiguatesRestrictedIdentifierWithLookAhead(this::mayBeAtASealedRestricedIdentifier, restrictedIdentifierToken, Goal.RestrictedIdentifierSealedGoal);
    }

    int disambiguatedRestrictedIdentifierWhen(int restrictedIdentifierToken) {
        if (restrictedIdentifierToken != 88) {
            return restrictedIdentifierToken;
        }
        if (this._isOTSource) {
            if (this._callinSeen) {
                return 88;
            }
            switch (this.lookBack[1]) {
                case 24: 
                case 33: {
                    return 88;
                }
            }
            switch (this.lookBack[0]) {
                case 75: 
                case 99: 
                case 152: {
                    return 88;
                }
            }
        }
        if (!JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(this.complianceLevel, this.previewEnabled)) {
            return 13;
        }
        return this.activeParser == null || !this.activeParser.automatonWillShift(88) ? 13 : 88;
    }

    int disambiguatedRestrictedIdentifierYield(int restrictedIdentifierToken) {
        if (restrictedIdentifierToken != 87) {
            return restrictedIdentifierToken;
        }
        if (this.sourceLevel < 0x3A0000L) {
            return 13;
        }
        return this.mayBeAtAnYieldStatement() && this.disambiguateYieldWithLookAhead() ? restrictedIdentifierToken : 13;
    }

    int disambiguatedRestrictedKeyword(int restrictedKeywordToken) {
        int token = restrictedKeywordToken;
        if (this.scanContext == ScanContext.EXPECTING_IDENTIFIER) {
            return 13;
        }
        switch (restrictedKeywordToken) {
            case 141: {
                if (this.scanContext != ScanContext.AFTER_REQUIRES) {
                    token = 13;
                    break;
                }
                this.getVanguardParser();
                this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1, true, ScanContext.EXPECTING_IDENTIFIER);
                try {
                    int lookAhead = this.vanguardScanner.getNextToken();
                    if (lookAhead != 25) break;
                    token = 13;
                }
                catch (InvalidInputException invalidInputException) {}
                break;
            }
            case 101: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 151: {
                if (this.scanContext == ScanContext.EXPECTING_KEYWORD) break;
                token = 13;
            }
        }
        return token;
    }

    int disambiguatesRestrictedIdentifierWithLookAhead(Predicate<Integer> checkPrecondition, int restrictedIdentifierToken, Goal goal) {
        if (checkPrecondition.test(restrictedIdentifierToken)) {
            VanguardParser vp = this.getNewVanguardParser();
            VanguardScanner vs = (VanguardScanner)vp.scanner;
            vs.resetTo(this.currentPosition, this.eofPosition - 1);
            if (vp.parse(goal)) {
                return restrictedIdentifierToken;
            }
        }
        return 13;
    }

    private VanguardScanner getNewVanguardScanner(char[] src) {
        VanguardScanner vs = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
        vs.setSource(src);
        vs.resetTo(0, src.length, this.isInModuleDeclaration(), this.scanContext);
        return vs;
    }

    private VanguardParser getNewVanguardParser(char[] src) {
        VanguardScanner vs = this.getNewVanguardScanner(src);
        VanguardParser vp = new VanguardParser(vs);
        vs.setActiveParser(vp);
        return vp;
    }

    int disambiguatedToken(int token, Scanner scanner) {
        VanguardParser parser = this.getVanguardParser();
        parser.scanner.caseStartPosition = this.caseStartPosition;
        if (token == 114 && this.mayBeAtCaseLabelExpr() && scanner.caseStartPosition != -1 && scanner.caseStartPosition < scanner.startPosition) {
            return this.disambiguateArrowWithCaseExpr(scanner, token);
        }
        if (token == 19 && this.maybeAtLambdaOrCast()) {
            if (parser.parse(Goal.LambdaParameterListGoal)) {
                scanner.nextToken = 19;
                return 53;
            }
            scanner.vanguardScanner.resetTo(scanner.startPosition, scanner.eofPosition - 1);
            if (parser.parse(Goal.IntersectionCastGoal)) {
                scanner.nextToken = 19;
                return 72;
            }
        } else if (token == 19 && this.maybeAtEnhForRecordPattern()) {
            if (parser.parse(Goal.RecordPatternGoal)) {
                scanner.nextToken = 149;
                return 19;
            }
        } else if (token == 8 && this.maybeAtReferenceExpression()) {
            if (parser.parse(Goal.ReferenceExpressionGoal)) {
                scanner.nextToken = 8;
                return 84;
            }
        } else if (token == 38 && this.atTypeAnnotation()) {
            if (this.atTypeAnchor()) {
                token = 128;
            } else {
                token = 26;
                if (this.maybeAtEllipsisAnnotationsStart() && parser.parse(Goal.VarargTypeAnnotationGoal)) {
                    scanner.consumingEllipsisAnnotations = true;
                    scanner.nextToken = 26;
                    return 147;
                }
            }
        }
        return token;
    }

    protected int disambiguateArrowWithCaseExpr(Scanner scanner, int retToken) {
        char[] nSource = CharOperation.append(Arrays.copyOfRange(scanner.source, scanner.caseStartPosition, scanner.startPosition), ':');
        VanguardParser vp = this.getNewVanguardParser(nSource);
        if (vp.parse(Goal.SwitchLabelCaseLhsGoal)) {
            scanner.nextToken = 114;
            retToken = 77;
        }
        return retToken;
    }

    int disambiguateCasePattern(int token, Scanner scanner) {
        int delta = token == 115 ? 4 : 0;
        VanguardParser parser = this.getNewVanguardParser();
        parser.scanner.resetTo(parser.scanner.currentPosition + delta, parser.scanner.eofPosition);
        parser.scanner.caseStartPosition = this.caseStartPosition;
        if (parser.parse(Goal.PatternGoal)) {
            if (token == 115) {
                scanner.nextToken = 148;
            } else {
                scanner.nextToken = token;
                token = 148;
            }
        }
        return token;
    }

    protected boolean mayBeAtCaseLabelExpr() {
        if (this.isInModuleDeclaration() || this.caseStartPosition <= 0) {
            return false;
        }
        if (this.lookBack[1] == 82) {
            return JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(this.complianceLevel, this.previewEnabled) ? this.lookBack[0] == 115 || this.lookBack[0] == 32 : false;
        }
        return true;
    }

    protected boolean isAtAssistIdentifier() {
        return false;
    }

    public int fastForward(Statement unused) {
        block8: while (true) {
            int token;
            try {
                token = this.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                return 69;
            }
            switch (token) {
                case 13: {
                    if (this.isAtAssistIdentifier()) {
                        return token;
                    }
                }
                case 2: 
                case 3: 
                case 8: 
                case 19: 
                case 26: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 75: 
                case 77: 
                case 78: 
                case 79: 
                case 82: 
                case 85: 
                case 86: 
                case 87: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 115: 
                case 116: 
                case 117: 
                case 119: 
                case 120: 
                case 121: 
                case 123: 
                case 124: 
                case 125: 
                case 127: {
                    if (!this.getVanguardParser().parse(Goal.BlockStatementoptGoal)) continue block8;
                    return token;
                }
                case 25: 
                case 69: {
                    return token;
                }
                case 34: {
                    this.ungetToken(token);
                    return 25;
                }
            }
        }
    }

    protected int getNextNotFakedToken() throws InvalidInputException {
        return this.getNextToken();
    }

    protected static InvalidInputException invalidCharacter() {
        return new InvalidInputException(INVALID_CHARACTER_CONSTANT);
    }

    protected static InvalidInputException invalidCharInString() {
        return new InvalidInputException(INVALID_CHAR_IN_STRING);
    }

    protected static InvalidInputException unterminatedString() {
        return new InvalidInputException(UNTERMINATED_STRING);
    }

    protected static InvalidInputException invalidUnicodeEscape() {
        return new InvalidInputException(INVALID_UNICODE_ESCAPE);
    }

    protected static InvalidInputException invalidLowSurrogate() {
        return new InvalidInputException(INVALID_LOW_SURROGATE);
    }

    protected static InvalidInputException invalidHighSurrogate() {
        return new InvalidInputException(INVALID_HIGH_SURROGATE);
    }

    protected static InvalidInputException unterminatedComment() {
        return new InvalidInputException(UNTERMINATED_COMMENT);
    }

    protected static InvalidInputException unterminatedTextBlock() {
        return new InvalidInputException(UNTERMINATED_TEXT_BLOCK);
    }

    protected static InvalidInputException invalidEof() {
        return new InvalidInputException("Ctrl-Z");
    }

    protected static InvalidInputException invalidUnderscore() {
        return new InvalidInputException(INVALID_UNDERSCORE);
    }

    protected static InvalidInputException invalidUnderscoresInLiterals() {
        return new InvalidInputException(UNDERSCORES_IN_LITERALS_NOT_BELOW_17);
    }

    protected static InvalidInputException invalidEscape() {
        return new InvalidInputException(INVALID_ESCAPE);
    }

    protected static InvalidInputException invalidHexa() {
        return new InvalidInputException(INVALID_HEXA);
    }

    protected static InvalidInputException illegalHexaLiteral() {
        return new InvalidInputException(ILLEGAL_HEXA_LITERAL);
    }

    protected static InvalidInputException invalidFloat() {
        return new InvalidInputException(INVALID_FLOAT);
    }

    protected static InvalidInputException invalidBinaryLiteral() {
        return new InvalidInputException(BINARY_LITERAL_NOT_BELOW_17);
    }

    protected static InvalidInputException invalidBinary() {
        return new InvalidInputException(INVALID_BINARY);
    }

    public static InvalidInputException invalidToken(int token) {
        return new InvalidInputException("Unknown token (check Scanner/TerminalTokens): " + token);
    }

    public static InvalidInputException invalidInput() {
        return new InvalidInputException();
    }

    protected class BindoutLookahead {
        LookaheadState state = LookaheadState.INIT;
        int[] tokens = new int[2];
        char[] identifier = null;
        int[][] positions = new int[2][];

        public BindoutLookahead() throws InvalidInputException {
            int token = this.tokens[0] = Scanner.this.getNextToken0();
            this.positions[0] = new int[]{Scanner.this.startPosition, Scanner.this.currentPosition};
            if (token == 13) {
                this.state = LookaheadState.ID_SEEN;
                this.identifier = Scanner.this.getCurrentIdentifierSource();
            }
        }

        public char[] getIdentifier() {
            if (this.state == LookaheadState.TWO_TOKENS) {
                return this.identifier;
            }
            return null;
        }

        public int getNextToken() throws InvalidInputException {
            switch (this.state) {
                case INIT: {
                    this.state = LookaheadState.ONE_TOKEN;
                    return 0;
                }
                case ONE_TOKEN: {
                    Scanner.this._bindoutLookahead = null;
                    return this.popToken(0);
                }
                case ID_SEEN: {
                    this.tokens[1] = Scanner.this.getNextToken0();
                    this.positions[1] = new int[]{Scanner.this.startPosition, Scanner.this.currentPosition};
                    this.state = LookaheadState.TWO_TOKENS;
                    switch (this.tokens[1]) {
                        case 25: 
                        case 32: 
                        case 34: {
                            return 73;
                        }
                    }
                    return 114;
                }
                case TWO_TOKENS: {
                    this.state = LookaheadState.ID_CONSUMED;
                    return this.popToken(0);
                }
                case ID_CONSUMED: {
                    Scanner.this._bindoutLookahead = null;
                    return this.popToken(1);
                }
            }
            return 0;
        }

        private int popToken(int i) {
            Scanner.this.startPosition = this.positions[i][0];
            Scanner.this.currentPosition = this.positions[i][1];
            return this.tokens[i];
        }
    }

    private static class Goal {
        int first;
        int[] follow;
        int[] rules;
        static int LambdaParameterListRule = 0;
        static int IntersectionCastRule = 0;
        static int ReferenceExpressionRule = 0;
        static int VarargTypeAnnotationsRule = 0;
        static int BlockStatementoptRule = 0;
        static int YieldStatementRule = 0;
        static int SwitchLabelCaseLhsRule = 0;
        static int[] RestrictedIdentifierSealedRule;
        static int[] RestrictedIdentifierPermitsRule;
        static int[] PatternRules;
        static int RecordPatternRule;
        static Goal LambdaParameterListGoal;
        static Goal IntersectionCastGoal;
        static Goal VarargTypeAnnotationGoal;
        static Goal ReferenceExpressionGoal;
        static Goal BlockStatementoptGoal;
        static Goal YieldStatementGoal;
        static Goal SwitchLabelCaseLhsGoal;
        static Goal RestrictedIdentifierSealedGoal;
        static Goal RestrictedIdentifierPermitsGoal;
        static Goal PatternGoal;
        static Goal RecordPatternGoal;
        static int[] RestrictedIdentifierSealedFollow;
        static int[] RestrictedIdentifierPermitsFollow;
        static int[] PatternCaseLabelFollow;
        static int[] RecordPatternFollow;

        static {
            RecordPatternRule = 0;
            RestrictedIdentifierSealedFollow = new int[]{75, 78, 79, 80};
            RestrictedIdentifierPermitsFollow = new int[]{41};
            PatternCaseLabelFollow = new int[]{68, 114, 32, 77, 88};
            RecordPatternFollow = new int[]{68};
            ArrayList<Integer> ridSealed = new ArrayList<Integer>(2);
            ArrayList<Integer> ridPermits = new ArrayList<Integer>();
            ArrayList<Integer> patternStates = new ArrayList<Integer>();
            int i = 1;
            while (i <= 1126) {
                if ("ParenthesizedLambdaParameterList".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    LambdaParameterListRule = i;
                } else if ("ParenthesizedCastNameAndBounds".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    IntersectionCastRule = i;
                } else if ("ReferenceExpressionTypeArgumentsAndTrunk".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    ReferenceExpressionRule = i;
                } else if ("TypeAnnotations".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    VarargTypeAnnotationsRule = i;
                } else if ("BlockStatementopt".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    BlockStatementoptRule = i;
                } else if ("YieldStatement".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    YieldStatementRule = i;
                } else if ("Modifiersopt".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    ridSealed.add(i);
                } else if ("PermittedSubclasses".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    ridPermits.add(i);
                } else if ("SwitchLabelCaseLhs".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    SwitchLabelCaseLhsRule = i;
                } else if ("TypePattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                } else if ("Pattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                } else if ("ParenthesizedPattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                } else if ("RecordPattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                    RecordPatternRule = i;
                }
                ++i;
            }
            RestrictedIdentifierSealedRule = ridSealed.stream().mapToInt(Integer::intValue).toArray();
            RestrictedIdentifierPermitsRule = ridPermits.stream().mapToInt(Integer::intValue).toArray();
            PatternRules = patternStates.stream().mapToInt(Integer::intValue).toArray();
            LambdaParameterListGoal = new Goal(114, new int[]{114}, LambdaParameterListRule);
            IntersectionCastGoal = new Goal(19, Goal.followSetOfCast(), IntersectionCastRule);
            VarargTypeAnnotationGoal = new Goal(38, new int[]{132}, VarargTypeAnnotationsRule);
            ReferenceExpressionGoal = new Goal(8, new int[]{7}, ReferenceExpressionRule);
            BlockStatementoptGoal = new Goal(41, new int[0], BlockStatementoptRule);
            YieldStatementGoal = new Goal(114, new int[0], YieldStatementRule);
            SwitchLabelCaseLhsGoal = new Goal(114, new int[0], SwitchLabelCaseLhsRule);
            RestrictedIdentifierSealedGoal = new Goal(55, RestrictedIdentifierSealedFollow, RestrictedIdentifierSealedRule);
            RestrictedIdentifierPermitsGoal = new Goal(140, RestrictedIdentifierPermitsFollow, RestrictedIdentifierPermitsRule);
            PatternGoal = new Goal(148, PatternCaseLabelFollow, PatternRules);
            RecordPatternGoal = new Goal(29, RecordPatternFollow, RecordPatternRule);
        }

        Goal(int first, int[] follow, int rule) {
            this.first = first;
            this.follow = follow;
            this.rules = new int[]{rule};
        }

        Goal(int first, int[] follow, int[] rules) {
            this.first = first;
            this.follow = follow;
            this.rules = rules;
        }

        boolean hasBeenReached(int act, int token) {
            boolean foundRule = false;
            int[] nArray = this.rules;
            int n = this.rules.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (act == i) {
                    foundRule = true;
                    break;
                }
                ++n2;
            }
            if (foundRule) {
                int length = this.follow.length;
                if (length == 0) {
                    return true;
                }
                int i = 0;
                while (i < length) {
                    if (this.follow[i] == token) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private static int[] followSetOfCast() {
            return new int[]{13, 37, 35, 36, 42, 45, 43, 46, 47, 48, 49, 50, 51, 52, 70, 71, 19};
        }
    }

    static enum LookaheadState {
        INIT,
        ONE_TOKEN,
        ID_SEEN,
        TWO_TOKENS,
        ID_CONSUMED;

    }

    static enum ScanContext {
        EXPECTING_KEYWORD,
        EXPECTING_IDENTIFIER,
        AFTER_REQUIRES,
        INACTIVE;

    }

    private class ScanContextDetector
    extends VanguardParser {
        ScanContextDetector(CompilerOptions options) {
            super(new ProblemReporter(DefaultErrorHandlingPolicies.ignoreAllProblems(), options, new DefaultProblemFactory()));
            this.problemReporter.options.performStatementsRecovery = false;
            this.reportSyntaxErrorIsRequired = false;
            this.reportOnlyOneSyntaxError = false;
        }

        @Override
        public void initializeScanner() {
            this.scanner = new Scanner(false, false, false, this.options.sourceLevel, this.options.complianceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive, this.options.enablePreviewFeatures){

                @Override
                void updateScanContext(int token) {
                    if (token != 69) {
                        super.updateScanContext(token);
                    }
                }
            };
            this.scanner.recordLineSeparator = false;
            this.scanner.setActiveParser(this);
            this.scanner.previewEnabled = this.options.enablePreviewFeatures;
        }

        @Override
        public boolean isParsingModuleDeclaration() {
            return true;
        }

        public ScanContext getScanContext(char[] src, int begin) {
            this.scanner.setSource(src);
            this.scanner.resetTo(0, begin);
            this.goForCompilationUnit();
            Goal goal = new Goal(2, null, 0){

                @Override
                boolean hasBeenReached(int act, int token) {
                    return token == 69;
                }
            };
            this.parse(goal);
            return this.scanner.scanContext;
        }
    }

    private static class VanguardParser
    extends Parser {
        public static final boolean SUCCESS = true;
        public static final boolean FAILURE = false;
        Goal currentGoal;

        public VanguardParser(VanguardScanner scanner) {
            this.scanner = scanner;
        }

        public VanguardParser(ProblemReporter reporter) {
            super(reporter, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean parse(Goal goal) {
            this.currentGoal = goal;
            try {
                int act = 1436;
                this.stateStackTop = -1;
                this.currentToken = goal.first;
                while (true) {
                    int stackLength;
                    if (++this.stateStackTop >= (stackLength = this.stack.length)) {
                        this.stack = new int[stackLength + 255];
                        System.arraycopy(this.stack, 0, this.stack, 0, stackLength);
                    }
                    this.stack[this.stateStackTop] = act;
                    if ((act = Parser.tAction(act, this.currentToken)) == 21631) {
                        return false;
                    }
                    if (act <= 1126) {
                        --this.stateStackTop;
                    } else if (act > 21631) {
                        this.unstackedAct = act;
                        try {
                            this.currentToken = this.scanner.getNextToken();
                        }
                        finally {
                            this.unstackedAct = 21631;
                        }
                        act -= 21631;
                    } else {
                        if (act >= 21630) {
                            return false;
                        }
                        this.unstackedAct = act;
                        try {
                            this.currentToken = this.scanner.getNextToken();
                        }
                        finally {
                            this.unstackedAct = 21631;
                        }
                        continue;
                    }
                    do {
                        int reskw;
                        if (goal.hasBeenReached(act, this.currentToken)) {
                            return true;
                        }
                        if (this.currentToken == 13 && (reskw = TerminalTokens.getRestrictedKeyword(this.scanner.getCurrentIdentifierSource())) != 0 && goal.hasBeenReached(act, reskw)) {
                            return true;
                        }
                        this.stateStackTop -= Parser.rhs[act] - '\u0001';
                    } while ((act = Parser.ntAction(this.stack[this.stateStackTop], Parser.lhs[act])) <= 1126);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public String toString() {
            return "\n\n\n----------------Scanner--------------\n" + this.scanner.toString();
        }
    }

    private static final class VanguardScanner
    extends Scanner {
        public VanguardScanner(long sourceLevel, long complianceLevel, boolean previewEnabled) {
            super(false, false, false, sourceLevel, complianceLevel, null, null, false, previewEnabled);
        }

        @Override
        public int getNextToken() throws InvalidInputException {
            if (this.nextToken != 0) {
                int token = this.nextToken;
                this.nextToken = 0;
                return token;
            }
            if (this.scanContext == null) {
                this.scanContext = this.isInModuleDeclaration() ? ScanContext.EXPECTING_KEYWORD : ScanContext.INACTIVE;
            }
            int token = this.getNextToken0();
            this.updateCase(token);
            if (this.areRestrictedModuleKeywordsActive()) {
                if (VanguardScanner.isRestrictedKeyword(token)) {
                    token = this.disambiguatedRestrictedKeyword(token);
                }
                this.updateScanContext(token);
            } else if (this.mayBeAtCasePattern(token)) {
                token = this.disambiguateCasePattern(token, this);
            } else if (token == 114 && this.mayBeAtCaseLabelExpr() && this.caseStartPosition < this.startPosition) {
                token = this.disambiguateArrowWithCaseExpr(this, token);
            } else if (token == 38 && this.atTypeAnnotation()) {
                token = ((VanguardParser)this.activeParser).currentGoal == Goal.LambdaParameterListGoal ? this.disambiguatedToken(token, this) : 26;
            }
            this.addTokenToLookBack(token);
            this.multiCaseLabelComma = false;
            return token == 69 ? 0 : token;
        }
    }
}

