/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;

public class TypeParameter
extends SourceRefElement
implements ITypeParameter {
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    protected String name;
    public boolean isValueParameter = false;
    public boolean hasBaseBound = false;

    public TypeParameter(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TypeParameter)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String[] getBounds() throws JavaModelException {
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return CharOperation.toStrings((char[][])info.bounds);
    }

    @Override
    public String[] getBoundsSignatures() throws JavaModelException {
        String[] boundSignatures = null;
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        if (this.getParent() instanceof BinaryMember) {
            char[][] boundsSignatures = info.boundsSignatures;
            if (boundsSignatures == null || boundsSignatures.length == 0) {
                return CharOperation.NO_STRINGS;
            }
            return CharOperation.toStrings((char[][])info.boundsSignatures);
        }
        char[][] bounds = info.bounds;
        if (bounds == null || bounds.length == 0) {
            return CharOperation.NO_STRINGS;
        }
        int boundsLength = bounds.length;
        boundSignatures = new String[boundsLength];
        int i = 0;
        while (i < boundsLength) {
            boundSignatures[i] = new String(Signature.createCharArrayTypeSignature(bounds[i], false));
            ++i;
        }
        return boundSignatures;
    }

    @Override
    public IMember getDeclaringMember() {
        return (IMember)((Object)this.getParent());
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 15;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return ']';
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        StringBuilder buf = new StringBuilder();
        if (this.getParent() instanceof IType) {
            if (this.getParent() instanceof BinaryType) {
                buf.append(((BinaryType)this.getParent()).getKey(forceOpen));
            } else {
                buf.append(((IType)((Object)this.getParent())).getKey());
            }
        } else if (this.getParent() instanceof IMember) {
            if (this.getParent() instanceof BinaryMember) {
                buf.append(((BinaryMember)this.getParent()).getKey(forceOpen));
            } else {
                buf.append(((IMethod)((Object)this.getParent())).getKey());
            }
        }
        buf.append(":T");
        buf.append(this.name);
        buf.append(';');
        return buf.toString();
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return new SourceRange(info.nameStart, info.nameEnd - info.nameStart + 1);
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    @Override
    public IClassFile getClassFile() {
        return this.getParent().getClassFile();
    }

    @Override
    public ITypeRoot getTypeRoot() {
        return this.getDeclaringMember().getTypeRoot();
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append('<');
        if (this.isValueParameter) {
            try {
                buffer.append(this.getBounds()[0]);
                buffer.append(' ');
            }
            catch (JavaModelException javaModelException) {}
        }
        buffer.append(this.getElementName());
        buffer.append('>');
    }
}

