/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.ITranslationStates;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

public class StateMemento {
    private int _state = 0;
    private boolean _methodResolveStarted = false;
    private int _currentlyProcessingState = 0;
    private int _completingBindingsStep = 0;
    private int _requestedState = 0;
    private HashMap<Integer, List<Runnable>> _pendingJobs = new HashMap();

    public int getProcessingState() {
        return Math.max(this._state, this._currentlyProcessingState);
    }

    public int getState() {
        return this._state;
    }

    public boolean isReadyToProcess(int state) {
        if (this._currentlyProcessingState == 0 || this._state >= state) {
            return true;
        }
        if (this._currentlyProcessingState < state) {
            this._requestedState = Math.max(this._requestedState, state);
        }
        return false;
    }

    public void inititalize(int initState) {
        if (this._state == 0) {
            this._state = initState;
        }
    }

    public int setState(int state) {
        int oldState = this._state;
        if (state >= this._currentlyProcessingState) {
            this._currentlyProcessingState = 0;
        }
        if (state >= this._requestedState) {
            this._requestedState = 0;
        }
        if (state > this._state) {
            this._state = state;
        }
        return oldState;
    }

    void startProcessing(int state, int step) {
        this._currentlyProcessingState = Math.max(this._currentlyProcessingState, state);
        this._completingBindingsStep = Math.max(this._completingBindingsStep, step);
    }

    public boolean isBlocking(TeamModel teamModel, int state, int step) {
        if (!teamModel._blockCatchup) {
            return false;
        }
        if (this._currentlyProcessingState == 0) {
            return false;
        }
        if (state < this._currentlyProcessingState) {
            return false;
        }
        if (state >= 4 && state <= 9) {
            return step < this._completingBindingsStep;
        }
        return true;
    }

    public void requestState(TypeDeclaration typeDecl, int state) {
        if (typeDecl != null && typeDecl.compilationUnit != null) {
            StateMemento unitState = typeDecl.compilationUnit.state;
            if (state > unitState._currentlyProcessingState) {
                unitState._requestedState = Math.max(state, unitState._requestedState);
                return;
            }
        }
        if (state > this._currentlyProcessingState) {
            this._requestedState = state;
        }
    }

    int fetchRequestedState() {
        int oldRequest = this._requestedState;
        this._requestedState = 0;
        return oldRequest;
    }

    public void handleRequest(CompilationUnitDeclaration unit, int requested) {
        if (Config.getBundledCompleteTypeBindingsMode()) {
            int envStateCompleted;
            LookupEnvironment env = null;
            if (unit.scope != null) {
                env = unit.scope.environment;
            }
            if (env == null) {
                try {
                    env = Config.getLookupEnvironment();
                }
                catch (Config.NotConfiguredException e) {
                    e.logWarning("Cannot handle processing request");
                }
            }
            if (env != null && (envStateCompleted = env.getDependenciesStateCompleted()) < requested) {
                this._requestedState = Math.max(requested, this._requestedState);
                if (envStateCompleted > this._state) {
                    Dependencies.ensureState(unit, envStateCompleted);
                }
                return;
            }
        }
        if (this._currentlyProcessingState == 0) {
            if (this._requestedState > this._state) {
                if (this.isBlocked(unit, requested = Math.max(requested, this._requestedState))) {
                    return;
                }
                this._requestedState = 0;
            }
            if (requested > this._state) {
                Dependencies.ensureState(unit, requested);
            }
        } else {
            this._requestedState = Math.max(this._requestedState, requested);
        }
    }

    private boolean isBlocked(CompilationUnitDeclaration unit, int requested) {
        TypeDeclaration enclosingType;
        if (unit.isRoleUnit() && unit.types != null && unit.types.length > 0 && (enclosingType = unit.types[0].enclosingType) != null && enclosingType.isTeam()) {
            return enclosingType.getTeamModel()._blockCatchup;
        }
        return false;
    }

    public void addJob(int state, Runnable job) {
        if (state <= this._state) {
            job.run();
            return;
        }
        List<Runnable> jobs = this._pendingJobs.get(state);
        if (jobs == null) {
            jobs = new ArrayList<Runnable>();
            this._pendingJobs.put(state, jobs);
        }
        jobs.add(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingJobs(int state) {
        List<Runnable> jobs;
        StateMemento stateMemento = this;
        synchronized (stateMemento) {
            jobs = this._pendingJobs.remove(state);
        }
        if (jobs != null) {
            for (Runnable job : jobs) {
                job.run();
            }
        }
    }

    public String toString() {
        Object result = ITranslationStates.STATE_NAMES[this._state];
        if (this._currentlyProcessingState > 0) {
            result = (String)result + " c:" + this._currentlyProcessingState;
        }
        if (this._requestedState > 0) {
            result = (String)result + " r:" + this._requestedState;
        }
        return result;
    }

    public void assertState(int state, String msg) {
        if (this._state < state) {
            throw new InternalCompilerError(msg);
        }
    }

    public int startProcessing(int state) {
        int previous = this._currentlyProcessingState;
        this._currentlyProcessingState = Math.max(this._currentlyProcessingState, state);
        return previous;
    }

    public static boolean hasMethodResolveStarted(ReferenceBinding type) {
        return StateHelper.getState((ReferenceBinding)type)._methodResolveStarted;
    }

    public static void methodResolveStart(ReferenceBinding type) {
        StateHelper.getState((ReferenceBinding)type)._methodResolveStarted = true;
    }

    public boolean hasMethodResolveStarted() {
        return this._methodResolveStarted;
    }
}

