/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.transformer.jplis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.ClassRepository;
import org.eclipse.objectteams.otredyn.bytecode.asm.MarkAsStepOverAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.WeavableRegionReader;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.eclipse.objectteams.runtime.IReweavingTask;

public class ObjectTeamsTransformer
implements ClassFileTransformer {
    private static final boolean PWR_DEBUG = Boolean.getBoolean("ot.debug.pwr");
    public static final ThreadLocal<Boolean> initiatedByThrowAwayLoader = new ThreadLocal();
    private IWeavingContext weavingContext;
    private Set<@NonNull String> boundBaseClassNames = new HashSet<String>();

    public ObjectTeamsTransformer() {
        this.weavingContext = new IWeavingContext(){

            @Override
            public boolean isWeavable(String className, boolean considerSupers, boolean allWeavingReasons) {
                return ObjectTeamsTransformer.isWeavable(className.replace('.', '/')) && WeavableRegionReader.isWeavable(className);
            }

            @Override
            public boolean scheduleReweaving(@NonNull String className, @NonNull IReweavingTask task) {
                return false;
            }
        };
    }

    public ObjectTeamsTransformer(IWeavingContext weavingContext) {
        this.weavingContext = weavingContext;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            return this.transform(loader, className, className, classBeingRedefined, classfileBuffer);
        }
        catch (IllegalClassFormatException e) {
            e.printStackTrace();
            return classfileBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(ClassLoader loader, String className, String classId, Class<?> classBeingRedefined, byte[] classfileBuffer) throws IllegalClassFormatException {
        String sourceClassName;
        if (className == null) {
            return null;
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((sourceClassName = className.replace('/', '.')).equals("org.eclipse.objectteams.otredyn.runtime.TeamManager")) {
            return MarkAsStepOverAdapter.transformTeamManager(classfileBuffer, loader);
        }
        if (className.equals("org/objectteams/ITeamManager")) {
            return null;
        }
        ClassRepository classRepo = ClassRepository.getInstance();
        AbstractBoundClass clazz = classRepo.peekBoundClass(classId);
        if (!this.weavingContext.isWeavable(sourceClassName, true, true) || loader == null) {
            if (clazz != null) {
                if (ObjectTeamsTransformer.isWeavable(className) && clazz.needsWeaving()) {
                    new LinkageError("Classs " + className + " requires weaving, but is not weavable!").printStackTrace();
                } else {
                    clazz.markAsUnweavable();
                }
            }
            return null;
        }
        if (PWR_DEBUG) {
            System.out.println("weaving " + className);
        }
        if (clazz == null) {
            clazz = classRepo.getBoundClass(sourceClassName, classId, loader);
        }
        boolean isHCR = false;
        if (classBeingRedefined == null && (classBeingRedefined = ClassRepository.popClassBeingRedefined(sourceClassName)) != null) {
            isHCR = true;
        }
        AbstractBoundClass abstractBoundClass = clazz;
        synchronized (abstractBoundClass) {
            block30: {
                block28: {
                    if (classBeingRedefined == null && !clazz.isFirstTransformation()) {
                        if (PWR_DEBUG) {
                            System.out.println("\tweave1");
                        }
                        return clazz.getBytecode();
                    }
                    if (!clazz.isTransformationActive()) break block28;
                    if (PWR_DEBUG) {
                        System.out.println("\tweave2");
                    }
                    return null;
                }
                try {
                    try {
                        clazz.startTransaction();
                        clazz = classRepo.getBoundClass(className, classId, classfileBuffer, loader, isHCR);
                        clazz.setWeavingContext(this.weavingContext);
                        if (!clazz.isInterface()) {
                            classRepo.linkClassWithSuperclass(clazz);
                        }
                        if (!clazz.isInterface() || clazz.isRole()) {
                            clazz.transformAtLoadTime();
                        }
                        classfileBuffer = clazz.getBytecode();
                    }
                    catch (IllegalClassFormatException e) {
                        if (PWR_DEBUG) {
                            System.out.println("\tweave" + e);
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        clazz.commitTransaction(classBeingRedefined);
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    clazz.commitTransaction(classBeingRedefined);
                    throw throwable;
                }
                clazz.commitTransaction(classBeingRedefined);
            }
        }
        if (PWR_DEBUG) {
            System.out.println("\tweave3");
        }
        clazz.dump(classfileBuffer, "initial");
        Collection<@NonNull String> boundBaseClasses = clazz.getBoundBaseClasses();
        if (boundBaseClasses != null) {
            this.boundBaseClassNames.addAll(boundBaseClasses);
        }
        return classfileBuffer;
    }

    public static boolean isWeavable(String className) {
        switch (className.charAt(0)) {
            case 'o': {
                if (!className.startsWith("org/eclipse/objectteams/otre") && !className.startsWith("org/objectteams/") && !className.startsWith("org/objectweb/asm")) break;
                return false;
            }
            case 's': {
                if (!className.startsWith("sun/misc") && !className.startsWith("sun/launcher") && !className.startsWith("sun/nio/cs")) break;
                return false;
            }
            case 'j': {
                if (!className.equals("java/util/LinkedHashMap$KeyIterator") && !className.startsWith("java/lang") && !className.startsWith("java/util") && !className.startsWith("java/io") && !className.equals("java/nio/charset/StandardCharsets") && !className.startsWith("jdk/jfr") && !className.contains("$Proxy")) break;
                return false;
            }
            case '$': {
                return false;
            }
        }
        return true;
    }

    public void readOTAttributes(String className, String classId, InputStream inputStream, ClassLoader loader) throws ClassFormatError, IOException {
        Collection<String> boundBaseClasses;
        AbstractBoundClass clazz = ClassRepository.getInstance().getBoundClass(className.replace('/', '.'), classId, loader);
        if (!clazz.isFirstTransformation()) {
            return;
        }
        try {
            if (clazz.isTransformationActive()) {
                return;
            }
            int available = inputStream.available();
            byte[] bytes = new byte[available];
            new DataInputStream(inputStream).readFully(bytes);
            clazz = ClassRepository.getInstance().getBoundClass(className, classId, bytes, loader, false);
            if (!clazz.isInterface()) {
                ClassRepository.getInstance().linkClassWithSuperclass(clazz);
            }
            if (!clazz.isInterface() || clazz.isRole()) {
                clazz.parseBytecode();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if ((boundBaseClasses = clazz.getBoundBaseClasses()) != null) {
            this.boundBaseClassNames.addAll(boundBaseClasses);
        }
    }

    public Collection<@NonNull String> fetchAdaptedBases() {
        try {
            Set<String> set = this.boundBaseClassNames;
            return set;
        }
        finally {
            this.boundBaseClassNames = new HashSet<String>();
        }
    }
}

