/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJMod;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathJrtWithReleaseOption;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiReleaseJar;

public abstract class ClasspathLocation {
    protected IModule module;
    protected IUpdatableModule.UpdatesByKind updates;
    protected Set<String> limitModuleNames = null;
    protected String patchModuleName = null;
    protected String externalAnnotationPath;
    private Collection<ClasspathLocation> allLocationsForEEA;
    protected ZipFile annotationZipFile;
    protected AccessRuleSet accessRuleSet;

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3, String var4);

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3, String var4, boolean var5, Predicate<String> var6);

    public abstract boolean isPackage(String var1, String var2);

    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        return this.singletonModuleNameIf(this.isPackage(qualifiedPackageName, moduleName));
    }

    public boolean hasModule() {
        return this.getModule() != null;
    }

    public abstract boolean hasCompilationUnit(String var1, String var2);

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        String fileName = new String(typeName);
        return this.findClass(fileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule getModule() {
        return this.module;
    }

    protected boolean areAllModuleOptionsEqual(ClasspathLocation other) {
        if (this.patchModuleName != null) {
            if (other.patchModuleName == null) {
                return false;
            }
            if (!this.patchModuleName.equals(other.patchModuleName)) {
                return false;
            }
        } else if (other.patchModuleName != null) {
            return false;
        }
        if (this.limitModuleNames != null) {
            if (other.limitModuleNames == null) {
                return false;
            }
            if (other.limitModuleNames.size() != this.limitModuleNames.size()) {
                return false;
            }
            if (!this.limitModuleNames.containsAll(other.limitModuleNames)) {
                return false;
            }
        } else if (other.limitModuleNames != null) {
            return false;
        }
        if (this.updates != null) {
            if (other.updates == null) {
                return false;
            }
            List packageUpdates = this.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
            List otherPackageUpdates = other.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
            if (packageUpdates != null) {
                if (otherPackageUpdates == null) {
                    return false;
                }
                if (packageUpdates.size() != otherPackageUpdates.size()) {
                    return false;
                }
                if (!packageUpdates.containsAll(otherPackageUpdates)) {
                    return false;
                }
            } else if (otherPackageUpdates != null) {
                return false;
            }
            List moduleUpdates = this.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
            List otherModuleUpdates = other.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
            if (moduleUpdates != null) {
                if (otherModuleUpdates == null) {
                    return false;
                }
                if (moduleUpdates.size() != otherModuleUpdates.size()) {
                    return false;
                }
                if (!moduleUpdates.containsAll(otherModuleUpdates)) {
                    return false;
                }
            } else if (otherModuleUpdates != null) {
                return false;
            }
        } else if (other.updates != null) {
            return false;
        }
        return true;
    }

    static ClasspathLocation forSourceFolder(IContainer sourceFolder, IContainer outputFolder, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean ignoreOptionalProblems, IPath externalAnnotationPath) {
        return new ClasspathMultiDirectory(sourceFolder, outputFolder, inclusionPatterns, exclusionPatterns, ignoreOptionalProblems, externalAnnotationPath);
    }

    public static ClasspathLocation forBinaryFolder(IContainer binaryFolder, boolean isOutputFolder, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean autoModule) {
        return new ClasspathDirectory(binaryFolder, isOutputFolder, accessRuleSet, externalAnnotationPath, autoModule);
    }

    static ClasspathLocation forLibrary(String libraryPathname, long lastModified, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean isOnModulePath, String compliance) {
        return Util.archiveFormat((String)libraryPathname) == 1 ? new ClasspathJMod(libraryPathname, lastModified, accessRuleSet, annotationsPath) : (compliance == null || CompilerOptions.versionToJdkLevel((String)compliance) < 0x350000L ? new ClasspathJar(libraryPathname, lastModified, accessRuleSet, annotationsPath, isOnModulePath) : new ClasspathMultiReleaseJar(libraryPathname, lastModified, accessRuleSet, annotationsPath, isOnModulePath, compliance));
    }

    public static ClasspathJrt forJrtSystem(String jrtPath, AccessRuleSet accessRuleSet, IPath annotationsPath, String release) throws CoreException {
        boolean useRelease;
        boolean bl = useRelease = release != null && !release.isEmpty();
        if (useRelease) {
            boolean sameRelease;
            String jrtVersion = JRTUtil.getJdkRelease((File)new File(jrtPath));
            boolean bl2 = sameRelease = JavaCore.compareJavaVersions(jrtVersion, release) == 0;
            if (sameRelease) {
                useRelease = false;
            }
        }
        return useRelease ? new ClasspathJrtWithReleaseOption(jrtPath, accessRuleSet, annotationsPath, release) : new ClasspathJrt(jrtPath, accessRuleSet, annotationsPath);
    }

    public static ClasspathLocation forLibrary(String libraryPathname, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean isOnModulePath, String compliance) {
        return ClasspathLocation.forLibrary(libraryPathname, 0L, accessRuleSet, annotationsPath, isOnModulePath, compliance);
    }

    public static ClasspathLocation forLibrary(IFile library, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean isOnModulePath, String compliance) {
        return CompilerOptions.versionToJdkLevel((String)compliance) < 0x350000L ? new ClasspathJar(library, accessRuleSet, annotationsPath, isOnModulePath) : new ClasspathMultiReleaseJar(library, accessRuleSet, annotationsPath, isOnModulePath, compliance);
    }

    public static ClasspathLocation forLibrary(ZipFile zipFile, AccessRuleSet accessRuleSet, boolean isOnModulePath, String compliance) {
        return CompilerOptions.versionToJdkLevel((String)compliance) < 0x350000L ? new ClasspathJar(zipFile, accessRuleSet, isOnModulePath) : new ClasspathMultiReleaseJar(zipFile, accessRuleSet, isOnModulePath, compliance);
    }

    public abstract IPath getProjectRelativePath();

    public boolean isOutputFolder() {
        return false;
    }

    public void cleanup() {
    }

    public void reset() {
    }

    public abstract String debugPathString();

    public char[][] singletonModuleNameIf(boolean condition) {
        if (!condition) {
            return null;
        }
        if (this.module != null) {
            return new char[][]{this.module.name()};
        }
        return new char[][]{ModuleBinding.UNNAMED};
    }

    public char[][] listPackages() {
        return CharOperation.NO_CHAR_CHAR;
    }

    protected IBinaryType decorateWithExternalAnnotations(IBinaryType reader, String fileNameWithoutExtension) {
        return reader;
    }

    protected NameEnvironmentAnswer createAnswer(String fileNameWithoutExtension, IBinaryType reader, char[] moduleName) {
        if (this.externalAnnotationPath != null) {
            try {
                if (this.annotationZipFile == null) {
                    this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile((String)this.externalAnnotationPath, null);
                }
                if ((reader = ExternalAnnotationDecorator.create((IBinaryType)reader, (String)this.externalAnnotationPath, (String)fileNameWithoutExtension, (ZipFile)this.annotationZipFile)).getExternalAnnotationStatus() == BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED) {
                    reader = new ExternalAnnotationDecorator(reader, null);
                }
            }
            catch (IOException iOException) {}
        } else if (this.allLocationsForEEA != null) {
            boolean isAnnotated = false;
            for (ClasspathLocation annotationLocation : this.allLocationsForEEA) {
                reader = annotationLocation.decorateWithExternalAnnotations(reader, fileNameWithoutExtension);
                if (reader.getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                isAnnotated = true;
                break;
            }
            if (!isAnnotated) {
                reader = new ExternalAnnotationDecorator(reader, null);
            }
        }
        if (this.accessRuleSet == null) {
            return this.module == null ? new NameEnvironmentAnswer(reader, null) : new NameEnvironmentAnswer(reader, null, moduleName);
        }
        return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), moduleName);
    }

    public void connectAllLocationsForEEA(Collection<ClasspathLocation> allLocations, boolean add) {
        this.allLocationsForEEA = allLocations;
        if (add) {
            allLocations.add(this);
        }
    }

    public boolean externalAnnotationsEquals(ClasspathLocation other) {
        String path1 = this.externalAnnotationPath;
        String path2 = other.externalAnnotationPath;
        if (!Objects.equals(path1, path2)) {
            if (path1 == null) {
                return path2.isEmpty();
            }
            if (path2 == null) {
                return path1.isEmpty();
            }
            return false;
        }
        if (this.allLocationsForEEA == null) {
            return other.allLocationsForEEA == null;
        }
        return Objects.deepEquals(new HashSet<ClasspathLocation>(this.allLocationsForEEA), new HashSet<ClasspathLocation>(other.allLocationsForEEA));
    }
}

