/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.search.matching.RoleTypePattern;
import org.eclipse.objectteams.otdt.internal.core.search.matching.TeamTypePattern;

public class OTSearchEngine {
    private SearchEngine m_searchEngine = new SearchEngine();

    public void search(SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.m_searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
    }

    public static IJavaSearchScope createOTSearchScope(IJavaElement[] elements, boolean includeReferencedProjects) {
        IJavaElement[] javaElements = OTSearchEngine.convertOTToJavaElements(elements);
        int includeMask = 3;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return SearchEngine.createJavaSearchScope(javaElements, includeMask);
    }

    private static IJavaElement[] convertOTToJavaElements(IJavaElement[] elements) {
        IJavaElement[] javaElements = new IJavaElement[elements.length];
        System.arraycopy(elements, 0, javaElements, 0, elements.length);
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (element instanceof IOTJavaElement) {
                javaElements[i] = ((IOTJavaElement)element).getCorrespondingJavaElement();
            }
            ++i;
        }
        return javaElements;
    }

    public static SearchPattern createTeamTypePattern(int limitTo, int matchRule) {
        return new TeamTypePattern(null, null, null, OTSearchEngine.getClassOrInterface(limitTo), matchRule);
    }

    public static SearchPattern createTeamTypePattern(char[] pkg, char[][] enclosingTypeNames, char[] simpleName, int limitTo, int matchRule) {
        return new TeamTypePattern(pkg, enclosingTypeNames, simpleName, OTSearchEngine.getClassOrInterface(limitTo), matchRule);
    }

    public static SearchPattern createRoleTypePattern(int limitTo, int matchRule) {
        return new RoleTypePattern(null, null, null, OTSearchEngine.getClassOrInterface(limitTo), matchRule);
    }

    public static SearchPattern createRoleTypePattern(char[] pkg, char[][] enclosingTypeNames, char[] simpleName, int limitTo, int matchRule) {
        return new RoleTypePattern(pkg, enclosingTypeNames, simpleName, OTSearchEngine.getClassOrInterface(limitTo), matchRule);
    }

    protected static final char getClassOrInterface(int limitTo) {
        switch (limitTo) {
            case 5: {
                return 'C';
            }
            case 6: {
                return 'I';
            }
            case 0: {
                return '\u0000';
            }
        }
        throw new IllegalArgumentException("Bad argument 'limitTo': " + limitTo);
    }
}

