/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom.rewrite;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;

public class ASTNodeCreator {
    public static CompilationUnit createCU(AST ast, PackageDeclaration pack, List<ImportDeclaration> importList, List<TypeDeclaration> typeList) {
        ASTNode tmp;
        int idx;
        CompilationUnit newCU = ast.newCompilationUnit();
        if (pack != null) {
            newCU.setPackage(pack);
        }
        if (importList != null && importList.size() != 0) {
            List cuImportList = newCU.imports();
            idx = 0;
            while (idx < importList.size()) {
                tmp = importList.get(idx);
                cuImportList.add(tmp);
                ++idx;
            }
        }
        if (typeList != null && typeList.size() != 0) {
            List cuTypeList = newCU.types();
            idx = 0;
            while (idx < typeList.size()) {
                tmp = typeList.get(idx);
                cuTypeList.add(tmp);
                ++idx;
            }
        }
        return newCU;
    }

    public static CallinMappingDeclaration createCallinMappingDeclaration(AST ast, Javadoc javadoc, int modifier, MethodSpec roleMethod, List baseMethods, List paramMappings) {
        CallinMappingDeclaration newCallinMapping = ast.newCallinMappingDeclaration();
        newCallinMapping.setCallinModifier(modifier);
        newCallinMapping.setRoleMappingElement(roleMethod);
        if (javadoc != null) {
            newCallinMapping.setJavadoc(javadoc);
        }
        if (baseMethods != null && baseMethods.size() != 0) {
            List baseMappingList = newCallinMapping.getBaseMappingElements();
            int idx = 0;
            while (idx < baseMethods.size()) {
                MethodSpec tmp = (MethodSpec)baseMethods.get(idx);
                baseMappingList.add(tmp);
                ++idx;
            }
        }
        if (paramMappings != null && paramMappings.size() != 0) {
            List parameterMappingList = newCallinMapping.getParameterMappings();
            while (!paramMappings.isEmpty()) {
                ParameterMapping tmp = (ParameterMapping)paramMappings.remove(0);
                parameterMappingList.add(tmp);
            }
        }
        return newCallinMapping;
    }

    public static CalloutMappingDeclaration createCalloutMappingDeclaration(AST ast, Javadoc javadoc, int modifier, MethodMappingElement roleMethod, MethodMappingElement baseMethod, int bindingModifier, List paramMappings, boolean calloutOverride, boolean signatureFlag) {
        CalloutMappingDeclaration newCalloutMapping = ast.newCalloutMappingDeclaration();
        if (javadoc != null) {
            newCalloutMapping.setJavadoc(javadoc);
        }
        if (ast.apiLevel() == 2) {
            newCalloutMapping.setModifiers(modifier);
        } else {
            newCalloutMapping.modifiers().addAll(ast.newModifiers(modifier));
        }
        newCalloutMapping.setSignatureFlag(signatureFlag);
        newCalloutMapping.setRoleMappingElement(roleMethod);
        newCalloutMapping.setBaseMappingElement(baseMethod);
        Modifier.ModifierKeyword keyword = null;
        switch (bindingModifier) {
            case 524288: {
                keyword = Modifier.ModifierKeyword.SET_KEYWORD;
                break;
            }
            case 262144: {
                keyword = Modifier.ModifierKeyword.GET_KEYWORD;
            }
        }
        int calloutKind = calloutOverride ? 2 : 1;
        newCalloutMapping.setBindingOperator(ast.newMethodBindingOperator(keyword, calloutKind));
        if (paramMappings != null && paramMappings.size() != 0) {
            List parameterMapping = newCalloutMapping.getParameterMappings();
            while (!paramMappings.isEmpty()) {
                ParameterMapping tmp = (ParameterMapping)paramMappings.remove(0);
                parameterMapping.add(tmp);
            }
        }
        return newCalloutMapping;
    }

    public static FieldAccessSpec createFieldAccSpec(AST ast, boolean isSetter, String fieldName, String fieldType, boolean hasSignature) {
        FieldAccessSpec newFieldAcc = ast.newFieldAccessSpec();
        newFieldAcc.setName(ast.newSimpleName(fieldName));
        newFieldAcc.setFieldType(ASTNodeCreator.createType(ast, fieldType));
        newFieldAcc.setSignatureFlag(hasSignature);
        return newFieldAcc;
    }

    public static FieldAccessSpec createFieldAccSpec(AST ast, String fieldName, Type type) {
        FieldAccessSpec newFieldAcc = ast.newFieldAccessSpec();
        newFieldAcc.setName(ast.newSimpleName(fieldName));
        newFieldAcc.setFieldType(type);
        newFieldAcc.setSignatureFlag(true);
        return newFieldAcc;
    }

    public static MethodSpec createMethodSpec(AST ast, String methodName, Type returnType, List parameters, boolean signatureFlag) {
        MethodSpec methodSpec = ast.newMethodSpec();
        methodSpec.setName(ast.newSimpleName(methodName));
        methodSpec.setSignatureFlag(signatureFlag);
        methodSpec.setReturnType2(returnType);
        if (parameters != null && parameters.size() != 0) {
            List methodParameters = methodSpec.parameters();
            int idx = 0;
            while (idx < parameters.size()) {
                VariableDeclaration tmp = (VariableDeclaration)parameters.get(idx);
                methodParameters.add(tmp);
                ++idx;
            }
        }
        return methodSpec;
    }

    public static GuardPredicateDeclaration createGuardPredicate(AST ast, boolean isBase, Expression expression) {
        GuardPredicateDeclaration result = ast.newGuardPredicateDeclaration();
        result.setBase(isBase);
        result.setExpression(expression);
        return result;
    }

    public static Type createType(AST ast, String typeName) {
        Object name;
        Type primType = ASTNodeCreator.getPrimitveType(ast, typeName);
        if (primType != null) {
            return primType;
        }
        if (typeName.endsWith("[]") && (name = typeName.split("\\[\\]"))[0] != null) {
            Type primitiveType = ASTNodeCreator.getPrimitveType(ast, name[0]);
            if (primitiveType != null) {
                return ast.newArrayType(primitiveType);
            }
            Name nameNode = ast.newName(name[0]);
            SimpleType simpleType = ast.newSimpleType(nameNode);
            return ast.newArrayType(simpleType);
        }
        name = ast.newName(typeName);
        SimpleType simpleType = ast.newSimpleType((Name)name);
        return simpleType;
    }

    private static Type getPrimitveType(AST ast, String typeName) {
        if (typeName.equals(PrimitiveType.BOOLEAN.toString())) {
            return ast.newPrimitiveType(PrimitiveType.BOOLEAN);
        }
        if (typeName.equals(PrimitiveType.BYTE.toString())) {
            return ast.newPrimitiveType(PrimitiveType.BYTE);
        }
        if (typeName.equals(PrimitiveType.CHAR.toString())) {
            return ast.newPrimitiveType(PrimitiveType.CHAR);
        }
        if (typeName.equals(PrimitiveType.DOUBLE.toString())) {
            return ast.newPrimitiveType(PrimitiveType.DOUBLE);
        }
        if (typeName.equals(PrimitiveType.FLOAT.toString())) {
            return ast.newPrimitiveType(PrimitiveType.FLOAT);
        }
        if (typeName.equals(PrimitiveType.INT.toString())) {
            return ast.newPrimitiveType(PrimitiveType.INT);
        }
        if (typeName.equals(PrimitiveType.LONG.toString())) {
            return ast.newPrimitiveType(PrimitiveType.LONG);
        }
        if (typeName.equals(PrimitiveType.SHORT.toString())) {
            return ast.newPrimitiveType(PrimitiveType.SHORT);
        }
        if (typeName.equals(PrimitiveType.VOID.toString())) {
            return ast.newPrimitiveType(PrimitiveType.VOID);
        }
        return null;
    }

    public static SingleVariableDeclaration createArgument(AST ast, int modifier, Type parameterType, String parameterName, Expression initializer) {
        SingleVariableDeclaration methodSpecParameter = ast.newSingleVariableDeclaration();
        methodSpecParameter.modifiers().addAll(ast.newModifiers(modifier));
        methodSpecParameter.setType(parameterType);
        methodSpecParameter.setName(ast.newSimpleName(parameterName));
        methodSpecParameter.setInitializer(initializer);
        return methodSpecParameter;
    }

    public static ParameterMapping createParameterMapping(AST ast, Expression expression, SimpleName identName, String direction, boolean resultFlag) {
        ParameterMapping newParameterMapping = ast.newParameterMapping();
        newParameterMapping.setExpression(expression);
        newParameterMapping.setDirection(direction);
        newParameterMapping.setIdentifier(identName);
        newParameterMapping.setResultFlag(resultFlag);
        return newParameterMapping;
    }

    public static Expression createExpression(AST ast, String expressionName, String methodName) {
        MethodInvocation expression = ast.newMethodInvocation();
        expression.setExpression(ast.newSimpleName(expressionName));
        expression.setName(ast.newSimpleName(methodName));
        return expression;
    }

    public static Expression createExpression(AST ast, String expr) {
        ASTParser parser = ASTParser.newParser(ast.apiLevel());
        parser.setKind(1);
        parser.setSource(expr.toCharArray());
        ASTNode parsedNode = parser.createAST(null);
        if (parsedNode instanceof Expression) {
            Expression exprNode = (Expression)parsedNode;
            Expression newExprNode = (Expression)ASTNode.copySubtree(ast, exprNode);
            return newExprNode;
        }
        return null;
    }

    public static Expression createExpression(AST ast, Expression innerExpression, String className, List arguments, AnonymousClassDeclaration anonymousClass) {
        ClassInstanceCreation expression = ast.newClassInstanceCreation();
        expression.setType(ast.newSimpleType(ast.newName(className)));
        expression.setExpression(innerExpression);
        expression.setAnonymousClassDeclaration(anonymousClass);
        if (arguments != null && arguments.size() != 0) {
            List classArguments = expression.arguments();
            int idx = 0;
            while (idx < arguments.size()) {
                Expression tmp = (Expression)arguments.get(idx);
                classArguments.add(tmp);
                ++idx;
            }
        }
        return expression;
    }
}

