/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.pde.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.objectteams.otdt.core.ext.OTDTPlugin;
import org.eclipse.objectteams.otdt.core.ext.OTREContainer;

public class OTPluginProject {
    public static void makeOTPlugin(IProject project) throws CoreException {
        OTPluginProject.addOTNatureAndBuilder(project);
        OTREContainer.initializeOTJProject((IProject)project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String value = javaProject.getOption("org.eclipse.objectteams.otdt.compiler.problem.binding_conventions", true);
        if (!value.equals("error")) {
            javaProject.setOption("org.eclipse.objectteams.otdt.compiler.problem.binding_conventions", "error");
        }
    }

    public static void addOTNatureAndBuilder(IProject project) throws CoreException {
        IProjectDescription prjDesc = project.getDescription();
        prjDesc.setNatureIds(OTDTPlugin.createProjectNatures((IProjectDescription)prjDesc));
        ICommand[] buildSpecs = prjDesc.getBuildSpec();
        prjDesc.setBuildSpec(OTPluginProject.replaceOrAddOTBuilder(prjDesc, buildSpecs));
        project.setDescription(prjDesc, null);
    }

    private static ICommand[] replaceOrAddOTBuilder(IProjectDescription prjDesc, ICommand[] buildSpecs) {
        ICommand otBuildCmd = OTDTPlugin.createProjectBuildCommand((IProjectDescription)prjDesc);
        int i = 0;
        while (i < buildSpecs.length) {
            if (buildSpecs[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                buildSpecs[i] = otBuildCmd;
                return buildSpecs;
            }
            ++i;
        }
        int len = buildSpecs.length;
        ICommand[] iCommandArray = buildSpecs;
        buildSpecs = new ICommand[len + 1];
        System.arraycopy(iCommandArray, 0, buildSpecs, 1, len);
        buildSpecs[0] = otBuildCmd;
        return buildSpecs;
    }
}

