/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmWritableBoundClass;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class CreateSpecificSuperCallInCallOrigAdapter
extends AbstractTransformableClassNode {
    private Method method;
    private String superClassName;
    private int boundMethodId;
    private int firstArgIndex;
    private int argOffset;
    private Method callOrig;

    public CreateSpecificSuperCallInCallOrigAdapter(AsmWritableBoundClass clazz, String superClassName, Method method, int boundMethodId) {
        this.superClassName = superClassName;
        this.method = method;
        this.boundMethodId = boundMethodId;
        if (method.isStatic()) {
            this.firstArgIndex = 0;
            this.argOffset = clazz.isRole() ? 2 : 0;
            this.callOrig = clazz.getCallOrigStatic();
        } else {
            this.firstArgIndex = 1;
            this.callOrig = ConstantMembers.callOrig;
        }
    }

    @Override
    protected boolean transform() {
        MethodNode callOrig = this.getMethod(this.callOrig);
        String methodSignature = this.method.getSignature();
        Type returnType = Type.getReturnType((String)methodSignature);
        InsnList newInstructions = new InsnList();
        if (!this.method.isStatic()) {
            newInstructions.add((AbstractInsnNode)new IntInsnNode(25, 0));
        }
        Type[] args = Type.getArgumentTypes((String)methodSignature);
        int size = 0;
        if (args.length > 0) {
            int i = this.argOffset;
            while (i < args.length) {
                newInstructions.add((AbstractInsnNode)new IntInsnNode(25, this.firstArgIndex + this.argOffset + 1));
                newInstructions.add(this.createLoadIntConstant(i));
                newInstructions.add((AbstractInsnNode)new InsnNode(50));
                Type arg = args[i];
                size += arg.getSize();
                if (arg.getSort() != 9 && arg.getSort() != 10) {
                    String objectType = AsmTypeHelper.getBoxingType(arg);
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                    newInstructions.add(AsmTypeHelper.getUnboxingInstructionForType(arg, objectType));
                } else if (!arg.getInternalName().equals(ClassNames.OBJECT_SLASH)) {
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, arg.getInternalName()));
                }
                ++i;
            }
        }
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(183, this.superClassName, this.method.getName(), methodSignature, false));
        newInstructions.add(AsmTypeHelper.getBoxingInstructionForType(returnType));
        newInstructions.add((AbstractInsnNode)new InsnNode(176));
        this.addNewLabelToSwitch(callOrig.instructions, newInstructions, this.boundMethodId);
        callOrig.maxStack = Math.max(Math.max(callOrig.maxStack, size + 3), 3);
        if (returnType.getSort() == 0) {
            ++callOrig.maxStack;
        }
        return true;
    }
}

