/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

public class LineInfo {
    private int _inputStartLine;
    private int _repeatCount;
    private int _outputStartLine;
    private int _outputLineIncrement;

    public LineInfo(int inputStartLine, int outputStartLine) {
        if (inputStartLine < 0) {
            throw new IllegalArgumentException("Linenumber has to be greater than 0, not " + inputStartLine);
        }
        if (outputStartLine < 0) {
            throw new IllegalArgumentException("Linenumber has to be greater than 0, not " + outputStartLine);
        }
        this._inputStartLine = inputStartLine;
        this._repeatCount = -1;
        this._outputStartLine = outputStartLine;
        this._outputLineIncrement = -1;
    }

    public void setRepeatCount(int repeatCount) {
        if (repeatCount < 0) {
            throw new IllegalArgumentException("RepeatCount has to be greater than 0, not " + repeatCount);
        }
        this._repeatCount = repeatCount;
    }

    public void setOutputLineIncrement(int outputLineIncrement) {
        if (outputLineIncrement < -1) {
            throw new IllegalArgumentException("Increment has to be greater than -1, not " + outputLineIncrement);
        }
        this._outputLineIncrement = outputLineIncrement;
    }

    public int getInputStartLine() {
        return this._inputStartLine;
    }

    public int getOutputStartLine() {
        return this._outputStartLine;
    }

    public int getOutputLineIncrement() {
        return this._outputLineIncrement;
    }

    public boolean hasOutputLineIncrement() {
        return this._outputLineIncrement != -1;
    }

    public boolean hasRepeatCount() {
        return this._repeatCount > 1;
    }

    public int getRepeatCount() {
        return this._repeatCount;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineInfo)) {
            return false;
        }
        LineInfo lineInfo = (LineInfo)obj;
        if (this._inputStartLine != lineInfo._inputStartLine) {
            return false;
        }
        if (this._outputStartLine != lineInfo._outputStartLine) {
            return false;
        }
        if (this.hasRepeatCount() != lineInfo.hasRepeatCount()) {
            return false;
        }
        if (this.getRepeatCount() != lineInfo.getRepeatCount()) {
            return false;
        }
        if (this.getOutputStartLine() != lineInfo.getOutputStartLine()) {
            return false;
        }
        if (this.hasOutputLineIncrement() != lineInfo.hasOutputLineIncrement()) {
            return false;
        }
        return this.getOutputLineIncrement() == lineInfo.getOutputLineIncrement();
    }

    public boolean isPreviousLineInfo(LineInfo previousLineInfo) {
        if (!(this._inputStartLine != previousLineInfo.getInputStartLine() + 1 || this._outputStartLine != previousLineInfo.getOutputStartLine() + 1 || this.hasRepeatCount() || previousLineInfo.hasRepeatCount() || this.hasOutputLineIncrement() || previousLineInfo.hasOutputLineIncrement())) {
            return true;
        }
        return this._inputStartLine <= previousLineInfo.getInputStartLine() * previousLineInfo.getRepeatCount() && this._outputStartLine == previousLineInfo.getOutputStartLine() + 1;
    }

    public LineInfo clone() {
        LineInfo copiedLineInfo = new LineInfo(this._inputStartLine, this._outputStartLine);
        if (this.hasOutputLineIncrement()) {
            copiedLineInfo.setOutputLineIncrement(this._outputLineIncrement);
        }
        if (this.hasRepeatCount()) {
            copiedLineInfo.setRepeatCount(this._repeatCount);
        }
        return copiedLineInfo;
    }
}

