/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public abstract class AbstractCreateDispatchCodeAdapter
extends AbstractTransformableClassNode {
    private boolean isStatic;
    private Type[] args;

    public AbstractCreateDispatchCodeAdapter(boolean isStatic) {
        this.isStatic = isStatic;
    }

    protected InsnList getDispatchCode(MethodNode method, int joinPointId, int boundMethodId) {
        InsnList instructions = new InsnList();
        instructions.add(this.createLoadIntConstant(joinPointId));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, ClassNames.TEAM_MANAGER_SLASH, ConstantMembers.getTeams.getName(), ConstantMembers.getTeams.getSignature(), false));
        instructions.add(this.createInstructionsToCheackTeams(method));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(50));
        instructions.add((AbstractInsnNode)new InsnNode(95));
        if (this.isStatic) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            instructions.add((AbstractInsnNode)new IntInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, ClassNames.I_BOUND_BASE_SLASH));
        }
        instructions.add((AbstractInsnNode)new InsnNode(95));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add(this.createLoadIntConstant(joinPointId));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, ClassNames.TEAM_MANAGER_SLASH, ConstantMembers.getCallinIds.getName(), ConstantMembers.getCallinIds.getSignature(), false));
        instructions.add(this.createLoadIntConstant(boundMethodId));
        this.args = Type.getArgumentTypes((String)method.desc);
        instructions.add(this.getBoxedArguments(this.args));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, ClassNames.ITEAM_SLASH, ConstantMembers.callAllBindingsTeam.getName(), ConstantMembers.callAllBindingsTeam.getSignature(), true));
        Type returnType = Type.getReturnType((String)method.desc);
        instructions.add(this.getUnboxingInstructionsForReturnValue(returnType));
        return instructions;
    }

    protected InsnList createInstructionsToCheackTeams(MethodNode method) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new InsnNode(89));
        LabelNode label = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(199, label));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new JumpInsnNode(167, this.findBreakLabel(method.instructions)));
        instructions.add((AbstractInsnNode)label);
        return instructions;
    }

    private LabelNode findBreakLabel(InsnList instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            AbstractInsnNode node = instructions.get(i);
            if (node.getType() == 8) {
                return (LabelNode)node;
            }
            --i;
        }
        throw new RuntimeException("Can't find break label to create dispatch code");
    }

    protected abstract InsnList getBoxedArguments(Type[] var1);

    protected int getMaxLocals() {
        return this.args.length + 1;
    }

    protected int getMaxStack() {
        return 10;
    }
}

