/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import org.eclipse.objectteams.otequinox.TransformerPlugin;

public class Util {
    public static int WARN_LEVEL = 1;
    public static boolean PROFILE = false;
    private static long[] profileTimes;
    private static long systemStartTime;

    static {
        String level = System.getProperty("otequinox.debug");
        if (level != null) {
            WARN_LEVEL = (level = level.toUpperCase()).equals("OK") ? 0 : (level.equals("INFO") ? 1 : (level.startsWith("WARN") ? 2 : (level.startsWith("ERR") ? 4 : 0)));
        }
        PROFILE = System.getProperty("otequinox.profile") != null;
        profileTimes = new long[ProfileKind.values().length];
        systemStartTime = System.nanoTime();
    }

    public static void profile(long startTime, ProfileKind kind, String msg) {
        long now = System.nanoTime();
        long delta = now - startTime;
        int n = kind.ordinal();
        long l = profileTimes[n] + delta;
        profileTimes[n] = l;
        long total = l;
        msg = msg.substring(msg.lastIndexOf(46) + 1);
        TransformerPlugin.doLog(1, "Profile " + kind.name() + ": " + Util.m(delta) + "(" + Util.m(total) + "/" + Util.m(now - systemStartTime) + ") [" + msg + "]");
    }

    private static double m(long l) {
        return (double)l / 1000000.0;
    }

    private static int getActiveCount() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        return group.activeCount();
    }

    static enum ProfileKind {
        Transformation,
        NoTransformation,
        Activation,
        Scan,
        SuperClassFetching;

    }
}

