/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;

public class CommentsPreparator
extends ASTVisitor {
    public static final int COMMENT_LINE_SEPARATOR_LENGTH = 3;
    private static final Pattern NLS_TAG_PATTERN = Pattern.compile("//\\$NON-NLS-([0-9]+)\\$");
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("\".*?(\\\\(\\\\\\\\)*\".*?)*\"");
    private static final Pattern HTML_TAG_PATTERN;
    private static final Pattern HTML_ATTRIBUTE_PATTERN;
    private static final Pattern HTML_ENTITY_PATTERN;
    private static final String HTML_ENTITY_REPLACE = "   <> &^~\"";
    private static final List<String> PARAM_TAGS;
    private static final List<String> IMMUTABLE_TAGS;
    private static final int[] NO_INDENT_AFTER_COMMENT;
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private final String sourceLevel;
    private final String formatDisableTag;
    private final String formatEnableTag;
    private Token lastLineComment;
    private int lastLineCommentPosition;
    private Token lastFormatOffComment;
    private TokenManager ctm;
    private List<Token> commentStructure;
    private int commentIndent;
    private boolean[] noSubstituteWrapping;
    private int noFormatTagOpenStart = -1;
    private int formatCodeTagOpenEnd = -1;
    private int lastFormatCodeClosingTagIndex = -1;
    private Token firstTagToken;
    private DefaultCodeFormatter commentCodeFormatter;

    static {
        String formatCodeTags = "(pre)";
        String separateLineTags = "(dl|hr|nl|p|ul|ol|table|tr)";
        String breakBeforeTags = "(dd|dt|li|td|th|h1|h2|h3|h4|h5|h6|q)";
        String breakAfterTags = "(br)";
        String noFormatTags = "(code|em|tt)";
        String otherTags = "([^<>&&\\S]++)";
        String ws = "(?>[ \\t]++|[\\r\\n]++[ \\t]*+\\*?)";
        String attributeValue = "(?>\"[^\"]*\")|(?>'[^']*')|[^/>\"'&&\\S]++";
        String attribute = "(?>" + ws + "+[^=&&\\S]+" + ws + "*(=)" + ws + "*(?>" + attributeValue + "))";
        HTML_TAG_PATTERN = Pattern.compile("<(/)?+(?:" + formatCodeTags + '|' + separateLineTags + '|' + breakBeforeTags + '|' + breakAfterTags + '|' + noFormatTags + '|' + otherTags + ')' + "(" + attribute + "*)" + ws + "*/?>", 2);
        HTML_ATTRIBUTE_PATTERN = Pattern.compile(attribute);
        HTML_ENTITY_PATTERN = Pattern.compile("&(#x[0-9a-fA-F]+)?(#[0-9]+)?(lt)?(gt)?(nbsp)?(amp)?(circ)?(tilde)?(quot)?;");
        PARAM_TAGS = Arrays.asList("@param", "@exception", "@serialField", "@throws");
        IMMUTABLE_TAGS = Arrays.asList("@code", "@literal");
        NO_INDENT_AFTER_COMMENT = new int[]{24, 53, 34};
        Arrays.sort(NO_INDENT_AFTER_COMMENT);
    }

    public CommentsPreparator(TokenManager tm, DefaultCodeFormatterOptions options, String sourceLevel) {
        this.tm = tm;
        this.options = options;
        this.sourceLevel = sourceLevel;
        this.formatDisableTag = options.disabling_tag != null ? new String(options.disabling_tag) : null;
        this.formatEnableTag = options.enabling_tag != null ? new String(options.enabling_tag) : null;
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed = (node.getFlags() & 1) != 0;
        return !isMalformed;
    }

    @Override
    public boolean visit(LineComment node) {
        int commentIndex = this.tm.firstIndexIn(node, 1001);
        this.handleLineComment(commentIndex);
        return true;
    }

    public void handleLineComment(int commentIndex) {
        boolean formattingEnabled;
        Token commentToken = this.tm.get(commentIndex);
        boolean isOnFirstColumn = this.handleWhitespaceAround(commentIndex);
        if (this.handleFormatOnOffTags(commentToken)) {
            return;
        }
        if (isOnFirstColumn) {
            if (this.options.comment_format_line_comment && !this.options.comment_format_line_comment_starting_on_first_column) {
                this.lastLineComment = null;
                commentToken.setIndent(0);
                commentToken.setWrapPolicy(null);
                return;
            }
            if (this.options.never_indent_line_comments_on_first_column) {
                commentToken.setIndent(0);
                commentToken.setWrapPolicy(null);
            }
        }
        this.handleNLSTags(commentToken, commentIndex);
        int positionInLine = this.tm.findSourcePositionInLine(commentToken.originalStart);
        boolean isContinuation = commentIndex > 0 && this.tm.get(commentIndex - 1) == this.lastLineComment && positionInLine >= this.lastLineCommentPosition - this.options.indentation_size + 1 && this.tm.countLineBreaksBetween(this.lastLineComment, commentToken) == 1;
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = this.options.comment_format_line_comment && !isHeader || this.options.comment_format_header && isHeader;
        if (!formattingEnabled) {
            this.preserveWhitespace(commentToken, commentIndex);
            if (isContinuation) {
                Token.WrapPolicy policy = this.lastLineComment.getWrapPolicy();
                if (policy == null) {
                    int lineStart = this.tm.getPositionInLine(this.tm.findFirstTokenInLine(commentIndex - 1));
                    int commentStart = this.tm.getPositionInLine(commentIndex - 1);
                    policy = new Token.WrapPolicy(commentStart - lineStart, commentIndex - 1, true);
                }
                commentToken.setWrapPolicy(policy);
                this.lastLineComment = commentToken;
            } else if (commentToken.getLineBreaksBefore() == 0) {
                this.lastLineComment = commentToken;
                this.lastLineCommentPosition = positionInLine;
            }
            return;
        }
        List<Token> structure = this.tokenizeLineComment(commentToken);
        if (isContinuation) {
            Token first = structure.get(0);
            first.breakBefore();
            first.setWrapPolicy(new Token.WrapPolicy(this.lastLineCommentPosition, commentIndex - 1, false));
            Token previous = this.lastLineComment;
            Token merged = new Token(previous, previous.originalStart, commentToken.originalEnd, previous.tokenType);
            this.tm.remove(commentIndex - 1);
            this.tm.insert(commentIndex - 1, merged);
            this.tm.remove(commentIndex);
            List<Token> lastStructure = this.lastLineComment.getInternalStructure();
            lastStructure.addAll(structure);
            structure = lastStructure;
            commentToken = merged;
        } else {
            this.lastLineCommentPosition = positionInLine;
        }
        commentToken.setInternalStructure(structure);
        this.preserveWhitespace(commentToken, commentIndex);
        this.lastLineComment = commentToken;
    }

    private void preserveWhitespace(Token commentToken, int commentIndex) {
        if (this.options.comment_preserve_white_space_between_code_and_line_comments && commentToken.getLineBreaksBefore() == 0 && commentIndex > 0) {
            commentToken.clearSpaceBefore();
            List<Token> structure = commentToken.getInternalStructure();
            if (structure != null && !structure.isEmpty()) {
                structure.get(0).clearSpaceBefore();
            }
            Token previous = this.tm.get(commentIndex - 1);
            previous.clearSpaceAfter();
            if (previous.originalEnd + 1 >= commentToken.originalStart) {
                return;
            }
            if (structure == null || structure.isEmpty()) {
                structure = new ArrayList<Token>();
                structure.add(new Token(previous.originalEnd + 1, commentToken.originalEnd, 1001));
                commentToken.setInternalStructure(structure);
            } else {
                structure.add(0, new Token(previous.originalEnd + 1, commentToken.originalStart - 1, 1000));
            }
        }
    }

    private boolean handleFormatOnOffTags(Token commentToken) {
        int onIndex;
        if (!this.options.use_tags) {
            return false;
        }
        String commentString = this.tm.toString(commentToken);
        int offIndex = this.formatDisableTag != null ? commentString.lastIndexOf(this.formatDisableTag) : -1;
        int n = onIndex = this.formatEnableTag != null ? commentString.lastIndexOf(this.formatEnableTag) : -1;
        if (this.lastFormatOffComment == null) {
            if (offIndex > onIndex) {
                this.lastFormatOffComment = commentToken;
            }
        } else if (onIndex > offIndex) {
            this.tm.addDisableFormatTokenPair(this.lastFormatOffComment, commentToken);
            this.lastFormatOffComment = null;
        }
        return offIndex >= 0 || onIndex >= 0;
    }

    private void handleNLSTags(Token comment, int commentIndex) {
        List<Token> stringLiterals = this.findStringLiteralsInLine(commentIndex);
        if (stringLiterals.isEmpty()) {
            return;
        }
        ArrayList<Token> commentFragments = new ArrayList<Token>();
        Matcher matcher = NLS_TAG_PATTERN.matcher(this.tm.toString(comment));
        int previousMatcherEnd = 0;
        boolean nlsFound = false;
        while (matcher.find()) {
            int nlsNumber = Integer.parseInt(matcher.group(1));
            if (nlsNumber <= 0 || nlsNumber > stringLiterals.size()) continue;
            if (matcher.start() > previousMatcherEnd) {
                Token fragment = new Token(comment.originalStart + previousMatcherEnd, comment.originalStart + matcher.start() - 1, 1001);
                commentFragments.add(fragment);
            }
            Token nlsTag = new Token(comment.originalStart + matcher.start(), comment.originalStart + matcher.end() - 1, 1001);
            stringLiterals.get(nlsNumber - 1).setNLSTag(nlsTag);
            nlsTag.setNLSTag(stringLiterals.get(nlsNumber - 1));
            commentFragments.add(nlsTag);
            nlsFound = true;
            previousMatcherEnd = matcher.end();
        }
        if (nlsFound) {
            comment.setInternalStructure(commentFragments);
            if (comment.originalStart + previousMatcherEnd <= comment.originalEnd) {
                Token fragment = new Token(comment.originalStart + previousMatcherEnd, comment.originalEnd, 1001);
                commentFragments.add(fragment);
            }
        }
    }

    private List<Token> findStringLiteralsInLine(int lastTokenIndex) {
        ArrayList<Token> stringLiterals = new ArrayList<Token>();
        Token previous = this.tm.get(lastTokenIndex);
        int i = lastTokenIndex - 1;
        while (i >= 0) {
            Token token = this.tm.get(i);
            if (this.tm.countLineBreaksBetween(token, previous) > 0) break;
            if (token.tokenType == 48) {
                stringLiterals.add(token);
            }
            previous = token;
            --i;
        }
        Collections.reverse(stringLiterals);
        return stringLiterals;
    }

    private List<Token> tokenizeLineComment(Token commentToken) {
        List<Token> fragments = commentToken.getInternalStructure();
        if (fragments == null) {
            fragments = Arrays.asList(commentToken);
        }
        ArrayList<Token> result = new ArrayList<Token>();
        int i = 0;
        while (i < fragments.size()) {
            Token token = fragments.get(i);
            if (token.hasNLSTag()) {
                if (ScannerHelper.isWhitespace(this.tm.charAt(token.originalStart - 1))) {
                    token.spaceBefore();
                }
                result.add(token);
            } else {
                int sourcePosition = token.originalStart;
                if (sourcePosition == commentToken.originalStart) {
                    while (sourcePosition <= token.originalEnd && this.tm.charAt(sourcePosition) == '/') {
                        ++sourcePosition;
                    }
                    result.add(new Token(commentToken.originalStart, sourcePosition - 1, 1001));
                }
                int tokenStart = sourcePosition;
                while (sourcePosition <= token.originalEnd + 1) {
                    if (sourcePosition == token.originalEnd + 1 || ScannerHelper.isWhitespace(this.tm.charAt(sourcePosition))) {
                        if (tokenStart < sourcePosition) {
                            Token outputToken = new Token(tokenStart, sourcePosition - 1, 1001);
                            outputToken.spaceBefore();
                            result.add(outputToken);
                        }
                        tokenStart = sourcePosition + 1;
                    }
                    ++sourcePosition;
                }
            }
            ++i;
        }
        if (this.tm.getSource().startsWith("$FALL-THROUGH$", ((Token)result.get((int)0)).originalEnd + 1)) {
            result.get(1).clearSpaceBefore();
        }
        return result;
    }

    @Override
    public boolean visit(BlockComment node) {
        int commentIndex = this.tm.firstIndexIn(node, 1002);
        this.handleBlockComment(commentIndex);
        return true;
    }

    public void handleBlockComment(int commentIndex) {
        Token commentToken = this.tm.get(commentIndex);
        boolean isFirstColumn = this.handleWhitespaceAround(commentIndex);
        if (this.handleFormatOnOffTags(commentToken)) {
            return;
        }
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean formattingEnabled = this.options.comment_format_block_comment && !isHeader || this.options.comment_format_header && isHeader;
        boolean bl = formattingEnabled = formattingEnabled && this.tm.charAt(commentToken.originalStart + 2) != '-';
        if (formattingEnabled && this.tokenizeMultilineComment(commentToken)) {
            this.commentStructure = commentToken.getInternalStructure();
            this.ctm = new TokenManager(this.commentStructure, this.tm);
            this.handleStringLiterals(this.tm.toString(commentToken), commentToken.originalStart);
            this.addSubstituteWraps();
        } else {
            commentToken.setInternalStructure(this.commentToLines(commentToken, -1));
        }
        if (this.options.never_indent_block_comments_on_first_column && isFirstColumn) {
            commentToken.setIndent(0);
            commentToken.setWrapPolicy(null);
        }
    }

    private boolean handleWhitespaceAround(int commentIndex) {
        char charAfter;
        int charBefore;
        Token commentToken = this.tm.get(commentIndex);
        int n = charBefore = commentToken.originalStart > 0 ? (int)this.tm.charAt(commentToken.originalStart - 1) : 0;
        if (charBefore == 32 || charBefore == 9) {
            commentToken.spaceBefore();
        }
        if (commentToken.originalEnd < this.tm.getSourceLength() - 1 && ((charAfter = this.tm.charAt(commentToken.originalEnd + 1)) == ' ' || charAfter == '\t')) {
            commentToken.spaceAfter();
        }
        Token previous = null;
        Token next = null;
        int existingBreaksBefore = 2;
        int existingBreaksAfter = 2;
        if (commentIndex > 0 && (existingBreaksBefore = this.tm.countLineBreaksBetween(previous = this.tm.get(commentIndex - 1), commentToken)) > 0) {
            commentToken.breakBefore();
            commentToken.clearSpaceBefore();
        }
        if (commentIndex < this.tm.size() - 1 && (existingBreaksAfter = this.tm.countLineBreaksBetween(commentToken, next = this.tm.get(commentIndex + 1))) > 0) {
            commentToken.breakAfter();
        }
        if (existingBreaksBefore <= 1 && (previous.tokenType == 1001 || previous.tokenType == 1002)) {
            commentToken.setWrapPolicy(previous.getWrapPolicy());
        } else {
            int i = commentIndex + 2;
            while (existingBreaksAfter <= 1 && i < this.tm.size() && (next.tokenType == 1001 || next.tokenType == 1002)) {
                Token next2 = this.tm.get(i++);
                existingBreaksAfter = this.tm.countLineBreaksBetween(next, next2);
                next = next2;
            }
            if (previous != null && previous.getLineBreaksAfter() == 0 && next != null && next.getLineBreaksBefore() == 0 && Arrays.binarySearch(NO_INDENT_AFTER_COMMENT, next.tokenType) < 0) {
                int policyIndent = commentToken.getIndent() - previous.getIndent();
                Token.WrapPolicy wrapPolicy = new Token.WrapPolicy(policyIndent, commentIndex - 1, true);
                if (this.tm.countLineBreaksBetween(previous, commentToken) == 1) {
                    commentToken.setWrapPolicy(wrapPolicy);
                }
                if (this.tm.countLineBreaksBetween(commentToken, next) == 1) {
                    next.setWrapPolicy(wrapPolicy);
                }
            }
            if (existingBreaksBefore < existingBreaksAfter && previous != null) {
                commentToken.putLineBreaksAfter(previous.getLineBreaksAfter());
                previous.clearLineBreaksAfter();
            } else if (existingBreaksAfter <= existingBreaksBefore && next != null && next.tokenType != 106) {
                commentToken.putLineBreaksBefore(next.getLineBreaksBefore());
                next.clearLineBreaksBefore();
            }
        }
        boolean isFirstColumn = charBefore == 13 || charBefore == 10 || commentToken.originalStart == 0;
        return isFirstColumn;
    }

    private List<Token> commentToLines(Token commentToken, int commentStartPositionInLine) {
        ArrayList<Token> lines = new ArrayList<Token>();
        int tab = this.options.tab_size;
        String commentText = this.tm.toString(commentToken);
        int commentStartPosition = commentStartPositionInLine;
        if (commentStartPosition < 0) {
            commentStartPosition = this.tm.findSourcePositionInLine(commentToken.originalStart);
        }
        int positionInLine = commentStartPosition;
        int lineStart = 0;
        int breaksBeforeFirstLine = 0;
        boolean firstLine = true;
        boolean emptyLine = true;
        int i = 0;
        while (i < commentText.length()) {
            char c = commentText.charAt(i);
            switch (c) {
                case ' ': {
                    if (lineStart == i && positionInLine < commentStartPosition || emptyLine && positionInLine == commentToken.getIndent() - 1) {
                        lineStart = i + 1;
                    }
                    ++positionInLine;
                    break;
                }
                case '\t': {
                    if (lineStart == i && positionInLine < commentStartPosition || emptyLine && positionInLine == commentToken.getIndent() - 1) {
                        lineStart = i + 1;
                    }
                    if (tab <= 0) break;
                    positionInLine += tab - positionInLine % tab;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (lineStart < i) {
                        Token line = new Token(commentToken.originalStart + lineStart, commentToken.originalStart + i - 1, firstLine ? commentToken.tokenType : 0);
                        line.breakAfter();
                        if (lines.isEmpty()) {
                            line.putLineBreaksBefore(breaksBeforeFirstLine);
                        }
                        lines.add(line);
                    } else if (!lines.isEmpty()) {
                        Token previousLine = (Token)lines.get(lines.size() - 1);
                        previousLine.putLineBreaksAfter(previousLine.getLineBreaksAfter() + 1);
                    } else {
                        ++breaksBeforeFirstLine;
                    }
                    if (i + 1 < commentText.length() && commentText.charAt(i + 1) == (c == '\r' ? (char)'\n' : '\r')) {
                        ++i;
                    }
                    lineStart = i + 1;
                    positionInLine = 0;
                    firstLine = false;
                    emptyLine = true;
                    break;
                }
                default: {
                    ++positionInLine;
                    emptyLine = false;
                }
            }
            ++i;
        }
        if (lineStart < commentText.length()) {
            Token line = new Token(commentToken.originalStart + lineStart, commentToken.originalEnd, firstLine ? commentToken.tokenType : 0);
            line.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
            lines.add(line);
        }
        return lines;
    }

    @Override
    public boolean visit(Javadoc node) {
        boolean formattingEnabled;
        this.noFormatTagOpenStart = -1;
        this.formatCodeTagOpenEnd = -1;
        this.lastFormatCodeClosingTagIndex = -1;
        this.firstTagToken = null;
        this.ctm = null;
        int commentIndex = this.tm.firstIndexIn(node, 1003);
        Token commentToken = this.tm.get(commentIndex);
        if (node.getParent() == null) {
            this.handleWhitespaceAround(commentIndex);
        }
        if (commentIndex < this.tm.size() - 1) {
            commentToken.breakAfter();
        }
        if (this.handleFormatOnOffTags(commentToken)) {
            return false;
        }
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = this.options.comment_format_javadoc_comment && !isHeader || this.options.comment_format_header && isHeader;
        if (!formattingEnabled || !this.tokenizeMultilineComment(commentToken)) {
            commentToken.setInternalStructure(this.commentToLines(commentToken, -1));
            return false;
        }
        this.commentStructure = commentToken.getInternalStructure();
        this.commentIndent = this.tm.toIndent(commentToken.getIndent(), true);
        this.ctm = new TokenManager(commentToken.getInternalStructure(), this.tm);
        return true;
    }

    @Override
    public void endVisit(Javadoc node) {
        if (this.ctm == null) {
            return;
        }
        if (this.options.comment_insert_empty_line_before_root_tags && this.firstTagToken != null && this.ctm.indexOf(this.firstTagToken) > 1) {
            this.firstTagToken.putLineBreaksBefore(2);
        }
        this.addSubstituteWraps();
    }

    @Override
    public boolean visit(TagElement node) {
        String tagName = node.getTagName();
        if (tagName == null || tagName.length() <= 1) {
            return true;
        }
        int startIndex = this.tokenStartingAt(node.getStartPosition());
        int nodeEnd = node.getStartPosition() + node.getLength() - 1;
        while (ScannerHelper.isWhitespace(this.ctm.charAt(nodeEnd))) {
            --nodeEnd;
        }
        int endIndex = this.tokenEndingAt(nodeEnd);
        this.ctm.get(startIndex + 1).setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
        if (node.getParent() instanceof Javadoc) {
            int firstTagIndex;
            assert (this.ctm.toString(startIndex).startsWith(tagName));
            boolean isParamTag = PARAM_TAGS.contains(tagName);
            if (isParamTag && this.options.comment_insert_new_line_for_parameter && startIndex < endIndex) {
                Token token = this.ctm.get(startIndex + 2);
                token.breakBefore();
            }
            if (this.options.comment_indent_root_tags) {
                int indent = this.ctm.getLength(this.ctm.get(startIndex), 0) + 1;
                if (isParamTag && this.options.comment_indent_parameter_description) {
                    indent += this.options.indentation_size;
                }
                int i = startIndex + 1;
                while (i <= endIndex) {
                    Token token = this.ctm.get(i);
                    token.setIndent(indent);
                    ++i;
                }
            }
            Token startTokeen = this.ctm.get(startIndex);
            if (startIndex > 1) {
                startTokeen.breakBefore();
            }
            if (this.firstTagToken == null || (firstTagIndex = this.ctm.indexOf(this.firstTagToken)) < 0 || startIndex < firstTagIndex) {
                this.firstTagToken = startTokeen;
            }
            this.handleHtml(node);
        } else if (IMMUTABLE_TAGS.contains(tagName)) {
            if (startIndex < endIndex) {
                this.disableFormatting(startIndex, endIndex);
            }
            this.noSubstituteWrapping(node.getStartPosition(), nodeEnd);
        } else if (node.isNested()) {
            this.noSubstituteWrapping(node.getStartPosition(), nodeEnd);
        }
        return true;
    }

    @Override
    public void endVisit(TagElement node) {
        String tagName = node.getTagName();
        if (tagName == null || tagName.length() <= 1) {
            this.handleHtml(node);
        }
        this.handleStringLiterals(this.tm.toString(node), node.getStartPosition());
    }

    private void handleHtml(TagElement node) {
        if (!this.options.comment_format_html && !this.options.comment_format_source) {
            return;
        }
        String text = this.tm.toString(node);
        Matcher matcher = HTML_TAG_PATTERN.matcher(text);
        while (matcher.find()) {
            int i;
            int startPos = matcher.start() + node.getStartPosition();
            int endPos = matcher.end() - 1 + node.getStartPosition();
            boolean isOpeningTag = matcher.start(1) == matcher.end(1);
            int firstTokenIndex = 0;
            int lastTokenIndex = 0;
            if (this.options.comment_format_html) {
                firstTokenIndex = this.tokenStartingAt(startPos);
                lastTokenIndex = this.tokenEndingAt(endPos);
                Token startToken = this.ctm.get(firstTokenIndex);
                if (!isOpeningTag && startToken.getWrapPolicy() == null) {
                    startToken.setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                }
                i = firstTokenIndex + 1;
                while (i <= lastTokenIndex) {
                    Token token = this.ctm.get(i);
                    if (token.getWrapPolicy() == null) {
                        token.setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                    }
                    ++i;
                }
                Token nextToken = this.ctm.get(lastTokenIndex + 1);
                if (isOpeningTag && nextToken.getWrapPolicy() == null) {
                    nextToken.setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                }
                this.noSubstituteWrapping(startPos, endPos - 1);
                String attributesText = matcher.group(8);
                Matcher attrMatcher = HTML_ATTRIBUTE_PATTERN.matcher(attributesText);
                int commentStart = this.ctm.get((int)0).originalStart;
                while (attrMatcher.find()) {
                    int equalPos = node.getStartPosition() + matcher.start(8) + attrMatcher.start(1);
                    assert (this.tm.charAt(equalPos) == '=');
                    this.noSubstituteWrapping[equalPos - commentStart] = false;
                }
            }
            int matchedGroups = 0;
            i = 2;
            while (i <= 7) {
                if (matcher.start(i) < matcher.end(i)) {
                    ++matchedGroups;
                }
                ++i;
            }
            if (matchedGroups != 1) continue;
            if (matcher.start(2) < matcher.end(2)) {
                this.handleFormatCodeTag(startPos, endPos, isOpeningTag);
            }
            if (!this.options.comment_format_html) continue;
            if (matcher.start(3) < matcher.end(3)) {
                this.handleSeparateLineTag(startPos, endPos);
                continue;
            }
            if (matcher.start(4) < matcher.end(4)) {
                this.handleBreakBeforeTag(startPos, endPos, isOpeningTag);
                continue;
            }
            if (matcher.start(5) < matcher.end(5)) {
                this.handleBreakAfterTag(startPos, endPos);
                continue;
            }
            if (matcher.start(6) >= matcher.end(6)) continue;
            this.handleNoFormatTag(startPos, endPos, isOpeningTag);
        }
    }

    @Override
    public boolean visit(MethodRef node) {
        this.handleReference(node);
        return true;
    }

    @Override
    public boolean visit(MemberRef node) {
        this.handleReference(node);
        return true;
    }

    private void handleReference(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent instanceof TagElement && ((TagElement)parent).isNested()) {
            int firstIndex = this.tokenStartingAt(node.getStartPosition());
            int lastIndex = this.tokenEndingAt(node.getStartPosition() + node.getLength() - 1);
            if (this.ctm.charAt(this.ctm.get((int)(lastIndex + 1)).originalStart) == '}') {
                ++lastIndex;
            }
            int i = firstIndex;
            while (i <= lastIndex) {
                Token token = this.ctm.get(i);
                token.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
                ++i;
            }
        }
        this.noSubstituteWrapping(node.getStartPosition(), node.getStartPosition() + node.getLength() - 1);
    }

    private void handleStringLiterals(String text, int textStartPosition) {
        Matcher matcher = STRING_LITERAL_PATTERN.matcher(text);
        while (matcher.find()) {
            int endPosition;
            int endIndex;
            int startPosition = textStartPosition + matcher.start();
            int startIndex = this.ctm.findIndex(startPosition, -1, false);
            if (startIndex != (endIndex = this.ctm.findIndex(endPosition = textStartPosition + matcher.end() - 1, -1, false))) {
                this.disableFormatting(this.tokenStartingAt(startPosition), this.tokenEndingAt(endPosition));
            }
            this.noSubstituteWrapping(startPosition, endPosition);
        }
    }

    private void handleSeparateLineTag(int startPos, int endPos) {
        int openingTagIndex = this.tokenStartingAt(startPos);
        if (openingTagIndex > 1 && this.lastFormatCodeClosingTagIndex == openingTagIndex - 1) {
            Token token = this.ctm.get(openingTagIndex - 1);
            assert (token.getLineBreaksAfter() == 2);
            token.clearLineBreaksAfter();
            token.breakAfter();
        }
        this.handleBreakBeforeTag(startPos, endPos, true);
        this.handleBreakAfterTag(startPos, endPos);
    }

    private void handleBreakBeforeTag(int start, int end, boolean isOpeningTag) {
        int firstPartIndex = this.tokenStartingAt(start);
        int lastPartIndex = this.tokenEndingAt(end);
        Token firstPartToken = this.ctm.get(firstPartIndex);
        if (isOpeningTag) {
            firstPartToken.breakBefore();
            this.ctm.get(lastPartIndex + 1).clearSpaceBefore();
        } else {
            firstPartToken.clearSpaceBefore();
            firstPartToken.setWrapPolicy(null);
        }
    }

    private void handleBreakAfterTag(int start, int end) {
        int tokenIndex = this.tokenEndingAt(end);
        this.ctm.get(tokenIndex).breakAfter();
    }

    private void handleNoFormatTag(int start, int end, boolean isOpeningTag) {
        if (isOpeningTag) {
            if (this.noFormatTagOpenStart < 0) {
                this.noFormatTagOpenStart = start;
            }
        } else if (this.noFormatTagOpenStart >= 0) {
            int closingTagIndex;
            int openingTagIndex = this.tokenStartingAt(this.noFormatTagOpenStart);
            if (openingTagIndex < (closingTagIndex = this.tokenEndingAt(end))) {
                this.disableFormatting(openingTagIndex, closingTagIndex);
            }
            closingTagIndex = this.tokenEndingAt(end);
            this.cleanupHTMLElement(openingTagIndex, closingTagIndex, false);
            this.noSubstituteWrapping(this.noFormatTagOpenStart, end);
            this.noFormatTagOpenStart = -1;
        }
    }

    private void handleFormatCodeTag(int startPos, int endPos, boolean isOpeningTag) {
        if (!this.options.comment_format_source) {
            this.handleNoFormatTag(startPos, endPos, isOpeningTag);
            return;
        }
        this.handleSeparateLineTag(startPos, endPos);
        if (isOpeningTag) {
            int startIndex = this.tokenStartingAt(startPos);
            if (startIndex > 1) {
                this.ctm.get(startIndex).putLineBreaksBefore(2);
            }
            if (this.formatCodeTagOpenEnd < 0) {
                this.formatCodeTagOpenEnd = endPos;
            }
        } else if (this.formatCodeTagOpenEnd >= 0) {
            int endTagIndex = this.tokenEndingAt(endPos);
            if (endTagIndex < this.ctm.size() - 2) {
                this.ctm.get(endTagIndex).putLineBreaksAfter(2);
            }
            this.formatCode(startPos, endPos);
            this.formatCodeTagOpenEnd = -1;
            this.lastFormatCodeClosingTagIndex = this.ctm.findIndex(startPos, -1, true);
        }
    }

    private void cleanupHTMLElement(int openingTagIndex, int closingTagIndex, boolean formattedCode) {
        Token token;
        Token previous = this.ctm.get(openingTagIndex);
        int indent = previous.getIndent();
        int i = openingTagIndex + 1;
        while (i < closingTagIndex) {
            token = this.ctm.get(i);
            token.setToEscape(true);
            if (formattedCode && (token.getLineBreaksBefore() > 0 || previous.getLineBreaksAfter() > 0)) {
                token.setAlign(indent);
            }
            previous = token;
            ++i;
        }
        i = closingTagIndex;
        while (i < this.ctm.size()) {
            token = this.ctm.get(i);
            if (token.getIndent() == 0) break;
            token.setIndent(indent);
            previous = token;
            ++i;
        }
    }

    private void disableFormatting(int startIndex, int endIndex) {
        Token startToken = this.ctm.get(startIndex);
        Token endToken = this.ctm.get(endIndex);
        Token noFormatToken = new Token(startToken.originalStart, endToken.originalEnd, 1003);
        List<Token> tokensToReplace = this.commentStructure.subList(startIndex, endIndex + 1);
        if (this.ctm.countLineBreaksBetween(startToken, endToken) == 0) {
            tokensToReplace.clear();
            tokensToReplace.add(noFormatToken);
        } else {
            int commentStart = this.findCommentLineIndent(startIndex);
            tokensToReplace.clear();
            tokensToReplace.addAll(this.commentToLines(noFormatToken, commentStart));
        }
        if (startToken.isSpaceBefore()) {
            tokensToReplace.get(0).spaceBefore();
        }
        tokensToReplace.get(0).putLineBreaksBefore(startToken.getLineBreaksBefore());
        Token lastToReplace = tokensToReplace.get(tokensToReplace.size() - 1);
        if (endToken.isSpaceAfter()) {
            lastToReplace.spaceAfter();
        }
        lastToReplace.putLineBreaksAfter(endToken.getLineBreaksAfter());
        for (Token token : tokensToReplace) {
            if (token.tokenType != 1003) continue;
            token.setIndent(startToken.getIndent());
        }
    }

    private void disableFormattingExclusively(int openingTagIndex, int closingTagIndex) {
        Token openingTag = this.ctm.get(openingTagIndex);
        int noFormatStart = openingTag.originalEnd + 1;
        int noFormatEnd = this.ctm.get((int)(closingTagIndex - 1)).originalEnd;
        if (noFormatStart <= noFormatEnd) {
            Token noFormatToken = new Token(noFormatStart, noFormatEnd, 1003);
            int commentStart = this.findCommentLineIndent(openingTagIndex);
            List<Token> lines = this.commentToLines(noFormatToken, commentStart);
            List<Token> tokensToReplace = this.commentStructure.subList(openingTagIndex + 1, closingTagIndex);
            tokensToReplace.clear();
            tokensToReplace.addAll(lines);
            this.noSubstituteWrapping(noFormatStart, noFormatEnd);
        } else {
            this.commentStructure.subList(openingTagIndex + 1, closingTagIndex).clear();
            Token closingTag = this.ctm.get(closingTagIndex);
            if (this.ctm.countLineBreaksBetween(openingTag, closingTag) == 0) {
                openingTag.clearLineBreaksAfter();
                closingTag.clearLineBreaksBefore();
            }
        }
    }

    private int findCommentLineIndent(int commentFragmentIndex) {
        int position;
        int lastNonWhitespace = position = this.ctm.get((int)commentFragmentIndex).originalStart;
        while (--position > 0) {
            char c = this.ctm.charAt(position);
            if (c == '\r' || c == '\n') break;
            if (ScannerHelper.isWhitespace(c)) continue;
            lastNonWhitespace = position;
        }
        if (lastNonWhitespace > 0 && this.ctm.charAt(lastNonWhitespace - 1) == ' ') {
            --lastNonWhitespace;
        }
        return this.ctm.getLength(position, lastNonWhitespace - 1, 0);
    }

    private int tokenStartingAt(int start) {
        int tokenIndex = this.ctm.findIndex(start, -1, false);
        Token token = this.ctm.get(tokenIndex);
        if (token.originalStart == start) {
            return tokenIndex;
        }
        assert (start > token.originalStart && start <= token.originalEnd);
        this.splitToken(token, tokenIndex, start);
        return tokenIndex + 1;
    }

    private int tokenEndingAt(int end) {
        int tokenIndex = this.ctm.findIndex(end, -1, true);
        Token token = this.ctm.get(tokenIndex);
        if (token.originalEnd == end) {
            return tokenIndex;
        }
        assert (end < token.originalEnd && end >= token.originalStart);
        this.splitToken(token, tokenIndex, end + 1);
        return tokenIndex;
    }

    private void splitToken(Token token, int tokenIndex, int splitPosition) {
        assert (splitPosition > token.originalStart && splitPosition <= token.originalEnd);
        Token part1 = new Token(token.originalStart, splitPosition - 1, token.tokenType);
        Token part2 = new Token(splitPosition, token.originalEnd, token.tokenType);
        if (token.isSpaceBefore()) {
            part1.spaceBefore();
        }
        part1.putLineBreaksBefore(token.getLineBreaksBefore());
        if (token.isSpaceAfter()) {
            part2.spaceAfter();
        }
        part2.putLineBreaksAfter(token.getLineBreaksAfter());
        part1.setIndent(token.getIndent());
        part2.setIndent(token.getIndent());
        part1.setWrapPolicy(token.getWrapPolicy());
        this.commentStructure.set(tokenIndex, part1);
        this.commentStructure.add(tokenIndex + 1, part2);
    }

    private boolean tokenizeMultilineComment(Token commentToken) {
        boolean newLinesAtBoundries;
        if (this.noSubstituteWrapping == null || this.noSubstituteWrapping.length < commentToken.countChars()) {
            this.noSubstituteWrapping = new boolean[commentToken.countChars()];
        } else {
            Arrays.fill(this.noSubstituteWrapping, 0, commentToken.countChars(), false);
        }
        boolean cleanBlankLines = commentToken.tokenType == 1003 ? this.options.comment_clear_blank_lines_in_javadoc_comment : this.options.comment_clear_blank_lines_in_block_comment;
        ArrayList<Token> structure = new ArrayList<Token>();
        int firstTokenEnd = commentToken.originalStart + 1;
        while (firstTokenEnd < commentToken.originalEnd - 1 && this.tm.charAt(firstTokenEnd + 1) == '*') {
            ++firstTokenEnd;
        }
        Token first = new Token(commentToken.originalStart, firstTokenEnd, commentToken.tokenType);
        first.spaceAfter();
        structure.add(first);
        int lastTokenStart = commentToken.originalEnd - 1;
        while (lastTokenStart - 1 > firstTokenEnd && this.tm.charAt(lastTokenStart - 1) == '*') {
            --lastTokenStart;
        }
        int position = firstTokenEnd + 1;
        int lineBreaks = 0;
        block2: while (position <= commentToken.originalEnd) {
            char c;
            int i = position;
            while (i < lastTokenStart) {
                c = this.tm.charAt(i);
                if (c == '\r' || c == '\n') {
                    ++lineBreaks;
                    char c2 = this.tm.charAt(i + 1);
                    if ((c2 == '\r' || c2 == '\n') && c2 != c) {
                        ++i;
                    }
                    position = i + 1;
                } else if (!ScannerHelper.isWhitespace(c)) {
                    while (this.tm.charAt(i) == '*' && lineBreaks > 0) {
                        ++i;
                    }
                    position = i;
                    break;
                }
                ++i;
            }
            int tokenStart = position;
            while (position <= commentToken.originalEnd + 1) {
                c = '\u0000';
                if (position == commentToken.originalEnd + 1 || position == lastTokenStart || ScannerHelper.isWhitespace(c = this.tm.charAt(position))) {
                    if (tokenStart < position) {
                        Token outputToken = new Token(tokenStart, position - 1, commentToken.tokenType);
                        outputToken.spaceBefore();
                        if (lineBreaks > 0) {
                            if (cleanBlankLines) {
                                lineBreaks = 1;
                            }
                            if (lineBreaks > 1 || !this.options.join_lines_in_comments) {
                                outputToken.putLineBreaksBefore(lineBreaks);
                            }
                        }
                        if (this.tm.charAt(tokenStart) == '@') {
                            outputToken.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
                            if (commentToken.tokenType == 1002 && lineBreaks == 1 && structure.size() > 1) {
                                outputToken.putLineBreaksBefore(cleanBlankLines ? 1 : 2);
                            }
                            if (this.tm.charAt(tokenStart + 1) == '@' && lineBreaks > 0 && this.firstTagToken == null) {
                                this.firstTagToken = outputToken;
                            }
                        }
                        structure.add(outputToken);
                        lineBreaks = 0;
                    }
                    if (c == '\r' || c == '\n') continue block2;
                    tokenStart = position == lastTokenStart ? position : position + 1;
                }
                ++position;
            }
        }
        Token last = (Token)structure.get(structure.size() - 1);
        boolean bl = newLinesAtBoundries = commentToken.tokenType == 1003 ? this.options.comment_new_lines_at_javadoc_boundaries : this.options.comment_new_lines_at_block_boundaries;
        if (newLinesAtBoundries && this.tm.countLineBreaksBetween(first, last) > 0) {
            first.breakAfter();
            last.breakBefore();
            last.setAlign(1);
        }
        if (structure.size() == 2) {
            return false;
        }
        commentToken.setInternalStructure(structure);
        return true;
    }

    private void noSubstituteWrapping(int from, int to) {
        int commentStart = this.ctm.get((int)0).originalStart;
        assert (commentStart <= from && from <= to && to <= this.ctm.get((int)(this.ctm.size() - 1)).originalEnd);
        Arrays.fill(this.noSubstituteWrapping, from - commentStart, to - commentStart + 1, true);
    }

    private void addSubstituteWraps() {
        int commentStart = this.ctm.get((int)0).originalStart;
        int i = 1;
        while (i < this.ctm.size() - 1) {
            Token token = this.ctm.get(i);
            int pos = token.originalStart + 1;
            while (pos < token.originalEnd) {
                char c;
                if (!this.noSubstituteWrapping[pos - commentStart] && !ScannerHelper.isJavaIdentifierPart(c = this.ctm.charAt(pos)) && c != '@') {
                    this.ctm.get(this.tokenStartingAt(pos)).setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                    this.ctm.get(this.tokenStartingAt(pos + 1)).setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                }
                ++pos;
            }
            ++i;
        }
    }

    private void formatCode(int javadocNoFormatCloseStart, int javadocNoFormatCloseEnd) {
        int openingTagLastIndex = this.tokenEndingAt(this.formatCodeTagOpenEnd);
        int closingTagFirstIndex = this.tokenStartingAt(javadocNoFormatCloseStart);
        int codeStartPosition = this.formatCodeTagOpenEnd + 1;
        int codeEndPosition = javadocNoFormatCloseStart - 1;
        StringBuilder codeBuilder = new StringBuilder(codeEndPosition - codeStartPosition + 1);
        int[] positionMapping = new int[codeEndPosition - codeStartPosition + 1];
        this.getCodeToFormat(codeStartPosition, codeEndPosition, codeBuilder, positionMapping);
        List<Token> formattedTokens = this.getCommentCodeFormatter().prepareFormattedCode(codeBuilder.toString(), 0);
        if (formattedTokens == null) {
            this.disableFormattingExclusively(openingTagLastIndex, closingTagFirstIndex);
            closingTagFirstIndex = this.tokenStartingAt(javadocNoFormatCloseStart);
            this.cleanupHTMLElement(openingTagLastIndex, closingTagFirstIndex, false);
            return;
        }
        formattedTokens = this.translateFormattedTokens(codeStartPosition, formattedTokens, positionMapping, null);
        Token start = formattedTokens.get(0);
        start.putLineBreaksBefore(start.getLineBreaksBefore() + 1);
        Token end = formattedTokens.get(formattedTokens.size() - 1);
        end.putLineBreaksAfter(end.getLineBreaksAfter() + 1);
        this.ctm.get(closingTagFirstIndex).clearLineBreaksBefore();
        List<Token> tokensToReplace = this.commentStructure.subList(openingTagLastIndex + 1, closingTagFirstIndex);
        tokensToReplace.clear();
        tokensToReplace.addAll(formattedTokens);
        this.cleanupHTMLElement(openingTagLastIndex, openingTagLastIndex + formattedTokens.size() + 1, true);
        this.noSubstituteWrapping(codeStartPosition, codeEndPosition);
    }

    private DefaultCodeFormatter getCommentCodeFormatter() {
        if (this.commentCodeFormatter == null) {
            Map<String, String> options2 = this.options.getMap();
            options2.put("org.eclipse.jdt.core.formatter.comment.line_length", String.valueOf(this.options.comment_line_length - this.commentIndent - 3));
            options2.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(this.options.page_width - this.commentIndent - 3));
            options2.put("org.eclipse.jdt.core.compiler.source", this.sourceLevel);
            this.commentCodeFormatter = new DefaultCodeFormatter(options2);
        }
        return this.commentCodeFormatter;
    }

    private void getCodeToFormat(int startPos, int endPos, StringBuilder sb, int[] posMapping) {
        char c2;
        int position = 0;
        char c = this.ctm.charAt(position + startPos);
        if (c == '\r' || c == '\n') {
            posMapping[position++] = sb.length() - 1;
            c2 = this.ctm.charAt(position + startPos);
            if ((c2 == '\r' || c2 == '\n') && c2 != c) {
                posMapping[position++] = sb.length() - 1;
            }
        }
        while (position + startPos <= endPos) {
            int lineStart;
            int i = lineStart = position + startPos;
            while (true) {
                if ((c = this.ctm.charAt(i)) == '\r' || c == '\n') {
                    sb.append(c);
                    lineStart = i + 1;
                } else if (!ScannerHelper.isWhitespace(c)) {
                    if (c != '*') break;
                    lineStart = this.ctm.charAt(i + 1) == ' ' ? i + 2 : i + 1;
                    break;
                }
                ++i;
            }
            int lineEnd = endPos + 1;
            int i2 = lineStart;
            while (i2 <= endPos) {
                c = this.ctm.charAt(i2);
                if (c == '\r' || c == '\n') {
                    lineEnd = i2;
                    break;
                }
                ++i2;
            }
            while (position + startPos < lineStart) {
                posMapping[position++] = sb.length() - 1;
            }
            int htmlEntityStart = -1;
            int i3 = lineStart;
            while (i3 < lineEnd) {
                c = this.ctm.charAt(i3);
                sb.append(c);
                posMapping[position++] = sb.length() - 1;
                if (c == '&') {
                    htmlEntityStart = i3;
                } else if (c == ';' && htmlEntityStart >= 0) {
                    char replacementChar = this.getHtmlEntityChar(this.ctm.getSource().substring(htmlEntityStart, i3 + 1));
                    if (replacementChar != '\u0000') {
                        sb.setLength(sb.length() - (i3 + 1 - htmlEntityStart));
                        sb.append(replacementChar);
                        int k = position - (i3 + 1 - htmlEntityStart);
                        while (k < position) {
                            posMapping[k] = sb.length() - 1;
                            ++k;
                        }
                    }
                    htmlEntityStart = -1;
                }
                ++i3;
            }
        }
        while (sb.length() > 0 && ((c = sb.charAt(sb.length() - 1)) == ' ' || c == '\t')) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (sb.length() > 0 && ((c = sb.charAt(sb.length() - 1)) == '\r' || c == '\n')) {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() > 0 && ((c2 = sb.charAt(sb.length() - 1)) == '\r' || c2 == '\n') && c2 != c) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
    }

    private char getHtmlEntityChar(String entity) {
        Matcher matcher = HTML_ENTITY_PATTERN.matcher(entity);
        if (matcher.find()) {
            char replaceChar = '\u0000';
            int i = 1;
            while (i < HTML_ENTITY_REPLACE.length()) {
                int end;
                int start = matcher.start(i);
                if (start != (end = matcher.end(i))) {
                    if (replaceChar != '\u0000') {
                        return '\u0000';
                    }
                    switch (i) {
                        case 1: {
                            replaceChar = (char)Integer.parseInt(entity.substring(start + 2, end), 16);
                            break;
                        }
                        case 2: {
                            replaceChar = (char)Integer.parseInt(entity.substring(start + 1, end), 10);
                            break;
                        }
                        default: {
                            replaceChar = HTML_ENTITY_REPLACE.charAt(i);
                        }
                    }
                }
                ++i;
            }
            return replaceChar;
        }
        return '\u0000';
    }

    private List<Token> translateFormattedTokens(int startPosition, List<Token> formattedTokens, int[] positionMapping, HashMap<Token, Token> translationMap) {
        int previousLineBreaks = 0;
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token token : formattedTokens) {
            int newStart = Arrays.binarySearch(positionMapping, token.originalStart);
            while (newStart > 0 && positionMapping[newStart - 1] == token.originalStart) {
                --newStart;
            }
            int newEnd = Arrays.binarySearch(positionMapping, token.originalEnd);
            while (newEnd + 1 < positionMapping.length && positionMapping[newEnd + 1] == token.originalEnd) {
                ++newEnd;
            }
            Token translated = new Token(token, newStart + startPosition, newEnd + startPosition, token.tokenType);
            if (translated.getWrapPolicy() == null) {
                translated.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
            }
            if (token.hasNLSTag()) {
                translationMap.put(token, translated);
            }
            int lineBreaks = Math.max(previousLineBreaks, token.getLineBreaksBefore());
            List<Token> structure = token.getInternalStructure();
            if (structure != null && !structure.isEmpty()) {
                if (translationMap == null) {
                    translationMap = new HashMap();
                }
                translated.setInternalStructure(this.translateFormattedTokens(startPosition, structure, positionMapping, translationMap));
            }
            translated.putLineBreaksBefore(lineBreaks);
            result.add(translated);
            previousLineBreaks = token.getLineBreaksAfter();
        }
        ((Token)result.get(result.size() - 1)).putLineBreaksAfter(previousLineBreaks);
        for (Token translated : result) {
            if (translated.getNLSTag() == null) continue;
            Token nlsTagToken = translationMap.get(translated.getNLSTag());
            translated.setNLSTag(nlsTagToken);
            nlsTagToken.setNLSTag(translated);
            assert (translated.getNLSTag() != null);
        }
        return result;
    }

    public void finishUp() {
        if (this.lastFormatOffComment != null) {
            this.tm.addDisableFormatTokenPair(this.lastFormatOffComment, this.tm.get(this.tm.size() - 1));
        }
    }
}

