/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.LiftingEnvironment;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.TreeNode;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class RoleMigrationImplementor {
    static final String TEAM = "Team";
    static final String BASE = "Base";
    static final char[] TYPEPARAM = "_OT$param$".toCharArray();
    static final char[][] JAVA_LANG_NULLPOINTEREXCEPTION = new char[][]{"java".toCharArray(), "lang".toCharArray(), "NullPointerException".toCharArray()};

    public static boolean checkMigratableInterfaces(SourceTypeBinding sourceType, TypeReference superInterfaceRef, ReferenceBinding superInterface, ClassScope scope) {
        if (CharOperation.equals(superInterface.compoundName, IOTConstants.ORG_OBJECTTEAMS_ITEAMMIGRATABLE)) {
            if (!sourceType.isRole()) {
                scope.problemReporter().migrateNonRole(superInterfaceRef, sourceType);
                return false;
            }
            if (scope.referenceContext.baseclass != null) {
                scope.problemReporter().migrateBoundRole(superInterfaceRef, sourceType);
                return false;
            }
            if (!sourceType.enclosingType().isFinal()) {
                scope.problemReporter().migrateWithinNonFinalTeam(superInterfaceRef, sourceType.enclosingType());
                return false;
            }
        }
        if (CharOperation.equals(superInterface.compoundName, IOTConstants.ORG_OBJECTTEAMS_IBASEMIGRATABLE)) {
            if (!sourceType.isRole()) {
                scope.problemReporter().baseMigrateNonRole(superInterfaceRef, sourceType);
                return false;
            }
            if (scope.referenceContext.baseclass == null) {
                scope.problemReporter().baseMigrateUnboundRole(superInterfaceRef, sourceType);
                return false;
            }
        }
        return true;
    }

    public static MethodBinding getMigrateMethodSubstitute(MethodBinding originalMethod, TypeBinding[] arguments, TypeBinding[] substitutes, Scope scope, InvocationSite invocationSite) {
        if (!(invocationSite instanceof MessageSend)) {
            return null;
        }
        MessageSend send = (MessageSend)invocationSite;
        if (!(send.actualReceiverType instanceof ReferenceBinding)) {
            return null;
        }
        ReferenceBinding roleType = ((ReferenceBinding)send.actualReceiverType).getRealType();
        TypeBinding typeArgument = null;
        boolean haveReportedError = false;
        if (CharOperation.equals(originalMethod.selector, IOTConstants.MIGRATE_TO_TEAM)) {
            Expression sendArgument = send.arguments[0];
            ITeamAnchor anchorBinding = TeamAnchor.getTeamAnchor(sendArgument);
            if (anchorBinding == null) {
                scope.problemReporter().migrateToNonTeam(sendArgument);
                haveReportedError = true;
            } else {
                ReferenceBinding anchorType = (ReferenceBinding)anchorBinding.getResolvedType();
                if (TypeBinding.notEquals(anchorType.getRealClass(), roleType.enclosingType())) {
                    scope.problemReporter().migrateToWrongTeam(sendArgument, anchorType, roleType);
                    haveReportedError = true;
                }
            }
            if (!haveReportedError) {
                typeArgument = RoleTypeCreator.getAnchoredType(scope, send, anchorBinding, roleType, null, 0);
            }
        } else if (CharOperation.equals(originalMethod.selector, IOTConstants.MIGRATE_TO_BASE)) {
            TypeBinding baseType = arguments[0];
            if (!baseType.isCompatibleWith(roleType.baseclass())) {
                scope.problemReporter().migrateToWrongBase(send.arguments[0], baseType, roleType, roleType.baseclass());
                haveReportedError = true;
            }
            typeArgument = baseType;
        } else {
            return null;
        }
        if (haveReportedError) {
            return new ProblemMethodBinding(originalMethod, originalMethod.selector, substitutes, 33);
        }
        return new ParameterizedGenericMethodBinding(originalMethod, new TypeBinding[]{typeArgument}, scope.environment());
    }

    public static void addMigrateToTeamMethod(TypeDeclaration roleClassDecl) {
        AstGenerator gen = new AstGenerator(roleClassDecl.sourceStart, roleClassDecl.sourceEnd);
        RoleMigrationImplementor.doAddMigrateMethod(roleClassDecl, IOTConstants.MIGRATE_TO_TEAM, gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM), new SingleTypeReference(TYPEPARAM, gen.pos){

            @Override
            public TypeBinding resolveType(ClassScope scope) {
                this.resolvedType = scope.enclosingSourceType();
                return this.resolvedType;
            }
        }, TEAM, null);
    }

    public static void checkAddMigrateToBaseMethod(TypeDeclaration roleClassDecl, TreeNode node) {
        AstGenerator gen = new AstGenerator(roleClassDecl.sourceStart, roleClassDecl.sourceEnd);
        if (roleClassDecl.isInterface()) {
            if (!roleClassDecl.binding.isCompatibleWith(roleClassDecl.scope.getOrgObjectteamsIBaseMigratable())) {
                return;
            }
        } else {
            FieldBinding baseField = roleClassDecl.scope.getField(roleClassDecl.binding, IOTConstants._OT_BASE, gen.singleNameReference(IOTConstants._OT_BASE));
            if (baseField == null) {
                assert (!node.getTreeObject().isBound()) : "bound role must have base field added";
                return;
            }
            if (baseField.isFinal()) {
                return;
            }
        }
        char[] cacheName = LiftingEnvironment.getCacheName(node.getTopmostBoundParent(true).getTreeObject());
        RoleMigrationImplementor.doAddMigrateMethod(roleClassDecl, IOTConstants.MIGRATE_TO_BASE, gen.singleTypeReference(TYPEPARAM), gen.singleTypeReference(TypeConstants.VOID), BASE, cacheName);
    }

    private static void doAddMigrateMethod(TypeDeclaration roleClassDecl, char[] selector, TypeReference argumentTypeRef, TypeReference returnTypeRef, final String kind, final char[] cacheName) {
        AstGenerator gen = new AstGenerator(roleClassDecl.sourceStart, roleClassDecl.sourceEnd);
        MethodDeclaration migrate = new MethodDeclaration(roleClassDecl.compilationResult){

            @Override
            protected void endOfMethodHook(ClassFile classfile) {
                CodeStream codeStream = classfile.codeStream;
                BranchLabel goOn = new BranchLabel(codeStream);
                codeStream.aload_1();
                codeStream.ifnonnull(goOn);
                ReferenceBinding npeBinding = (ReferenceBinding)this.scope.getType(JAVA_LANG_NULLPOINTEREXCEPTION, 3);
                codeStream.new_(npeBinding);
                codeStream.dup();
                MethodBinding npeStringCtor = this.getStringArgCtor(npeBinding);
                if (npeStringCtor == null) {
                    throw new InternalCompilerError("Expected constructor NullPointerException.<init>(String) not found");
                }
                codeStream.ldc(String.valueOf(kind) + " argument must not be null");
                codeStream.invoke((byte)-73, npeStringCtor, npeBinding);
                codeStream.athrow();
                goOn.place();
                if (kind == RoleMigrationImplementor.TEAM) {
                    RoleMigrationImplementor.genMigrateToTeamInstructions(codeStream, this.scope.enclosingSourceType());
                } else {
                    RoleMigrationImplementor.genMigrateToBaseInstructions(codeStream, this.scope.enclosingSourceType(), this.scope, cacheName);
                }
            }

            private MethodBinding getStringArgCtor(ReferenceBinding npeBinding) {
                MethodBinding[] ctors;
                MethodBinding[] methodBindingArray = ctors = npeBinding.getMethods(TypeConstants.INIT);
                int n = ctors.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding ctor = methodBindingArray[n2];
                    if (ctor.parameters.length == 1 && ctor.parameters[0].id == 11) {
                        return ctor;
                    }
                    ++n2;
                }
                return null;
            }

            @Override
            public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
            }
        };
        gen.setMethodPositions(migrate);
        migrate.isGenerated = true;
        migrate.modifiers = 33;
        migrate.typeParameters = new TypeParameter[]{gen.unboundedTypeParameter(TYPEPARAM)};
        migrate.returnType = returnTypeRef;
        migrate.selector = selector;
        migrate.arguments = new Argument[]{gen.argument(("other" + kind).toCharArray(), argumentTypeRef)};
        migrate.statements = new Statement[0];
        migrate.hasParsedStatements = true;
        AstEdit.addMethod(roleClassDecl, migrate);
    }

    static void genMigrateToTeamInstructions(CodeStream codeStream, SourceTypeBinding roleBinding) {
        codeStream.aload_0();
        codeStream.aload_1();
        codeStream.checkcast(roleBinding.enclosingType());
        codeStream.fieldAccess((byte)-75, RoleMigrationImplementor.enclosingInstanceField(roleBinding), roleBinding);
        codeStream.aload_0();
        codeStream.areturn();
    }

    static void genMigrateToBaseInstructions(CodeStream codeStream, SourceTypeBinding roleBinding, Scope scope, char[] cacheName) {
        FieldBinding baseField = roleBinding.getField(IOTConstants._OT_BASE, true);
        ReferenceBinding cacheTypeBinding = (ReferenceBinding)scope.getType(IOTConstants.WEAK_HASH_MAP, 3);
        MethodBinding remove = RoleMigrationImplementor.getMethod(cacheTypeBinding, "remove".toCharArray(), 1);
        MethodBinding put = cacheTypeBinding.getMethod(scope, "put".toCharArray());
        CompilerOptions.WeavingScheme weavingScheme = scope.compilerOptions().weavingScheme;
        ReferenceBinding iboundBase = (ReferenceBinding)scope.getType(weavingScheme == CompilerOptions.WeavingScheme.OTDRE ? IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2 : IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE, 3);
        codeStream.aload_0();
        codeStream.fieldAccess((byte)-76, RoleMigrationImplementor.enclosingInstanceField(roleBinding), roleBinding);
        codeStream.fieldAccess((byte)-76, roleBinding.enclosingType().getField(cacheName, true), roleBinding.enclosingType());
        codeStream.dup();
        codeStream.aload_0();
        codeStream.fieldAccess((byte)-76, baseField, roleBinding);
        codeStream.dup();
        RoleMigrationImplementor.genAddOrRemoveRole(codeStream, scope, iboundBase, false);
        codeStream.invoke((byte)-74, remove, cacheTypeBinding);
        codeStream.pop();
        codeStream.aload_0();
        codeStream.aload_1();
        codeStream.checkcast(roleBinding.baseclass());
        codeStream.fieldAccess((byte)-75, baseField, roleBinding);
        codeStream.aload_1();
        codeStream.aload_0();
        codeStream.invoke((byte)-74, put, cacheTypeBinding);
        codeStream.aload_1();
        RoleMigrationImplementor.genAddOrRemoveRole(codeStream, scope, iboundBase, true);
        codeStream.return_();
    }

    static MethodBinding getMethod(ReferenceBinding declaringClass, char[] selector, int numParams) {
        MethodBinding[] methods = declaringClass.getMethods(selector);
        MethodBinding found = null;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].parameters.length == numParams) {
                if (found != null) {
                    throw new IncompatibleClassChangeError("More than 1 " + String.valueOf(selector) + " method found");
                }
                found = methods[i];
            }
            ++i;
        }
        if (found == null) {
            throw new IncompatibleClassChangeError("Required " + String.valueOf(selector) + " method not found");
        }
        return found;
    }

    static void genAddOrRemoveRole(CodeStream codeStream, Scope scope, ReferenceBinding iboundBase, boolean isAdding) {
        codeStream.aload_0();
        switch (scope.compilerOptions().weavingScheme) {
            case OTDRE: {
                if (isAdding) {
                    codeStream.iconst_1();
                } else {
                    codeStream.iconst_0();
                }
                codeStream.invoke((byte)-71, iboundBase.getMethod(scope, IOTConstants.ADD_REMOVE_ROLE), iboundBase);
                break;
            }
            case OTRE: {
                codeStream.invoke((byte)-71, isAdding ? iboundBase.getMethod(scope, IOTConstants.ADD_ROLE) : iboundBase.getMethod(scope, IOTConstants.REMOVE_ROLE), iboundBase);
            }
        }
    }

    private static FieldBinding enclosingInstanceField(SourceTypeBinding roleBinding) {
        return roleBinding.getSyntheticField(roleBinding.enclosingType(), true);
    }
}

