/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WithinStatement;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;

public class LineBreaksPreparator
extends ASTVisitor {
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private boolean declarationModifierVisited;

    public LineBreaksPreparator(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed = (node.getFlags() & 1) != 0;
        return !isMalformed;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        List types;
        int index;
        List imports = node.imports();
        if (!imports.isEmpty() && (index = this.tm.firstIndexIn((ASTNode)imports.get(0), -1)) > 0) {
            this.tm.get(index).putLineBreaksBefore(this.options.blank_lines_before_imports + 1);
        }
        if (!(types = node.types()).isEmpty()) {
            if (!imports.isEmpty()) {
                this.tm.firstTokenIn((ASTNode)types.get(0), -1).putLineBreaksBefore(this.options.blank_lines_after_imports + 1);
            }
            int i = 1;
            while (i < types.size()) {
                this.tm.firstTokenIn((ASTNode)types.get(i), -1).putLineBreaksBefore(this.options.blank_lines_between_type_declarations + 1);
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        int blanks = this.options.blank_lines_before_package;
        if (blanks > 0) {
            List annotations = node.annotations();
            int firstTokenIndex = annotations.isEmpty() ? this.tm.firstIndexBefore(node.getName(), 106) : this.tm.firstIndexIn((ASTNode)annotations.get(0), -1);
            this.tm.get(firstTokenIndex).putLineBreaksBefore(blanks + 1);
        }
        this.tm.lastTokenIn(node, 27).putLineBreaksAfter(this.options.blank_lines_after_package + 1);
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        this.breakLineBefore(node);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        GuardPredicateDeclaration predicate = node.getGuardPredicate();
        if (predicate != null) {
            this.tm.firstTokenIn(node.getGuardPredicate(), predicate.isBase() ? 32 : 107).breakBefore();
            this.indent(node.getGuardPredicate());
            this.indent(node.getGuardPredicate());
            this.tm.firstTokenAfter(node.getGuardPredicate(), 53).breakBefore();
        }
        this.handleBodyDeclarations(node.bodyDeclarations());
        if (node.getName().getStartPosition() == -1) {
            return true;
        }
        this.breakLineBefore(node);
        this.handleBracedCode(node, node.getName(), this.options.brace_position_for_type_declaration, this.options.indent_body_declarations_compare_to_type_header, this.options.insert_new_line_in_empty_type_declaration);
        this.declarationModifierVisited = false;
        return true;
    }

    private void handleBodyDeclarations(List<BodyDeclaration> bodyDeclarations) {
        BodyDeclaration previous = null;
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (previous == null) {
                this.tm.firstTokenIn(bodyDeclaration, -1).putLineBreaksBefore(this.options.blank_lines_before_first_class_body_declaration + 1);
            } else {
                int blankLines = bodyDeclaration instanceof FieldDeclaration ? this.options.blank_lines_before_field : (bodyDeclaration instanceof AbstractTypeDeclaration ? this.options.blank_lines_before_member_type : this.options.blank_lines_before_method);
                if (!this.sameChunk(previous, bodyDeclaration)) {
                    blankLines = Math.max(blankLines, this.options.blank_lines_before_new_chunk);
                }
                this.tm.firstTokenIn(bodyDeclaration, -1).putLineBreaksBefore(blankLines + 1);
            }
            previous = bodyDeclaration;
        }
    }

    private boolean sameChunk(BodyDeclaration bd1, BodyDeclaration bd2) {
        if (bd1.getClass().equals(bd2.getClass())) {
            return true;
        }
        if (bd1 instanceof AbstractTypeDeclaration && bd2 instanceof AbstractTypeDeclaration) {
            return true;
        }
        return !(!(bd1 instanceof MethodDeclaration) && !(bd1 instanceof Initializer) || !(bd2 instanceof MethodDeclaration) && !(bd2 instanceof Initializer));
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        int index;
        this.handleBracedCode(node, node.getName(), this.options.brace_position_for_enum_declaration, this.options.indent_body_declarations_compare_to_enum_declaration_header, this.options.insert_new_line_in_empty_enum_declaration);
        this.handleBodyDeclarations(node.bodyDeclarations());
        List enumConstants = node.enumConstants();
        int i = 0;
        while (i < enumConstants.size() - 1) {
            EnumConstantDeclaration declaration = (EnumConstantDeclaration)enumConstants.get(i);
            if (declaration.getAnonymousClassDeclaration() != null) {
                this.tm.firstTokenAfter(declaration, 33).breakAfter();
            }
            ++i;
        }
        int n = index = enumConstants.isEmpty() ? this.tm.firstIndexAfter(node.getName(), 53) + 1 : this.tm.firstIndexAfter((ASTNode)enumConstants.get(enumConstants.size() - 1), -1);
        while (true) {
            Token token;
            if (!(token = this.tm.get(index)).isComment()) {
                if (token.tokenType != 27) break;
                token.breakAfter();
            }
            ++index;
        }
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        this.handleBracedCode(node, node.getName(), this.options.brace_position_for_annotation_type_declaration, this.options.indent_body_declarations_compare_to_annotation_declaration_header, this.options.insert_new_line_in_empty_annotation_declaration);
        this.handleBodyDeclarations(node.bodyDeclarations());
        if (node.getModifiers() == 0) {
            this.tm.firstTokenBefore(node.getName(), 39).breakBefore();
        }
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        if (node.getParent() instanceof EnumConstantDeclaration) {
            this.handleBracedCode(node, null, this.options.brace_position_for_enum_constant, this.options.indent_body_declarations_compare_to_enum_constant_header, this.options.insert_new_line_in_empty_enum_constant);
        } else {
            this.handleBracedCode(node, null, this.options.brace_position_for_anonymous_type_declaration, this.options.indent_body_declarations_compare_to_type_header, this.options.insert_new_line_in_empty_anonymous_type_declaration);
        }
        this.handleBodyDeclarations(node.bodyDeclarations());
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (node.isConstructor()) {
            this.handleBracedCode(node.getBody(), null, this.options.brace_position_for_constructor_declaration, this.options.indent_statements_compare_to_body, this.options.insert_new_line_in_empty_method_body);
        } else if (node.getBody() != null) {
            this.handleBracedCode(node.getBody(), null, this.options.brace_position_for_method_declaration, this.options.indent_statements_compare_to_body, this.options.insert_new_line_in_empty_method_body);
            Token openBrace = this.tm.firstTokenIn(node.getBody(), 53);
            if (openBrace.getLineBreaksAfter() > 0) {
                openBrace.putLineBreaksAfter(this.options.blank_lines_at_beginning_of_method_body + 1);
            }
        }
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(Block node) {
        if (this.options.keep_guardian_clause_on_one_line && this.tm.isGuardClause(node)) {
            return true;
        }
        List statements = node.statements();
        for (Statement statement : statements) {
            if (!this.options.put_empty_statement_on_new_line && statement instanceof EmptyStatement) continue;
            this.breakLineBefore(statement);
        }
        if (node.getParent().getLength() == 0) {
            return true;
        }
        ASTNode parent = node.getParent();
        if (parent instanceof MethodDeclaration) {
            return true;
        }
        String bracePosition = this.options.brace_position_for_block;
        if (parent instanceof SwitchStatement) {
            boolean isFirstInCase;
            List siblings = ((SwitchStatement)parent).statements();
            int blockPosition = siblings.indexOf(node);
            boolean bl = isFirstInCase = blockPosition > 0 && siblings.get(blockPosition - 1) instanceof SwitchCase;
            if (isFirstInCase) {
                bracePosition = this.options.brace_position_for_block_in_case;
            }
        } else if (parent instanceof LambdaExpression) {
            bracePosition = this.options.brace_position_for_lambda_body;
        }
        this.handleBracedCode(node, null, bracePosition, this.options.indent_statements_compare_to_block, this.options.insert_new_line_in_empty_block);
        return true;
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.handleBracedCode(node, node.getExpression(), this.options.brace_position_for_switch, this.options.indent_switchstatements_compare_to_switch, true);
        List statements = node.statements();
        if (this.options.indent_switchstatements_compare_to_cases) {
            int nonBreakStatementEnd = -1;
            for (Statement statement : statements) {
                if (statement instanceof SwitchCase) {
                    if (nonBreakStatementEnd >= 0) {
                        this.tm.get(nonBreakStatementEnd + 1).indent();
                        this.tm.firstTokenIn(statement, -1).unindent();
                    }
                } else if (!(statement instanceof BreakStatement) && !(statement instanceof Block)) {
                    this.indent(statement);
                }
                int n = nonBreakStatementEnd = statement instanceof BreakStatement || statement instanceof ReturnStatement ? -1 : this.tm.lastIndexIn(statement, -1);
            }
            if (nonBreakStatementEnd >= 0) {
                this.tm.get(nonBreakStatementEnd + 1).indent();
                this.tm.lastTokenIn(node, 34).unindent();
            }
        }
        if (this.options.indent_breaks_compare_to_cases) {
            for (Statement statement : statements) {
                if (!(statement instanceof BreakStatement)) continue;
                this.indent(statement);
            }
        }
        for (Statement statement : statements) {
            if (statement instanceof Block || !this.options.put_empty_statement_on_new_line && statement instanceof EmptyStatement) continue;
            this.breakLineBefore(statement);
        }
        return true;
    }

    @Override
    public boolean visit(DoStatement node) {
        Statement body = node.getBody();
        this.handleLoopBody(body);
        if (this.options.insert_new_line_before_while_in_do_statement || !(body instanceof Block) && !(body instanceof EmptyStatement)) {
            Token whileToken = this.tm.firstTokenBefore(node.getExpression(), 80);
            whileToken.breakBefore();
        }
        return true;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        if (this.options.insert_new_line_after_label) {
            this.tm.firstTokenIn(node, 66).breakAfter();
        }
        return true;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        boolean isEmpty;
        int openBraceIndex = this.tm.firstIndexIn(node, 53);
        Token afterOpenBraceToken = this.tm.get(openBraceIndex + 1);
        boolean bl = isEmpty = afterOpenBraceToken.tokenType == 34;
        if (isEmpty && this.options.keep_empty_array_initializer_on_one_line) {
            return true;
        }
        Token openBraceToken = this.tm.get(openBraceIndex);
        int closeBraceIndex = this.tm.lastIndexIn(node, 34);
        this.handleBracePosition(openBraceToken, closeBraceIndex, this.options.brace_position_for_array_initializer);
        if (!isEmpty) {
            Token closeBraceToken = this.tm.get(closeBraceIndex);
            if (this.options.insert_new_line_after_opening_brace_in_array_initializer) {
                openBraceToken.breakAfter();
            }
            if (this.options.insert_new_line_before_closing_brace_in_array_initializer) {
                closeBraceToken.breakBefore();
            }
            if (!(node.getParent() instanceof ArrayInitializer)) {
                int i = 0;
                while (i < this.options.continuation_indentation_for_array_initializer) {
                    afterOpenBraceToken.indent();
                    closeBraceToken.unindent();
                    ++i;
                }
            }
        }
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.handleAnnotation(node);
        return true;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.handleAnnotation(node);
        return true;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.handleAnnotation(node);
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        this.declarationModifierVisited = false;
        if (node.getParent() instanceof MethodDeclaration) {
            this.declarationModifierVisited = node.getModifiers() == 0;
        }
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.declarationModifierVisited = false;
        return true;
    }

    @Override
    public boolean visit(Modifier node) {
        this.declarationModifierVisited = true;
        return true;
    }

    private void handleAnnotation(Annotation node) {
        ASTNode parentNode = node.getParent();
        boolean breakAfter = false;
        boolean isTypeAnnotation = this.declarationModifierVisited;
        if (isTypeAnnotation) {
            breakAfter = this.options.insert_new_line_after_type_annotation;
        } else if (parentNode instanceof PackageDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_package;
        } else if (parentNode instanceof AbstractTypeDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_type;
        } else if (parentNode instanceof FieldDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_field;
        } else if (parentNode instanceof MethodDeclaration || parentNode instanceof AnnotationTypeMemberDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_method;
        } else if (parentNode instanceof VariableDeclarationStatement || parentNode instanceof VariableDeclarationExpression) {
            breakAfter = this.options.insert_new_line_after_annotation_on_local_variable;
        } else if (parentNode instanceof SingleVariableDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_parameter;
            if (parentNode.getParent() instanceof EnhancedForStatement) {
                breakAfter = this.options.insert_new_line_after_annotation_on_local_variable;
            }
        }
        if (breakAfter) {
            this.tm.lastTokenIn(node, -1).breakAfter();
        }
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.handleLoopBody(node.getBody());
        return true;
    }

    @Override
    public boolean visit(ForStatement node) {
        this.handleLoopBody(node.getBody());
        return true;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.handleLoopBody(node.getBody());
        return true;
    }

    private void handleLoopBody(Statement body) {
        if (!(body instanceof Block || body instanceof EmptyStatement && !this.options.put_empty_statement_on_new_line)) {
            this.breakLineBefore(body);
            this.indent(body);
        }
    }

    @Override
    public boolean visit(IfStatement node) {
        boolean keepThenOnSameLine;
        Statement elseNode = node.getElseStatement();
        Statement thenNode = node.getThenStatement();
        if (elseNode != null) {
            boolean keepElseOnSameLine;
            if (this.options.insert_new_line_before_else_in_if_statement || !(thenNode instanceof Block)) {
                this.tm.firstTokenBefore(elseNode, 124).breakBefore();
            }
            boolean bl = keepElseOnSameLine = elseNode instanceof Block || this.options.keep_else_statement_on_same_line || this.options.compact_else_if && elseNode instanceof IfStatement;
            if (!keepElseOnSameLine) {
                this.breakLineBefore(elseNode);
                this.indent(elseNode);
            }
        }
        boolean bl = keepThenOnSameLine = this.options.keep_then_statement_on_same_line || this.options.keep_simple_if_on_one_line && elseNode == null;
        if (!keepThenOnSameLine && !(thenNode instanceof Block)) {
            this.breakLineBefore(thenNode);
            this.indent(thenNode);
        }
        return true;
    }

    @Override
    public boolean visit(TryStatement node) {
        if (node.getFinally() != null && this.options.insert_new_line_before_finally_in_try_statement) {
            this.tm.firstTokenBefore(node.getFinally(), 122).breakBefore();
        }
        return true;
    }

    @Override
    public boolean visit(CatchClause node) {
        if (this.options.insert_new_line_before_catch_in_try_statement) {
            this.breakLineBefore(node);
        }
        return true;
    }

    @Override
    public boolean visit(RoleTypeDeclaration node) {
        return this.visit((TypeDeclaration)node);
    }

    @Override
    public boolean visit(CalloutMappingDeclaration node) {
        if (node.hasParameterMapping()) {
            for (Object pMap : node.getParameterMappings()) {
                this.breakLineBefore((ASTNode)pMap);
            }
            String bracePosition = this.options.brace_position_for_method_declaration;
            this.handleBracedCode(node, null, bracePosition, this.options.indent_statements_compare_to_block, this.options.insert_new_line_in_empty_block);
        }
        return true;
    }

    @Override
    public boolean visit(CallinMappingDeclaration node) {
        GuardPredicateDeclaration predicate = node.getGuardPredicate();
        if (predicate != null) {
            this.tm.firstTokenIn(node.getGuardPredicate(), predicate.isBase() ? 32 : 107).breakBefore();
            this.indent(node.getGuardPredicate());
        }
        if (node.hasParameterMapping()) {
            for (Object pMap : node.getParameterMappings()) {
                this.breakLineBefore((ASTNode)pMap);
            }
            String bracePosition = this.options.brace_position_for_method_declaration;
            this.handleBracedCode(node, null, bracePosition, this.options.indent_statements_compare_to_block, this.options.insert_new_line_in_empty_block);
        }
        return true;
    }

    @Override
    public boolean visit(WithinStatement node) {
        this.handleLoopBody(node.getBody());
        return true;
    }

    private void breakLineBefore(ASTNode node) {
        this.tm.firstTokenIn(node, -1).breakBefore();
    }

    private void handleBracedCode(ASTNode node, ASTNode nodeBeforeOpenBrace, String bracePosition, boolean indentBody, boolean newLineInEmpty) {
        int openBraceIndex = nodeBeforeOpenBrace == null ? this.tm.firstIndexIn(node, 53) : this.tm.firstIndexAfter(nodeBeforeOpenBrace, 53);
        int closeBraceIndex = this.tm.lastIndexIn(node, 34);
        Token openBraceToken = this.tm.get(openBraceIndex);
        this.handleBracePosition(openBraceToken, closeBraceIndex, bracePosition);
        boolean isEmpty = true;
        int i = openBraceIndex + 1;
        while (i < closeBraceIndex) {
            if (!this.tm.get(i).isComment()) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        if (!isEmpty || newLineInEmpty) {
            openBraceToken.breakAfter();
            this.tm.get(closeBraceIndex).breakBefore();
        }
        if (indentBody) {
            this.tm.get(openBraceIndex + 1).indent();
            this.tm.get(closeBraceIndex).unindent();
        }
    }

    private void handleBracePosition(Token openBraceToken, int closeBraceIndex, String bracePosition) {
        if (bracePosition.equals("next_line")) {
            openBraceToken.breakBefore();
        } else if (bracePosition.equals("next_line_shifted")) {
            openBraceToken.breakBefore();
            openBraceToken.indent();
            if (closeBraceIndex + 1 < this.tm.size()) {
                this.tm.get(closeBraceIndex + 1).unindent();
            }
        } else if (bracePosition.equals("next_line_on_wrap")) {
            openBraceToken.setNextLineOnWrap();
        }
    }

    private void indent(ASTNode node) {
        int startIndex = this.tm.firstIndexIn(node, -1);
        while (startIndex > 0 && this.tm.get(startIndex - 1).isComment()) {
            --startIndex;
        }
        this.tm.get(startIndex).indent();
        int lastIndex = this.tm.lastIndexIn(node, -1);
        if (lastIndex + 1 < this.tm.size()) {
            this.tm.get(lastIndex + 1).unindent();
        }
    }

    public void finishUp() {
        int currentIndent = this.options.initial_indentation_level;
        for (Token token : this.tm) {
            token.setIndent((currentIndent += token.getIndent()) * this.options.indentation_size);
        }
    }
}

