/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.jdt.nullity.quickfix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.objectteams.internal.jdt.nullity.quickfix.FixMessages;
import org.eclipse.objectteams.internal.jdt.nullity.quickfix.QuickFixes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullAnnotationsCleanUp
extends AbstractMultiFix {
    private QuickFixes master;
    private int handledProblemID;

    public NullAnnotationsCleanUp(Map<String, String> options, QuickFixes quickFixes, int handledProblemID) {
        super(options);
        this.master = quickFixes;
        this.handledProblemID = handledProblemID;
    }

    public CleanUpRequirements getRequirements() {
        Map requiredOptions = this.getRequiredOptions();
        return new CleanUpRequirements(true, false, false, requiredOptions);
    }

    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return this.createFix(compilationUnit, null);
    }

    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        ArrayList<IProblemLocation> filteredLocations = new ArrayList<IProblemLocation>();
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getProblemId() == this.handledProblemID) {
                filteredLocations.add(problems[i]);
            }
            ++i;
        }
        return this.master.createCleanUp(compilationUnit, filteredLocations.toArray(new IProblemLocation[filteredLocations.size()]), this.handledProblemID);
    }

    private Map getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("org.eclipse.jdt.core.compiler.problem.nullContractViolation", "warning");
        result.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        return result;
    }

    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        switch (this.handledProblemID) {
            case 67109744: 
            case 67109745: 
            case 67109747: 
            case 536871369: 
            case 536871370: {
                result.add(FixMessages.NullAnnotationsCleanUp_add_nullable_annotation);
                break;
            }
            case 67109756: 
            case 67109757: {
                result.add(FixMessages.NullAnnotationsCleanUp_add_nonnull_annotation);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        return "No preview available";
    }

    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == this.handledProblemID;
    }

    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id = problems[i].getID();
            if (id == this.handledProblemID) {
                ++result;
            }
            ++i;
        }
        return result;
    }
}

