/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.IRoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public abstract class TeamAnchor
extends Binding
implements ITeamAnchor {
    public TypeBinding type;
    protected ITeamAnchor[] bestNamePath = new ITeamAnchor[]{this};

    public boolean isTeam() {
        return this.type.isTeam();
    }

    public boolean couldBeTeamAnchor() {
        return this.isValidBinding() && this.isFinal() && this.type.isTeam();
    }

    public ITeamAnchor[] getBestNamePath() {
        return this.getBestNamePath(true);
    }

    public ITeamAnchor[] getBestNamePath(boolean needResolve) {
        if (needResolve) {
            this.resolveInitIfNeeded();
        }
        return this.flattenBestNamePath(this.bestNamePath, 0);
    }

    public boolean pathIsAbsolute() {
        return ((TeamAnchor)this.bestNamePath[0]).kind() == 1;
    }

    public boolean isValidAnchor() {
        if (!this.isValidBinding()) {
            return false;
        }
        if (!this.type.isValidBinding()) {
            return false;
        }
        return !this.type.leafComponentType().isBaseType();
    }

    private ITeamAnchor[] flattenBestNamePath(ITeamAnchor[] tree, int start) {
        if (tree == null || start >= tree.length) {
            return new ITeamAnchor[0];
        }
        ReferenceBinding firstType = ((TeamAnchor)this.bestNamePath[start]).leafType();
        ITeamAnchor[] prefix = RoleTypeBinding.isRoleWithExplicitAnchor(firstType) ? ((IRoleTypeBinding)((Object)firstType)).getAnchorBestName() : new ITeamAnchor[]{this.bestNamePath[start]};
        if (start == tree.length - 1) {
            return prefix;
        }
        ITeamAnchor[] tail = this.flattenBestNamePath(tree, start + 1);
        if (tail.length == 0) {
            return prefix;
        }
        int len1 = prefix.length;
        int len2 = tail.length;
        ITeamAnchor[] result = new ITeamAnchor[len1 + len2];
        System.arraycopy(prefix, 0, result, 0, len1);
        System.arraycopy(tail, 0, result, len1, len2);
        return result;
    }

    public char[][] tokens() {
        char[][] tokens = new char[this.bestNamePath.length][];
        int i = 0;
        while (i < this.bestNamePath.length) {
            tokens[i] = this.bestNamePath[i].internalName();
            ++i;
        }
        return tokens;
    }

    public void setBestNameFromStat(Statement rhs) {
        ITeamAnchor[] path;
        if (this.isFinal() && this.type instanceof ReferenceBinding && (path = this.getBestNameFromStat(rhs)) != null) {
            ITeamAnchor lastBinding = path[path.length - 1];
            if (this instanceof FieldBinding && lastBinding instanceof LocalVariableBinding) {
                LocalVariableBinding localVar = (LocalVariableBinding)lastBinding;
                BlockScope scope = localVar.declaringScope;
                if (scope.referenceContext() instanceof ConstructorDeclaration && lastBinding.isFinal() && (localVar.tagBits & 0x400L) != 0L && !localVar.pathIsAbsolute()) {
                    lastBinding.shareBestName(this);
                }
                return;
            }
            this.bestNamePath = path;
        }
    }

    public void shareBestName(ITeamAnchor other) {
        this.bestNamePath = other.getBestNamePath();
    }

    private ITeamAnchor[] getBestNameFromStat(Statement stat) {
        if (stat instanceof Argument) {
            return ((Argument)stat).binding.bestNamePath;
        }
        Expression expr = (Expression)stat;
        if (RoleTypeBinding.isRoleWithExplicitAnchor(expr.resolvedType)) {
            return ((IRoleTypeBinding)((Object)expr.resolvedType)).getAnchorBestName();
        }
        if (expr instanceof QualifiedNameReference) {
            QualifiedNameReference qRef = (QualifiedNameReference)expr;
            if (qRef.binding instanceof ITeamAnchor) {
                ITeamAnchor first = (ITeamAnchor)((Object)qRef.binding);
                if (!first.isFinal()) {
                    return null;
                }
                int resultLength = qRef.otherBindings == null ? 0 : qRef.otherBindings.length;
                ITeamAnchor[] result = new ITeamAnchor[resultLength + 1];
                result[0] = first;
                int i = 0;
                while (i < resultLength) {
                    result[i + 1] = qRef.otherBindings[i];
                    if (!result[i + 1].isFinal()) {
                        return null;
                    }
                    ++i;
                }
                return result;
            }
        } else if (expr instanceof NameReference) {
            Binding bind = ((NameReference)expr).binding;
            if (bind instanceof VariableBinding && ((VariableBinding)bind).isFinal()) {
                return ((VariableBinding)bind).bestNamePath;
            }
        } else if (expr instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)expr;
            if (fieldRef.binding.isFinal()) {
                ITeamAnchor[] prefix = this.getBestNameFromStat(fieldRef.receiver);
                if (prefix == null) {
                    prefix = new VariableBinding[]{};
                }
                ITeamAnchor[] tail = fieldRef.binding.bestNamePath;
                ITeamAnchor[] path = new ITeamAnchor[prefix.length + tail.length];
                System.arraycopy(prefix, 0, path, 0, prefix.length);
                System.arraycopy(tail, 0, path, prefix.length, tail.length);
                return path;
            }
        }
        return null;
    }

    public static ITeamAnchor getTeamAnchor(Expression expression) {
        Binding bind = null;
        if (expression instanceof NameReference) {
            FieldBinding[] otherFields;
            bind = ((NameReference)expression).binding;
            if (expression instanceof QualifiedNameReference && (otherFields = ((QualifiedNameReference)expression).otherBindings) != null && otherFields.length > 0) {
                int len = otherFields.length;
                ITeamAnchor anchor = otherFields[len - 1];
                int i = len - 2;
                while (i >= 0) {
                    anchor = anchor.setPathPrefix(otherFields[i]);
                    --i;
                }
                if (bind instanceof ITeamAnchor) {
                    return anchor.setPathPrefix((ITeamAnchor)((Object)bind));
                }
            }
        } else if (expression instanceof TypeAnchorReference) {
            bind = (Binding)((Object)((TypeAnchorReference)expression).getResolvedAnchor());
        }
        if (bind != null && bind instanceof TeamAnchor) {
            return (TeamAnchor)bind;
        }
        TypeBinding type = expression.resolvedType;
        if (RoleTypeBinding.isRoleType(type)) {
            return ((IRoleTypeBinding)((Object)type)).getAnchor();
        }
        return null;
    }

    public boolean hasSameBestNameAs(ITeamAnchor other) {
        if (other == this) {
            return true;
        }
        ITeamAnchor[] thisBestName = this.getBestNamePath();
        ITeamAnchor[] otherBestName = other.getBestNamePath();
        if (thisBestName.length == 1 && thisBestName[0] == other) {
            return true;
        }
        if (otherBestName.length == 1 && otherBestName[0] == this) {
            return true;
        }
        if (thisBestName.length == otherBestName.length) {
            int i = 0;
            while (i < thisBestName.length) {
                if (!this.isSameVariable(thisBestName[i], otherBestName[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isSameVariable(ITeamAnchor one, ITeamAnchor two) {
        if (one == two) {
            return true;
        }
        if (one instanceof TThisBinding && two instanceof TThisBinding) {
            return true;
        }
        if (one instanceof FieldBinding && two instanceof FieldBinding) {
            FieldBinding f1 = (FieldBinding)one;
            FieldBinding f2 = (FieldBinding)two;
            if (!CharOperation.equals(f1.name, f2.name)) {
                return false;
            }
            return FieldModel.getActualDeclaringClass(f1) == FieldModel.getActualDeclaringClass(f2);
        }
        return false;
    }

    protected void resolveInitIfNeeded() {
    }

    public char[] getBestName() {
        char[][] tokens;
        int len = this.bestNamePath.length;
        int prefixLen = 0;
        if (this.bestNamePath[0] instanceof FieldBinding) {
            tokens = new char[len + 1][];
            tokens[0] = CharOperation.concatWith(((FieldBinding)this.bestNamePath[0]).declaringClass.compoundName, '.');
            ++prefixLen;
        } else {
            tokens = new char[len][];
        }
        int i = 0;
        while (i < len) {
            tokens[i + prefixLen] = this.bestNamePath[i].internalName();
            ++i;
        }
        return CharOperation.concatWith(tokens, '.');
    }

    public ITeamAnchor asAnchorFor(ReferenceBinding roleType) {
        if (!(this.type instanceof ReferenceBinding)) {
            return null;
        }
        ReferenceBinding leafType = this.leafType();
        if (TeamModel.isTeamContainingRole(leafType, roleType)) {
            if (this instanceof TThisBinding && RoleTypeBinding.isRoleWithExplicitAnchor(roleType)) {
                return ((IRoleTypeBinding)((Object)roleType)).getAnchor();
            }
            return this;
        }
        if (leafType instanceof IRoleTypeBinding) {
            return ((IRoleTypeBinding)((Object)leafType)).getAnchor().asAnchorFor(roleType);
        }
        return null;
    }

    public ITeamAnchor retrieveAnchorFromAnchorRoleTypeFor(ReferenceBinding roleType) {
        if (this.type != null && RoleTypeBinding.isRoleType(this.leafType())) {
            ITeamAnchor anchor = ((IRoleTypeBinding)((Object)this.leafType())).getAnchor();
            if (anchor.isTeamContainingRole(roleType)) {
                return anchor;
            }
            return anchor.asAnchorFor(roleType);
        }
        return null;
    }

    protected abstract TeamAnchor getClone();

    public ITeamAnchor setPathPrefix(ITeamAnchor prefix) {
        TeamAnchor result = this.getClone();
        ITeamAnchor[] prefixBestName = prefix.getBestNamePath();
        ITeamAnchor[] thisBestName = this.getBestNamePath();
        int len1 = prefixBestName.length;
        int len2 = thisBestName.length;
        result.bestNamePath = new VariableBinding[len1 + len2];
        System.arraycopy(prefixBestName, 0, result.bestNamePath, 0, len1);
        System.arraycopy(thisBestName, 0, result.bestNamePath, len1, len2);
        return result;
    }

    public ITeamAnchor replaceFirst(ITeamAnchor anchor) {
        TeamAnchor result = this.getClone();
        result.bestNamePath[0] = anchor;
        return result;
    }

    public boolean isPrefixLegal(ReferenceBinding site, ITeamAnchor prefix) {
        ITeamAnchor firstField = this.bestNamePath[0];
        if (firstField instanceof FieldBinding) {
            ReferenceBinding declaringClass = ((FieldBinding)firstField).declaringClass;
            if (this.maySkipAnchor(site, prefix, declaringClass)) {
                return false;
            }
            ReferenceBinding currentType = (ReferenceBinding)((TeamAnchor)prefix).type.leafComponentType();
            while (currentType != null) {
                if (currentType.isCompatibleWith(declaringClass)) {
                    return true;
                }
                currentType = currentType.enclosingType();
            }
        }
        return false;
    }

    private boolean maySkipAnchor(ReferenceBinding site, ITeamAnchor prefix, ReferenceBinding declaringClass) {
        if (((TeamAnchor)prefix).hasRoleTypeWithRelevantAnchor()) {
            return false;
        }
        ReferenceBinding currentType = site;
        while (currentType != null) {
            if (currentType.isCompatibleWith(declaringClass)) {
                return true;
            }
            currentType = currentType.enclosingType();
        }
        return false;
    }

    private boolean hasRoleTypeWithRelevantAnchor() {
        int i = 0;
        while (i < this.bestNamePath.length) {
            ReferenceBinding currentLeafType = ((TeamAnchor)this.bestNamePath[i]).leafType();
            if (RoleTypeBinding.isRoleWithExplicitAnchor(currentLeafType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasValidReferenceType() {
        return this.type != null && this.type instanceof ReferenceBinding && this.type.isValidBinding();
    }

    public boolean hasSameTypeAs(ITeamAnchor other) {
        return this.leafType() == ((TeamAnchor)other).leafType();
    }

    public TeamModel getTeamModelOfType() {
        return this.leafType().getTeamModel();
    }

    public boolean isTypeCompatibleWith(ReferenceBinding other) {
        if (!(this.type instanceof ReferenceBinding)) {
            return false;
        }
        if (this.type.isRole()) {
            return ((ReferenceBinding)this.type).getRealClass().isCompatibleWith(other);
        }
        return this.type.isCompatibleWith(other);
    }

    public boolean isTypeCompatibleWithTypeOf(ITeamAnchor other) {
        ReferenceBinding otherAnchorType = (ReferenceBinding)((TeamAnchor)other).type;
        if (otherAnchorType.isRole() && !otherAnchorType.isInterface()) {
            otherAnchorType = otherAnchorType.roleModel.getInterfacePartBinding();
        }
        return this.type.isCompatibleWith(otherAnchorType);
    }

    public void setStaticallyKnownTeam(RoleTypeBinding rtb) {
        ReferenceBinding teamBinding = this.leafType();
        if (teamBinding.isSynthInterface()) {
            ReferenceBinding outerTeam = teamBinding.enclosingType();
            char[] teamName = CharOperation.concat(IOTConstants.OT_DELIM_NAME, teamBinding.internalName());
            teamBinding = outerTeam.getMemberType(teamName);
        }
        rtb._staticallyKnownTeam = teamBinding;
    }

    public boolean isTeamContainingRole(ReferenceBinding roleType) {
        return TeamModel.isTeamContainingRole(this.leafType(), roleType);
    }

    public FieldBinding getFieldOfType(char[] token, boolean isStatic, boolean allowOuter) {
        return TypeAnalyzer.findField(this.leafType(), token, isStatic, allowOuter);
    }

    public ReferenceBinding getMemberTypeOfType(char[] name) {
        ReferenceBinding roleType = this.leafType().getMemberType(name);
        if (roleType == null) {
            return null;
        }
        return (RoleTypeBinding)this.getRoleTypeBinding(roleType, 0);
    }

    public RoleModel getStrengthenedRole(ReferenceBinding role) {
        if (role.roleModel.getTeamModel().getBinding() != this.leafType()) {
            return this.leafType().getMemberType((char[])role.internalName()).roleModel;
        }
        return role.roleModel;
    }

    public static ITeamAnchor maybeImproveAnchor(ReferenceBinding site, ITeamAnchor existingAnchor, Expression receiver) {
        TeamAnchor receiverVar = null;
        FieldBinding fallback = null;
        if (receiver instanceof CastExpression) {
            receiver = ((CastExpression)receiver).expression;
        }
        if (receiver instanceof NameReference) {
            Binding bind = ((NameReference)receiver).binding;
            if (bind instanceof VariableBinding) {
                receiverVar = (VariableBinding)bind;
            }
        } else if (receiver instanceof AllocationExpression) {
            receiverVar = new FieldBinding(("'non-final anchor " + receiver.toString() + '\'').toCharArray(), receiver.resolvedType, 16, site, Constant.NotAConstant){

                public int problemId() {
                    return 1102209;
                }
            };
            fallback = receiverVar;
        } else {
            TypeBinding receiverType = receiver.resolvedType;
            if (receiverType != null && RoleTypeBinding.isRoleWithExplicitAnchor(receiverType)) {
                receiverVar = (TeamAnchor)((IRoleTypeBinding)((Object)receiverType)).getAnchor();
            }
        }
        if (receiverVar != null) {
            ITeamAnchor[] prefix = existingAnchor.getBestNamePath();
            ITeamAnchor previous = null;
            if (prefix != null && prefix.length > 0) {
                previous = prefix[prefix.length - 1];
            }
            if (previous instanceof FieldBinding) {
                if (DependentTypeBinding.isDependentTypeOf(receiverVar.type, previous)) {
                    DependentTypeBinding depReceiver = (DependentTypeBinding)receiverVar.type;
                    return existingAnchor.replaceFirst(depReceiver._teamAnchor);
                }
                FieldBinding previousField = (FieldBinding)previous;
                ReferenceBinding currentType = null;
                boolean firstImplicitlyReachable = false;
                if (receiverVar instanceof FieldBinding) {
                    currentType = ((FieldBinding)receiverVar).declaringClass;
                } else if (receiverVar instanceof LocalVariableBinding) {
                    currentType = ((LocalVariableBinding)receiverVar).declaringScope.enclosingSourceType();
                }
                while (currentType != null) {
                    if (currentType.isCompatibleWith(previousField.declaringClass)) {
                        firstImplicitlyReachable = true;
                        break;
                    }
                    currentType = currentType.enclosingType();
                }
                currentType = super.leafType();
                while (currentType != null) {
                    if (currentType.isCompatibleWith(previousField.declaringClass)) {
                        if (firstImplicitlyReachable) {
                            if (fallback != null) {
                                return fallback;
                            }
                        } else {
                            return existingAnchor.setPathPrefix(receiverVar);
                        }
                    }
                    currentType = currentType.enclosingType();
                    fallback = null;
                }
                if (firstImplicitlyReachable) {
                    return existingAnchor;
                }
            }
            return null;
        }
        return null;
    }

    public TypeBinding getResolvedType() {
        if (this.leafType() != null && this.leafType().isRole()) {
            int len;
            ITeamAnchor previousAnchor;
            ReferenceBinding roleIfc = this.leafType().roleModel.getInterfacePartBinding();
            if (this.bestNamePath != null && this.bestNamePath.length > 1 && (previousAnchor = this.bestNamePath[(len = this.bestNamePath.length) - 2]).isTeam()) {
                int i = len - 3;
                while (i >= 0) {
                    previousAnchor = previousAnchor.setPathPrefix(this.bestNamePath[i]);
                    --i;
                }
                TypeBinding[] typeArguments = this.type.isParameterizedType() ? ((ParameterizedTypeBinding)this.type).arguments : null;
                return previousAnchor.getDependentTypeBinding(roleIfc, -1, typeArguments, this.type.dimensions());
            }
            return roleIfc;
        }
        return this.type;
    }

    private ReferenceBinding leafType() {
        if (this.type != null) {
            return (ReferenceBinding)this.type.leafComponentType();
        }
        return null;
    }

    public ReferenceBinding getFirstDeclaringClass() {
        if (this.bestNamePath[0] instanceof FieldBinding) {
            return ((FieldBinding)this.bestNamePath[0]).declaringClass;
        }
        if (this.bestNamePath[0] instanceof TThisBinding) {
            return ((TThisBinding)this.bestNamePath[0]).declaringClass;
        }
        return null;
    }

    public TypeBinding getRoleTypeBinding(ReferenceBinding roleBinding, int dimensions) {
        TypeBinding[] typeArguments = roleBinding.isParameterizedType() ? ((ParameterizedTypeBinding)roleBinding).arguments : null;
        return this.getRoleTypeBinding(roleBinding, typeArguments, dimensions);
    }

    public TypeBinding getRoleTypeBinding(ReferenceBinding roleBinding, TypeBinding[] arguments, int dimensions) {
        if (this.kind() == 2) {
            ((LocalVariableBinding)this).useFlag = 1;
        }
        if (RoleTypeBinding.isRoleWithExplicitAnchor(roleBinding)) {
            return this.getRoleTypeBinding(roleBinding.getRealType(), arguments, dimensions);
        }
        ReferenceBinding roleEnclosing = roleBinding.enclosingType();
        if (roleEnclosing != null && roleEnclosing.erasure() != this.leafType().getRealClass()) {
            DependentTypeBinding strongRoleType;
            ReferenceBinding strengthenedRole = (ReferenceBinding)TeamModel.strengthenRoleType(this.leafType(), roleBinding);
            if (strengthenedRole != roleBinding && (strongRoleType = (DependentTypeBinding)this.getRoleTypeBinding(strengthenedRole, arguments, 0)) != null) {
                return WeakenedTypeBinding.makeWeakenedTypeBinding(strongRoleType, roleBinding, dimensions);
            }
            if (dimensions == roleBinding.dimensions() && DependentTypeBinding.isDependentType(roleBinding)) {
                return roleBinding;
            }
        }
        int paramPosition = -1;
        if (roleBinding instanceof DependentTypeBinding) {
            paramPosition = ((DependentTypeBinding)roleBinding)._valueParamPosition;
        }
        if (roleBinding instanceof RoleTypeBinding && !this.isTeamContainingRole(roleBinding)) {
            return this.asAnchorFor(roleBinding).getDependentTypeBinding(roleBinding, paramPosition, arguments, dimensions, ((RoleTypeBinding)roleBinding).environment);
        }
        if (roleBinding instanceof WeakenedTypeBinding && ((WeakenedTypeBinding)roleBinding)._teamAnchor == this) {
            return roleBinding;
        }
        if (roleBinding instanceof ParameterizedTypeBinding) {
            return this.getDependentTypeBinding(roleBinding, paramPosition, arguments, dimensions, ((ParameterizedTypeBinding)roleBinding).environment);
        }
        return this.getDependentTypeBinding(roleBinding, paramPosition, arguments, dimensions);
    }

    public TypeBinding getDependentTypeBinding(ReferenceBinding typeBinding, int paramPosition, TypeBinding[] arguments, int dimensions) {
        try {
            return this.getDependentTypeBinding(typeBinding, paramPosition, arguments, dimensions, Config.getLookupEnvironment());
        }
        catch (Config.NotConfiguredException e) {
            throw new AbortCompilation(false, e);
        }
    }

    public TypeBinding getDependentTypeBinding(ReferenceBinding typeBinding, int paramPosition, TypeBinding[] arguments, int dimensions, LookupEnvironment env) {
        DependentTypeBinding dependentTypeBinding = (DependentTypeBinding)env.createParameterizedType(typeBinding, arguments, this, paramPosition, typeBinding.enclosingType());
        return dimensions > 0 ? dependentTypeBinding.getArrayType(dimensions) : dependentTypeBinding;
    }

    public TypeBinding resolveRoleType(char[] roleName, int dims) {
        if (!this.type.isTeam()) {
            return null;
        }
        ReferenceBinding roleType = ((ReferenceBinding)this.type).getMemberType(roleName);
        if (roleType == null || !roleType.isValidBinding()) {
            return roleType;
        }
        return this.getRoleTypeBinding(roleType, dims);
    }
}

