/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.delete;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Animal;
import ee.jakarta.tck.nosql.factories.AnimalListSupplier;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class DeleteTemplateMappedSuperclassTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with no conditions")
    void shouldInsertIterableAndDeleteNoCondition(List<Animal> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Animal.class).execute();
            List result = this.template.select(Animal.class).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with simple condition")
    void shouldInsertIterableAndDeleteWithSimpleCondition(List<Animal> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Animal.class).where("name").eq((Object)entities.get(0).getName()).execute();
            List result = this.template.select(Animal.class).where("name").eq((Object)entities.get(0).getName()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'in' condition")
    void shouldInsertIterableAndDeleteWithInCondition(List<Animal> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Animal.class).where("name").in(List.of(entities.get(0).getName())).execute();
            List result = this.template.select(Animal.class).where("name").in(List.of(entities.get(0).getName())).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'between' condition")
    void shouldInsertIterableAndDeleteWithBetweenCondition(List<Animal> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Animal.class).where("species").between((Object)entities.get(0).getSpecies(), (Object)"Zebra").execute();
            List result = this.template.select(Animal.class).where("species").between((Object)entities.get(0).getSpecies(), (Object)"Zebra").result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'complex' query")
    void shouldInsertIterableAndDeleteWithComplexQuery(List<Animal> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Animal.class).where("genus").eq((Object)entities.get(0).getGenus()).and("species").eq((Object)entities.get(0).getSpecies()).execute();
            List result = this.template.select(Animal.class).where("genus").eq((Object)entities.get(0).getGenus()).and("species").eq((Object)entities.get(0).getSpecies()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

