/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.UpdateRowGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.event.RowGroupCollapseEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.event.RowGroupExpandEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class RowGroupExpandCollapseLayer
extends AbstractRowHideShowLayer {
    private final MutableMap<GroupModel.Group, MutableIntSet> hidden = Maps.mutable.empty();

    public RowGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowGroupExpandCommand) {
            List<GroupModel.Group> groups = ((RowGroupExpandCommand)command).getGroups();
            MutableIntSet shownIndexes = IntSets.mutable.empty();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable() || !group.isCollapsed()) continue;
                group.setCollapsed(false);
                MutableIntSet rowIndexes = (MutableIntSet)this.hidden.get((Object)group);
                this.hidden.remove((Object)group);
                shownIndexes.addAll((IntIterable)rowIndexes);
            }
            if (!shownIndexes.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new RowGroupExpandEvent((ILayer)this, this.getRowPositionsByIndexes(shownIndexes.toArray())));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof RowGroupCollapseCommand) {
            GroupModel groupModel = ((RowGroupCollapseCommand)command).getGroupModel();
            List<GroupModel.Group> groups = ((RowGroupCollapseCommand)command).getGroups();
            Collections.sort(groups, (o1, o2) -> o2.getVisibleStartPosition() - o1.getVisibleStartPosition());
            MutableIntSet hiddenPositions = IntSets.mutable.empty();
            MutableIntSet hiddenIndexes = IntSets.mutable.empty();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable()) continue;
                MutableIntSet rowIndexes = IntSets.mutable.empty();
                if (!group.isCollapsed()) {
                    rowIndexes.addAll(group.getVisibleIndexes());
                    group.setCollapsed(true);
                } else if (!this.hidden.containsKey((Object)group)) {
                    int[] nArray = group.getMembers();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int member = nArray[n2];
                        int pos = groupModel.getPositionByIndex(member);
                        if (pos > -1) {
                            rowIndexes.add(member);
                        }
                        ++n2;
                    }
                }
                this.modifyForVisible(group, rowIndexes);
                hiddenPositions.addAll(this.getRowPositionsByIndexes(rowIndexes.toArray()));
                hiddenIndexes.addAll((IntIterable)rowIndexes);
                this.hidden.put((Object)group, (Object)rowIndexes);
            }
            if (!hiddenPositions.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new RowGroupCollapseEvent((ILayer)this, hiddenPositions.toArray(), hiddenIndexes.toArray()));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof UpdateRowGroupCollapseCommand) {
            UpdateRowGroupCollapseCommand cmd = (UpdateRowGroupCollapseCommand)command;
            GroupModel.Group group = cmd.getGroup();
            MutableIntSet hiddenRowIndexes = (MutableIntSet)this.hidden.get((Object)group);
            if (group.getVisibleIndexes().length + hiddenRowIndexes.size() <= group.getOriginalSpan()) {
                MutableIntSet indexesToHide = IntSets.mutable.of(cmd.getIndexesToHide());
                MutableIntSet indexesToShow = IntSets.mutable.of(cmd.getIndexesToShow());
                indexesToHide.removeAll((IntIterable)hiddenRowIndexes);
                this.modifyForVisible(group, indexesToHide);
                int[] hiddenPositions = this.getRowPositionsByIndexes(indexesToHide.toArray());
                hiddenRowIndexes.addAll((IntIterable)indexesToHide);
                hiddenRowIndexes.removeAll((IntIterable)indexesToShow);
                this.invalidateCache();
                this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, hiddenPositions, indexesToHide.toArray()));
            }
            return true;
        }
        return super.doCommand(command);
    }

    private void modifyForVisible(GroupModel.Group group, MutableIntSet rowIndexes) {
        int[] staticIndexes = group.getStaticIndexes();
        if (staticIndexes.length == 0) {
            rowIndexes.remove(group.getVisibleStartIndex());
        } else {
            rowIndexes.removeAll(staticIndexes);
        }
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        MutableIntSet found = (MutableIntSet)this.hidden.detect((Predicate & Serializable)indexes -> indexes.contains(rowIndex));
        return found != null;
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        MutableIntList hiddenRowIndexes = IntLists.mutable.empty();
        for (MutableIntSet indexes : this.hidden.values()) {
            hiddenRowIndexes.addAll((IntIterable)indexes);
        }
        return ArrayUtil.asIntegerList(hiddenRowIndexes.distinct().toSortedArray());
    }

    @Override
    public int[] getHiddenRowIndexesArray() {
        MutableIntList hiddenRowIndexes = IntLists.mutable.empty();
        for (MutableIntSet indexes : this.hidden.values()) {
            hiddenRowIndexes.addAll((IntIterable)indexes);
        }
        return hiddenRowIndexes.distinct().toSortedArray();
    }

    @Override
    public boolean hasHiddenRows() {
        return !this.hidden.isEmpty();
    }
}

