/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.command.RowInsertCommand;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.event.KeyRowInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class KeyRowInsertCommandHandler<T>
implements ILayerCommandHandler<RowInsertCommand> {
    private List<T> bodyData;
    private final CellKeyHandler<?> keyHandler;

    public KeyRowInsertCommandHandler(List<T> bodyData, CellKeyHandler<?> keyHandler) {
        this.bodyData = bodyData;
        this.keyHandler = keyHandler;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, RowInsertCommand command) {
        if (command.convertToTargetLayer(targetLayer)) {
            if (command.getRowIndex() < 0 || command.getRowIndex() >= this.bodyData.size()) {
                int start = this.bodyData.size();
                this.bodyData.addAll(command.getObjects());
                ArrayList<Object> keys = new ArrayList<Object>();
                int i = 0;
                while (i < command.getObjects().size()) {
                    keys.add(this.keyHandler.getKey(-1, start + i));
                    ++i;
                }
                targetLayer.fireLayerEvent(new KeyRowInsertEvent(targetLayer, new Range(start, start + command.getObjects().size()), keys, this.keyHandler));
            } else {
                this.bodyData.addAll(command.getRowIndex(), command.getObjects());
                ArrayList<Object> keys = new ArrayList<Object>();
                int i = 0;
                while (i < command.getObjects().size()) {
                    keys.add(this.keyHandler.getKey(-1, command.getRowIndex() + i));
                    ++i;
                }
                targetLayer.fireLayerEvent(new KeyRowInsertEvent(targetLayer, new Range(command.getRowIndex(), command.getRowIndex() + command.getObjects().size()), keys, this.keyHandler));
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<RowInsertCommand> getCommandClass() {
        return RowInsertCommand.class;
    }
}

