/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.config.DefaultColumnGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;

public class ColumnGroupGroupHeaderLayer
extends AbstractLayerTransform {
    private final SizeConfig rowHeightConfig = new SizeConfig(20);
    private final ColumnGroupModel model;
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;

    @Deprecated
    public ColumnGroupGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel) {
        this(columnGroupHeaderLayer, selectionLayer, columnGroupModel, true);
    }

    @Deprecated
    public ColumnGroupGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel, boolean useDefaultConfiguration) {
        super(columnGroupHeaderLayer);
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
        this.model = columnGroupModel;
        this.registerCommandHandler(new ConfigureScalingCommandHandler(null, this.rowHeightConfig));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnGroupHeaderLayerConfiguration(columnGroupModel));
        }
    }

    public ColumnGroupGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer, ColumnGroupModel columnGroupModel) {
        this(columnGroupHeaderLayer, columnGroupModel, true);
    }

    public ColumnGroupGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer, ColumnGroupModel columnGroupModel, boolean useDefaultConfiguration) {
        super(columnGroupHeaderLayer);
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
        this.model = columnGroupModel;
        this.registerCommandHandler(new ConfigureScalingCommandHandler(null, this.rowHeightConfig));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnGroupHeaderLayerConfiguration(columnGroupModel));
        }
    }

    @Override
    public int getRowCount() {
        return this.columnGroupHeaderLayer.getRowCount() + this.getGroupRowCount();
    }

    private int getGroupRowCount() {
        return this.isGroupRowIncluded() ? 1 : 0;
    }

    @Override
    public int getPreferredRowCount() {
        return this.columnGroupHeaderLayer.getPreferredRowCount() + this.getGroupRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition == 0 && this.isGroupRowIncluded()) {
            return rowPosition;
        }
        return this.columnGroupHeaderLayer.getRowIndexByPosition(rowPosition - this.getGroupRowCount());
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        if (localRowPosition == 0 && this.isGroupRowIncluded()) {
            return localRowPosition;
        }
        return localRowPosition - this.getGroupRowCount();
    }

    @Override
    public int getHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnGroupHeaderLayer.getHeight();
    }

    private boolean isGroupRowIncluded() {
        return this.model.getAllIndexesInGroups() != null && !this.model.getAllIndexesInGroups().isEmpty();
    }

    @Override
    public int getPreferredHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnGroupHeaderLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        if (rowPosition == 0 && this.isGroupRowIncluded()) {
            return this.rowHeightConfig.getSize(rowPosition);
        }
        return this.columnGroupHeaderLayer.getRowHeightByPosition(rowPosition - this.getGroupRowCount());
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeightConfig.setSize(0, rowHeight);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        if (rowPosition == 0 && this.isGroupRowIncluded()) {
            return this.rowHeightConfig.isPositionResizable(rowPosition);
        }
        return this.columnGroupHeaderLayer.isRowPositionResizable(rowPosition - this.getGroupRowCount());
    }

    @Override
    public int getRowPositionByY(int y) {
        if (this.isGroupRowIncluded()) {
            int row0Height = this.getRowHeightByPosition(0);
            if (y < row0Height) {
                return 0;
            }
            return 1 + this.columnGroupHeaderLayer.getRowPositionByY(y - row0Height);
        }
        return this.columnGroupHeaderLayer.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        if (this.isGroupRowIncluded()) {
            if (rowPosition == 0) {
                return this.rowHeightConfig.getAggregateSize(rowPosition);
            }
            return this.getRowHeightByPosition(0) + this.columnGroupHeaderLayer.getStartYOfRowPosition(rowPosition - 1);
        }
        return this.columnGroupHeaderLayer.getStartYOfRowPosition(rowPosition);
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0) {
            if (this.model.isPartOfAGroup(bodyColumnIndex)) {
                return new LayerCell(this, this.getStartPositionOfGroup(columnPosition), rowPosition, columnPosition, rowPosition, this.getColumnSpan(columnPosition), 1);
            }
            ILayerCell underlyingCell = this.columnGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition);
            return new LayerCell(this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition(), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + 1);
        }
        if (rowPosition == 1) {
            ILayerCell underlyingCell = this.columnGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex);
            return new LayerCell(this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        if (rowPosition == 2) {
            ILayerCell underlyingCell = this.columnGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex) || this.columnGroupHeaderLayer.isColumnInGroup(bodyColumnIndex);
            return new LayerCell(this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        return null;
    }

    public int getColumnSpan(int columnPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        if (columnGroup == null) {
            return this.columnGroupHeaderLayer.getColumnSpan(columnPosition);
        }
        int sizeOfGroup = columnGroup.getSize();
        if (columnGroup.isCollapsed()) {
            int sizeOfStaticColumns = columnGroup.getStaticColumnIndexes().size();
            if (sizeOfStaticColumns == 0) {
                return 1;
            }
            sizeOfGroup = sizeOfStaticColumns;
        }
        int startPositionOfGroup = this.getStartPositionOfGroup(columnPosition);
        int endPositionOfGroup = startPositionOfGroup + sizeOfGroup;
        List<Integer> columnIndexesInGroup = columnGroup.getMembers();
        int i = startPositionOfGroup;
        while (i < endPositionOfGroup) {
            int index = this.getColumnIndexByPosition(i);
            if (!columnIndexesInGroup.contains(index)) {
                --sizeOfGroup;
            }
            ++i;
        }
        return sizeOfGroup;
    }

    public int getStartPositionOfGroup(int columnPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(bodyColumnIndex);
        if (columnGroup == null) {
            return this.columnGroupHeaderLayer.getStartPositionOfGroup(columnPosition);
        }
        int leastPossibleStartPositionOfGroup = columnPosition - columnGroup.getSize();
        int i = 0;
        i = columnPosition;
        while (i >= leastPossibleStartPositionOfGroup) {
            if (!ColumnGroupUtils.isInTheSameGroup(this.getColumnIndexByPosition(i), bodyColumnIndex, this.model)) {
                ++i;
                break;
            }
            --i;
        }
        return i;
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return DisplayMode.NORMAL;
        }
        if (rowPosition == 1 && this.columnGroupHeaderLayer.isColumnInGroup(columnIndex)) {
            return DisplayMode.NORMAL;
        }
        return this.columnGroupHeaderLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            LabelStack stack = new LabelStack(new String[0]);
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(stack, columnPosition, rowPosition);
            }
            stack.addLabel("COLUMN_GROUP_HEADER");
            if (this.model.isPartOfACollapseableGroup(columnIndex)) {
                ColumnGroupModel.ColumnGroup group = this.model.getColumnGroupByIndex(columnIndex);
                if (group.isCollapsed()) {
                    stack.addLabelOnTop("GROUP_COLLAPSED");
                } else {
                    stack.addLabelOnTop("GROUP_EXPANDED");
                }
            }
            return stack;
        }
        if (rowPosition != 0) {
            --rowPosition;
        }
        return this.columnGroupHeaderLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        if (rowPosition == 0) {
            if (this.model.isPartOfAGroup(columnIndex)) {
                return columnGroup.getName();
            }
        } else {
            --rowPosition;
        }
        return this.columnGroupHeaderLayer.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        int columnIndex = this.getColumnIndexByPosition(this.getColumnPositionByX(x));
        if (this.model.isPartOfAGroup(columnIndex) && y < this.getRowHeightByPosition(0)) {
            return new LabelStack("COLUMN_GROUP_HEADER");
        }
        return this.columnGroupHeaderLayer.getRegionLabelsByXY(x, y - this.getRowHeightByPosition(0));
    }

    public void addColumnsIndexesToGroup(String colGroupName, int ... colIndexes) {
        this.model.addColumnsIndexesToGroup(colGroupName, colIndexes);
    }

    public void clearAllGroups() {
        this.model.clear();
    }

    public void setStaticColumnIndexesByGroup(String colGroupName, int ... staticColumnIndexes) {
        this.model.setStaticColumnIndexesByGroup(colGroupName, staticColumnIndexes);
    }

    public boolean isColumnInGroup(int bodyColumnIndex) {
        return this.model.isPartOfAGroup(bodyColumnIndex);
    }

    public void setGroupUnbreakable(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        columnGroup.setUnbreakable(true);
    }

    public void setGroupAsCollapsed(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        columnGroup.setCollapsed(true);
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add("COLUMN_GROUP_HEADER");
        labels.add("GROUP_COLLAPSED");
        labels.add("GROUP_EXPANDED");
        if (this.getConfigLabelAccumulator() instanceof IConfigLabelProvider) {
            labels.addAll(((IConfigLabelProvider)this.getConfigLabelAccumulator()).getProvidedLabels());
        }
        return labels;
    }
}

