/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.widgets.richtext.RichTextPainter;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class RichTextCellLabelProvider<T>
extends StyledCellLabelProvider {
    private int columnIndex = -1;
    private RichTextPainter painter;
    int preferredWidth = -1;

    public RichTextCellLabelProvider(Control viewerControl) {
        this(viewerControl, 5, false);
    }

    public RichTextCellLabelProvider(Control viewerControl, boolean wordWrap) {
        this(viewerControl, 5, wordWrap);
    }

    public RichTextCellLabelProvider(Control viewerControl, int leftRightMargin, boolean wordWrap) {
        this(viewerControl, leftRightMargin, wordWrap, "\\s");
    }

    public RichTextCellLabelProvider(Control viewerControl, final int leftRightMargin, boolean wordWrap, String wordSplitRegex) {
        super(1);
        this.painter = new RichTextPainter(wordWrap);
        this.painter.setWordSplitRegex(wordSplitRegex);
        if (viewerControl instanceof Tree) {
            viewerControl.addListener(41, new Listener(){

                public void handleEvent(Event event) {
                    Item item = (Item)event.item;
                    String html = RichTextCellLabelProvider.this.getRichText(item.getData());
                    if (event.index == RichTextCellLabelProvider.this.columnIndex && html != null && !html.isEmpty()) {
                        Rectangle bounds = null;
                        if (item instanceof TableItem) {
                            bounds = ((TableItem)item).getBounds(event.index);
                        } else if (item instanceof TreeItem) {
                            bounds = ((TreeItem)item).getBounds();
                            bounds.x -= 3;
                        }
                        bounds.width -= leftRightMargin * 2;
                        if (bounds != null) {
                            int topMargin = (bounds.height - event.gc.getFontMetrics().getHeight()) / 2 - RichTextCellLabelProvider.this.painter.getParagraphSpace();
                            bounds.x += leftRightMargin;
                            bounds.y += topMargin;
                            RichTextCellLabelProvider.this.painter.preCalculate(html, event.gc, bounds, false);
                            event.width = RichTextCellLabelProvider.this.painter.getPreferredSize().x + leftRightMargin;
                        }
                    }
                }
            });
        }
        viewerControl.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                Item item = (Item)event.item;
                String html = RichTextCellLabelProvider.this.getRichText(item.getData());
                if (event.index == RichTextCellLabelProvider.this.columnIndex && html != null && !html.isEmpty()) {
                    Rectangle bounds = null;
                    if (item instanceof TableItem) {
                        bounds = ((TableItem)item).getBounds(event.index);
                    } else if (item instanceof TreeItem) {
                        bounds = ((TreeItem)item).getBounds();
                        bounds.x -= 3;
                    }
                    bounds.width -= leftRightMargin * 2;
                    if (bounds != null) {
                        int topMargin = (bounds.height - event.gc.getFontMetrics().getHeight()) / 2 - RichTextCellLabelProvider.this.painter.getParagraphSpace();
                        bounds.x += leftRightMargin;
                        bounds.y += topMargin;
                        RichTextCellLabelProvider.this.painter.paintHTML(html, event.gc, bounds);
                    }
                }
            }
        });
    }

    public void update(ViewerCell cell) {
        this.columnIndex = cell.getColumnIndex();
        super.update(cell);
    }

    public abstract String getRichText(T var1);

    protected String getText(T object) {
        if (object != null) {
            return this.getRichText(object);
        }
        return "";
    }
}

