/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ColumnReorderEvent
extends ColumnStructuralChangeEvent {
    private ILayer beforeLayer;
    private Collection<Range> beforeFromColumnPositionRanges;
    private MutableIntList beforeFromColumnIndexes;
    private int beforeToColumnPosition;
    private int beforeToColumnIndex;
    private boolean reorderToLeftEdge;

    public ColumnReorderEvent(ILayer layer, int beforeFromColumnPosition, int beforeFromColumnIndex, int beforeToColumnPosition, int beforeToColumnIndex, boolean reorderToLeftEdge) {
        this(layer, new int[]{beforeFromColumnPosition}, new int[]{beforeFromColumnIndex}, beforeToColumnPosition, beforeToColumnIndex, reorderToLeftEdge);
    }

    public ColumnReorderEvent(ILayer layer, List<Integer> beforeFromColumnPositions, List<Integer> beforeFromColumnIndexes, int beforeToColumnPosition, int beforeToColumnIndex, boolean reorderToLeftEdge) {
        this(layer, beforeFromColumnPositions.stream().mapToInt(Integer::intValue).toArray(), beforeFromColumnIndexes.stream().mapToInt(Integer::intValue).toArray(), beforeToColumnPosition, beforeToColumnIndex, reorderToLeftEdge);
    }

    public ColumnReorderEvent(ILayer layer, int[] beforeFromColumnPositions, int[] beforeFromColumnIndexes, int beforeToColumnPosition, int beforeToColumnIndex, boolean reorderToLeftEdge) {
        super(layer, new Range[0]);
        this.beforeLayer = layer;
        this.beforeFromColumnPositionRanges = PositionUtil.getRanges(beforeFromColumnPositions);
        this.beforeFromColumnIndexes = IntLists.mutable.of(beforeFromColumnIndexes);
        this.beforeToColumnPosition = beforeToColumnPosition;
        this.beforeToColumnIndex = beforeToColumnIndex;
        this.reorderToLeftEdge = reorderToLeftEdge;
        MutableIntList allColumnPositions = IntLists.mutable.of(beforeFromColumnPositions);
        allColumnPositions.add(beforeToColumnPosition);
        this.setColumnPositionRanges(PositionUtil.getRanges(allColumnPositions.toSortedArray()));
    }

    public ColumnReorderEvent(ColumnReorderEvent event) {
        super(event);
        this.beforeLayer = event.beforeLayer;
        this.beforeFromColumnPositionRanges = new ArrayList<Range>(event.beforeFromColumnPositionRanges);
        this.beforeFromColumnIndexes = IntLists.mutable.ofAll((IntIterable)event.beforeFromColumnIndexes);
        this.beforeToColumnPosition = event.beforeToColumnPosition;
        this.beforeToColumnIndex = event.beforeToColumnIndex;
        this.reorderToLeftEdge = event.reorderToLeftEdge;
    }

    public Collection<Integer> getBeforeFromColumnIndexes() {
        return ArrayUtil.asIntegerList(this.beforeFromColumnIndexes.toSortedArray());
    }

    public int[] getBeforeFromColumnIndexesArray() {
        return this.beforeFromColumnIndexes.toSortedArray();
    }

    public Collection<Range> getBeforeFromColumnPositionRanges() {
        return this.beforeFromColumnPositionRanges;
    }

    public int getBeforeToColumnPosition() {
        return this.beforeToColumnPosition;
    }

    public int getBeforeToColumnIndex() {
        return this.beforeToColumnIndex;
    }

    public void setBeforeToColumnIndex(int beforeIndex) {
        this.beforeToColumnIndex = beforeIndex;
    }

    public boolean isReorderToLeftEdge() {
        return this.reorderToLeftEdge;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        int beforeToColumnPosition;
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        Collection<Range> beforeFromColumnPositionRanges = this.getBeforeFromColumnPositionRanges();
        int afterAddColumnPosition = beforeToColumnPosition = this.reorderToLeftEdge ? this.beforeToColumnPosition : this.beforeToColumnPosition + 1;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            if (beforeFromColumnPositionRange.start >= beforeToColumnPosition) break;
            afterAddColumnPosition -= Math.min(beforeFromColumnPositionRange.end, beforeToColumnPosition) - beforeFromColumnPositionRange.start;
        }
        int cumulativeAddSize = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            cumulativeAddSize += beforeFromColumnPositionRange.size();
        }
        int offset = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            int afterDeleteColumnPosition = beforeFromColumnPositionRange.start - offset;
            if (afterAddColumnPosition < afterDeleteColumnPosition) {
                afterDeleteColumnPosition += cumulativeAddSize;
            }
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, beforeFromColumnPositionRange, new Range(afterDeleteColumnPosition, afterDeleteColumnPosition)));
            offset += beforeFromColumnPositionRange.size();
        }
        Range beforeAddRange = new Range(beforeToColumnPosition, beforeToColumnPosition);
        offset = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            int size = beforeFromColumnPositionRange.size();
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, beforeAddRange, new Range(afterAddColumnPosition + offset, afterAddColumnPosition + offset + size)));
            offset += size;
        }
        return columnDiffs;
    }

    public void setConvertedBeforePositions(ILayer layer, Collection<Range> fromColumnPositionRanges, int toColumnPosition) {
        this.beforeLayer = layer;
        this.beforeFromColumnPositionRanges = fromColumnPositionRanges;
        this.beforeToColumnPosition = toColumnPosition;
    }

    @Override
    public boolean convertToLocal(ILayer targetLayer) {
        if (this.beforeLayer != targetLayer) {
            this.beforeFromColumnPositionRanges = targetLayer.underlyingToLocalColumnPositions(this.getLayer(), this.beforeFromColumnPositionRanges);
            this.beforeToColumnPosition = targetLayer.underlyingToLocalColumnPosition(this.getLayer(), this.beforeToColumnPosition);
            this.beforeLayer = targetLayer;
        }
        if (this.beforeToColumnPosition >= 0) {
            return super.convertToLocal(targetLayer);
        }
        return false;
    }

    @Override
    public ColumnReorderEvent cloneEvent() {
        return new ColumnReorderEvent(this);
    }
}

