/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.TextDecorationEnum;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DefaultHierarchicalTreeLayerThemeExtension
implements IThemeExtension {
    public Color defaultBgColor = GUIHelper.COLOR_WHITE;
    public Color defaultFgColor = GUIHelper.COLOR_BLACK;
    public Color defaultGradientBgColor = GUIHelper.COLOR_WHITE;
    public Color defaultGradientFgColor = GUIHelper.getColor(136, 212, 215);
    public HorizontalAlignmentEnum defaultHAlign = HorizontalAlignmentEnum.LEFT;
    public VerticalAlignmentEnum defaultVAlign = VerticalAlignmentEnum.TOP;
    public Font defaultFont = GUIHelper.DEFAULT_FONT;
    public Image defaultImage = null;
    public BorderStyle defaultBorderStyle = null;
    public Character defaultPWEchoChar = null;
    public TextDecorationEnum defaultTextDecoration = null;
    public ICellPainter defaultCellPainter = null;
    public Color treeBgColor = null;
    public Color treeFgColor = null;
    public Color treeGradientBgColor = null;
    public Color treeGradientFgColor = null;
    public HorizontalAlignmentEnum treeHAlign = HorizontalAlignmentEnum.LEFT;
    public VerticalAlignmentEnum treeVAlign = VerticalAlignmentEnum.TOP;
    public Font treeFont = null;
    public Image treeImage = null;
    public BorderStyle treeBorderStyle = null;
    public Character treePWEchoChar = null;
    public TextDecorationEnum treeTextDecoration = null;
    public Color treeSelectionBgColor = null;
    public Color treeSelectionFgColor = null;
    public Color treeSelectionGradientBgColor = null;
    public Color treeSelectionGradientFgColor = null;
    public HorizontalAlignmentEnum treeSelectionHAlign = HorizontalAlignmentEnum.LEFT;
    public VerticalAlignmentEnum treeSelectionVAlign = VerticalAlignmentEnum.TOP;
    public Font treeSelectionFont = null;
    public Image treeSelectionImage = null;
    public BorderStyle treeSelectionBorderStyle = null;
    public Character treeSelectionPWEchoChar = null;
    public TextDecorationEnum treeSelectionTextDecoration = null;
    public Color levelHeaderBgColor = GUIHelper.COLOR_WIDGET_BACKGROUND;
    public Color levelHeaderFgColor = null;
    public Color levelHeaderGradientBgColor = null;
    public Color levelHeaderGradientFgColor = null;
    public HorizontalAlignmentEnum levelHeaderHAlign = null;
    public VerticalAlignmentEnum levelHeaderVAlign = null;
    public Font levelHeaderFont = null;
    public Image levelHeaderImage = null;
    public BorderStyle levelHeaderBorderStyle = null;
    public Character levelHeaderPWEchoChar = null;
    public TextDecorationEnum levelHeaderTextDecoration = null;
    public Color levelHeaderSelectionBgColor = GUIHelper.COLOR_GRAY;
    public Color levelHeaderSelectionFgColor = null;
    public Color levelHeaderSelectionGradientBgColor = null;
    public Color levelHeaderSelectionGradientFgColor = null;
    public HorizontalAlignmentEnum levelHeaderSelectionHAlign = null;
    public VerticalAlignmentEnum levelHeaderSelectionVAlign = null;
    public Font levelHeaderSelectionFont = null;
    public Image levelHeaderSelectionImage = null;
    public BorderStyle levelHeaderSelectionBorderStyle = null;
    public Character levelHeaderSelectionPWEchoChar = null;
    public TextDecorationEnum levelHeaderSelectionTextDecoration = null;
    public Color evenRowBgColor = GUIHelper.COLOR_WHITE;
    public Color evenRowFgColor = null;
    public Color evenRowGradientBgColor = null;
    public Color evenRowGradientFgColor = null;
    public HorizontalAlignmentEnum evenRowHAlign = null;
    public VerticalAlignmentEnum evenRowVAlign = null;
    public Font evenRowFont = null;
    public Image evenRowImage = null;
    public BorderStyle evenRowBorderStyle = null;
    public Character evenRowPWEchoChar = null;
    public TextDecorationEnum evenRowTextDecoration = null;
    public Color oddRowBgColor = GUIHelper.COLOR_WIDGET_BACKGROUND;
    public Color oddRowFgColor = null;
    public Color oddRowGradientBgColor = null;
    public Color oddRowGradientFgColor = null;
    public HorizontalAlignmentEnum oddRowHAlign = null;
    public VerticalAlignmentEnum oddRowVAlign = null;
    public Font oddRowFont = null;
    public Image oddRowImage = null;
    public BorderStyle oddRowBorderStyle = null;
    public Character oddRowPWEchoChar = null;
    public TextDecorationEnum oddRowTextDecoration = null;
    public ICellPainter treeCellPainter = null;
    public ICellPainter treeSelectionCellPainter = null;
    public ICellPainter treeStructurePainter = null;
    public ICellPainter treeStructureSelectionPainter = null;
    public ICellPainter collapsedChildPainter = null;
    public ICellPainter levelHeaderCellPainter = null;
    public ICellPainter levelHeaderSelectionCellPainter = null;
    public ICellPainter evenRowCellPainter = null;
    public ICellPainter oddRowCellPainter = null;

    @Override
    public void createPainterInstances() {
        this.defaultCellPainter = new PaddingDecorator((ICellPainter)new TextPainter(), 2);
        PaddingDecorator treeImagePainter = new PaddingDecorator(new TreeImagePainter(), 5, 2, 5, 2);
        IndentedTreeImagePainter treePainter = new IndentedTreeImagePainter(0, CellEdgeEnum.TOP_LEFT, treeImagePainter);
        treePainter.getInternalPainter().setPaintDecorationDependent(false);
        this.treeStructurePainter = new BackgroundPainter(treePainter);
        this.treeCellPainter = new PaddingDecorator(new TextPainter(), 2, 2, 2, 15);
        this.collapsedChildPainter = new BackgroundPainter();
    }

    @Override
    public void registerStyles(IConfigRegistry configRegistry) {
        this.createPainterInstances();
        this.configureDefaultStyle(configRegistry);
        this.configureTreeStyle(configRegistry);
        this.configureLevelHeaderStyle(configRegistry);
        this.configureAlternatingRowStyle(configRegistry);
    }

    protected void configureDefaultStyle(IConfigRegistry configRegistry) {
        ICellPainter defaultPainter;
        IStyle defaultStyle = this.getDefaultCellStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultStyle);
        }
        if ((defaultPainter = this.getDefaultCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultPainter);
        }
    }

    protected IStyle getDefaultCellStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.defaultBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.defaultFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.defaultGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.defaultGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.defaultHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.defaultVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.defaultFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.defaultImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.defaultBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.defaultPWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.defaultTextDecoration);
        return cellStyle;
    }

    protected ICellPainter getDefaultCellPainter() {
        return this.defaultCellPainter;
    }

    protected void configureTreeStyle(IConfigRegistry configRegistry) {
        ICellPainter collapsedChildPainter;
        ICellPainter treeSelectionPainter;
        ICellPainter treePainter;
        ICellPainter selectionCellPainter;
        IStyle treeSelectionStyle;
        ICellPainter cellPainter;
        IStyle treeStyle = this.getTreeStyle();
        if (!ThemeConfiguration.isStyleEmpty(treeStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeStyle, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if ((cellPainter = this.getTreeCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(treeSelectionStyle = this.getTreeSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeSelectionStyle, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if ((selectionCellPainter = this.getTreeSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, selectionCellPainter, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if ((treePainter = this.getTreeStructurePainter()) != null) {
            configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treePainter, DisplayMode.NORMAL);
        }
        if ((treeSelectionPainter = this.getTreeStructureSelectionPainter()) != null) {
            configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treeSelectionPainter, DisplayMode.SELECT);
        }
        if ((collapsedChildPainter = this.getCollapsedChildPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, collapsedChildPainter, DisplayMode.NORMAL, "COLLAPSED_CHILD");
        }
    }

    protected void configureLevelHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter levelHeaderSelectionCellPainter;
        IStyle levelHeaderSelectedStyle;
        ICellPainter levelHeaderCellPainter;
        IStyle levelHeaderStyle = this.getLevelHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(levelHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, levelHeaderStyle, DisplayMode.NORMAL, "LEVEL_HEADER_CELL");
        }
        if ((levelHeaderCellPainter = this.getLevelHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, levelHeaderCellPainter, DisplayMode.NORMAL, "LEVEL_HEADER_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(levelHeaderSelectedStyle = this.getLevelHeaderSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, levelHeaderSelectedStyle, DisplayMode.SELECT, "LEVEL_HEADER_CELL");
        }
        if ((levelHeaderSelectionCellPainter = this.getLevelHeaderSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, levelHeaderSelectionCellPainter, DisplayMode.SELECT, "LEVEL_HEADER_CELL");
        }
    }

    protected void configureAlternatingRowStyle(IConfigRegistry configRegistry) {
        ICellPainter oddCellPainter;
        IStyle oddStyle;
        ICellPainter evenCellPainter;
        IStyle evenStyle = this.getEvenRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(evenStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, evenStyle, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if ((evenCellPainter = this.getEvenRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, evenCellPainter, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(oddStyle = this.getOddRowStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, oddStyle, DisplayMode.NORMAL, "ODD_BODY");
        }
        if ((oddCellPainter = this.getOddRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, oddCellPainter, DisplayMode.NORMAL, "ODD_BODY");
        }
    }

    protected ICellPainter getTreeCellPainter() {
        return this.treeCellPainter;
    }

    protected ICellPainter getTreeSelectionCellPainter() {
        return this.treeSelectionCellPainter;
    }

    protected ICellPainter getTreeStructurePainter() {
        return this.treeStructurePainter;
    }

    protected ICellPainter getTreeStructureSelectionPainter() {
        return this.treeStructureSelectionPainter;
    }

    protected ICellPainter getCollapsedChildPainter() {
        return this.collapsedChildPainter;
    }

    protected IStyle getTreeStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.treeBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.treeFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.treeGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.treeGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.treeHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.treeVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.treeFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.treeImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.treeBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.treePWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.treeTextDecoration);
        return cellStyle;
    }

    protected IStyle getTreeSelectionStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.treeSelectionBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.treeSelectionFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.treeSelectionGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.treeSelectionGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.treeSelectionHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.treeSelectionVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.treeSelectionFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.treeSelectionImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.treeSelectionBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.treeSelectionPWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.treeSelectionTextDecoration);
        return cellStyle;
    }

    protected IStyle getLevelHeaderStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.levelHeaderBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.levelHeaderFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.levelHeaderGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.levelHeaderGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.levelHeaderHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.levelHeaderVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.levelHeaderFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.levelHeaderImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.levelHeaderBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.levelHeaderPWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.levelHeaderTextDecoration);
        return cellStyle;
    }

    protected ICellPainter getLevelHeaderCellPainter() {
        return this.levelHeaderCellPainter;
    }

    protected IStyle getLevelHeaderSelectionStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.levelHeaderSelectionBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.levelHeaderSelectionFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.levelHeaderSelectionGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.levelHeaderSelectionGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.levelHeaderSelectionHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.levelHeaderSelectionVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.levelHeaderSelectionFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.levelHeaderSelectionImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.levelHeaderSelectionBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.levelHeaderSelectionPWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.levelHeaderSelectionTextDecoration);
        return cellStyle;
    }

    protected ICellPainter getLevelHeaderSelectionCellPainter() {
        return this.levelHeaderSelectionCellPainter;
    }

    protected IStyle getEvenRowStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.evenRowBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.evenRowFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.evenRowGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.evenRowGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.evenRowHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.evenRowVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.evenRowFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.evenRowImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.evenRowBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.evenRowPWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.evenRowTextDecoration);
        return cellStyle;
    }

    protected ICellPainter getEvenRowCellPainter() {
        return this.evenRowCellPainter;
    }

    protected IStyle getOddRowStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.oddRowBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.oddRowFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.oddRowGradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.oddRowGradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.oddRowHAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.oddRowVAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.oddRowFont);
        cellStyle.setAttributeValue(CellStyleAttributes.IMAGE, this.oddRowImage);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.oddRowBorderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR, this.oddRowPWEchoChar);
        cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, this.oddRowTextDecoration);
        return cellStyle;
    }

    protected ICellPainter getOddRowCellPainter() {
        return this.oddRowCellPainter;
    }

    @Override
    public void unregisterStyles(IConfigRegistry configRegistry) {
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultCellStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE);
        }
        if (this.getDefaultCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getTreeStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if (this.getTreeCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getTreeSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if (this.getTreeSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if (this.getTreeStructurePainter() != null) {
            configRegistry.unregisterConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, DisplayMode.NORMAL);
        }
        if (this.getTreeStructureSelectionPainter() != null) {
            configRegistry.unregisterConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, DisplayMode.SELECT);
        }
        if (this.getCollapsedChildPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "COLLAPSED_CHILD");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getLevelHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "LEVEL_HEADER_CELL");
        }
        if (this.getLevelHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "LEVEL_HEADER_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getLevelHeaderSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "LEVEL_HEADER_CELL");
        }
        if (this.getLevelHeaderSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "LEVEL_HEADER_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getEvenRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if (this.getEvenRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getOddRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "ODD_BODY");
        }
        if (this.getOddRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "ODD_BODY");
        }
    }
}

