/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.SearchDirection;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.CellDisplayValueSearchUtil;

public class ColumnSearchStrategy
extends AbstractSearchStrategy {
    private int[] columnPositions;
    private int startingRowPosition;
    private final IConfigRegistry configRegistry;

    public ColumnSearchStrategy(int[] columnPositions, IConfigRegistry configRegistry) {
        this(columnPositions, 0, configRegistry, SearchDirection.SEARCH_FORWARD);
    }

    @Deprecated
    public ColumnSearchStrategy(int[] columnPositions, int startingRowPosition, IConfigRegistry configRegistry, String searchDirection) {
        this(columnPositions, startingRowPosition, configRegistry, SearchDirection.valueOf(searchDirection));
    }

    public ColumnSearchStrategy(int[] columnPositions, int startingRowPosition, IConfigRegistry configRegistry, SearchDirection searchDirection) {
        this.columnPositions = columnPositions;
        this.startingRowPosition = startingRowPosition;
        this.configRegistry = configRegistry;
        this.searchDirection = searchDirection;
    }

    @Override
    public PositionCoordinate executeSearch(Object valueToMatch) {
        Comparator<String> comparator = this.getComparator();
        return CellDisplayValueSearchUtil.findCell(this.getContextLayer(), this.configRegistry, this.getColumnCellsToSearch(this.getContextLayer()), valueToMatch, comparator, this.isCaseSensitive(), this.isWholeWord(), this.isRegex(), this.isIncludeCollapsed());
    }

    public void setStartingRowPosition(int startingRowPosition) {
        this.startingRowPosition = startingRowPosition;
    }

    public void setColumnPositions(int[] columnPositions) {
        this.columnPositions = columnPositions;
    }

    protected PositionCoordinate[] getColumnCellsToSearch(ILayer contextLayer) {
        ArrayList<PositionCoordinate> cellsToSearch = new ArrayList<PositionCoordinate>();
        int rowPosition = this.startingRowPosition;
        int rowCount = contextLayer.getRowCount();
        int height = this.searchDirection.equals((Object)SearchDirection.SEARCH_FORWARD) ? rowCount - this.startingRowPosition : this.startingRowPosition;
        int columnIndex = 0;
        while (columnIndex < this.columnPositions.length) {
            int startingColumnPosition = this.columnPositions[columnIndex];
            if (this.searchDirection.equals((Object)SearchDirection.SEARCH_BACKWARDS)) {
                cellsToSearch.addAll(CellDisplayValueSearchUtil.getDescendingCellCoordinates(this.getContextLayer(), startingColumnPosition, rowPosition, 1, height));
                rowPosition = rowCount - 1;
            } else {
                cellsToSearch.addAll(CellDisplayValueSearchUtil.getCellCoordinates(this.getContextLayer(), startingColumnPosition, rowPosition, 1, height));
                rowPosition = 0;
            }
            height = rowCount;
            ++columnIndex;
        }
        return cellsToSearch.toArray(new PositionCoordinate[0]);
    }
}

