/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.SearchDirection;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.CellDisplayValueSearchUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class SelectionSearchStrategy
extends AbstractSearchStrategy {
    private final IConfigRegistry configRegistry;

    public SelectionSearchStrategy(IConfigRegistry configRegistry) {
        this(configRegistry, true);
    }

    public SelectionSearchStrategy(IConfigRegistry configRegistry, boolean columnFirst) {
        this(configRegistry, SearchDirection.SEARCH_FORWARD, columnFirst);
    }

    @Deprecated
    public SelectionSearchStrategy(IConfigRegistry configRegistry, String searchDirection, boolean columnFirst) {
        this(configRegistry, SearchDirection.valueOf(searchDirection), columnFirst);
    }

    public SelectionSearchStrategy(IConfigRegistry configRegistry, SearchDirection searchDirection, boolean columnFirst) {
        this.configRegistry = configRegistry;
        this.searchDirection = searchDirection;
        this.columnFirst = columnFirst;
    }

    @Override
    public PositionCoordinate executeSearch(Object valueToMatch) {
        ILayer contextLayer = this.getContextLayer();
        if (!(contextLayer instanceof SelectionLayer)) {
            throw new RuntimeException("For the SelectionSearchStrategy to work it needs the selectionLayer to be passed as the contextLayer.");
        }
        SelectionLayer selectionLayer = (SelectionLayer)contextLayer;
        PositionCoordinate coordinate = CellDisplayValueSearchUtil.findCell(selectionLayer, this.configRegistry, this.getSelectedCells(selectionLayer), valueToMatch, this.getComparator(), this.isCaseSensitive(), this.isWholeWord(), this.isRegex(), this.isIncludeCollapsed());
        if (coordinate != null) {
            selectionLayer.moveSelectionAnchor(coordinate.columnPosition, coordinate.rowPosition);
            selectionLayer.doCommand(new VisualRefreshCommand());
        }
        return coordinate;
    }

    protected PositionCoordinate[] getSelectedCells(SelectionLayer selectionLayer) {
        PositionCoordinate[] selectedCells = null;
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        if (selectionAnchor.columnPosition == -1 && selectionAnchor.rowPosition == -1 && !SearchDirection.SEARCH_BACKWARDS.equals((Object)this.searchDirection)) {
            selectedCells = selectionLayer.getSelectedCellPositions();
        } else {
            List<PositionCoordinate> coordinates = Arrays.asList(selectionLayer.getSelectedCellPositions());
            if (this.searchDirection.equals((Object)SearchDirection.SEARCH_BACKWARDS)) {
                Collections.reverse(coordinates);
            }
            int index = coordinates.indexOf(selectionAnchor);
            ArrayList<PositionCoordinate> reordered = new ArrayList<PositionCoordinate>(coordinates.subList(index + 1, coordinates.size()));
            if (this.wrapSearch) {
                reordered.addAll(coordinates.subList(0, index + 1));
            }
            selectedCells = reordered.toArray(new PositionCoordinate[0]);
        }
        return selectedCells;
    }

    @Override
    public boolean processResultInternally() {
        return true;
    }
}

