/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.CellEditorCreatedEvent;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditTypeEnum;
import org.eclipse.nebula.widgets.nattable.edit.InlineEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.CellEditDialogFactory;
import org.eclipse.nebula.widgets.nattable.edit.gui.ICellEditDialog;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditController {
    private static final Logger LOG = LoggerFactory.getLogger(EditController.class);

    private EditController() {
    }

    public static void editCell(ILayerCell cell, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        if (cell == null) {
            LOG.error("Cell being edited is no longer available. Initial value: {}", initialCanonicalValue);
            return;
        }
        try {
            Rectangle cellBounds = cell.getBounds();
            ILayer layer = cell.getLayer();
            int columnPosition = cell.getColumnPosition();
            int rowPosition = cell.getRowPosition();
            LabelStack configLabels = cell.getConfigLabels();
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, (List<String>)configLabels);
            if (cellEditor.openInline(configRegistry, configLabels)) {
                InlineEditHandler editHandler = new InlineEditHandler(layer, columnPosition, rowPosition);
                Rectangle editorBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height));
                cellEditor.activateCell(parent, initialCanonicalValue, EditModeEnum.INLINE, editHandler, cell, configRegistry);
                Control editorControl = cellEditor.getEditorControl();
                editorBounds = cellEditor.calculateControlBounds(editorBounds);
                if (editorBounds.x == 0) {
                    ++editorBounds.x;
                    --editorBounds.width;
                }
                if (editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setBounds(editorBounds);
                    cellEditor.addEditorControlListeners();
                    layer.fireLayerEvent(new CellEditorCreatedEvent(cellEditor));
                }
            } else {
                ArrayList<ILayerCell> cells = new ArrayList<ILayerCell>();
                cells.add(cell);
                EditController.editCells(cells, parent, initialCanonicalValue, configRegistry);
            }
        }
        catch (Exception e) {
            LOG.error("Error while editing cell: Cell: {}; Initial value: {}", new Object[]{cell, initialCanonicalValue, e});
        }
    }

    public static void editCells(Collection<ILayerCell> cells, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        block3: {
            ICellEditor cellEditor;
            block4: {
                if (cells == null || cells.isEmpty()) break block3;
                cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, (List<String>)cells.iterator().next().getConfigLabels());
                if (cells.size() != 1 && (cells.size() <= 1 || !EditController.supportMultiEdit(cells, cellEditor, configRegistry))) break block3;
                if (!cellEditor.openMultiEditDialog()) break block4;
                ICellEditDialog dialog = CellEditDialogFactory.createCellEditDialog(parent != null ? parent.getShell() : null, initialCanonicalValue, cells.iterator().next(), cellEditor, configRegistry);
                int returnValue = dialog.open();
                if (returnValue != 0) break block3;
                for (ILayerCell selectedCell : cells) {
                    Object editorValue = dialog.getCommittedValue();
                    if (dialog.getEditType() != EditTypeEnum.SET) {
                        editorValue = dialog.calculateValue(selectedCell.getDataValue(), editorValue);
                    }
                    ILayer layer = selectedCell.getLayer();
                    layer.doCommand(new UpdateDataCommand(layer, selectedCell.getColumnPosition(), selectedCell.getRowPosition(), editorValue));
                }
                break block3;
            }
            for (ILayerCell cell : cells) {
                InlineEditHandler editHandler = new InlineEditHandler(cell.getLayer(), cell.getColumnPosition(), cell.getRowPosition());
                cellEditor.activateCell(parent, initialCanonicalValue, EditModeEnum.INLINE, editHandler, cell, configRegistry);
            }
        }
    }

    private static boolean supportMultiEdit(Collection<ILayerCell> cells, ICellEditor cellEditor, IConfigRegistry configRegistry) {
        for (ILayerCell cell : cells) {
            if (cellEditor.supportMultiEdit(configRegistry, cell.getConfigLabels())) continue;
            return false;
        }
        return true;
    }
}

