/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedReflectiveColumnPropertyAccessor<R>
extends ReflectiveColumnPropertyAccessor<R> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedReflectiveColumnPropertyAccessor.class);
    private static final String ERROR_LOG_STATEMENT = "Error on accessing the data model via reflection";

    public ExtendedReflectiveColumnPropertyAccessor(String ... propertyNames) {
        super(propertyNames);
    }

    public ExtendedReflectiveColumnPropertyAccessor(List<String> propertyNames) {
        super(propertyNames);
    }

    @Override
    public Object getDataValue(R rowObj, int columnIndex) {
        String propertyName = this.getColumnProperty(columnIndex);
        if (propertyName.contains(".")) {
            return this.getPropertyValue(rowObj, propertyName);
        }
        return super.getDataValue(rowObj, columnIndex);
    }

    @Override
    public void setDataValue(R rowObj, int columnIndex, Object newValue) {
        String propertyName = this.getColumnProperty(columnIndex);
        if (propertyName.contains(".")) {
            this.setPropertyValue(rowObj, propertyName, newValue);
        } else {
            super.setDataValue(rowObj, columnIndex, newValue);
        }
    }

    private Object getPropertyValue(Object object, String propertyName) {
        assert (object != null) : "object can not be null!";
        String[] propertyChain = null;
        propertyChain = propertyName.contains(".") ? propertyName.split("\\.") : new String[]{propertyName};
        Object child = object;
        Class<?> objectClass = object.getClass();
        String getterName = null;
        Method getterMethod = null;
        String[] stringArray = propertyChain;
        int n = propertyChain.length;
        int n2 = 0;
        while (n2 < n) {
            String pc = stringArray[n2];
            getterName = "get" + pc.substring(0, 1).toUpperCase() + pc.substring(1);
            try {
                getterMethod = objectClass.getMethod(getterName, new Class[0]);
                child = getterMethod.invoke(child, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getterName = "is" + pc.substring(0, 1).toUpperCase() + pc.substring(1);
                    getterMethod = objectClass.getMethod(getterName, new Class[0]);
                    child = getterMethod.invoke(child, new Object[0]);
                }
                catch (Exception e1) {
                    LOG.error(ERROR_LOG_STATEMENT, (Throwable)e1);
                    throw new IllegalStateException(e);
                }
            }
            catch (Exception e) {
                LOG.error(ERROR_LOG_STATEMENT, (Throwable)e);
                throw new IllegalStateException(e);
            }
            if (child == null) break;
            objectClass = child.getClass();
            ++n2;
        }
        return child;
    }

    private void setPropertyValue(Object object, String propertyName, Object value) {
        assert (object != null) : "object can not be null!";
        try {
            Object singlePropertyObject = null;
            String singlePropertyName = null;
            if (propertyName.contains(".")) {
                singlePropertyObject = this.getPropertyValue(object, propertyName.substring(0, propertyName.lastIndexOf(46)));
                singlePropertyName = propertyName.substring(propertyName.lastIndexOf(46) + 1);
            } else {
                singlePropertyObject = object;
                singlePropertyName = propertyName;
            }
            if (singlePropertyObject == null) {
                return;
            }
            String setterName = "set" + singlePropertyName.substring(0, 1).toUpperCase() + singlePropertyName.substring(1);
            Method setterMethod = null;
            if (value != null) {
                setterMethod = this.getSetterMethodByNameAndType(singlePropertyObject, setterName, value);
            } else {
                Method[] methods = singlePropertyObject.getClass().getMethods();
                setterMethod = Arrays.stream(methods).filter(m -> m.getName().equals(setterName)).findFirst().orElse(null);
            }
            if (setterMethod != null) {
                setterMethod.invoke(singlePropertyObject, value);
            }
        }
        catch (Exception e) {
            LOG.error(ERROR_LOG_STATEMENT, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private Method getSetterMethodByNameAndType(Object singlePropertyObject, String setterName, Object value) throws NoSuchMethodException {
        Method setterMethod = null;
        try {
            setterMethod = singlePropertyObject.getClass().getMethod(setterName, value.getClass());
        }
        catch (NoSuchMethodException e) {
            if (value.getClass() == Boolean.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Boolean.TYPE);
            }
            if (value.getClass() == Byte.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Byte.TYPE);
            }
            if (value.getClass() == Short.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Short.TYPE);
            }
            if (value.getClass() == Integer.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Integer.TYPE);
            }
            if (value.getClass() == Long.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Long.TYPE);
            }
            if (value.getClass() == Float.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Float.TYPE);
            }
            if (value.getClass() == Double.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Double.TYPE);
            }
            if (value.getClass() == Character.class) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, Character.TYPE);
            }
            throw e;
        }
        return setterMethod;
    }
}

