/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public abstract class AbstractMultiRowCommand
implements ILayerCommand {
    private Collection<RowPositionCoordinate> rowPositionCoordinates;

    protected AbstractMultiRowCommand(ILayer layer, int ... rowPositions) {
        this.setRowPositions(layer, rowPositions);
    }

    protected AbstractMultiRowCommand(AbstractMultiRowCommand command) {
        this.rowPositionCoordinates = new HashSet<RowPositionCoordinate>(command.rowPositionCoordinates);
    }

    public Collection<Integer> getRowPositions() {
        return this.rowPositionCoordinates.stream().map(RowPositionCoordinate::getRowPosition).collect(Collectors.toCollection(HashSet::new));
    }

    public int[] getRowPositionsArray() {
        return this.rowPositionCoordinates.stream().mapToInt(RowPositionCoordinate::getRowPosition).sorted().toArray();
    }

    protected final void setRowPositions(ILayer layer, int ... rowPositions) {
        this.rowPositionCoordinates = new HashSet<RowPositionCoordinate>();
        int[] nArray = rowPositions;
        int n = rowPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int rowPosition = nArray[n2];
            this.rowPositionCoordinates.add(new RowPositionCoordinate(layer, rowPosition));
            ++n2;
        }
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        Collection converted = this.rowPositionCoordinates.stream().map(coord -> LayerCommandUtil.convertRowPositionToTargetContext(coord, targetLayer)).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        if (!converted.isEmpty()) {
            this.rowPositionCoordinates = converted;
            return true;
        }
        return false;
    }
}

