/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileOutputStreamProvider
implements IOutputStreamProvider {
    protected String defaultFileName;
    protected String[] defaultFilterNames;
    protected String[] defaultFilterExtensions;
    protected String currentFileName;
    protected int extFilterIndex = -1;

    public FileOutputStreamProvider(String defaultFileName, String[] defaultFilterNames, String[] defaultFilterExtensions) {
        this.defaultFileName = defaultFileName;
        this.defaultFilterNames = defaultFilterNames;
        this.defaultFilterExtensions = defaultFilterExtensions;
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        String relativeFileName;
        String filterPath;
        FileDialog dialog = new FileDialog(shell, 8192);
        int lastIndexOfFileSeparator = this.defaultFileName.lastIndexOf(File.separator);
        if (lastIndexOfFileSeparator >= 0) {
            filterPath = this.defaultFileName.substring(0, lastIndexOfFileSeparator);
            relativeFileName = this.defaultFileName.substring(lastIndexOfFileSeparator + 1);
        } else {
            filterPath = "/";
            relativeFileName = this.defaultFileName;
        }
        dialog.setFilterPath(filterPath);
        dialog.setOverwrite(true);
        dialog.setFileName(relativeFileName);
        dialog.setFilterNames(this.defaultFilterNames);
        dialog.setFilterExtensions(this.defaultFilterExtensions);
        this.currentFileName = dialog.open();
        this.extFilterIndex = -1;
        if (this.currentFileName == null) {
            return null;
        }
        this.extFilterIndex = dialog.getFilterIndex();
        try {
            return new PrintStream(this.currentFileName);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("FileOutputStreamProvider.errorMessage", this.currentFileName), e);
        }
    }

    @Override
    public File getResult() {
        return this.currentFileName != null ? new File(this.currentFileName) : null;
    }

    public int getExtensionFilterIndex() {
        return this.extFilterIndex;
    }
}

