/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

class StateWriter {
    private final Map<Object, Integer> objectTable = new HashMap<Object, Integer>();
    private final List<Object> forcedWrite = new ArrayList<Object>();

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        Integer cur = this.objectTable.get(object);
        if (cur != null) {
            return cur;
        }
        this.objectTable.put(object, this.objectTable.size());
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Integer objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return objectResult;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream out) throws IOException {
        if (this.writeIndex(object, out)) {
            return true;
        }
        int index = this.addToObjectTable(object);
        out.writeByte(1);
        out.writeInt(index);
        return false;
    }

    private void writeStateDeprecated(StateImpl state, DataOutputStream out) throws IOException {
        out.write(38);
        if (this.writePrefix(state, out)) {
            return;
        }
        out.writeLong(state.getTimeStamp());
        String[] platformPropKeys = state.getPlatformPropertyKeys();
        this.writePlatformProp(platformPropKeys, out);
        Dictionary<Object, Object>[] propSet = state.getPlatformProperties();
        out.writeInt(propSet.length);
        Dictionary<Object, Object>[] dictionaryArray = propSet;
        int n = propSet.length;
        int n2 = 0;
        while (n2 < n) {
            Dictionary<Object, Object> props = dictionaryArray[n2];
            out.writeInt(platformPropKeys.length);
            String[] stringArray = platformPropKeys;
            int n3 = platformPropKeys.length;
            int n4 = 0;
            while (n4 < n3) {
                String platformPropKey = stringArray[n4];
                this.writePlatformProp(props.get(platformPropKey), out);
                ++n4;
            }
            ++n2;
        }
        BundleDescription[] bundles = state.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundles);
        out.writeInt(bundles.length);
        if (bundles.length == 0) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = bundles;
        int n5 = bundles.length;
        n = 0;
        while (n < n5) {
            BundleDescription bundle = bundleDescriptionArray[n];
            this.writeBundleDescription(bundle, out, false);
            ++n;
        }
        out.writeBoolean(state.isResolved());
        out.writeInt(out.size());
        bundleDescriptionArray = bundles;
        n5 = bundles.length;
        n = 0;
        while (n < n5) {
            BundleDescription bundle = bundleDescriptionArray[n];
            this.writeBundleDescriptionLazyData(bundle, out);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(StateImpl state, File stateFile, File lazyFile) throws IOException {
        DataOutputStream outLazy = null;
        DataOutputStream outState = null;
        FileOutputStream fosLazy = null;
        FileOutputStream fosState = null;
        Object object = state.monitor;
        synchronized (object) {
            BundleDescription[] bundles;
            block42: {
                block43: {
                    BundleDescription bundle;
                    bundles = state.getBundles();
                    StateHelperImpl.getInstance().sortBundles(bundles);
                    BundleDescription[] bundleDescriptionArray = bundles;
                    int n = bundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        bundle = bundleDescriptionArray[n2];
                        this.addToObjectTable(bundle);
                        if (bundle.getHost() != null) {
                            this.addToObjectTable(bundle.getHost());
                        }
                        ++n2;
                    }
                    fosLazy = new FileOutputStream(lazyFile);
                    outLazy = new DataOutputStream(new BufferedOutputStream(fosLazy));
                    bundleDescriptionArray = bundles;
                    n = bundles.length;
                    n2 = 0;
                    while (n2 < n) {
                        bundle = bundleDescriptionArray[n2];
                        this.writeBundleDescriptionLazyData(bundle, outLazy);
                        ++n2;
                    }
                    fosState = new FileOutputStream(stateFile);
                    outState = new DataOutputStream(new BufferedOutputStream(fosState));
                    outState.write(38);
                    if (!this.writePrefix(state, outState)) break block42;
                    if (outLazy == null) break block43;
                    try {
                        outLazy.flush();
                        fosLazy.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        outLazy.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outState != null) {
                    try {
                        outState.flush();
                        fosState.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        outState.close();
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
            try {
                outState.writeLong(state.getTimeStamp());
                String[] platformPropKeys = state.getPlatformPropertyKeys();
                this.writePlatformProp(platformPropKeys, outState);
                Dictionary<Object, Object>[] propSet = state.getPlatformProperties();
                outState.writeInt(propSet.length);
                Dictionary<Object, Object>[] dictionaryArray = propSet;
                int n = propSet.length;
                int n3 = 0;
                while (n3 < n) {
                    Dictionary<Object, Object> props = dictionaryArray[n3];
                    outState.writeInt(platformPropKeys.length);
                    String[] stringArray = platformPropKeys;
                    int n4 = platformPropKeys.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String platformPropKey = stringArray[n5];
                        this.writePlatformProp(props.get(platformPropKey), outState);
                        ++n5;
                    }
                    ++n3;
                }
                outState.writeInt(bundles.length);
                dictionaryArray = bundles;
                n = bundles.length;
                n3 = 0;
                while (n3 < n) {
                    Dictionary<Object, Object> bundle = dictionaryArray[n3];
                    this.writeBundleDescription((BundleDescription)bundle, outState, true);
                    ++n3;
                }
                DisabledInfo[] infos = state.getDisabledInfos();
                outState.writeInt(infos.length);
                DisabledInfo[] disabledInfoArray = infos;
                int n6 = infos.length;
                n = 0;
                while (n < n6) {
                    DisabledInfo info = disabledInfoArray[n];
                    this.writeDisabledInfo(info, outState);
                    ++n;
                }
                outState.writeBoolean(state.isResolved());
            }
            catch (Throwable throwable) {
                if (outLazy != null) {
                    try {
                        outLazy.flush();
                        fosLazy.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        outLazy.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outState != null) {
                    try {
                        outState.flush();
                        fosState.getFD().sync();
                    }
                    catch (IOException iOException) {}
                    try {
                        outState.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (outLazy != null) {
                try {
                    outLazy.flush();
                    fosLazy.getFD().sync();
                }
                catch (IOException iOException) {}
                try {
                    outLazy.close();
                }
                catch (IOException iOException) {}
            }
            if (outState != null) {
                try {
                    outState.flush();
                    fosState.getFD().sync();
                }
                catch (IOException iOException) {}
                try {
                    outState.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writePlatformProp(Object obj, DataOutputStream out) throws IOException {
        if (!(obj instanceof String) && !(obj instanceof String[])) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (obj instanceof String) {
                out.writeInt(1);
                this.writeStringOrNull((String)obj, out);
            } else {
                String[] props = (String[])obj;
                out.writeInt(props.length);
                String[] stringArray = props;
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    String prop = stringArray[n2];
                    this.writeStringOrNull(prop, out);
                    ++n2;
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundle, DataOutputStream out, boolean force) throws IOException {
        if (force && !this.forcedWrite.contains(bundle)) {
            int index = this.addToObjectTable(bundle);
            out.writeByte(1);
            out.writeInt(index);
            this.forcedWrite.add(bundle);
        } else if (this.writePrefix(bundle, out)) {
            return;
        }
        out.writeLong(bundle.getBundleId());
        this.writeBaseDescription((BaseDescription)bundle, out);
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataOffset());
        out.writeInt(((BundleDescriptionImpl)bundle).getLazyDataSize());
        out.writeBoolean(bundle.isResolved());
        out.writeBoolean(bundle.isSingleton());
        out.writeBoolean(bundle.hasDynamicImports());
        out.writeBoolean(bundle.attachFragments());
        out.writeBoolean(bundle.dynamicFragments());
        this.writeList(out, (String[])((BundleDescriptionImpl)bundle).getDirective("mandatory"));
        this.writeMap(out, bundle.getAttributes());
        this.writeMap(out, ((BundleDescriptionImpl)bundle).getArbitraryDirectives());
        this.writeHostSpec((HostSpecificationImpl)bundle.getHost(), out, force);
        List<BundleDescription> dependencies = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        out.writeInt(dependencies.size());
        Iterator<BundleDescription> iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.writeBundleDescription(iter.next(), out, force);
        }
    }

    private void writeBundleDescriptionLazyData(BundleDescription bundle, DataOutputStream out) throws IOException {
        int n;
        int dataStart = out.size();
        int index = this.getFromObjectTable(bundle);
        ((BundleDescriptionImpl)bundle).setLazyDataOffset(out.size());
        out.writeInt(index);
        this.writeStringOrNull(bundle.getLocation(), out);
        this.writeStringOrNull(bundle.getPlatformFilter(), out);
        ExportPackageDescription[] exports = bundle.getExportPackages();
        out.writeInt(exports.length);
        ExportPackageDescription[] exportPackageDescriptionArray = exports;
        int n2 = exports.length;
        int n3 = 0;
        while (n3 < n2) {
            ExportPackageDescription export = exportPackageDescriptionArray[n3];
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)export, out);
            ++n3;
        }
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        out.writeInt(imports.length);
        ImportPackageSpecification[] importPackageSpecificationArray = imports;
        int n4 = imports.length;
        n2 = 0;
        while (n2 < n4) {
            ImportPackageSpecification importSpecification = importPackageSpecificationArray[n2];
            this.writeImportPackageSpec((ImportPackageSpecificationImpl)importSpecification, out);
            ++n2;
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        out.writeInt(requiredBundles.length);
        BundleSpecification[] bundleSpecificationArray = requiredBundles;
        int n5 = requiredBundles.length;
        n4 = 0;
        while (n4 < n5) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n4];
            this.writeBundleSpec((BundleSpecificationImpl)requiredBundle, out);
            ++n4;
        }
        ExportPackageDescription[] selectedExports = bundle.getSelectedExports();
        if (selectedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(selectedExports.length);
            ExportPackageDescription[] exportPackageDescriptionArray2 = selectedExports;
            int n6 = selectedExports.length;
            n5 = 0;
            while (n5 < n6) {
                ExportPackageDescription selectedExport = exportPackageDescriptionArray2[n5];
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)selectedExport, out);
                ++n5;
            }
        }
        ExportPackageDescription[] substitutedExports = bundle.getSubstitutedExports();
        if (substitutedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(substitutedExports.length);
            ExportPackageDescription[] exportPackageDescriptionArray3 = substitutedExports;
            int n7 = substitutedExports.length;
            int n8 = 0;
            while (n8 < n7) {
                ExportPackageDescription substitutedExport = exportPackageDescriptionArray3[n8];
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)substitutedExport, out);
                ++n8;
            }
        }
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        if (resolvedImports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedImports.length);
            ExportPackageDescription[] exportPackageDescriptionArray4 = resolvedImports;
            int n9 = resolvedImports.length;
            int n10 = 0;
            while (n10 < n9) {
                ExportPackageDescription resolvedImport = exportPackageDescriptionArray4[n10];
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)resolvedImport, out);
                ++n10;
            }
        }
        BundleDescription[] resolvedRequires = bundle.getResolvedRequires();
        if (resolvedRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedRequires.length);
            BundleDescription[] bundleDescriptionArray = resolvedRequires;
            int n11 = resolvedRequires.length;
            int n12 = 0;
            while (n12 < n11) {
                BundleDescription resolvedRequire = bundleDescriptionArray[n12];
                this.writeBundleDescription(resolvedRequire, out, false);
                ++n12;
            }
        }
        String[] ees = bundle.getExecutionEnvironments();
        out.writeInt(ees.length);
        String[] stringArray = ees;
        int n13 = ees.length;
        int n14 = 0;
        while (n14 < n13) {
            String ee = stringArray[n14];
            this.writeStringOrNull(ee, out);
            ++n14;
        }
        Map<String, Long> dynamicStamps = ((BundleDescriptionImpl)bundle).getDynamicStamps();
        if (dynamicStamps == null) {
            out.writeInt(0);
        } else {
            out.writeInt(dynamicStamps.size());
            for (String pkg : dynamicStamps.keySet()) {
                this.writeStringOrNull(pkg, out);
                out.writeLong(dynamicStamps.get(pkg));
            }
        }
        GenericDescription[] genericCapabilities = bundle.getGenericCapabilities();
        if (genericCapabilities == null) {
            out.writeInt(0);
        } else {
            out.writeInt(genericCapabilities.length);
            GenericDescription[] genericDescriptionArray = genericCapabilities;
            n = genericCapabilities.length;
            int n15 = 0;
            while (n15 < n) {
                GenericDescription genericCapability = genericDescriptionArray[n15];
                this.writeGenericDescription(genericCapability, out);
                ++n15;
            }
        }
        GenericSpecification[] genericRequires = bundle.getGenericRequires();
        if (genericRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(genericRequires.length);
            GenericSpecification[] genericSpecificationArray = genericRequires;
            int n16 = genericRequires.length;
            n = 0;
            while (n < n16) {
                GenericSpecification genericRequire = genericSpecificationArray[n];
                this.writeGenericSpecification((GenericSpecificationImpl)genericRequire, out);
                ++n;
            }
        }
        GenericDescription[] selectedCapabilities = bundle.getSelectedGenericCapabilities();
        if (selectedCapabilities == null) {
            out.writeInt(0);
        } else {
            out.writeInt(selectedCapabilities.length);
            GenericDescription[] genericDescriptionArray = selectedCapabilities;
            int n17 = selectedCapabilities.length;
            int n18 = 0;
            while (n18 < n17) {
                GenericDescription selectedCapability = genericDescriptionArray[n18];
                this.writeGenericDescription(selectedCapability, out);
                ++n18;
            }
        }
        GenericDescription[] resolvedCapabilities = bundle.getResolvedGenericRequires();
        if (resolvedCapabilities == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedCapabilities.length);
            GenericDescription[] genericDescriptionArray = resolvedCapabilities;
            int n19 = resolvedCapabilities.length;
            int n20 = 0;
            while (n20 < n19) {
                GenericDescription resolvedCapability = genericDescriptionArray[n20];
                this.writeGenericDescription(resolvedCapability, out);
                ++n20;
            }
        }
        this.writeNativeCode(bundle.getNativeCodeSpecification(), out);
        this.writeMap(out, ((BundleDescriptionImpl)bundle).getWiresInternal());
        ((BundleDescriptionImpl)bundle).setLazyDataSize(out.size() - dataStart);
    }

    private void writeDisabledInfo(DisabledInfo disabledInfo, DataOutputStream out) throws IOException {
        this.writeStringOrNull(disabledInfo.getPolicyName(), out);
        this.writeStringOrNull(disabledInfo.getMessage(), out);
        this.writeBundleDescription(disabledInfo.getBundle(), out, false);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundle, DataOutputStream out) throws IOException {
        if (this.writePrefix(bundle, out)) {
            return;
        }
        this.writeVersionConstraint(bundle, out);
        this.writeBundleDescription((BundleDescription)bundle.getSupplier(), out, false);
        out.writeBoolean(bundle.isExported());
        out.writeBoolean(bundle.isOptional());
        this.writeMap(out, bundle.getAttributes());
        this.writeMap(out, bundle.getArbitraryDirectives());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDesc, DataOutputStream out) throws IOException {
        if (this.writePrefix(exportPackageDesc, out)) {
            return;
        }
        this.writeBaseDescription(exportPackageDesc, out);
        this.writeBundleDescription(exportPackageDesc.getExporter(), out, false);
        this.writeMap(out, exportPackageDesc.getAttributes());
        this.writeMap(out, exportPackageDesc.getDirectives());
        this.writeMap(out, exportPackageDesc.getArbitraryDirectives());
        this.writeExportPackageDesc((ExportPackageDescriptionImpl)exportPackageDesc.getFragmentDeclaration(), out);
    }

    private void writeGenericDescription(GenericDescription description, DataOutputStream out) throws IOException {
        if (this.writePrefix(description, out)) {
            return;
        }
        this.writeBaseDescription((BaseDescription)description, out);
        this.writeBundleDescription(description.getSupplier(), out, false);
        this.writeStringOrNull(description.getType() == "generic" ? null : description.getType(), out);
        Dictionary attrs = description.getAttributes();
        HashMap mapAttrs = new HashMap(attrs.size());
        Enumeration keys = attrs.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            mapAttrs.put(key, attrs.get(key));
        }
        this.writeMap(out, mapAttrs);
        Map directives = description.getDeclaredDirectives();
        this.writeMap(out, directives);
        this.writeGenericDescription((GenericDescription)((BaseDescriptionImpl)description).getFragmentDeclaration(), out);
    }

    private void writeGenericSpecification(GenericSpecificationImpl specification, DataOutputStream out) throws IOException {
        if (this.writePrefix(specification, out)) {
            return;
        }
        this.writeVersionConstraint(specification, out);
        this.writeStringOrNull(specification.getType() == "generic" ? null : specification.getType(), out);
        GenericDescription[] suppliers = specification.getSuppliers();
        out.writeInt(suppliers == null ? 0 : suppliers.length);
        if (suppliers != null) {
            GenericDescription[] genericDescriptionArray = suppliers;
            int n = suppliers.length;
            int n2 = 0;
            while (n2 < n) {
                GenericDescription supplier = genericDescriptionArray[n2];
                this.writeGenericDescription(supplier, out);
                ++n2;
            }
        }
        out.writeInt(specification.getResolution());
        this.writeStringOrNull(specification.getMatchingFilter(), out);
        this.writeMap(out, specification.getAttributes());
        this.writeMap(out, specification.getArbitraryDirectives());
    }

    private void writeNativeCode(NativeCodeSpecification nativeCodeSpecification, DataOutputStream out) throws IOException {
        if (nativeCodeSpecification == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeBoolean(nativeCodeSpecification.isOptional());
        NativeCodeDescription[] nativeDescs = nativeCodeSpecification.getPossibleSuppliers();
        int numDescs = nativeDescs == null ? 0 : nativeDescs.length;
        out.writeInt(numDescs);
        int supplierIndex = -1;
        int i = 0;
        while (i < numDescs) {
            if (nativeDescs[i] == nativeCodeSpecification.getSupplier()) {
                supplierIndex = i;
            }
            this.writeNativeCodeDescription(nativeDescs[i], out);
            ++i;
        }
        out.writeInt(supplierIndex);
    }

    private void writeNativeCodeDescription(NativeCodeDescription nativeCodeDescription, DataOutputStream out) throws IOException {
        this.writeBaseDescription((BaseDescription)nativeCodeDescription, out);
        this.writeBundleDescription(nativeCodeDescription.getSupplier(), out, false);
        Filter filter = nativeCodeDescription.getFilter();
        this.writeStringOrNull(filter == null ? null : filter.toString(), out);
        this.writeStringArray(nativeCodeDescription.getLanguages(), out);
        this.writeStringArray(nativeCodeDescription.getNativePaths(), out);
        this.writeStringArray(nativeCodeDescription.getOSNames(), out);
        this.writeVersionRanges(nativeCodeDescription.getOSVersions(), out);
        this.writeStringArray(nativeCodeDescription.getProcessors(), out);
        out.writeBoolean(nativeCodeDescription.hasInvalidNativePaths());
    }

    private void writeVersionRanges(VersionRange[] ranges, DataOutputStream out) throws IOException {
        out.writeInt(ranges == null ? 0 : ranges.length);
        if (ranges == null) {
            return;
        }
        VersionRange[] versionRangeArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            VersionRange range = versionRangeArray[n2];
            this.writeVersionRange(range, out);
            ++n2;
        }
    }

    private void writeStringArray(String[] strings, DataOutputStream out) throws IOException {
        out.writeInt(strings == null ? 0 : strings.length);
        if (strings == null) {
            return;
        }
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.writeStringOrNull(string, out);
            ++n2;
        }
    }

    private void writeMap(DataOutputStream out, Map<String, ?> source) throws IOException {
        if (source == null) {
            out.writeInt(0);
        } else {
            out.writeInt(source.size());
            for (String key : source.keySet()) {
                Object value = source.get(key);
                this.writeStringOrNull(key, out);
                if (value instanceof String) {
                    out.writeByte(0);
                    this.writeStringOrNull((String)value, out);
                    continue;
                }
                if (value instanceof String[]) {
                    out.writeByte(1);
                    this.writeList(out, (String[])value);
                    continue;
                }
                if (value instanceof Boolean) {
                    out.writeByte(2);
                    out.writeBoolean((Boolean)value);
                    continue;
                }
                if (value instanceof Integer) {
                    out.writeByte(3);
                    out.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    out.writeByte(4);
                    out.writeLong((Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    out.writeByte(5);
                    out.writeDouble((Double)value);
                    continue;
                }
                if (value instanceof Version) {
                    out.writeByte(6);
                    this.writeVersion((Version)value, out);
                    continue;
                }
                if ("java.net.URI".equals(value.getClass().getName())) {
                    out.writeByte(7);
                    this.writeStringOrNull(value.toString(), out);
                    continue;
                }
                if (!(value instanceof List)) continue;
                this.writeList(out, (List)value);
            }
        }
    }

    private void writeList(DataOutputStream out, List<?> list) throws IOException {
        byte type = this.getListType(list);
        if (type == -2) {
            return;
        }
        out.writeByte(8);
        out.writeByte(type);
        out.writeInt(list.size());
        for (Object value : list) {
            switch (type) {
                case 0: {
                    this.writeStringOrNull((String)value, out);
                    break;
                }
                case 3: {
                    out.writeInt((Integer)value);
                    break;
                }
                case 4: {
                    out.writeLong((Long)value);
                    break;
                }
                case 5: {
                    out.writeDouble((Double)value);
                    break;
                }
                case 6: {
                    this.writeVersion((Version)value, out);
                    break;
                }
                case 7: {
                    this.writeStateWire((StateWire)value, out);
                }
            }
        }
    }

    private void writeStateWire(StateWire wire, DataOutputStream out) throws IOException {
        VersionConstraint requirement = wire.getDeclaredRequirement();
        if (requirement instanceof ImportPackageSpecificationImpl) {
            out.writeByte(0);
            this.writeImportPackageSpec((ImportPackageSpecificationImpl)requirement, out);
        } else if (requirement instanceof BundleSpecificationImpl) {
            out.writeByte(1);
            this.writeBundleSpec((BundleSpecificationImpl)requirement, out);
        } else if (requirement instanceof HostSpecificationImpl) {
            out.writeByte(2);
            this.writeHostSpec((HostSpecificationImpl)requirement, out, false);
        } else if (requirement instanceof GenericSpecificationImpl) {
            out.writeByte(3);
            this.writeGenericSpecification((GenericSpecificationImpl)requirement, out);
        } else {
            throw new IllegalArgumentException("Unknown requiement type: " + requirement.getClass());
        }
        BaseDescription capability = wire.getDeclaredCapability();
        if (capability instanceof BundleDescription) {
            this.writeBundleDescription((BundleDescription)capability, out, false);
        } else if (capability instanceof ExportPackageDescriptionImpl) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)capability, out);
        } else if (capability instanceof GenericDescription) {
            this.writeGenericDescription((GenericDescription)capability, out);
        } else {
            throw new IllegalArgumentException("Unknown capability type: " + requirement.getClass());
        }
        this.writeBundleDescription(wire.getRequirementHost(), out, false);
        this.writeBundleDescription(wire.getCapabilityHost(), out, false);
    }

    private byte getListType(List<?> list) {
        if (list.size() == 0) {
            return -1;
        }
        Object type = list.get(0);
        if (type instanceof String) {
            return 0;
        }
        if (type instanceof Integer) {
            return 3;
        }
        if (type instanceof Long) {
            return 4;
        }
        if (type instanceof Double) {
            return 5;
        }
        if (type instanceof Version) {
            return 6;
        }
        if (type instanceof StateWire) {
            return 7;
        }
        return -2;
    }

    private void writeList(DataOutputStream out, String[] list) throws IOException {
        if (list == null) {
            out.writeInt(0);
        } else {
            out.writeInt(list.length);
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.writeStringOrNull(s, out);
                ++n2;
            }
        }
    }

    private void writeBaseDescription(BaseDescription rootDesc, DataOutputStream out) throws IOException {
        this.writeStringOrNull(rootDesc.getName(), out);
        this.writeVersion(rootDesc.getVersion(), out);
    }

    private void writeImportPackageSpec(ImportPackageSpecificationImpl importPackageSpec, DataOutputStream out) throws IOException {
        if (this.writePrefix(importPackageSpec, out)) {
            return;
        }
        this.writeVersionConstraint(importPackageSpec, out);
        if (importPackageSpec.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpec.getSupplier(), out);
        } else {
            out.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpec.getBundleSymbolicName(), out);
        this.writeVersionRange(importPackageSpec.getBundleVersionRange(), out);
        this.writeMap(out, importPackageSpec.getAttributes());
        this.writeMap(out, importPackageSpec.getDirectives());
        this.writeMap(out, importPackageSpec.getArbitraryDirectives());
    }

    private void writeHostSpec(HostSpecificationImpl host, DataOutputStream out, boolean force) throws IOException {
        if (host != null && force && !this.forcedWrite.contains(host)) {
            int index = this.addToObjectTable(host);
            out.writeByte(1);
            out.writeInt(index);
            this.forcedWrite.add(host);
        } else if (this.writePrefix(host, out)) {
            return;
        }
        this.writeVersionConstraint(host, out);
        BundleDescription[] hosts = host.getHosts();
        if (hosts == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(hosts.length);
        BundleDescription[] bundleDescriptionArray = hosts;
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription h = bundleDescriptionArray[n2];
            this.writeBundleDescription(h, out, force);
            ++n2;
        }
        this.writeMap(out, host.getAttributes());
        this.writeMap(out, host.getArbitraryDirectives());
    }

    private void writeVersionConstraint(VersionConstraint constraint, DataOutputStream out) throws IOException {
        this.writeStringOrNull(constraint.getName(), out);
        this.writeVersionRange(constraint.getVersionRange(), out);
    }

    private void writeVersion(Version version, DataOutputStream out) throws IOException {
        if (version == null || version.equals((Object)Version.emptyVersion)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(version.getMajor());
        out.writeInt(version.getMinor());
        out.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), out);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream out) throws IOException {
        if (versionRange == null || versionRange.equals((Object)VersionRange.emptyRange)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), out);
        out.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), out);
        out.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStateDeprecated(StateImpl state, DataOutputStream output) throws IOException {
        Object object = state.monitor;
        synchronized (object) {
            try {
                this.writeStateDeprecated(state, output);
            }
            finally {
                output.close();
            }
        }
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            byte[] data = string.getBytes("UTF-8");
            if (data.length > 65535) {
                out.writeByte(3);
                out.writeInt(data.length);
                out.write(data);
            } else {
                out.writeByte(1);
                out.writeUTF(string);
            }
        }
    }

    private void writeQualifier(String string, DataOutputStream out) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, out);
    }
}

