/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ComboBoxCellEditor
extends AbstractCellEditor {
    private NatCombo combo;
    protected int maxVisibleItems;
    private List<?> canonicalValues;
    private IComboBoxDataProvider dataProvider;
    protected boolean showDropdownFilter = false;
    protected boolean freeEdit = false;
    protected boolean multiselect = false;
    protected boolean useCheckbox = false;
    protected String multiselectValueSeparator = null;
    protected String multiselectTextPrefix = null;
    protected String multiselectTextSuffix = null;
    protected Image iconImage;
    private List<?> currentCanonicalValues;
    private boolean focusOnText = false;

    public ComboBoxCellEditor(List<?> canonicalValues) {
        this(canonicalValues, 5);
    }

    public ComboBoxCellEditor(Object ... canonicalValues) {
        this(Arrays.asList(canonicalValues), 5);
    }

    public ComboBoxCellEditor(List<?> canonicalValues, int maxVisibleItems) {
        this.canonicalValues = canonicalValues;
        this.maxVisibleItems = maxVisibleItems;
    }

    public ComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider, 5);
    }

    public ComboBoxCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems) {
        this.dataProvider = dataProvider;
        this.maxVisibleItems = maxVisibleItems;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.combo = this.createEditorControl(parent);
        BusyIndicator.showWhile((Display)parent.getDisplay(), () -> {
            this.fillCombo();
            this.setCanonicalValue(originalCanonicalValue);
        });
        if (this.editMode == EditModeEnum.INLINE) {
            final boolean focusOnText = originalCanonicalValue instanceof Character || this.focusOnText;
            this.combo.addTextControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    ComboBoxCellEditor.this.combo.showDropdownControl(focusOnText);
                    ComboBoxCellEditor.this.combo.removeTextControlListener((ControlListener)this);
                }

                public void controlMoved(ControlEvent e) {
                    ComboBoxCellEditor.this.combo.showDropdownControl(focusOnText);
                    ComboBoxCellEditor.this.combo.removeTextControlListener((ControlListener)this);
                }
            });
        }
        return this.combo;
    }

    @Override
    public Object getCanonicalValue() {
        if (!this.multiselect) {
            int selectionIndex = this.combo.getSelectionIndex();
            if (selectionIndex >= 0) {
                if (this.dataProvider != null) {
                    return this.dataProvider.getValues(this.getColumnIndex(), this.getRowIndex()).get(selectionIndex);
                }
                return this.canonicalValues.get(selectionIndex);
            }
            if (this.combo.getSelection().length > 0) {
                return super.getCanonicalValue();
            }
        } else {
            int[] selectionIndices = this.combo.getSelectionIndices();
            ArrayList<Object> result = null;
            if (selectionIndices.length > 0) {
                result = new ArrayList<Object>(selectionIndices.length);
                int[] nArray = selectionIndices;
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    result.add(this.currentCanonicalValues.get(i));
                    ++n2;
                }
            } else {
                String[] comboSelection = this.combo.getSelection();
                if (comboSelection.length > 0) {
                    result = new ArrayList(comboSelection.length);
                    String[] stringArray = comboSelection;
                    int n = comboSelection.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String selection = stringArray[n3];
                        result.add(this.handleConversion(selection, this.conversionEditErrorHandler));
                        ++n3;
                    }
                }
            }
            return result != null ? result : new ArrayList<Object>();
        }
        return null;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        if (canonicalValue != null) {
            String[] editorValues = null;
            if (canonicalValue instanceof List) {
                List temp = (List)canonicalValue;
                editorValues = this.displayConverter != null ? (String[])temp.stream().map(canonical -> (String)this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonical)).toArray(String[]::new) : (String[])temp.stream().map(canonical -> canonical != null ? canonical.toString() : "").toArray(String[]::new);
            } else {
                editorValues = "SELECT_ALL".equals(canonicalValue) || this.displayConverter == null ? new String[]{canonicalValue.toString()} : new String[]{(String)this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue)};
            }
            this.setEditorValue(editorValues);
        }
    }

    private void fillCombo() {
        ArrayList<String> displayValues = new ArrayList<String>();
        this.currentCanonicalValues = this.dataProvider != null ? this.dataProvider.getValues(this.getColumnIndex(), this.getRowIndex()) : this.canonicalValues;
        for (Object canonicalValue : this.currentCanonicalValues) {
            Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue) : canonicalValue;
            displayValues.add(displayValue != null ? displayValue.toString() : "");
        }
        this.combo.setItems(displayValues.toArray(ArrayUtil.STRING_TYPE_ARRAY));
    }

    @Override
    public void close() {
        super.close();
        this.currentCanonicalValues = null;
    }

    @Override
    public Object getEditorValue() {
        if (!this.multiselect) {
            return this.combo.getSelection()[0];
        }
        return this.combo.getSelection();
    }

    @Override
    public void setEditorValue(Object value) {
        this.combo.setSelection((String[])value);
    }

    public NatCombo getEditorControl() {
        return this.combo;
    }

    public NatCombo createEditorControl(Composite parent) {
        int style = 0;
        if (!this.freeEdit) {
            style |= 8;
        }
        if (this.multiselect) {
            style |= 2;
        }
        if (this.useCheckbox) {
            style |= 0x20;
        }
        NatCombo combo = this.iconImage == null ? new NatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.showDropdownFilter) : new NatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.iconImage, this.showDropdownFilter);
        combo.setCursor(new Cursor((Device)Display.getDefault(), 19));
        if (this.multiselect) {
            combo.setMultiselectValueSeparator(this.multiselectValueSeparator);
            combo.setMultiselectTextBracket(this.multiselectTextPrefix, this.multiselectTextSuffix);
        }
        this.addNatComboListener(combo);
        return combo;
    }

    protected void addNatComboListener(final NatCombo combo) {
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, ComboBoxCellEditor.this.editMode == EditModeEnum.INLINE);
                } else if (event.keyCode == 27) {
                    if (ComboBoxCellEditor.this.editMode == EditModeEnum.INLINE) {
                        ComboBoxCellEditor.this.close();
                    } else {
                        combo.hideDropdownControl();
                    }
                }
            }
        });
        combo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, !ComboBoxCellEditor.this.multiselect && ComboBoxCellEditor.this.editMode == EditModeEnum.INLINE);
                if (!ComboBoxCellEditor.this.multiselect && ComboBoxCellEditor.this.editMode == EditModeEnum.DIALOG) {
                    combo.hideDropdownControl();
                }
            }
        });
        if (this.editMode == EditModeEnum.INLINE) {
            combo.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    ComboBoxCellEditor.this.close();
                }
            });
        }
        if (this.editMode == EditModeEnum.DIALOG) {
            combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    combo.hideDropdownControl();
                }
            });
        }
    }

    public void select(int index) {
        this.combo.select(index);
    }

    public void select(int[] indices) {
        this.combo.select(indices);
    }

    public void setMultiselectValueSeparator(String multiselectValueSeparator) {
        this.multiselectValueSeparator = multiselectValueSeparator;
    }

    public void setMultiselectTextBracket(String multiselectTextPrefix, String multiselectTextSuffix) {
        this.multiselectTextPrefix = multiselectTextPrefix;
        this.multiselectTextSuffix = multiselectTextSuffix;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public void setIconImage(Image iconImage) {
        this.iconImage = iconImage;
    }

    public boolean isFreeEdit() {
        return this.freeEdit;
    }

    public void setFreeEdit(boolean freeEdit) {
        this.freeEdit = freeEdit;
    }

    public boolean isMultiselect() {
        return this.multiselect;
    }

    public void setMultiselect(boolean multiselect) {
        this.multiselect = multiselect;
    }

    public boolean isUseCheckbox() {
        return this.useCheckbox;
    }

    public void setUseCheckbox(boolean useCheckbox) {
        this.useCheckbox = useCheckbox;
    }

    public boolean isShowDropdownFilter() {
        return this.showDropdownFilter;
    }

    public void setShowDropdownFilter(boolean showDropdownFilter) {
        this.showDropdownFilter = showDropdownFilter;
    }

    public boolean isFocusOnText() {
        return this.focusOnText;
    }

    public void setFocusOnText(boolean focusOnText) {
        this.focusOnText = focusOnText;
    }
}

