/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupMultiRowReorderCommandHandler
extends AbstractLayerCommandHandler<MultiRowReorderCommand> {
    private final RowGroupHeaderLayer rowGroupHeaderLayer;

    public GroupMultiRowReorderCommandHandler(RowGroupHeaderLayer rowGroupHeaderLayer) {
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(MultiRowReorderCommand command) {
        SelectionLayer.MoveDirectionEnum moveDirection;
        boolean reorderToTopEdge;
        List<Integer> fromRowPositions = command.getFromRowPositions();
        int toRowPosition = command.getToRowPosition();
        if (!RowGroupUtils.isBetweenTwoGroups(this.rowGroupHeaderLayer, toRowPosition, reorderToTopEdge = command.isReorderToTopEdge(), moveDirection = PositionUtil.getVerticalMoveDirection(fromRowPositions.get(0), toRowPosition))) {
            for (int fromRowPosition : fromRowPositions) {
                if (RowGroupUtils.isReorderValid(this.rowGroupHeaderLayer, fromRowPosition, toRowPosition, reorderToTopEdge)) continue;
                return true;
            }
        }
        int level = 0;
        while (level < this.rowGroupHeaderLayer.getLevelCount()) {
            GroupModel.Group toGroup;
            int toPositionToCheck = toRowPosition;
            if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
                --toPositionToCheck;
            }
            if ((toGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck)) != null && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                command.toggleCoordinateByEdge();
            }
            ++level;
        }
        return false;
    }

    @Override
    public Class<MultiRowReorderCommand> getCommandClass() {
        return MultiRowReorderCommand.class;
    }
}

